/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actionsOnSave.impl;

import com.intellij.ide.actionsOnSave.impl.ActionsOnSaveFileDocumentManagerListenerKt;
import com.intellij.ide.actionsOnSave.impl.ActionsOnSaveManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/actionsOnSave/impl/ActionsOnSaveFileDocumentManagerListener;", "Lcom/intellij/openapi/fileEditor/FileDocumentManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "beforeDocumentSaving", "", "document", "Lcom/intellij/openapi/editor/Document;", "beforeAllDocumentsSaving", "ActionOnSave", "DocumentUpdatingActionOnSave", "intellij.platform.ide.impl"})
public final class ActionsOnSaveFileDocumentManagerListener
implements FileDocumentManagerListener {
    @NotNull
    private final Project project;

    private ActionsOnSaveFileDocumentManagerListener(Project project2) {
        this.project = project2;
    }

    public void beforeDocumentSaving(@NotNull Document document2) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        if (!ActionsOnSaveManager.Companion.getInstance(this.project).getRunningSaveDocumentAction$intellij_platform_ide_impl()) {
            return;
        }
        for (ActionOnSave saveAction : ActionsOnSaveFileDocumentManagerListenerKt.access$getEP_NAME$p().getExtensionList()) {
            if (!saveAction.isEnabledForProject(this.project)) continue;
            Document[] documentArray = new Document[]{document2};
            ActionsOnSaveManager.Companion.getInstance(this.project).scheduleDocumentsProcessing$intellij_platform_ide_impl(documentArray);
            return;
        }
    }

    public void beforeAllDocumentsSaving() {
        Document[] documentArray = FileDocumentManager.getInstance().getUnsavedDocuments();
        Intrinsics.checkNotNullExpressionValue((Object)documentArray, (String)"getUnsavedDocuments(...)");
        Document[] documents = documentArray;
        if (documents.length == 0) {
            return;
        }
        for (ActionOnSave saveAction : ActionsOnSaveFileDocumentManagerListenerKt.access$getEP_NAME$p().getExtensionList()) {
            if (!saveAction.isEnabledForProject(this.project)) continue;
            ActionsOnSaveManager.Companion.getInstance(this.project).scheduleDocumentsProcessing$intellij_platform_ide_impl(documents);
            return;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J#\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0017\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/actionsOnSave/impl/ActionsOnSaveFileDocumentManagerListener$ActionOnSave;", "", "<init>", "()V", "isEnabledForProject", "", "project", "Lcom/intellij/openapi/project/Project;", "processDocuments", "", "documents", "", "Lcom/intellij/openapi/editor/Document;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/editor/Document;)V", "intellij.platform.ide.impl"})
    public static abstract class ActionOnSave {
        @RequiresReadLock
        public boolean isEnabledForProject(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return false;
        }

        @RequiresEdt
        public void processDocuments(@NotNull Project project2, @NotNull Document[] documents) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)documents, (String)"documents");
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\nH\u00a7@\u00a2\u0006\u0002\u0010\u0012R\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/actionsOnSave/impl/ActionsOnSaveFileDocumentManagerListener$DocumentUpdatingActionOnSave;", "Lcom/intellij/ide/actionsOnSave/impl/ActionsOnSaveFileDocumentManagerListener$ActionOnSave;", "<init>", "()V", "processDocuments", "", "project", "Lcom/intellij/openapi/project/Project;", "documents", "", "Lcom/intellij/openapi/editor/Document;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/editor/Document;)V", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "updateDocument", "document", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
    public static abstract class DocumentUpdatingActionOnSave
    extends ActionOnSave {
        @Override
        public final void processDocuments(@NotNull Project project2, @NotNull Document[] documents) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)documents, (String)"documents");
        }

        @NotNull
        public abstract String getPresentableName();

        @RequiresBackgroundThread
        @Nullable
        public abstract Object updateDocument(@NotNull Project var1, @NotNull Document var2, @NotNull Continuation<? super Unit> var3);
    }
}

