/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CustomFileTypeEditor
extends SettingsEditor<AbstractFileType> {
    private final JTextField myFileTypeName = new JTextField();
    private final JTextField myFileTypeDescr = new JTextField();
    private final JCheckBox myIgnoreCase = new JCheckBox(IdeBundle.message((String)"checkbox.customfiletype.ignore.case", (Object[])new Object[0]));
    private final JCheckBox mySupportBraces = new JCheckBox(IdeBundle.message((String)"checkbox.customfiletype.support.paired.braces", (Object[])new Object[0]));
    private final JCheckBox mySupportBrackets = new JCheckBox(IdeBundle.message((String)"checkbox.customfiletype.support.paired.brackets", (Object[])new Object[0]));
    private final JCheckBox mySupportParens = new JCheckBox(IdeBundle.message((String)"checkbox.customfiletype.support.paired.parens", (Object[])new Object[0]));
    private final JCheckBox mySupportEscapes = new JCheckBox(IdeBundle.message((String)"checkbox.customfiletype.support.string.escapes", (Object[])new Object[0]));
    private final JTextField myLineComment = new JTextField(5);
    private final JCheckBox myCommentAtLineStart = new JCheckBox(UIUtil.replaceMnemonicAmpersand((String)IdeBundle.message((String)"only.at.line.start", (Object[])new Object[0])));
    private final JTextField myBlockCommentStart = new JTextField(5);
    private final JTextField myBlockCommentEnd = new JTextField(5);
    private final JTextField myHexPrefix = new JTextField(5);
    private final JTextField myNumPostfixes = new JTextField(5);
    private final JTextArea[] myKeywordsLists = new JTextArea[]{new JTextArea(), new JTextArea(), new JTextArea(), new JTextArea()};

    public CustomFileTypeEditor() {
        this.myLineComment.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean enabled2 = StringUtil.isNotEmpty((String)CustomFileTypeEditor.this.myLineComment.getText());
                CustomFileTypeEditor.this.myCommentAtLineStart.setEnabled(enabled2);
                if (!enabled2) {
                    CustomFileTypeEditor.this.myCommentAtLineStart.setSelected(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/highlighter/custom/impl/CustomFileTypeEditor$1", "textChanged"));
            }
        });
        this.myCommentAtLineStart.setEnabled(false);
    }

    public void resetEditorFrom(@NotNull AbstractFileType fileType2) {
        if (fileType2 == null) {
            CustomFileTypeEditor.$$$reportNull$$$0(0);
        }
        this.myFileTypeName.setText(fileType2.getName());
        this.myFileTypeDescr.setText(fileType2.getDescription());
        SyntaxTable table2 = fileType2.getSyntaxTable();
        this.myLineComment.setText(table2.getLineComment());
        this.myBlockCommentEnd.setText(table2.getEndComment());
        this.myBlockCommentStart.setText(table2.getStartComment());
        this.myHexPrefix.setText(table2.getHexPrefix());
        this.myNumPostfixes.setText(table2.getNumPostfixChars());
        this.myIgnoreCase.setSelected(table2.isIgnoreCase());
        this.myCommentAtLineStart.setSelected(table2.lineCommentOnlyAtStart);
        this.mySupportBraces.setSelected(table2.isHasBraces());
        this.mySupportBrackets.setSelected(table2.isHasBrackets());
        this.mySupportParens.setSelected(table2.isHasParens());
        this.mySupportEscapes.setSelected(table2.isHasStringEscapes());
        this.myKeywordsLists[0].setText(((StreamEx)StreamEx.of((Collection)table2.getKeywords1()).sorted()).joining((CharSequence)"\n"));
        this.myKeywordsLists[1].setText(((StreamEx)StreamEx.of((Collection)table2.getKeywords2()).sorted()).joining((CharSequence)"\n"));
        this.myKeywordsLists[2].setText(((StreamEx)StreamEx.of((Collection)table2.getKeywords3()).sorted()).joining((CharSequence)"\n"));
        this.myKeywordsLists[3].setText(((StreamEx)StreamEx.of((Collection)table2.getKeywords4()).sorted()).joining((CharSequence)"\n"));
        for (int i2 = 0; i2 < 4; ++i2) {
            this.myKeywordsLists[i2].setCaretPosition(0);
        }
    }

    public void applyEditorTo(@NotNull AbstractFileType type) throws ConfigurationException {
        if (type == null) {
            CustomFileTypeEditor.$$$reportNull$$$0(1);
        }
        if (this.myFileTypeName.getText().trim().isEmpty()) {
            throw new ConfigurationException(IdeBundle.message((String)"error.name.cannot.be.empty", (Object[])new Object[0]), CommonBundle.getErrorTitle());
        }
        if (this.myFileTypeDescr.getText().trim().isEmpty()) {
            this.myFileTypeDescr.setText(this.myFileTypeName.getText());
        }
        type.setName(this.myFileTypeName.getText());
        type.setDescription(this.myFileTypeDescr.getText());
        type.setSyntaxTable(this.getSyntaxTable());
    }

    @NotNull
    public JComponent createEditor() {
        JPanel panel2 = new JPanel(new BorderLayout());
        JPanel fileTypePanel = new JPanel(new BorderLayout());
        JPanel info = FormBuilder.createFormBuilder().addLabeledComponent(IdeBundle.message((String)"editbox.customfiletype.name", (Object[])new Object[0]), (JComponent)this.myFileTypeName).addLabeledComponent(IdeBundle.message((String)"editbox.customfiletype.description", (Object[])new Object[0]), (JComponent)this.myFileTypeDescr).getPanel();
        info.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        fileTypePanel.add((Component)info, "North");
        JPanel highlighterPanel = new JPanel();
        highlighterPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"group.customfiletype.syntax.highlighting", (Object[])new Object[0]), (boolean)false));
        highlighterPanel.setLayout(new BorderLayout());
        JPanel commentsAndNumbersPanel = new JPanel();
        commentsAndNumbersPanel.setLayout(new GridBagLayout());
        JPanel _panel1 = new JPanel(new BorderLayout());
        GridBag gb = new GridBag().setDefaultFill(2).setDefaultAnchor(17).setDefaultInsets(1, 5, 1, 5);
        commentsAndNumbersPanel.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.line.comment", (Object[])new Object[0])), gb.nextLine().next());
        commentsAndNumbersPanel.add((Component)this.myLineComment, gb.next());
        commentsAndNumbersPanel.add((Component)this.myCommentAtLineStart, gb.next().coverLine(2));
        commentsAndNumbersPanel.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.block.comment.start", (Object[])new Object[0])), gb.nextLine().next());
        commentsAndNumbersPanel.add((Component)this.myBlockCommentStart, gb.next());
        commentsAndNumbersPanel.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.block.comment.end", (Object[])new Object[0])), gb.next());
        commentsAndNumbersPanel.add((Component)this.myBlockCommentEnd, gb.next());
        commentsAndNumbersPanel.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.hex.prefix", (Object[])new Object[0])), gb.nextLine().next());
        commentsAndNumbersPanel.add((Component)this.myHexPrefix, gb.next());
        commentsAndNumbersPanel.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.number.postfixes", (Object[])new Object[0])), gb.next());
        commentsAndNumbersPanel.add((Component)this.myNumPostfixes, gb.next());
        commentsAndNumbersPanel.add((Component)this.mySupportBraces, gb.nextLine().next().coverLine(2));
        commentsAndNumbersPanel.add((Component)this.mySupportBrackets, gb.next().next().coverLine(2));
        commentsAndNumbersPanel.add((Component)this.mySupportParens, gb.nextLine().next().coverLine(2));
        commentsAndNumbersPanel.add((Component)this.mySupportEscapes, gb.next().next().coverLine(2));
        _panel1.add((Component)commentsAndNumbersPanel, "West");
        highlighterPanel.add((Component)_panel1, "North");
        TabbedPaneWrapper tabbedPaneWrapper = new TabbedPaneWrapper((Disposable)this);
        tabbedPaneWrapper.getComponent().setBorder((Border)IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"listbox.customfiletype.keywords", (Object[])new Object[0]), (boolean)false));
        for (int i2 = 0; i2 < 4; ++i2) {
            JTextArea list2 = this.myKeywordsLists[i2];
            list2.setRows(10);
            tabbedPaneWrapper.addTab(" " + (i2 + 1) + " ", (JComponent)new JBScrollPane((Component)list2));
        }
        highlighterPanel.add((Component)tabbedPaneWrapper.getComponent(), "Center");
        highlighterPanel.add((Component)this.myIgnoreCase, "South");
        fileTypePanel.add((Component)highlighterPanel, "Center");
        panel2.add(fileTypePanel);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            CustomFileTypeEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @NotNull
    public SyntaxTable getSyntaxTable() {
        SyntaxTable syntaxTable = new SyntaxTable();
        syntaxTable.setLineComment(this.myLineComment.getText());
        syntaxTable.setStartComment(this.myBlockCommentStart.getText());
        syntaxTable.setEndComment(this.myBlockCommentEnd.getText());
        syntaxTable.setHexPrefix(this.myHexPrefix.getText());
        syntaxTable.setNumPostfixChars(this.myNumPostfixes.getText());
        syntaxTable.lineCommentOnlyAtStart = this.myCommentAtLineStart.isSelected();
        boolean ignoreCase = this.myIgnoreCase.isSelected();
        syntaxTable.setIgnoreCase(ignoreCase);
        syntaxTable.setHasBraces(this.mySupportBraces.isSelected());
        syntaxTable.setHasBrackets(this.mySupportBrackets.isSelected());
        syntaxTable.setHasParens(this.mySupportParens.isSelected());
        syntaxTable.setHasStringEscapes(this.mySupportEscapes.isSelected());
        CustomFileTypeEditor.splitKeywordLines(ignoreCase, this.myKeywordsLists[0]).forEach(arg_0 -> ((SyntaxTable)syntaxTable).addKeyword1(arg_0));
        CustomFileTypeEditor.splitKeywordLines(ignoreCase, this.myKeywordsLists[1]).forEach(arg_0 -> ((SyntaxTable)syntaxTable).addKeyword2(arg_0));
        CustomFileTypeEditor.splitKeywordLines(ignoreCase, this.myKeywordsLists[2]).forEach(arg_0 -> ((SyntaxTable)syntaxTable).addKeyword3(arg_0));
        CustomFileTypeEditor.splitKeywordLines(ignoreCase, this.myKeywordsLists[3]).forEach(arg_0 -> ((SyntaxTable)syntaxTable).addKeyword4(arg_0));
        SyntaxTable syntaxTable2 = syntaxTable;
        if (syntaxTable2 == null) {
            CustomFileTypeEditor.$$$reportNull$$$0(3);
        }
        return syntaxTable2;
    }

    private static Stream<String> splitKeywordLines(boolean ignoreCase, JTextArea list2) {
        return Arrays.stream(StringUtil.splitByLines((String)list2.getText())).filter(StringUtil::isNotEmpty).map(s -> ignoreCase ? s.toLowerCase(Locale.getDefault()) : s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/highlighter/custom/impl/CustomFileTypeEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/highlighter/custom/impl/CustomFileTypeEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyntaxTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

