/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.minimap;

import com.intellij.ide.minimap.MinimapImage;
import com.intellij.ide.minimap.MinimapPanel;
import com.intellij.ide.minimap.settings.MinimapSettings;
import com.intellij.ide.minimap.settings.MinimapSettingsState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.ui.Gray;
import com.intellij.ui.PopupHandler;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0004\u001c\u001f\"%\u0018\u0000 ;2\u00020\u0001:\u0002:;B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010,\u001a\u00020*H\u0002J\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u0011H\u0002J\u0010\u0010/\u001a\u00020*2\u0006\u00100\u001a\u00020\u0011H\u0002J\b\u00101\u001a\u00020*H\u0016J\b\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020*H\u0002J\b\u00105\u001a\u00020\u0015H\u0002J\u0010\u00106\u001a\u00020*2\u0006\u00107\u001a\u000208H\u0016J\u0006\u00109\u001a\u00020*R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0010\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u0010\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010#R\u0010\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010&R\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/ide/minimap/MinimapPanel;", "Ljavax/swing/JPanel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "container", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/editor/Editor;Ljavax/swing/JPanel;)V", "settings", "Lcom/intellij/ide/minimap/settings/MinimapSettings;", "state", "Lcom/intellij/ide/minimap/settings/MinimapSettingsState;", "isResizing", "", "isDragging", "resizeInitialX", "", "resizeInitialWidth", "minimapImageSoftReference", "Ljava/lang/ref/SoftReference;", "Lcom/intellij/ide/minimap/MinimapImage;", "minimapHeight", "areaStart", "areaEnd", "thumbStart", "thumbHeight", "contentComponentListener", "com/intellij/ide/minimap/MinimapPanel$contentComponentListener$1", "Lcom/intellij/ide/minimap/MinimapPanel$contentComponentListener$1;", "componentListener", "com/intellij/ide/minimap/MinimapPanel$componentListener$1", "Lcom/intellij/ide/minimap/MinimapPanel$componentListener$1;", "selectionListener", "com/intellij/ide/minimap/MinimapPanel$selectionListener$1", "Lcom/intellij/ide/minimap/MinimapPanel$selectionListener$1;", "visibleAreaListener", "com/intellij/ide/minimap/MinimapPanel$visibleAreaListener$1", "Lcom/intellij/ide/minimap/MinimapPanel$visibleAreaListener$1;", "onSettingsChange", "Lkotlin/Function1;", "Lcom/intellij/ide/minimap/settings/MinimapSettings$SettingsChangeType;", "", "initialized", "updateParameters", "isInResizeArea", "x", "scrollTo", "y", "updateUI", "createPopupActionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "updatePreferredSize", "getOrCreateImage", "paint", "g", "Ljava/awt/Graphics;", "onClose", "PanelMouseListener", "Companion", "intellij.platform.ide.impl"})
public final class MinimapPanel
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final Editor editor;
    @NotNull
    private final JPanel container;
    @NotNull
    private final MinimapSettings settings;
    @NotNull
    private MinimapSettingsState state;
    private boolean isResizing;
    private boolean isDragging;
    private int resizeInitialX;
    private int resizeInitialWidth;
    @NotNull
    private SoftReference<MinimapImage> minimapImageSoftReference;
    private int minimapHeight;
    private int areaStart;
    private int areaEnd;
    private int thumbStart;
    private int thumbHeight;
    @NotNull
    private final contentComponentListener.1 contentComponentListener;
    @NotNull
    private final componentListener.1 componentListener;
    @NotNull
    private final selectionListener.1 selectionListener;
    @NotNull
    private final visibleAreaListener.1 visibleAreaListener;
    @NotNull
    private final Function1<MinimapSettings.SettingsChangeType, Unit> onSettingsChange;
    private boolean initialized;
    public static final int MINIMUM_WIDTH = 50;
    public static final int RESIZE_TOLERANCE = 7;

    public MinimapPanel(@NotNull Disposable parentDisposable, @NotNull Editor editor2, @NotNull JPanel container) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.parentDisposable = parentDisposable;
        this.editor = editor2;
        this.container = container;
        this.settings = MinimapSettings.Companion.getInstance();
        this.state = this.settings.getState();
        this.minimapImageSoftReference = new SoftReference<Object>(null);
        this.contentComponentListener = new ComponentAdapter(this){
            final /* synthetic */ MinimapPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(ComponentEvent componentEvent) {
                MinimapPanel.access$updateParameters(this.this$0);
                this.this$0.repaint();
            }
        };
        this.componentListener = new ComponentAdapter(this){
            private int lastHeight;
            final /* synthetic */ MinimapPanel this$0;
            {
                this.this$0 = $receiver;
                this.lastHeight = -1;
            }

            public void componentResized(ComponentEvent componentEvent) {
                if (this.lastHeight == this.this$0.getHeight()) {
                    return;
                }
                this.lastHeight = this.this$0.getHeight();
                MinimapPanel.access$updateParameters(this.this$0);
                this.this$0.revalidate();
                this.this$0.repaint();
            }
        };
        this.selectionListener = new SelectionListener(this){
            final /* synthetic */ MinimapPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.repaint();
            }
        };
        this.visibleAreaListener = new VisibleAreaListener(this){
            private Rectangle visibleArea;
            final /* synthetic */ MinimapPanel this$0;
            {
                this.this$0 = $receiver;
                this.visibleArea = new Rectangle(0, 0, 0, 0);
            }

            public void visibleAreaChanged(VisibleAreaEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.visibleArea.y == e.getNewRectangle().y && this.visibleArea.height == e.getNewRectangle().height && this.visibleArea.width == e.getNewRectangle().width) {
                    return;
                }
                Rectangle rectangle = e.getNewRectangle();
                Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getNewRectangle(...)");
                this.visibleArea = rectangle;
                MinimapPanel.access$updateParameters(this.this$0);
                this.this$0.repaint();
            }
        };
        this.onSettingsChange = arg_0 -> MinimapPanel.onSettingsChange$lambda$0(this, arg_0);
        this.container.addComponentListener(this.componentListener);
        this.settings.getSettingsChangeCallback().plusAssign(this.onSettingsChange);
        this.editor.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this.visibleAreaListener);
        this.editor.getSelectionModel().addSelectionListener((SelectionListener)this.selectionListener);
        this.editor.getContentComponent().addComponentListener(this.contentComponentListener);
        PopupHandler.installPopupMenu((JComponent)this, (ActionGroup)((ActionGroup)this.createPopupActionGroup()), (String)"Minimap");
        this.updatePreferredSize();
        PanelMouseListener mouseListener2 = new PanelMouseListener();
        this.addMouseListener(mouseListener2);
        this.addMouseWheelListener(mouseListener2);
        this.addMouseMotionListener(mouseListener2);
    }

    private final void updateParameters() {
        Rectangle rectangle = this.editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        int componentHeight = this.editor.getContentComponent().getHeight();
        this.minimapHeight = (int)((double)(componentHeight * this.state.getWidth()) / (double)visibleArea.width);
        double proportion = (double)this.minimapHeight / (double)componentHeight;
        this.thumbStart = (int)((double)visibleArea.y * proportion);
        this.thumbHeight = (int)((double)visibleArea.height * proportion);
        this.areaStart = (int)((float)this.thumbStart / (float)(this.minimapHeight - this.thumbHeight) * (float)(this.minimapHeight - this.getHeight()));
        if (this.areaStart < 0) {
            this.areaStart = 0;
        }
        this.areaEnd = this.areaStart + Math.min(this.getHeight(), this.minimapHeight);
    }

    private final boolean isInResizeArea(int x) {
        boolean bl;
        if (this.state.getRightAligned()) {
            bl = 0 <= x ? x < 8 : false;
        } else {
            int n = this.state.getWidth() - 7;
            bl = x <= this.state.getWidth() ? n <= x : false;
        }
        return bl;
    }

    private final void scrollTo(int y) {
        float percentage = (float)(y + this.areaStart) / (float)this.minimapHeight;
        int offset = this.editor.getComponent().getSize().height / 2;
        this.editor.getScrollingModel().scrollVertically((int)(percentage * (float)this.editor.getContentComponent().getSize().height - (float)offset));
    }

    @Override
    public void updateUI() {
        block1: {
            super.updateUI();
            if (!this.initialized) break block1;
            MinimapImage minimapImage = this.minimapImageSoftReference.get();
            if (minimapImage != null) {
                minimapImage.update(this.editor, this.editor.getContentComponent().getHeight(), this.editor.getScrollingModel().getVisibleArea().width, this.minimapHeight, true);
            }
        }
    }

    private final DefaultActionGroup createPopupActionGroup() {
        AnAction[] anActionArray = new AnAction[]{ActionManager.getInstance().getAction("MoveMinimap"), ActionManager.getInstance().getAction("OpenMinimapSettings"), ActionManager.getInstance().getAction("DisableMinimap")};
        return new DefaultActionGroup(anActionArray);
    }

    private final void updatePreferredSize() {
        this.setPreferredSize(new Dimension(this.state.getWidth(), 0));
    }

    private final MinimapImage getOrCreateImage() {
        MinimapImage map2 = this.minimapImageSoftReference.get();
        if (map2 == null) {
            map2 = new MinimapImage();
            map2.setOnImageReady((Function0<Unit>)((Function0)() -> MinimapPanel.getOrCreateImage$lambda$0(this)));
            this.minimapImageSoftReference = new SoftReference<MinimapImage>(map2);
        }
        return map2;
    }

    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (!this.initialized) {
            this.updateParameters();
            this.initialized = true;
        }
        MinimapImage minimap = this.getOrCreateImage();
        MinimapImage.update$default(minimap, this.editor, this.editor.getContentComponent().getHeight(), this.editor.getScrollingModel().getVisibleArea().width, this.minimapHeight, false, 16, null);
        g.setColor(this.editor.getContentComponent().getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        BufferedImage preview = minimap.getPreview();
        if (preview != null) {
            Graphics graphics = preview.getGraphics();
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            double scaleY = ((Graphics2D)graphics).getTransform().getScaleY();
            g.drawImage(preview, 0, 0, this.state.getWidth(), this.areaEnd - this.areaStart, 0, (int)((double)this.areaStart * scaleY), preview.getWidth(), (int)((double)this.areaEnd * scaleY), null);
        }
        g.setColor((Color)Gray._161);
        Graphics2D graphics2D = g instanceof Graphics2D ? (Graphics2D)g : null;
        if (graphics2D != null) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.35f));
        }
        g.fillRect(0, this.thumbStart - this.areaStart, this.getWidth(), this.thumbHeight);
    }

    public final void onClose() {
        this.settings.getSettingsChangeCallback().minusAssign(this.onSettingsChange);
        this.container.removeComponentListener(this.componentListener);
        this.editor.getSelectionModel().removeSelectionListener((SelectionListener)this.selectionListener);
        this.editor.getContentComponent().removeComponentListener(this.contentComponentListener);
        this.editor.getScrollingModel().removeVisibleAreaListener((VisibleAreaListener)this.visibleAreaListener);
        this.minimapImageSoftReference.clear();
    }

    private static final Unit onSettingsChange$lambda$0(MinimapPanel this$0, MinimapSettings.SettingsChangeType settingsChangeType) {
        Intrinsics.checkNotNullParameter((Object)((Object)settingsChangeType), (String)"<unused var>");
        this$0.updatePreferredSize();
        this$0.revalidate();
        this$0.repaint();
        return Unit.INSTANCE;
    }

    private static final Unit getOrCreateImage$lambda$0(MinimapPanel this$0) {
        this$0.repaint();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$updateParameters(MinimapPanel $this) {
        $this.updateParameters();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/minimap/MinimapPanel$Companion;", "", "<init>", "()V", "MINIMUM_WIDTH", "", "RESIZE_TOLERANCE", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/minimap/MinimapPanel$PanelMouseListener;", "Ljava/awt/event/MouseAdapter;", "<init>", "(Lcom/intellij/ide/minimap/MinimapPanel;)V", "mousePressed", "", "e", "Ljava/awt/event/MouseEvent;", "mouseReleased", "mouseWheelMoved", "mouseWheelEvent", "Ljava/awt/event/MouseWheelEvent;", "mouseDragged", "mouseMoved", "intellij.platform.ide.impl"})
    public final class PanelMouseListener
    extends MouseAdapter {
        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.getButton() != 1) {
                return;
            }
            if (!MinimapPanel.this.isDragging && MinimapPanel.this.isInResizeArea(e.getX())) {
                MinimapPanel.this.isResizing = true;
                MinimapPanel.this.resizeInitialX = e.getXOnScreen();
                MinimapPanel.this.resizeInitialWidth = MinimapPanel.this.state.getWidth();
            } else {
                MinimapPanel.this.isDragging = true;
                MinimapPanel.this.scrollTo(e.getY());
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.getButton() == 1) {
                MinimapPanel.this.isDragging = false;
                MinimapPanel.this.isResizing = false;
            }
        }

        @Override
        public void mouseWheelMoved(@NotNull MouseWheelEvent mouseWheelEvent) {
            Intrinsics.checkNotNullParameter((Object)mouseWheelEvent, (String)"mouseWheelEvent");
            MinimapPanel.this.editor.getScrollingModel().scrollVertically(MinimapPanel.this.editor.getScrollingModel().getVerticalScrollOffset() + (int)(mouseWheelEvent.getPreciseWheelRotation() * (double)MinimapPanel.this.editor.getLineHeight() * (double)5));
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (MinimapPanel.this.isResizing) {
                int newWidth = MinimapPanel.this.resizeInitialWidth + (MinimapPanel.this.state.getRightAligned() ? MinimapPanel.this.resizeInitialX - e.getXOnScreen() : e.getXOnScreen() - MinimapPanel.this.resizeInitialX);
                int n = newWidth < 50 ? 50 : (newWidth = newWidth > MinimapPanel.this.container.getWidth() / 2 ? MinimapPanel.this.container.getWidth() / 2 : newWidth);
                if (MinimapPanel.this.state.getWidth() != newWidth) {
                    MinimapPanel.this.state.setWidth(newWidth);
                    MinimapPanel.this.settings.getSettingsChangeCallback().notify(MinimapSettings.SettingsChangeType.Normal);
                }
            } else if (MinimapPanel.this.isDragging) {
                MinimapPanel.this.editor.getScrollingModel().disableAnimation();
                MinimapPanel.this.scrollTo(e.getY());
                MinimapPanel.this.editor.getScrollingModel().enableAnimation();
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (MinimapPanel.this.isInResizeArea(e.getX())) {
                MinimapPanel.this.setCursor(MinimapPanel.this.state.getRightAligned() ? Cursor.getPredefinedCursor(10) : Cursor.getPredefinedCursor(11));
            } else {
                MinimapPanel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }
}

