/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.cellvalidators.CellComponentProvider;
import com.intellij.openapi.ui.cellvalidators.CellTooltipManager;
import com.intellij.openapi.ui.cellvalidators.StatefulValidatingCellEditor;
import com.intellij.openapi.ui.cellvalidators.ValidatingTableCellRendererWrapper;
import com.intellij.openapi.ui.cellvalidators.ValidationUtils;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginHostsConfigurable
implements Configurable.NoScroll,
Configurable,
Configurable.SingleEditorConfiguration {
    private final ListTableModel<UrlInfo> myModel = new ListTableModel<UrlInfo>(new ColumnInfo[0]){

        public void addRow() {
            this.addRow(new UrlInfo(""));
        }
    };
    private final AnimatedIcon.Default myAnimatedIcon = new AnimatedIcon.Default();
    private final Disposable myDisposable = Disposer.newDisposable();
    private final JBTable myTable = new JBTable((TableModel)this.myModel){

        protected void paintComponent(@NotNull Graphics g) {
            if (g == null) {
                2.$$$reportNull$$$0(0);
            }
            super.paintComponent(g);
            Rectangle bounds = g.getClipBounds();
            int startRow = Math.max(0, this.rowAtPoint(bounds.getLocation()));
            int endRow = this.rowAtPoint(new Point(bounds.x + bounds.width, bounds.y + bounds.height));
            if (endRow == -1) {
                endRow = PluginHostsConfigurable.this.myModel.getRowCount() - 1;
            }
            int iconWidth = PluginHostsConfigurable.this.myAnimatedIcon.getIconWidth();
            int cellHeight = PluginHostsConfigurable.this.myAnimatedIcon.getIconHeight();
            int offset = JBUIScale.scale((int)5);
            int editingRow = this.getEditingRow();
            int selectedRow = this.getSelectedRow();
            Border border = UIUtil.getTableFocusCellHighlightBorder();
            for (int i2 = startRow; i2 <= endRow; ++i2) {
                UrlInfo item = (UrlInfo)PluginHostsConfigurable.this.myModel.getItem(i2);
                if (!item.progress || i2 == editingRow) continue;
                Rectangle rect = this.getCellRect(i2, 0, true);
                int x = rect.x + rect.width - iconWidth - offset;
                int xx = 0;
                int yy = 0;
                int hh = 0;
                if (i2 == selectedRow) {
                    Insets insets = border.getBorderInsets(null);
                    xx = insets.right;
                    yy = insets.top;
                    hh = insets.top + insets.bottom + 1;
                }
                g.setColor(i2 == selectedRow ? this.getSelectionBackground() : this.getBackground());
                g.fillRect(x - offset, rect.y + yy, iconWidth + offset * 2 - xx, rect.height - hh);
                PluginHostsConfigurable.this.myAnimatedIcon.paintIcon((Component)((Object)this), g, x, rect.y + (rect.height - cellHeight) / 2);
            }
        }

        public void editingCanceled(ChangeEvent e) {
            int row2 = this.getEditingRow();
            super.editingCanceled(e);
            if (row2 >= 0 && row2 < PluginHostsConfigurable.this.myModel.getRowCount() && StringUtil.isEmpty((String)((UrlInfo)PluginHostsConfigurable.this.myModel.getRowValue((int)row2)).name)) {
                PluginHostsConfigurable.this.myModel.removeRow(row2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ide/plugins/PluginHostsConfigurable$2", "paintComponent"));
        }
    };

    @Nullable
    public JComponent createComponent() {
        this.myModel.setColumnInfos(new ColumnInfo[]{new ColumnInfo<UrlInfo, String>(""){

            @Nullable
            public String valueOf(UrlInfo info) {
                return info.name;
            }

            public boolean isCellEditable(UrlInfo info) {
                return true;
            }

            public void setValue(UrlInfo info, String value) {
                int row2 = PluginHostsConfigurable.this.myTable.getSelectedRow();
                if (StringUtil.isEmpty((String)value) && row2 >= 0 && row2 < PluginHostsConfigurable.this.myModel.getRowCount()) {
                    PluginHostsConfigurable.this.myModel.removeRow(row2);
                } else {
                    info.name = PluginHostsConfigurable.correctRepositoryRule(value);
                    PluginHostsConfigurable.this.validateRepositories(Collections.singletonList(info));
                }
            }
        }});
        this.myTable.getColumnModel().setColumnMargin(0);
        this.myTable.setShowColumns(false);
        this.myTable.setShowGrid(false);
        this.myTable.getEmptyText().setText(IdeBundle.message((String)"update.no.update.hosts", (Object[])new Object[0]));
        this.myTable.setSelectionMode(0);
        ExtendableTextField cellEditor = new ExtendableTextField();
        StatefulValidatingCellEditor editor2 = new StatefulValidatingCellEditor((JTextField)cellEditor, this.myDisposable).withStateUpdater(vi -> ValidationUtils.setExtension((ExtendableTextComponent)cellEditor, (ValidationInfo)vi));
        editor2.setClickCountToStart(1);
        this.myTable.setDefaultEditor(Object.class, (TableCellEditor)editor2);
        this.myTable.setDefaultRenderer(Object.class, (TableCellRenderer)new ValidatingTableCellRendererWrapper((TableCellRenderer)new ColoredTableCellRenderer(){
            {
                this.setIpad((Insets)JBInsets.emptyInsets());
            }

            protected void customizeCellRenderer(@NotNull JTable table2, @Nullable Object value, boolean selected, boolean hasFocus, int row2, int column) {
                if (table2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (row2 >= 0 && row2 < PluginHostsConfigurable.this.myModel.getRowCount()) {
                    UrlInfo info = (UrlInfo)PluginHostsConfigurable.this.myModel.getRowValue(row2);
                    this.setForeground(selected ? table2.getSelectionForeground() : table2.getForeground());
                    this.setBackground(selected ? table2.getSelectionBackground() : table2.getBackground());
                    this.append(info.name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }

            protected SimpleTextAttributes modifyAttributes(SimpleTextAttributes attributes) {
                return attributes;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/ide/plugins/PluginHostsConfigurable$4", "customizeCellRenderer"));
            }
        }).bindToEditorSize(() -> cellEditor.getPreferredSize()).withCellValidator((value, row2, column) -> {
            if (row2 >= 0 && row2 < this.myModel.getRowCount()) {
                UrlInfo info = (UrlInfo)this.myModel.getRowValue(row2);
                return info.errorTooltip == null || info.progress ? null : new ValidationInfo(info.errorTooltip);
            }
            return null;
        }));
        new CellTooltipManager(this.myDisposable).withCellComponentProvider(CellComponentProvider.forTable((JTable)this.myTable)).installOn((JComponent)this.myTable);
        return ToolbarDecorator.createDecorator((JTable)this.myTable).disableUpDownActions().createPanel();
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private void validateRepositories(@NotNull List<? extends UrlInfo> urls) {
        if (urls == null) {
            PluginHostsConfigurable.$$$reportNull$$$0(0);
        }
        final ArrayList<UrlInfo> infos = new ArrayList<UrlInfo>();
        final ArrayList<@Nls Object> results = new ArrayList<Object>();
        for (UrlInfo urlInfo : urls) {
            urlInfo.progress = true;
            infos.add(urlInfo);
            results.add(null);
        }
        this.myTable.repaint();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, IdeBundle.message((String)"progress.title.checking.plugins.repository", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                int size2 = infos.size();
                for (int i2 = 0; i2 < size2; ++i2) {
                    try {
                        if (!RepositoryHelper.loadPlugins(((UrlInfo)infos.get((int)i2)).name, null, indicator2).isEmpty()) continue;
                        results.set(i2, IdeBundle.message((String)"error.no.plugins.found", (Object[])new Object[0]));
                        continue;
                    }
                    catch (Exception ignore) {
                        results.set(i2, IdeBundle.message((String)"error.connection.failed", (Object[])new Object[0]));
                    }
                }
            }

            public void onSuccess() {
                this.finish(true);
            }

            public void onCancel() {
                this.finish(false);
            }

            private void finish(boolean success2) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (success2) {
                        int size2 = infos.size();
                        for (int i2 = 0; i2 < size2; ++i2) {
                            UrlInfo info = (UrlInfo)infos.get(i2);
                            info.errorTooltip = (String)results.get(i2);
                            info.progress = false;
                        }
                    } else {
                        for (UrlInfo info : infos) {
                            info.progress = false;
                        }
                    }
                    PluginHostsConfigurable.this.myTable.repaint();
                }, ModalityState.any());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/plugins/PluginHostsConfigurable$5", "run"));
            }
        });
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"configurable.PluginHostsConfigurable.display.name", (Object[])new Object[0]);
    }

    public void reset() {
        ArrayList<UrlInfo> infos = new ArrayList<UrlInfo>();
        for (String host : UpdateSettings.getInstance().getStoredPluginHosts()) {
            infos.add(new UrlInfo(host));
        }
        this.myModel.setItems(infos);
        ApplicationManager.getApplication().invokeLater(() -> this.validateRepositories(infos), ModalityState.any());
    }

    public boolean isModified() {
        ArrayList<String> hosts = new ArrayList<String>();
        for (UrlInfo item : this.myModel.getItems()) {
            hosts.add(item.name);
        }
        return !UpdateSettings.getInstance().getStoredPluginHosts().equals(hosts);
    }

    public void apply() throws ConfigurationException {
        this.myTable.editingStopped(null);
        List<String> list2 = UpdateSettings.getInstance().getStoredPluginHosts();
        list2.clear();
        for (UrlInfo item : this.myModel.getItems()) {
            list2.add(item.name);
        }
    }

    @NotNull
    public Dimension getDialogInitialSize() {
        Dimension dimension = JBUI.DialogSizes.medium();
        if (dimension == null) {
            PluginHostsConfigurable.$$$reportNull$$$0(1);
        }
        return dimension;
    }

    @NotNull
    private static String correctRepositoryRule(@NotNull String input) {
        if (input == null) {
            PluginHostsConfigurable.$$$reportNull$$$0(2);
        }
        if (VirtualFileManager.extractProtocol((String)input) == null) {
            String string = VirtualFileManager.constructUrl((String)"http", (String)input);
            if (string == null) {
                PluginHostsConfigurable.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = input;
        if (string == null) {
            PluginHostsConfigurable.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginHostsConfigurable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginHostsConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialogInitialSize";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "correctRepositoryRule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validateRepositories";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "correctRepositoryRule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static final class UrlInfo {
        @NlsSafe
        String name;
        boolean progress;
        @Nls
        String errorTooltip;

        UrlInfo(@NotNull String name2) {
            if (name2 == null) {
                UrlInfo.$$$reportNull$$$0(0);
            }
            this.name = name2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/plugins/PluginHostsConfigurable$UrlInfo", "<init>"));
        }
    }
}

