/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.marketplace.utils;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.marketplace.utils.MarketplaceCustomizationService;
import com.intellij.ide.plugins.marketplace.utils.MarketplaceUrlsKt;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.URLUtil;
import com.intellij.util.system.CpuArch;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IntellijInternalApi
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0005H\u0007J\b\u0010\u000b\u001a\u00020\u0005H\u0007J\b\u0010\f\u001a\u00020\u0005H\u0002J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u0016\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010\u0011\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0005J\u0006\u0010\u0013\u001a\u00020\u0005J\u0006\u0010\u0014\u001a\u00020\u0015J\u001a\u0010\u0016\u001a\u00020\u00152\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0018J\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0005J\u0006\u0010\u001b\u001a\u00020\u0005J\u0006\u0010\u001c\u001a\u00020\u0005J\u001e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020 J\u0012\u0010'\u001a\u0004\u0018\u00010\u00052\u0006\u0010$\u001a\u00020%H\u0007J\b\u0010(\u001a\u00020\u0005H\u0007J\u001c\u0010)\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u0005H\u0007J,\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00052\b\u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u000102H\u0007J\f\u00103\u001a\u00020\u0005*\u00020%H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/ide/plugins/marketplace/utils/MarketplaceUrls;", "", "<init>", "()V", "IDE_BUILD_FOR_REQUEST", "", "Lorg/jetbrains/annotations/NotNull;", "FULL_PLUGINS_XML_IDS_FILENAME", "JB_PLUGINS_XML_IDS_FILENAME", "EXTENSIONS_BACKUP_FILENAME", "getPluginManagerUrl", "getPluginManagerHost", "getDownloadUrl", "getPluginMetaUrl", "externalPluginId", "getUpdateMetaUrl", "externalUpdateId", "getJBPluginsXmlIdsUrl", "getPluginsXmlIdsUrl", "getBrokenPluginsJsonUrl", "getIdeExtensionsJsonUrl", "Lcom/intellij/util/Url;", "getFeatureImplUrl", "param", "", "getSearchAggregationUrl", "field", "getSearchPluginsUpdatesUrl", "getSearchNearestUpdate", "getSearchPluginsUrl", "query", "count", "", "includeIncompatible", "", "getPluginReviewsUrl", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "page", "getPluginHomepage", "getPluginReviewNoteUrl", "getPluginWriteReviewUrl", "version", "getPluginDownloadUrl", "descriptor", "Lcom/intellij/ide/plugins/newui/PluginUiModel;", "uuid", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "currentVersion", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "urlEncode", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class MarketplaceUrls {
    @NotNull
    public static final MarketplaceUrls INSTANCE = new MarketplaceUrls();
    @NotNull
    private static final String IDE_BUILD_FOR_REQUEST;
    @NotNull
    public static final String FULL_PLUGINS_XML_IDS_FILENAME = "pluginsXMLIds.json";
    @NotNull
    public static final String JB_PLUGINS_XML_IDS_FILENAME = "jbPluginsXMLIds.json";
    @NotNull
    public static final String EXTENSIONS_BACKUP_FILENAME = "pluginsFeatures.json";

    private MarketplaceUrls() {
    }

    @JvmStatic
    @NotNull
    public static final String getPluginManagerUrl() {
        char[] cArray = new char[]{'/'};
        return StringsKt.trimEnd((String)MarketplaceCustomizationService.Companion.getInstance().getPluginManagerUrl(), (char[])cArray);
    }

    @JvmStatic
    @NotNull
    public static final String getPluginManagerHost() {
        String string = new URI(MarketplaceUrls.getPluginManagerUrl()).getHost();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private final String getDownloadUrl() {
        char[] cArray = new char[]{'/'};
        return StringsKt.trimEnd((String)MarketplaceCustomizationService.Companion.getInstance().getPluginDownloadUrl(), (char[])cArray);
    }

    @NotNull
    public final String getPluginMetaUrl(@NotNull String externalPluginId) {
        Intrinsics.checkNotNullParameter((Object)externalPluginId, (String)"externalPluginId");
        return MarketplaceUrls.getPluginManagerUrl() + "/files/" + externalPluginId + "/meta.json";
    }

    @NotNull
    public final String getUpdateMetaUrl(@NotNull String externalPluginId, @NotNull String externalUpdateId) {
        Intrinsics.checkNotNullParameter((Object)externalPluginId, (String)"externalPluginId");
        Intrinsics.checkNotNullParameter((Object)externalUpdateId, (String)"externalUpdateId");
        return MarketplaceUrls.getPluginManagerUrl() + "/files/" + externalPluginId + "/" + externalUpdateId + "/meta.json";
    }

    @NotNull
    public final String getJBPluginsXmlIdsUrl() {
        return MarketplaceUrls.getPluginManagerUrl() + "/files/jbPluginsXMLIds.json";
    }

    @NotNull
    public final String getPluginsXmlIdsUrl() {
        return MarketplaceUrls.getPluginManagerUrl() + "/files/pluginsXMLIds.json";
    }

    @NotNull
    public final String getBrokenPluginsJsonUrl() {
        return MarketplaceUrls.getPluginManagerUrl() + "/files/brokenPlugins.json";
    }

    @NotNull
    public final Url getIdeExtensionsJsonUrl() {
        Url url = Urls.newFromEncoded((String)(MarketplaceUrls.getPluginManagerUrl() + "/files/IDE/extensions.json")).addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"build", (Object)IDE_BUILD_FOR_REQUEST)));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"addParameters(...)");
        return url;
    }

    @NotNull
    public final Url getFeatureImplUrl(@NotNull Map<String, String> param) {
        Intrinsics.checkNotNullParameter(param, (String)"param");
        Url url = Urls.newFromEncoded((String)(MarketplaceUrls.getPluginManagerUrl() + "/feature/getImplementations")).addParameters(param);
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"addParameters(...)");
        return url;
    }

    @NotNull
    public final Url getSearchAggregationUrl(@NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Url url = Urls.newFromEncoded((String)(MarketplaceUrls.getPluginManagerUrl() + "/api/search/aggregation/" + field)).addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"build", (Object)IDE_BUILD_FOR_REQUEST)));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"addParameters(...)");
        return url;
    }

    @NotNull
    public final String getSearchPluginsUpdatesUrl() {
        String string = Urls.newFromEncoded((String)(MarketplaceUrls.getPluginManagerUrl() + "/api/search/updates/compatible")).toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
        return string;
    }

    @NotNull
    public final String getSearchNearestUpdate() {
        String string = Urls.newFromEncoded((String)(MarketplaceUrls.getPluginManagerUrl() + "/api/search/updates/nearest")).toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
        return string;
    }

    @NotNull
    public final Url getSearchPluginsUrl(@NotNull String query, int count, boolean includeIncompatible) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"build", (Object)IDE_BUILD_FOR_REQUEST), TuplesKt.to((Object)"max", (Object)String.valueOf(count)), TuplesKt.to((Object)"all", (Object)String.valueOf(includeIncompatible)), TuplesKt.to((Object)"os", (Object)MarketplaceUrlsKt.buildOsParameter()), TuplesKt.to((Object)"arch", (Object)CpuArch.CURRENT.name())};
        Map params = MapsKt.mapOf((Pair[])pairArray);
        Url url = Urls.newFromEncoded((String)(MarketplaceUrls.getPluginManagerUrl() + "/api/search/plugins?" + query)).addParameters(params);
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"addParameters(...)");
        return url;
    }

    @NotNull
    public final Url getPluginReviewsUrl(@NotNull PluginId pluginId, int page) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Object pageValue = page == 1 ? "" : "?page=" + page;
        return Urls.newFromEncoded((String)(MarketplaceUrls.getPluginManagerUrl() + "/api/products/intellij/plugins/" + this.urlEncode(pluginId) + "/comments" + (String)pageValue));
    }

    @JvmStatic
    @Nullable
    public static final String getPluginHomepage(@NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        return MarketplaceCustomizationService.Companion.getInstance().getPluginHomepageUrl(pluginId);
    }

    @JvmStatic
    @NotNull
    public static final String getPluginReviewNoteUrl() {
        return MarketplaceUrls.getPluginManagerUrl() + "/docs/marketplace/reviews-policy.html";
    }

    @JvmStatic
    @NotNull
    public static final String getPluginWriteReviewUrl(@NotNull PluginId pluginId, @Nullable String version) {
        StringBuilder stringBuilder;
        block0: {
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            StringBuilder $this$getPluginWriteReviewUrl_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$getPluginWriteReviewUrl_u24lambda_u240.append(MarketplaceUrls.getPluginManagerUrl() + "/intellij/" + INSTANCE.urlEncode(pluginId) + "/review/new");
            $this$getPluginWriteReviewUrl_u24lambda_u240.append("?build=" + IDE_BUILD_FOR_REQUEST);
            String string = version;
            if (string == null) break block0;
            String it = string;
            boolean bl2 = false;
            $this$getPluginWriteReviewUrl_u24lambda_u240.append("&version=" + it);
        }
        return stringBuilder.toString();
    }

    public static /* synthetic */ String getPluginWriteReviewUrl$default(PluginId pluginId, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return MarketplaceUrls.getPluginWriteReviewUrl(pluginId, string);
    }

    @JvmStatic
    @NotNull
    public static final String getPluginDownloadUrl(@NotNull PluginUiModel descriptor2, @NotNull String uuid, @Nullable BuildNumber buildNumber, @Nullable IdeaPluginDescriptor currentVersion) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Object object = currentVersion;
        if (object == null || (object = object.getVersion()) == null) {
            object = "";
        }
        Object updatedFrom = object;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)descriptor2.getPluginId().getIdString()), TuplesKt.to((Object)"build", (Object)ApplicationInfoImpl.orFromPluginCompatibleBuild((BuildNumber)buildNumber)), TuplesKt.to((Object)"uuid", (Object)uuid), TuplesKt.to((Object)"updatedFrom", (Object)updatedFrom)};
        HashMap parameters = MapsKt.hashMapOf((Pair[])pairArray);
        String string = descriptor2.getChannel();
        if (string != null) {
            String it = string;
            boolean bl = false;
            ((Map)parameters).put("channel", it);
        }
        String string2 = Urls.newFromEncoded((String)INSTANCE.getDownloadUrl()).addParameters((Map)parameters).toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toExternalForm(...)");
        return string2;
    }

    private final String urlEncode(PluginId $this$urlEncode) {
        String string = URLUtil.encodeURIComponent((String)$this$urlEncode.getIdString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeURIComponent(...)");
        return string;
    }

    static {
        String string = URLUtil.encodeURIComponent((String)ApplicationInfoImpl.getShadowInstanceImpl().getPluginCompatibleBuild());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeURIComponent(...)");
        IDE_BUILD_FOR_REQUEST = string;
    }
}

