/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.enums.SortBy;
import com.intellij.ide.plugins.newui.SearchWords;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class SearchQueryParser {
    public String searchQuery;

    protected void addToSearchQuery(@NotNull String query) {
        if (query == null) {
            SearchQueryParser.$$$reportNull$$$0(0);
        }
        this.searchQuery = this.searchQuery == null ? query : this.searchQuery + " " + query;
    }

    @NotNull
    protected static List<String> splitQuery(@NotNull String query) {
        if (query == null) {
            SearchQueryParser.$$$reportNull$$$0(1);
        }
        ArrayList<String> words = new ArrayList<String>();
        int length = query.length();
        int index = 0;
        block0: while (index < length) {
            char startCh;
            if ((startCh = query.charAt(index++)) == ' ') continue;
            if (startCh == '\"') {
                int end = query.indexOf(34, index);
                if (end == -1) break;
                words.add(query.substring(index, end));
                index = end + 1;
                continue;
            }
            int start2 = index - 1;
            while (index <= length) {
                char nextCh;
                if (index == length) {
                    words.add(query.substring(start2));
                    continue block0;
                }
                if ((nextCh = query.charAt(index++)) != ':' && nextCh != ' ' && index != length) continue;
                words.add(query.substring(start2, nextCh == ' ' ? index - 1 : index));
                continue block0;
            }
        }
        ArrayList<String> arrayList = words;
        if (arrayList == null) {
            SearchQueryParser.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public static String getTagQuery(@NotNull String tag) {
        if (tag == null) {
            SearchQueryParser.$$$reportNull$$$0(3);
        }
        String string = "/tag:" + (tag.indexOf(32) == -1 ? tag : StringUtil.wrapWithDoubleQuote((String)tag));
        if (string == null) {
            SearchQueryParser.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String wrapAttribute(@NotNull String value) {
        if (value == null) {
            SearchQueryParser.$$$reportNull$$$0(5);
        }
        String string = StringUtil.containsAnyChar((String)value, (String)" ,:") ? StringUtil.wrapWithDoubleQuote((String)value) : value;
        if (string == null) {
            SearchQueryParser.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/SearchQueryParser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/SearchQueryParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "splitQuery";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagQuery";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapAttribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addToSearchQuery";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "splitQuery";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTagQuery";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrapAttribute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6 -> new IllegalStateException(string);
        };
    }

    public static class Installed
    extends SearchQueryParser {
        public final Set<String> vendors;
        public final Set<String> tags;
        public boolean enabled;
        public boolean disabled;
        public boolean bundled;
        public boolean downloaded;
        public boolean invalid;
        public boolean needUpdate;
        public boolean attributes;

        public Installed(@NotNull String query) {
            if (query == null) {
                Installed.$$$reportNull$$$0(0);
            }
            this.vendors = new HashSet<String>();
            this.tags = new HashSet<String>();
            this.parse(query);
        }

        private void parse(@NotNull String query) {
            List<String> words;
            int size2;
            if (query == null) {
                Installed.$$$reportNull$$$0(1);
            }
            if ((size2 = (words = Installed.splitQuery(query)).size()) == 0) {
                return;
            }
            int index = 0;
            while (index < size2) {
                String name2;
                if ((name2 = words.get(index++)).startsWith("/")) {
                    if (name2.equals(SearchWords.VENDOR.getValue()) || name2.equals(SearchWords.TAG.getValue())) {
                        if (index < size2) {
                            this.handleAttribute(name2, words.get(index++));
                            continue;
                        }
                        this.addToSearchQuery(query);
                        break;
                    }
                    this.handleAttribute(name2, "");
                    continue;
                }
                this.addToSearchQuery(name2);
            }
            this.attributes = this.enabled || this.disabled || this.bundled || this.downloaded || this.invalid || this.needUpdate;
        }

        protected void handleAttribute(@NotNull String name2, @NotNull String value) {
            if (name2 == null) {
                Installed.$$$reportNull$$$0(2);
            }
            if (value == null) {
                Installed.$$$reportNull$$$0(3);
            }
            if ("/enabled".equals(name2)) {
                this.enabled = true;
            } else if ("/disabled".equals(name2)) {
                this.disabled = true;
            } else if ("/bundled".equals(name2)) {
                this.bundled = true;
            } else if ("/downloaded".equals(name2)) {
                this.downloaded = true;
            } else if ("/invalid".equals(name2)) {
                this.invalid = true;
            } else if ("/outdated".equals(name2)) {
                this.needUpdate = true;
            } else if (SearchWords.VENDOR.getValue().equals(name2)) {
                this.vendors.add(value);
            } else if (SearchWords.TAG.getValue().equals(name2)) {
                this.tags.add(value);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/newui/SearchQueryParser$Installed";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parse";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleAttribute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Marketplace
    extends SearchQueryParser {
        public final Set<String> vendors;
        public final Set<String> tags;
        public final Set<String> repositories;
        public SortBy sortBy;
        public boolean suggested;
        public boolean internal;
        public boolean staffPicks;

        public Marketplace(@NotNull String query) {
            if (query == null) {
                Marketplace.$$$reportNull$$$0(0);
            }
            this.vendors = new HashSet<String>();
            this.tags = new HashSet<String>();
            this.repositories = new HashSet<String>();
            this.staffPicks = false;
            this.parse(query);
        }

        private void parse(@NotNull String query) {
            List<String> words;
            int size2;
            if (query == null) {
                Marketplace.$$$reportNull$$$0(1);
            }
            if ((size2 = (words = Marketplace.splitQuery(query)).size()) == 0) {
                return;
            }
            if (size2 == 1) {
                this.addToSearchQuery(words.get(0));
                return;
            }
            int index = 0;
            while (index < size2) {
                String name2;
                if ((name2 = words.get(index++)).endsWith(":")) {
                    if (index < size2) {
                        this.handleAttribute(name2, words.get(index++));
                        continue;
                    }
                    this.addToSearchQuery(query);
                    return;
                }
                this.addToSearchQuery(name2);
            }
        }

        @Override
        protected void addToSearchQuery(@NotNull String query) {
            if (query == null) {
                Marketplace.$$$reportNull$$$0(2);
            }
            if (query.equals(SearchWords.SUGGESTED.getValue())) {
                this.suggested = true;
            } else if (query.equals(SearchWords.INTERNAL.getValue())) {
                this.internal = true;
            } else if (query.equals(SearchWords.STAFF_PICKS.getValue())) {
                this.staffPicks = true;
            } else {
                super.addToSearchQuery(query);
            }
        }

        protected void handleAttribute(@NotNull String name2, @NotNull String value) {
            if (name2 == null) {
                Marketplace.$$$reportNull$$$0(3);
            }
            if (value == null) {
                Marketplace.$$$reportNull$$$0(4);
            }
            if (name2.equals(SearchWords.TAG.getValue())) {
                this.tags.add(value);
            } else if (name2.equals(SearchWords.SORT_BY.getValue())) {
                this.sortBy = SortBy.getByQueryOrNull(value);
            } else if (name2.equals(SearchWords.REPOSITORY.getValue())) {
                this.repositories.add(value);
            } else if (name2.equals(SearchWords.VENDOR.getValue())) {
                this.vendors.add(value);
            }
        }

        @NotNull
        public String getUrlQuery() {
            StringBuilder url = new StringBuilder();
            if (this.sortBy != null) {
                url.append(this.sortBy.getMpParameter());
            }
            if (this.staffPicks) {
                if (!url.isEmpty()) {
                    url.append("&");
                }
                url.append("is_featured_search=true");
            }
            for (String tag : this.tags) {
                if (!url.isEmpty()) {
                    url.append("&");
                }
                url.append("tags=").append(URLUtil.encodeURIComponent((String)tag));
            }
            for (String vendor : this.vendors) {
                if (!url.isEmpty()) {
                    url.append("&");
                }
                url.append("organization=").append(URLUtil.encodeURIComponent((String)vendor));
            }
            if (this.searchQuery != null) {
                if (!url.isEmpty()) {
                    url.append("&");
                }
                url.append("search=").append(URLUtil.encodeURIComponent((String)this.searchQuery));
            }
            String string = url.toString();
            if (string == null) {
                Marketplace.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/newui/SearchQueryParser$Marketplace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/newui/SearchQueryParser$Marketplace";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrlQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addToSearchQuery";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "handleAttribute";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

