/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.trustedProjects;

import com.intellij.ide.impl.TrustedPaths;
import com.intellij.ide.impl.TrustedPathsSettings;
import com.intellij.ide.impl.TrustedProjectsStatistics;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.trustedProjects.TrustedProjectsListener;
import com.intellij.ide.trustedProjects.TrustedProjectsLocator;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ThreeState;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\"\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0005H\u0007J\b\u0010\u0011\u001a\u00020\u0005H\u0007J\b\u0010\u0012\u001a\u00020\u0005H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/trustedProjects/TrustedProjects;", "", "<init>", "()V", "isProjectTrusted", "", "project", "Lcom/intellij/openapi/project/Project;", "setProjectTrusted", "", "isTrusted", "getProjectTrustedState", "Lcom/intellij/util/ThreeState;", "path", "Ljava/nio/file/Path;", "locatedProject", "Lcom/intellij/ide/trustedProjects/TrustedProjectsLocator$LocatedProject;", "isTrustedCheckDisabled", "isTrustedCheckDisabledForProduct", "intellij.platform.ide.impl"})
public final class TrustedProjects {
    @NotNull
    public static final TrustedProjects INSTANCE = new TrustedProjects();

    private TrustedProjects() {
    }

    @JvmStatic
    public static final boolean isProjectTrusted(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return INSTANCE.isProjectTrusted(TrustedProjectsLocator.Companion.locateProject(project2));
    }

    @JvmStatic
    public static final void setProjectTrusted(@NotNull Project project2, boolean isTrusted) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        INSTANCE.setProjectTrusted(TrustedProjectsLocator.Companion.locateProject(project2), isTrusted);
    }

    @ApiStatus.Internal
    @NotNull
    public final ThreeState getProjectTrustedState(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return this.getProjectTrustedState(TrustedProjectsLocator.Companion.locateProject(project2));
    }

    @JvmStatic
    public static final boolean isProjectTrusted(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return TrustedProjects.isProjectTrusted(path, null);
    }

    @JvmStatic
    public static final void setProjectTrusted(@NotNull Path path, boolean isTrusted) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        TrustedProjects.setProjectTrusted(path, null, isTrusted);
    }

    @ApiStatus.Internal
    @NotNull
    public final ThreeState getProjectTrustedState(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.getProjectTrustedState(path, null);
    }

    @JvmStatic
    public static final boolean isProjectTrusted(@NotNull Path path, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return INSTANCE.isProjectTrusted(TrustedProjectsLocator.Companion.locateProject(path, project2));
    }

    @JvmStatic
    public static final void setProjectTrusted(@NotNull Path path, @Nullable Project project2, boolean isTrusted) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        INSTANCE.setProjectTrusted(TrustedProjectsLocator.Companion.locateProject(path, project2), isTrusted);
    }

    @ApiStatus.Internal
    @NotNull
    public final ThreeState getProjectTrustedState(@NotNull Path path, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.getProjectTrustedState(TrustedProjectsLocator.Companion.locateProject(path, project2));
    }

    @ApiStatus.Internal
    public final boolean isProjectTrusted(@NotNull TrustedProjectsLocator.LocatedProject locatedProject) {
        Intrinsics.checkNotNullParameter((Object)locatedProject, (String)"locatedProject");
        return this.getProjectTrustedState(locatedProject) == ThreeState.YES;
    }

    @ApiStatus.Internal
    @NotNull
    public final ThreeState getProjectTrustedState(@NotNull TrustedProjectsLocator.LocatedProject locatedProject) {
        ThreeState threeState;
        Intrinsics.checkNotNullParameter((Object)locatedProject, (String)"locatedProject");
        ThreeState explicitTrustedState = TrustedPaths.Companion.getInstance().getProjectTrustedState(locatedProject);
        if (explicitTrustedState != ThreeState.UNSURE) {
            threeState = explicitTrustedState;
        } else if (this.isTrustedCheckDisabledForProduct()) {
            threeState = ThreeState.YES;
        } else if (LightEdit.owns((Project)locatedProject.getProject())) {
            threeState = ThreeState.YES;
        } else if (TrustedPathsSettings.Companion.getInstance().isProjectTrusted(locatedProject)) {
            TrustedProjectsStatistics.INSTANCE.getPROJECT_IMPLICITLY_TRUSTED_BY_PATH().log(locatedProject.getProject());
            threeState = ThreeState.YES;
        } else {
            threeState = ThreeState.UNSURE;
        }
        return threeState;
    }

    @ApiStatus.Internal
    public final void setProjectTrusted(@NotNull TrustedProjectsLocator.LocatedProject locatedProject, boolean isTrusted) {
        Intrinsics.checkNotNullParameter((Object)locatedProject, (String)"locatedProject");
        TrustedPaths trustedPaths = TrustedPaths.Companion.getInstance();
        ThreeState oldState = trustedPaths.getProjectTrustedState(locatedProject);
        trustedPaths.setProjectTrustedState(locatedProject, isTrusted);
        ThreeState newState = trustedPaths.getProjectTrustedState(locatedProject);
        if (oldState != newState) {
            TrustedProjectsListener syncPublisher = (TrustedProjectsListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(TrustedProjectsListener.TOPIC);
            if (isTrusted) {
                syncPublisher.onProjectTrusted(locatedProject);
            } else {
                syncPublisher.onProjectUntrusted(locatedProject);
            }
        }
    }

    @ApiStatus.Internal
    public final boolean isTrustedCheckDisabled() {
        boolean isHeadlessMode;
        if (Boolean.getBoolean("idea.trust.all.projects")) {
            return true;
        }
        boolean bl = isHeadlessMode = ApplicationKt.getApplication().isUnitTestMode() || ApplicationKt.getApplication().isHeadlessEnvironment();
        return isHeadlessMode && Boolean.parseBoolean(System.getProperty("idea.trust.headless.disabled", "true"));
    }

    private final boolean isTrustedCheckDisabledForProduct() {
        if (Boolean.getBoolean("idea.trust.disabled")) {
            return true;
        }
        return this.isTrustedCheckDisabled();
    }
}

