/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomizableActionGroupProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.IconLoaderKt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.EmptyIcon;
import java.io.FileNotFoundException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a*\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0007\u001a\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0003H\u0002\u001a(\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001f\u001a\u00020\u001cH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "ACTIONS_SCHEMA", "", "ACTIVE", "ELEMENT_ACTION", "ATTRIBUTE_ID", "ATTRIBUTE_ICON", "GROUP", "additionalIdToName", "Ljava/util/concurrent/ConcurrentHashMap;", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/ide/ui/customization/CustomizableActionGroupProvider;", "fillExtGroups", "", "idToName", "", "extGroupIds", "", "loadCustomIcon", "Ljavax/swing/Icon;", "path", "doLoadCustomIcon", "urlString", "getIconForPath", "actionSupplier", "Lkotlin/Function1;", "Lcom/intellij/openapi/actionSystem/AnAction;", "iconPath", "getOriginalIconFrom", "reuseFrom", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nCustomActionsSchema.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomActionsSchema.kt\ncom/intellij/ide/ui/customization/CustomActionsSchemaKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,638:1\n296#2,2:639\n1#3:641\n13#4:642\n*S KotlinDebug\n*F\n+ 1 CustomActionsSchema.kt\ncom/intellij/ide/ui/customization/CustomActionsSchemaKt\n*L\n565#1:639,2\n48#1:642\n*E\n"})
public final class CustomActionsSchemaKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String ACTIONS_SCHEMA = "custom_actions_schema";
    @NotNull
    private static final String ACTIVE = "active";
    @NotNull
    private static final String ELEMENT_ACTION = "action";
    @NotNull
    private static final String ATTRIBUTE_ID = "id";
    @NotNull
    private static final String ATTRIBUTE_ICON = "icon";
    @NotNull
    private static final String GROUP = "group";
    @NotNull
    private static final ConcurrentHashMap<String, String> additionalIdToName;
    @NotNull
    private static final ExtensionPointName<CustomizableActionGroupProvider> EP_NAME;

    private static final void fillExtGroups(Map<String, String> idToName, Set<String> extGroupIds) {
        for (String id2 : extGroupIds) {
            idToName.remove(id2);
        }
        extGroupIds.clear();
        ArrayList extList = new ArrayList();
        CustomizableActionGroupProvider.CustomizableActionGroupRegistrar registrar = (arg_0, arg_1) -> CustomActionsSchemaKt.fillExtGroups$lambda$0(extList, arg_0, arg_1);
        for (CustomizableActionGroupProvider provider : EP_NAME.getExtensionList()) {
            provider.registerGroups(registrar);
        }
        CollectionsKt.sortWith((List)extList, (arg_0, arg_1) -> CustomActionsSchemaKt.fillExtGroups$lambda$2(CustomActionsSchemaKt::fillExtGroups$lambda$1, arg_0, arg_1));
        Iterator iterator2 = extList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Pair couple = (Pair)e;
            extGroupIds.add((String)couple.getFirst());
            idToName.put((String)couple.getFirst(), (String)couple.getSecond());
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static final Icon loadCustomIcon(@NotNull String path) throws Throwable {
        String string;
        String ext;
        String rawUrl;
        block11: {
            block10: {
                Object v3;
                block9: {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    String string2 = FileUtilRt.toSystemIndependentName((String)path);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
                    String independentPath = string2;
                    int lastDotIndex = StringsKt.lastIndexOf$default((CharSequence)independentPath, (char)'.', (int)0, (boolean)false, (int)6, null);
                    rawUrl = null;
                    ext = null;
                    if (lastDotIndex == -1) {
                        rawUrl = independentPath;
                        ext = "svg";
                    } else {
                        String string3 = independentPath.substring(0, lastDotIndex);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        rawUrl = string3;
                        String string4 = independentPath.substring(lastDotIndex + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                        ext = string4;
                    }
                    Object[] objectArray = new String[]{"@2x_dark", "_dark@2x", "_dark", "@2x"};
                    List possibleSuffixes = CollectionsKt.listOf((Object[])objectArray);
                    Iterable $this$firstOrNull$iv = possibleSuffixes;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        if (!StringsKt.endsWith$default((String)rawUrl, (String)it, (boolean)false, (int)2, null)) continue;
                        v3 = element$iv;
                        break block9;
                    }
                    v3 = null;
                }
                if ((string = (String)v3) == null) break block10;
                String it = string;
                boolean bl = false;
                String string5 = StringsKt.removeSuffix((String)rawUrl, (CharSequence)it);
                string = string5;
                if (string5 != null) break block11;
            }
            string = rawUrl;
        }
        String adjustedUrl = string;
        try {
            return CustomActionsSchemaKt.doLoadCustomIcon(adjustedUrl + "." + ext);
        }
        catch (Throwable t) {
            if (Intrinsics.areEqual((Object)rawUrl, (Object)adjustedUrl)) {
                throw t;
            }
            return CustomActionsSchemaKt.doLoadCustomIcon(rawUrl + "." + ext);
        }
    }

    private static final Icon doLoadCustomIcon(String urlString) {
        if (!StringsKt.startsWith$default((String)urlString, (String)"file:", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)urlString, (String)"jar:", (boolean)false, (int)2, null)) {
            Path file2 = Path.of(urlString, new String[0]);
            if (Files.notExists(file2, new LinkOption[0])) {
                throw new FileNotFoundException("Failed to find icon by URL: " + urlString);
            }
            Intrinsics.checkNotNull((Object)file2);
            CachedImageIcon icon2 = IconLoaderKt.findUserIconByPath((Path)file2);
            int w = icon2.getIconWidth();
            int h = icon2.getIconHeight();
            if (w <= 1 || h <= 1) {
                throw new FileNotFoundException("Failed to find icon by URL: " + urlString);
            }
            if (w > EmptyIcon.ICON_18.getIconWidth() || h > EmptyIcon.ICON_18.getIconHeight()) {
                return (Icon)icon2.scale((float)EmptyIcon.ICON_18.getIconWidth() / (float)RangesKt.coerceAtLeast((int)w, (int)h));
            }
            return (Icon)icon2;
        }
        URL url = new URL(null, urlString);
        Icon icon3 = IconLoader.findIcon((URL)url);
        if (icon3 == null) {
            throw new FileNotFoundException("Failed to find icon by URL: " + url);
        }
        Icon icon4 = icon3;
        int w = icon4.getIconWidth();
        int h = icon4.getIconHeight();
        if (w <= 1 || h <= 1) {
            throw new FileNotFoundException("Failed to find icon by URL: " + url);
        }
        if (w > EmptyIcon.ICON_18.getIconWidth() || h > EmptyIcon.ICON_18.getIconHeight()) {
            float scale = (float)EmptyIcon.ICON_18.getIconWidth() / (float)RangesKt.coerceAtLeast((int)w, (int)h);
            return IconUtil.scale((Icon)icon4, null, (float)scale);
        }
        return icon4;
    }

    @Nullable
    public static final Icon getIconForPath(@NotNull Function1<? super String, ? extends AnAction> actionSupplier, @NotNull String iconPath) {
        Intrinsics.checkNotNullParameter(actionSupplier, (String)"actionSupplier");
        Intrinsics.checkNotNullParameter((Object)iconPath, (String)"iconPath");
        AnAction reuseFrom = (AnAction)actionSupplier.invoke((Object)iconPath);
        if (reuseFrom != null) {
            return CustomActionsSchemaKt.getOriginalIconFrom(reuseFrom);
        }
        try {
            return CustomActionsSchemaKt.loadCustomIcon(iconPath);
        }
        catch (Throwable e) {
            LOG.info(e.getMessage());
            return null;
        }
    }

    @Nullable
    public static final Icon getOriginalIconFrom(@NotNull AnAction reuseFrom) {
        Intrinsics.checkNotNullParameter((Object)reuseFrom, (String)"reuseFrom");
        Presentation presentation2 = reuseFrom.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getTemplatePresentation(...)");
        Presentation presentation3 = presentation2;
        Icon icon2 = (Icon)presentation3.getClientProperty(CustomActionsSchema.PROP_ORIGINAL_ICON);
        if (icon2 == null) {
            icon2 = presentation3.getIcon();
        }
        return icon2;
    }

    private static final void fillExtGroups$lambda$0(ArrayList $extList, String groupId, String groupTitle) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)groupTitle, (String)"groupTitle");
        $extList.add(TuplesKt.to((Object)groupId, (Object)groupTitle));
    }

    private static final int fillExtGroups$lambda$1(Pair o1, Pair o2) {
        return NaturalComparator.INSTANCE.compare(o1.getSecond(), o2.getSecond());
    }

    private static final int fillExtGroups$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    public static final /* synthetic */ void access$fillExtGroups(Map idToName, Set extGroupIds) {
        CustomActionsSchemaKt.fillExtGroups(idToName, extGroupIds);
    }

    public static final /* synthetic */ ExtensionPointName access$getEP_NAME$p() {
        return EP_NAME;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getAdditionalIdToName$p() {
        return additionalIdToName;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(CustomActionsSchema.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
        additionalIdToName = new ConcurrentHashMap();
        EP_NAME = new ExtensionPointName("com.intellij.customizableActionGroupProvider");
    }
}

