/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.text;

import com.intellij.ide.ui.text.paragraph.TextParagraph;
import com.intellij.ide.ui.text.parts.TextPart;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\u0006\u0010\u0014\u001a\u00020\u0011J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0007H\u0004J\u001e\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0011H\u0016J\u0010\u0010\u001f\u001a\u00020\u00112\b\u0010 \u001a\u0004\u0018\u00010!J\u0010\u0010\"\u001a\u00020\u00112\b\u0010 \u001a\u0004\u0018\u00010#R0\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/ide/ui/text/StyledTextPane;", "Ljavax/swing/JTextPane;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "value", "", "Lcom/intellij/ide/ui/text/paragraph/TextParagraph;", "paragraphs", "getParagraphs", "()Ljava/util/List;", "setParagraphs", "(Ljava/util/List;)V", "paragraphRanges", "", "Lkotlin/ranges/IntRange;", "addNotify", "", "updateUI", "redraw", "clear", "getParagraphRange", "paragraph", "findPartByOffset", "Lkotlin/Pair;", "Lcom/intellij/ide/ui/text/parts/TextPart;", "offset", "", "getMaximumSize", "Ljava/awt/Dimension;", "dispose", "addMouseListener", "l", "Ljava/awt/event/MouseListener;", "addMouseMotionListener", "Ljava/awt/event/MouseMotionListener;", "intellij.platform.ide.impl"})
@ApiStatus.Experimental
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nStyledTextPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StyledTextPane.kt\ncom/intellij/ide/ui/text/StyledTextPane\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n363#2,7:138\n*S KotlinDebug\n*F\n+ 1 StyledTextPane.kt\ncom/intellij/ide/ui/text/StyledTextPane\n*L\n117#1:138,7\n*E\n"})
public class StyledTextPane
extends JTextPane
implements Disposable {
    @NotNull
    private List<? extends TextParagraph> paragraphs = CollectionsKt.emptyList();
    @NotNull
    private final List<IntRange> paragraphRanges = new ArrayList();

    public StyledTextPane() {
        UIUtil.doNotScrollToCaret((JTextComponent)this);
        this.setEditable(false);
        MouseAdapter listener2 = new MouseAdapter(this){
            final /* synthetic */ StyledTextPane this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent me) {
                Intrinsics.checkNotNullParameter((Object)me, (String)"me");
                int offset = this.this$0.viewToModel2D(new Point2D.Double(me.getX(), me.getY()));
                Pair<TextPart, IntRange> pair = this.this$0.findPartByOffset(offset);
                if (pair == null) {
                    return;
                }
                Pair<TextPart, IntRange> pair2 = pair;
                TextPart part = (TextPart)pair2.component1();
                IntRange range = (IntRange)pair2.component2();
                Function3<JTextPane, Point, Integer, Unit> onClickAction = part.getOnClickAction();
                if (onClickAction != null) {
                    int middle = (range.getFirst() + range.getLast()) / 2;
                    Rectangle2D rectangle = this.this$0.modelToView2D(middle);
                    onClickAction.invoke((Object)this.this$0, (Object)new Point(MathKt.roundToInt((double)rectangle.getX()), MathKt.roundToInt((double)rectangle.getY()) + MathKt.roundToInt((double)rectangle.getHeight()) / 2), (Object)MathKt.roundToInt((double)rectangle.getHeight()));
                }
            }

            public void mouseMoved(MouseEvent me) {
                Intrinsics.checkNotNullParameter((Object)me, (String)"me");
                int offset = this.this$0.viewToModel2D(new Point2D.Double(me.getX(), me.getY()));
                Pair<TextPart, IntRange> pair = this.this$0.findPartByOffset(offset);
                if (pair == null) {
                    return;
                }
                TextPart part = (TextPart)pair.component1();
                this.this$0.setCursor(part.getOnClickAction() == null ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(12));
            }
        };
        this.addMouseListener(listener2);
        this.addMouseMotionListener(listener2);
        MessageBusConnection connect = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = KeymapManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connect.subscribe(topic, (Object)new KeymapManagerListener(){

            public void activeKeymapChanged(Keymap keymap2) {
                this.redraw();
            }

            public void shortcutsChanged(Keymap keymap2, Collection<String> actionIds, boolean fromSettings) {
                Intrinsics.checkNotNullParameter((Object)keymap2, (String)"keymap");
                Intrinsics.checkNotNullParameter(actionIds, (String)"actionIds");
                this.redraw();
            }
        });
    }

    @NotNull
    public List<TextParagraph> getParagraphs() {
        return this.paragraphs;
    }

    public void setParagraphs(@NotNull List<? extends TextParagraph> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.paragraphs = value;
        this.redraw();
        this.repaint();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.redraw();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        ActionsKt.invokeLater$default(null, () -> StyledTextPane.updateUI$lambda$0(this), (int)1, null);
    }

    public void redraw() {
        this.clear();
        int curOffset = 0;
        Iterator iterator2 = ((Iterable)this.getParagraphs()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int ind = n++;
            TextParagraph paragraph = (TextParagraph)iterator2.next();
            boolean isLast = ind == CollectionsKt.getLastIndex(this.getParagraphs());
            int start2 = curOffset;
            curOffset = paragraph.insertToDocument(this, curOffset, isLast);
            this.paragraphRanges.add(RangesKt.until((int)start2, (int)curOffset));
        }
    }

    public final void clear() {
        this.paragraphRanges.clear();
        this.setText("");
        this.getHighlighter().removeAllHighlights();
    }

    @NotNull
    protected final IntRange getParagraphRange(@NotNull TextParagraph paragraph) {
        Intrinsics.checkNotNullParameter((Object)paragraph, (String)"paragraph");
        int index = this.getParagraphs().indexOf(paragraph);
        if (index != -1) {
            return this.paragraphRanges.get(index);
        }
        throw new IllegalArgumentException("Provided paragraph: " + paragraph + ", do not contained inside this text pane");
    }

    @Nullable
    protected final Pair<TextPart, IntRange> findPartByOffset(int offset) {
        int n;
        block2: {
            List<IntRange> $this$indexOfFirst$iv = this.paragraphRanges;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<IntRange> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                IntRange item$iv;
                IntRange it = item$iv = iterator2.next();
                boolean bl = false;
                int n2 = it.getFirst();
                boolean bl2 = offset <= it.getLast() ? n2 <= offset : false;
                if (bl2) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        int paragraphInd = n;
        return paragraphInd != -1 ? this.getParagraphs().get(paragraphInd).findPartByOffset(offset) : null;
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        return dimension;
    }

    public void dispose() {
    }

    @Override
    public final void addMouseListener(@Nullable MouseListener l) {
        super.addMouseListener(l);
    }

    @Override
    public final void addMouseMotionListener(@Nullable MouseMotionListener l) {
        super.addMouseMotionListener(l);
    }

    private static final Unit updateUI$lambda$0(StyledTextPane this$0) {
        this$0.redraw();
        return Unit.INSTANCE;
    }
}

