/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.text.parts;

import com.intellij.util.ui.JBFont;
import java.awt.Font;
import java.awt.Point;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\u0013\u001a\u00020\u00002\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\u0002\b\u0017H\u0086\b\u00f8\u0001\u0000J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J\n\u0010%\u001a\u00020\u0003H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00020\t8F\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R=\u0010\u001d\u001a+\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001f\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006&"}, d2={"Lcom/intellij/ide/ui/text/parts/TextPart;", "", "text", "", "<init>", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "attributes", "Ljavax/swing/text/SimpleAttributeSet;", "getAttributes", "()Ljavax/swing/text/SimpleAttributeSet;", "fontGetter", "Lkotlin/Function0;", "Ljava/awt/Font;", "getFontGetter", "()Lkotlin/jvm/functions/Function0;", "setFontGetter", "(Lkotlin/jvm/functions/Function0;)V", "editAttributes", "edit", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "insertToTextPane", "", "textPane", "Ljavax/swing/JTextPane;", "startOffset", "onClickAction", "Lkotlin/Function3;", "Ljava/awt/Point;", "Lkotlin/ParameterName;", "name", "height", "getOnClickAction", "()Lkotlin/jvm/functions/Function3;", "toString", "intellij.platform.ide.impl"})
@ApiStatus.Experimental
@ApiStatus.Internal
public abstract class TextPart {
    @NotNull
    private final String text;
    @NotNull
    private final SimpleAttributeSet attributes;
    @NotNull
    private Function0<? extends Font> fontGetter;
    @Nullable
    private final Function3<JTextPane, Point, Integer, Unit> onClickAction;

    public TextPart(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.text = text2;
        this.attributes = new SimpleAttributeSet();
        this.fontGetter = TextPart::fontGetter$lambda$0;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final SimpleAttributeSet getAttributes() {
        SimpleAttributeSet simpleAttributeSet;
        SimpleAttributeSet $this$_get_attributes__u24lambda_u240 = simpleAttributeSet = this.attributes;
        boolean bl = false;
        Font font = (Font)this.fontGetter.invoke();
        StyleConstants.setFontFamily($this$_get_attributes__u24lambda_u240, font.getName());
        StyleConstants.setFontSize($this$_get_attributes__u24lambda_u240, font.getSize());
        return simpleAttributeSet;
    }

    @NotNull
    public final Function0<Font> getFontGetter() {
        return this.fontGetter;
    }

    public final void setFontGetter(@NotNull Function0<? extends Font> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.fontGetter = function0;
    }

    @NotNull
    public final TextPart editAttributes(@NotNull Function1<? super SimpleAttributeSet, Unit> edit) {
        Intrinsics.checkNotNullParameter(edit, (String)"edit");
        boolean $i$f$editAttributes = false;
        edit.invoke((Object)this.getAttributes());
        return this;
    }

    public int insertToTextPane(@NotNull JTextPane textPane, int startOffset) {
        Intrinsics.checkNotNullParameter((Object)textPane, (String)"textPane");
        String textToInsert = this.text;
        textPane.getDocument().insertString(startOffset, textToInsert, this.getAttributes());
        return startOffset + textToInsert.length();
    }

    @Nullable
    public Function3<JTextPane, Point, Integer, Unit> getOnClickAction() {
        return this.onClickAction;
    }

    @NotNull
    public String toString() {
        return this.text;
    }

    private static final Font fontGetter$lambda$0() {
        JBFont jBFont = JBFont.label();
        Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"label(...)");
        return (Font)jBFont;
    }
}

