/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jps.impl;

import com.intellij.jps.impl.JpsPluginBean;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots.SourceRootTypeRegistryImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.UnknownSourceRootType;
import org.jetbrains.jps.model.module.UnknownSourceRootTypeProperties;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.module.JpsModuleSourceRootPropertiesSerializer;
import org.jetbrains.jps.model.serialization.module.UnknownSourceRootPropertiesSerializer;
import org.jetbrains.jps.plugin.JpsPluginManager;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.jps.service.impl.JpsServiceManagerImpl;

@ApiStatus.Internal
public final class JpsIdePluginManagerImpl
extends JpsPluginManager {
    public static final ExtensionPointName<JpsPluginBean> EP_NAME = new ExtensionPointName("com.intellij.jps.plugin");
    private final List<PluginDescriptor> myExternalBuildPlugins = new CopyOnWriteArrayList<PluginDescriptor>();
    private final AtomicInteger myModificationStamp = new AtomicInteger(0);
    private final boolean myFullyLoaded;

    public JpsIdePluginManagerImpl() {
        Application application = ApplicationManager.getApplication();
        boolean bl = this.myFullyLoaded = application != null;
        if (!this.myFullyLoaded) {
            return;
        }
        ExtensionsArea rootArea = application.getExtensionArea();
        if (rootArea.hasExtensionPoint(EP_NAME)) {
            final Ref initial = new Ref((Object)Boolean.TRUE);
            EP_NAME.getPoint().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<JpsPluginBean>(){

                public void extensionAdded(@NotNull JpsPluginBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                    if (extension == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (pluginDescriptor == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (((Boolean)initial.get()).booleanValue()) {
                        JpsIdePluginManagerImpl.this.myExternalBuildPlugins.add(pluginDescriptor);
                    } else {
                        JpsIdePluginManagerImpl.this.handlePluginAdded(pluginDescriptor);
                    }
                }

                public void extensionRemoved(@NotNull JpsPluginBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                    if (extension == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (pluginDescriptor == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    JpsIdePluginManagerImpl.this.handlePluginRemoved(pluginDescriptor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "extension";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "pluginDescriptor";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/jps/impl/JpsIdePluginManagerImpl$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionAdded";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionRemoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, true, null);
            initial.set((Object)Boolean.FALSE);
        }
        if (rootArea.hasExtensionPoint("com.intellij.compileServer.plugin")) {
            ExtensionPoint extensionPoint = rootArea.getExtensionPoint("com.intellij.compileServer.plugin");
            final Ref initial = new Ref((Object)Boolean.TRUE);
            extensionPoint.addExtensionPointListener(new ExtensionPointListener(){

                public void extensionAdded(@NotNull Object extension, @NotNull PluginDescriptor pluginDescriptor) {
                    if (extension == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (pluginDescriptor == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (((Boolean)initial.get()).booleanValue()) {
                        JpsIdePluginManagerImpl.this.myExternalBuildPlugins.add(pluginDescriptor);
                    } else {
                        JpsIdePluginManagerImpl.this.handlePluginAdded(pluginDescriptor);
                    }
                }

                public void extensionRemoved(@NotNull Object extension, @NotNull PluginDescriptor pluginDescriptor) {
                    if (extension == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (pluginDescriptor == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    JpsIdePluginManagerImpl.this.handlePluginRemoved(pluginDescriptor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "extension";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "pluginDescriptor";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/jps/impl/JpsIdePluginManagerImpl$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionAdded";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionRemoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, true, null);
            initial.set((Object)Boolean.FALSE);
        }
    }

    public boolean isFullyLoaded() {
        return this.myFullyLoaded;
    }

    private void handlePluginRemoved(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            JpsIdePluginManagerImpl.$$$reportNull$$$0(0);
        }
        if (!this.myExternalBuildPlugins.contains(pluginDescriptor)) {
            return;
        }
        HashMap<JpsModuleSourceRootType, JpsModuleSourceRootPropertiesSerializer> removed = new HashMap<JpsModuleSourceRootType, JpsModuleSourceRootPropertiesSerializer>();
        for (JpsModelSerializerExtension extension : this.loadExtensions(JpsModelSerializerExtension.class)) {
            for (JpsModuleSourceRootPropertiesSerializer serializer2 : extension.getModuleSourceRootPropertiesSerializers()) {
                removed.put((JpsModuleSourceRootType)serializer2.getType(), serializer2);
            }
        }
        for (JpsModelSerializerExtension extension : this.loadExtensions(JpsModelSerializerExtension.class, descriptor2 -> !descriptor2.equals((Object)pluginDescriptor))) {
            for (JpsModuleSourceRootPropertiesSerializer serializer2 : extension.getModuleSourceRootPropertiesSerializers()) {
                removed.remove(serializer2.getType());
            }
        }
        if (!removed.isEmpty()) {
            for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
                JpsIdePluginManagerImpl.replaceWithUnknownRootType(project2, removed.values());
            }
        }
        this.myExternalBuildPlugins.remove(pluginDescriptor);
        this.myModificationStamp.incrementAndGet();
        JpsServiceManager jpsServiceManager = JpsServiceManager.getInstance();
        if (jpsServiceManager instanceof JpsServiceManagerImpl) {
            ((JpsServiceManagerImpl)jpsServiceManager).cleanupExtensionCache();
        }
        SourceRootTypeRegistryImpl.getInstance().clearCache();
    }

    private void handlePluginAdded(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            JpsIdePluginManagerImpl.$$$reportNull$$$0(1);
        }
        if (this.myExternalBuildPlugins.contains(pluginDescriptor)) {
            return;
        }
        SourceRootTypeRegistryImpl.getInstance().clearCache();
        HashSet<String> before = new HashSet<String>();
        for (JpsModelSerializerExtension extension : this.loadExtensions(JpsModelSerializerExtension.class)) {
            for (JpsModuleSourceRootPropertiesSerializer serializer2 : extension.getModuleSourceRootPropertiesSerializers()) {
                before.add(serializer2.getTypeId());
            }
        }
        this.myExternalBuildPlugins.add(pluginDescriptor);
        this.myModificationStamp.incrementAndGet();
        HashMap<String, JpsModuleSourceRootPropertiesSerializer> added = new HashMap<String, JpsModuleSourceRootPropertiesSerializer>();
        for (JpsModelSerializerExtension extension : this.loadExtensions(JpsModelSerializerExtension.class)) {
            for (JpsModuleSourceRootPropertiesSerializer serializer3 : extension.getModuleSourceRootPropertiesSerializers()) {
                added.put(serializer3.getTypeId(), serializer3);
            }
        }
        added.keySet().removeAll(before);
        if (!added.isEmpty()) {
            for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
                JpsIdePluginManagerImpl.updateCustomRootTypes(project2, added.values());
            }
        }
    }

    private static void replaceWithUnknownRootType(Project project2, Collection<? extends JpsModuleSourceRootPropertiesSerializer<?>> unregisteredSerializers) {
        if (unregisteredSerializers.isEmpty()) {
            return;
        }
        HashMap serializers = new HashMap();
        for (JpsModuleSourceRootPropertiesSerializer<?> serializer2 : unregisteredSerializers) {
            serializers.put((JpsModuleSourceRootType)serializer2.getType(), serializer2);
        }
        for (Module module : ModuleManager.getInstance((Project)project2).getModules()) {
            ModuleRootModificationUtil.modifyModel((Module)module, model2 -> {
                boolean shouldCommit = false;
                for (ContentEntry contentEntry : model2.getContentEntries()) {
                    for (SourceFolder folder : contentEntry.getSourceFolders()) {
                        JpsModuleSourceRootPropertiesSerializer removedSerializer = (JpsModuleSourceRootPropertiesSerializer)serializers.get(folder.getRootType());
                        if (removedSerializer == null) continue;
                        JpsIdePluginManagerImpl.changeType(folder, UnknownSourceRootPropertiesSerializer.forType((String)removedSerializer.getTypeId()), JpsIdePluginManagerImpl.serializeProperties(folder, removedSerializer));
                        shouldCommit = true;
                    }
                }
                return shouldCommit;
            });
        }
    }

    private static void updateCustomRootTypes(Project project2, Collection<? extends JpsModuleSourceRootPropertiesSerializer<?>> registeredSerializers) {
        if (registeredSerializers.isEmpty()) {
            return;
        }
        HashMap serializers = new HashMap();
        for (JpsModuleSourceRootPropertiesSerializer<?> ser : registeredSerializers) {
            serializers.put(ser.getTypeId(), ser);
        }
        for (Module module : ModuleManager.getInstance((Project)project2).getModules()) {
            HashMap<SourceFolder, Pair> foldersToUpdate = new HashMap<SourceFolder, Pair>();
            for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                for (SourceFolder folder : contentEntry.getSourceFolders()) {
                    UnknownSourceRootType type;
                    JpsModuleSourceRootPropertiesSerializer serializer2;
                    JpsModuleSourceRootType jpsModuleSourceRootType = folder.getRootType();
                    if (!(jpsModuleSourceRootType instanceof UnknownSourceRootType) || (serializer2 = (JpsModuleSourceRootPropertiesSerializer)serializers.get((type = (UnknownSourceRootType)jpsModuleSourceRootType).getUnknownTypeId())) == null) continue;
                    UnknownSourceRootTypeProperties properties = (UnknownSourceRootTypeProperties)folder.getJpsElement().getProperties((JpsModuleSourceRootType)type);
                    Object data2 = properties != null ? properties.getPropertiesData() : null;
                    foldersToUpdate.put(folder, new Pair((Object)serializer2, (Object)(data2 instanceof Element ? (Element)data2 : null)));
                }
            }
            if (foldersToUpdate.isEmpty()) continue;
            ModuleRootModificationUtil.updateModel((Module)module, model2 -> {
                for (ContentEntry contentEntry : model2.getContentEntries()) {
                    for (SourceFolder folder : contentEntry.getSourceFolders()) {
                        Pair pair = (Pair)foldersToUpdate.get(folder);
                        if (pair == null) continue;
                        JpsIdePluginManagerImpl.changeType(folder, (JpsModuleSourceRootPropertiesSerializer)pair.first, (Element)pair.second);
                    }
                }
            });
        }
    }

    @Nullable
    private static <P extends JpsElement> Element serializeProperties(SourceFolder root, @NotNull JpsModuleSourceRootPropertiesSerializer<P> serializer2) {
        JpsElement properties;
        if (serializer2 == null) {
            JpsIdePluginManagerImpl.$$$reportNull$$$0(2);
        }
        if ((properties = root.getJpsElement().getProperties((JpsModuleSourceRootType)serializer2.getType())) != null) {
            Element sourceElement = new Element("sourceFolder");
            serializer2.saveProperties(properties, sourceElement);
            return sourceElement;
        }
        return null;
    }

    private static <P extends JpsElement> void changeType(SourceFolder root, @NotNull JpsModuleSourceRootPropertiesSerializer<P> serializer2, @Nullable Element serializedProps) {
        if (serializer2 == null) {
            JpsIdePluginManagerImpl.$$$reportNull$$$0(3);
        }
        root.changeType((JpsModuleSourceRootType)serializer2.getType(), serializedProps != null ? serializer2.loadProperties(serializedProps) : (JpsElement)((JpsModuleSourceRootType)serializer2.getType()).createDefaultProperties());
    }

    public int getModificationStamp() {
        if (!this.myFullyLoaded && this.myModificationStamp.get() == 0 && ApplicationManager.getApplication() != null) {
            this.myModificationStamp.compareAndSet(0, 1);
        }
        return this.myModificationStamp.get();
    }

    @NotNull
    public <T> Collection<T> loadExtensions(@NotNull Class<T> extensionClass) {
        if (extensionClass == null) {
            JpsIdePluginManagerImpl.$$$reportNull$$$0(4);
        }
        return this.loadExtensions(extensionClass, null);
    }

    @NotNull
    private <T> Collection<T> loadExtensions(@NotNull Class<T> extensionClass, @Nullable Predicate<? super PluginDescriptor> filter2) {
        if (extensionClass == null) {
            JpsIdePluginManagerImpl.$$$reportNull$$$0(5);
        }
        LinkedHashSet<ClassLoader> loaders = new LinkedHashSet<ClassLoader>();
        for (PluginDescriptor plugin : this.myExternalBuildPlugins) {
            ClassLoader element;
            if (filter2 != null && !filter2.test((PluginDescriptor)plugin) || (element = plugin.getPluginClassLoader()) == null) continue;
            loaders.add(element);
        }
        if (loaders.isEmpty()) {
            loaders.add(((Object)((Object)this)).getClass().getClassLoader());
        }
        return JpsIdePluginManagerImpl.loadExtensionsFrom(loaders, extensionClass);
    }

    @NotNull
    private static <T> Collection<T> loadExtensionsFrom(@NotNull Collection<? extends ClassLoader> loaders, @NotNull Class<T> extensionClass) {
        if (loaders == null) {
            JpsIdePluginManagerImpl.$$$reportNull$$$0(6);
        }
        if (extensionClass == null) {
            JpsIdePluginManagerImpl.$$$reportNull$$$0(7);
        }
        if (loaders.isEmpty()) {
            List list2 = List.of();
            if (list2 == null) {
                JpsIdePluginManagerImpl.$$$reportNull$$$0(8);
            }
            return list2;
        }
        @NonNls String resourceName = "META-INF/services/" + extensionClass.getName();
        LinkedHashSet classes = new LinkedHashSet();
        HashSet<String> loadedUrls = new HashSet<String>();
        for (ClassLoader classLoader : loaders) {
            try {
                Enumeration<URL> resources = classLoader.getResources(resourceName);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    if (!loadedUrls.add(url.toExternalForm())) continue;
                    JpsIdePluginManagerImpl.loadImplementations(url, classLoader, classes);
                }
            }
            catch (IOException e) {
                throw new ServiceConfigurationError("Cannot load configuration files for " + extensionClass.getName(), e);
            }
        }
        ArrayList<T> extensions = new ArrayList<T>();
        for (Class aClass : classes) {
            try {
                extensions.add(extensionClass.cast(aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
            }
            catch (Exception e) {
                throw new ServiceConfigurationError("Class " + aClass.getName() + " cannot be instantiated", e);
            }
        }
        ArrayList<T> arrayList = extensions;
        if (arrayList == null) {
            JpsIdePluginManagerImpl.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static <T> void loadImplementations(URL url, ClassLoader loader, Set<? super Class<T>> result2) throws IOException {
        for (String name2 : JpsIdePluginManagerImpl.loadClassNames(url)) {
            try {
                result2.add(Class.forName(name2, false, loader));
            }
            catch (ClassNotFoundException e) {
                throw new ServiceConfigurationError("Cannot find class " + name2, e);
            }
        }
    }

    private static List<String> loadClassNames(URL url) throws IOException {
        ArrayList<String> result2 = new ArrayList<String>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                int i2 = line.indexOf(35);
                if (i2 >= 0) {
                    line = line.substring(0, i2);
                }
                if ((line = line.trim()).isEmpty()) continue;
                result2.add(line);
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaders";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jps/impl/JpsIdePluginManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jps/impl/JpsIdePluginManagerImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadExtensionsFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handlePluginRemoved";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handlePluginAdded";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serializeProperties";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "changeType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadExtensions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadExtensionsFrom";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9 -> new IllegalStateException(string);
        };
    }
}

