/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.notification.ActionCenter;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.notification.impl.ApplicationNotificationsModel;
import com.intellij.notification.impl.NotificationCollector;
import com.intellij.notification.impl.NotificationFullContent;
import com.intellij.notification.impl.NotificationParentGroup;
import com.intellij.notification.impl.NotificationScopeKt;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.notification.impl.ui.NotificationsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeBalloonLayoutImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceKt;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutConfiguration;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.NotificationBalloonActionProvider;
import com.intellij.ui.NotificationBalloonRoundShadowBorderProvider;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtil;
import com.intellij.util.FontUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.SingleEdtTaskScheduler;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotificationsManagerImpl
extends NotificationsManager {
    public static final Color DEFAULT_TEXT_COLOR = new JBColor((Color)Gray._0, (Color)Gray._191);
    public static final Color FILL_COLOR = JBColor.namedColor((String)"Notification.background", (Color)new JBColor((Color)Gray._242, new Color(5132370)));
    public static final Color BORDER_COLOR = JBColor.namedColor((String)"Notification.borderColor", (Color)new JBColor(-843926862, -849978788));
    public static final Object NOTIFICATION_BALLOON_FLAG = new Object();
    private static final Logger LOG = Logger.getInstance(NotificationsManagerImpl.class);
    @Nullable
    private @Nullable List<Pair<Notification, @Nullable Project>> myEarlyNotifications = new ArrayList<Pair<Notification, Project>>();
    @Nullable
    private @Nullable List<Pair<Notification, @Nullable Project>> myPostponedNotifications = null;
    private final IJTracer myTracer = TelemetryManager.getInstance().getTracer(NotificationScopeKt.NotificationScope);

    public NotificationsManagerImpl() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

            public void projectClosed(@NotNull Project project2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (NotificationsManagerImpl.this.myEarlyNotifications != null) {
                    NotificationsManagerImpl.this.myEarlyNotifications.removeIf(pair -> project2.equals(pair.second));
                }
                for (Notification notification2 : NotificationsManagerImpl.this.getNotificationsOfType(Notification.class, project2)) {
                    notification2.hideBalloon();
                }
                TooltipController.getInstance().resetCurrent();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/notification/impl/NotificationsManagerImpl$1", "projectClosed"));
            }
        });
    }

    public void expire(@NotNull Notification notification2) {
        if (notification2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(0);
        }
        UIUtil.invokeLaterIfNeeded(() -> ApplicationNotificationsModel.remove(notification2));
    }

    public <T extends Notification> T @NotNull [] getNotificationsOfType(@NotNull Class<T> klass, @Nullable Project project2) {
        if (klass == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(1);
        }
        ArrayList<Notification> result2 = new ArrayList<Notification>();
        if (project2 == null || !project2.isDefault() && !project2.isDisposed()) {
            for (Notification notification2 : ApplicationNotificationsModel.getNotifications(project2)) {
                if (!klass.isInstance(notification2)) continue;
                Notification t = notification2;
                result2.add(t);
            }
        }
        Notification[] notificationArray = (Notification[])ArrayUtil.toObjectArray(result2, klass);
        if (notificationArray == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(2);
        }
        return notificationArray;
    }

    public void showNotification(@NotNull Notification notification2, @Nullable Project project2) {
        if (notification2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(3);
        }
        NotificationsConfigurationImpl configuration = NotificationsConfigurationImpl.getInstanceImpl();
        NotificationSettings settings = NotificationsConfigurationImpl.getSettings(notification2.getGroupId());
        if (!configuration.isRegistered(notification2.getGroupId())) {
            configuration.register(notification2.getGroupId(), NotificationDisplayType.BALLOON);
        }
        if (!(settings.isShouldLog() || settings.getDisplayType() != NotificationDisplayType.NONE && !notification2.isShowingPopupSuppressed() && configuration.SHOW_BALLOONS)) {
            notification2.expire();
        }
        if (configuration.SHOW_BALLOONS) {
            if (project2 == null) {
                ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.any(), (Condition)ApplicationManager.getApplication().getDisposed(), () -> this.showNotificationWithSpan(notification2, null));
            } else if (!project2.isDisposed()) {
                StartupManager.getInstance((Project)project2).runAfterOpened(() -> ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.any(), (Condition)project2.getDisposed(), () -> this.showNotificationWithSpan(notification2, project2)));
            }
        }
    }

    @RequiresEdt
    @ApiStatus.Internal
    public void dispatchEarlyNotifications() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myEarlyNotifications != null) {
            List<Pair<Notification, @Nullable Project>> copy2 = this.myEarlyNotifications;
            this.myEarlyNotifications = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("dispatching early notifications: " + String.valueOf(copy2));
            }
            copy2.forEach(early -> this.showNotificationWithSpan((Notification)early.first, (Project)early.second));
        }
    }

    @IntellijInternalApi
    @RequiresEdt
    @ApiStatus.Internal
    public void pauseNotifications() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myPostponedNotifications == null) {
            this.myPostponedNotifications = new ArrayList<Pair<Notification, Project>>();
        }
    }

    @IntellijInternalApi
    @RequiresEdt
    @ApiStatus.Internal
    public void resumeNotifications() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myPostponedNotifications != null) {
            List<Pair<Notification, @Nullable Project>> postponedNotifications = this.myPostponedNotifications;
            this.myPostponedNotifications = null;
            postponedNotifications.forEach(pair -> this.showNotificationWithSpan((Notification)pair.first, (Project)pair.second));
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private void showNotificationInner(Notification notification2, @Nullable Project project2) {
        void project3;
        void notification3;
        ThreadingAssertions.assertEventDispatchThread();
        if (LOG.isDebugEnabled()) {
            LOG.debug("incoming: " + String.valueOf(notification3) + ", project=" + String.valueOf(project3));
        }
        if (this.myEarlyNotifications != null) {
            this.myEarlyNotifications.add((Pair<Notification, Project>)new Pair((Object)notification3, (Object)project3));
            return;
        }
        if (this.myPostponedNotifications != null) {
            this.myPostponedNotifications.add((Pair<Notification, Project>)new Pair((Object)notification3, (Object)project3));
            return;
        }
        String groupId = notification3.getGroupId();
        NotificationSettings settings = NotificationsConfigurationImpl.getSettings(groupId);
        NotificationDisplayType type = settings.getDisplayType();
        String toolWindowId = notification3.getToolWindowId();
        if (toolWindowId == null) {
            toolWindowId = NotificationsConfigurationImpl.getInstanceImpl().getToolWindowId(groupId);
        }
        if (!(type != NotificationDisplayType.TOOL_WINDOW || toolWindowId != null && project3 != null && ToolWindowManager.getInstance((Project)project3).canShowNotification(toolWindowId))) {
            type = NotificationDisplayType.BALLOON;
        }
        if (notification3.isShowingPopupSuppressed()) {
            type = NotificationDisplayType.NONE;
            if (LOG.isDebugEnabled()) {
                LOG.debug("showing popup is suppressed for the notification");
            }
        }
        switch (type) {
            case NONE: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("not shown (type=NONE): " + String.valueOf(notification3));
                break;
            }
            case STICKY_BALLOON: 
            case BALLOON: {
                Balloon balloon = NotificationsManagerImpl.notifyByBalloon((Notification)notification3, type, (Project)project3);
                if (balloon == null && LOG.isDebugEnabled()) {
                    LOG.debug("not shown (no balloon): " + String.valueOf(notification3));
                }
                if (project3 == null || project3.isDefault() || settings.isShouldLog() && type != NotificationDisplayType.STICKY_BALLOON) break;
                if (balloon == null) {
                    notification3.expire();
                    break;
                }
                balloon.addListener(new JBPopupListener(){
                    final /* synthetic */ Notification val$notification;
                    {
                        this.val$notification = notification2;
                    }

                    public void onClosed(@NotNull LightweightWindowEvent event) {
                        if (event == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (!event.isOk()) {
                            this.val$notification.expire();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/notification/impl/NotificationsManagerImpl$2", "onClosed"));
                    }
                });
                break;
            }
            case TOOL_WINDOW: {
                NotificationListener notificationListener;
                BalloonLayout layout2;
                Window window;
                MessageType messageType = notification3.getType() == NotificationType.ERROR ? MessageType.ERROR : (notification3.getType() == NotificationType.WARNING ? MessageType.WARNING : MessageType.INFO);
                Object messageBody = notification3.getTitle();
                HyperlinkListener listener2 = null;
                String content2 = notification3.getContent();
                if (!content2.isEmpty()) {
                    if (!((String)messageBody).isEmpty()) {
                        messageBody = (String)messageBody + String.valueOf(HtmlChunk.br());
                    }
                    messageBody = (String)messageBody + content2;
                }
                List actions = notification3.getActions();
                final HashMap<CallSite, AnAction> actionListeners = new HashMap<CallSite, AnAction>();
                if (!actions.isEmpty()) {
                    messageBody = (String)messageBody + String.valueOf(HtmlChunk.br());
                    for (int index = 0; index < actions.size(); ++index) {
                        AnAction action2 = (AnAction)actions.get(index);
                        String text2 = action2.getTemplatePresentation().getText();
                        if (text2 == null) continue;
                        String linkTarget = "notification-action-" + index + "for-tool-window-" + System.identityHashCode(notification3);
                        actionListeners.put((CallSite)((Object)linkTarget), action2);
                        messageBody = (String)messageBody + String.valueOf(HtmlChunk.link((String)linkTarget, (String)text2));
                        messageBody = (String)messageBody + " ";
                    }
                }
                if ((window = NotificationsManagerImpl.findWindowForBalloon((Project)project3)) instanceof IdeFrame && (layout2 = ((IdeFrame)window).getBalloonLayout()) != null) {
                    ((BalloonLayoutImpl)layout2).remove((Notification)notification3);
                }
                if ((notificationListener = notification3.getListener()) != null || !actionListeners.isEmpty()) {
                    listener2 = new HyperlinkListener(){
                        final /* synthetic */ Notification val$notification;
                        final /* synthetic */ Project val$project;
                        final /* synthetic */ NotificationListener val$notificationListener;
                        {
                            this.val$notification = notification2;
                            this.val$project = project2;
                            this.val$notificationListener = notificationListener;
                        }

                        @Override
                        public void hyperlinkUpdate(HyperlinkEvent e) {
                            AnAction action2;
                            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (action2 = (AnAction)actionListeners.get(e.getDescription())) != null) {
                                DataContext dataContext2;
                                Object source = e.getSource();
                                if (source instanceof Component) {
                                    Component o = (Component)source;
                                    dataContext2 = CustomizedDataContext.withSnapshot((DataContext)DataManager.getInstance().getDataContext(o), sink -> sink.set(Notification.KEY, (Object)this.val$notification));
                                } else {
                                    dataContext2 = null;
                                }
                                DataContext context2 = dataContext2;
                                Notification.fire((Notification)this.val$notification, (AnAction)action2, context2);
                                NotificationCollector.getInstance().logNotificationActionInvoked(this.val$project, this.val$notification, action2, NotificationCollector.NotificationPlace.TOOL_WINDOW);
                                return;
                            }
                            if (this.val$notificationListener != null) {
                                this.val$notificationListener.hyperlinkUpdate(this.val$notification, e);
                            }
                        }
                    };
                }
                ToolWindowManager.getInstance((Project)((Project)Objects.requireNonNull(project3))).notifyByBalloon(toolWindowId, messageType, (String)messageBody, notification3.getIcon(), listener2);
                NotificationCollector.getInstance().logToolWindowNotificationShown((Project)project3, (Notification)notification3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private void showNotificationWithSpan(Notification notification2, @Nullable Project project2) {
        void notification3;
        void project3;
        ThreadingAssertions.assertEventDispatchThread();
        TraceKt.use((SpanBuilder)this.myTracer.spanBuilder("show notification").setAttribute("project", project3 == null ? null : project3.toString()).setAttribute("notification", notification3.toString()), arg_0 -> this.lambda$showNotificationWithSpan$6((Notification)notification3, (Project)project3, arg_0));
    }

    @Nullable
    private static Balloon notifyByBalloon(Notification notification2, NotificationDisplayType displayType, @Nullable Project project2) {
        if (NotificationsManagerImpl.isDummyEnvironment()) {
            return null;
        }
        if (!notification2.canShowFor(project2)) {
            return null;
        }
        Window window = NotificationsManagerImpl.findWindowForBalloon(project2);
        if (!(window instanceof IdeFrame)) {
            return null;
        }
        BalloonLayout layout2 = ((IdeFrame)window).getBalloonLayout();
        if (layout2 == null) {
            return null;
        }
        Ref layoutDataRef = new Ref();
        if (project2 == null || project2.isDefault()) {
            BalloonLayoutData layoutData = new BalloonLayoutData();
            layoutData.groupId = "";
            layoutData.welcomeScreen = layout2 instanceof WelcomeBalloonLayoutImpl;
            layoutData.type = notification2.getType();
            layoutDataRef.set((Object)layoutData);
        } else {
            BalloonLayoutData.MergeInfo mergeData = ((BalloonLayoutImpl)layout2).preMerge(notification2);
            if (mergeData != null) {
                BalloonLayoutData layoutData = new BalloonLayoutData();
                layoutData.mergeData = mergeData;
                layoutDataRef.set((Object)layoutData);
            }
        }
        Project disposable = project2 != null ? project2 : ApplicationManager.getApplication();
        Balloon balloon = NotificationsManagerImpl.createBalloon((IdeFrame)window, notification2, false, false, (Ref<BalloonLayoutData>)layoutDataRef, (Disposable)disposable);
        if (notification2.isExpired()) {
            return null;
        }
        BalloonLayoutData layoutData = (BalloonLayoutData)layoutDataRef.get();
        layout2.add(balloon, (Object)layoutData);
        if (balloon.isDisposed()) {
            return null;
        }
        if (layoutData != null) {
            layoutData.project = project2;
        }
        if (balloon instanceof BalloonImpl) {
            NotificationsManagerImpl.frameActivateBalloonListener((Disposable)balloon, () -> {
                if (!balloon.isDisposed()) {
                    int delay = displayType == NotificationDisplayType.STICKY_BALLOON ? 300000 : 10000;
                    ((BalloonImpl)balloon).startSmartFadeoutTimer(delay);
                }
            });
        }
        NotificationCollector.getInstance().logBalloonShown(project2, displayType, notification2, layoutData != null && layoutData.isExpandable);
        return balloon;
    }

    public static void frameActivateBalloonListener(@NotNull Disposable parentDisposable, final @NotNull Runnable callback) {
        if (parentDisposable == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(4);
        }
        if (callback == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isActive()) {
            callback.run();
        } else {
            final Disposable listenerDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)parentDisposable, (Disposable)listenerDisposable);
            ApplicationManager.getApplication().getMessageBus().connect(listenerDisposable).subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

                public void applicationActivated(@NotNull IdeFrame ideFrame) {
                    if (ideFrame == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    Disposer.dispose((Disposable)listenerDisposable);
                    callback.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/notification/impl/NotificationsManagerImpl$4", "applicationActivated"));
                }
            });
        }
    }

    @Nullable
    public static Window findWindowForBalloon(@Nullable Project project2) {
        Window frame = WindowManager.getInstance().getFrame(project2);
        if (frame == null && project2 == null) {
            frame = (Window)WelcomeFrame.getInstance();
        }
        if (frame == null && project2 == null) {
            DialogWrapper wrapper2;
            frame = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            while (frame instanceof DialogWrapperDialog && (wrapper2 = ((DialogWrapperDialog)frame).getDialogWrapper()) != null && wrapper2.isModalProgress()) {
                frame = frame.getOwner();
            }
        }
        if (frame == null && project2 == null) {
            frame = WindowManager.getInstance().findVisibleFrame();
        }
        return frame;
    }

    @NotNull
    public static Balloon createBalloon(@NotNull IdeFrame window, @NotNull Notification notification2, boolean showCallout, boolean hideOnClickOutside, @NotNull Ref<BalloonLayoutData> layoutDataRef, @NotNull Disposable parentDisposable) {
        if (window == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(6);
        }
        if (notification2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(7);
        }
        if (layoutDataRef == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(8);
        }
        if (parentDisposable == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(9);
        }
        return NotificationsManagerImpl.createBalloon(window.getComponent(), notification2, showCallout, hideOnClickOutside, layoutDataRef, parentDisposable);
    }

    @NotNull
    public static Balloon createBalloon(@Nullable JComponent windowComponent, @NotNull Notification notification2, boolean showCallout, boolean hideOnClickOutside, @NotNull Ref<BalloonLayoutData> layoutDataRef, @NotNull Disposable parentDisposable) {
        BalloonLayoutData layoutData;
        if (notification2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(10);
        }
        if (layoutDataRef == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(11);
        }
        if (parentDisposable == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(12);
        }
        BalloonLayoutData balloonLayoutData = layoutData = layoutDataRef.isNull() ? new BalloonLayoutData() : (BalloonLayoutData)layoutDataRef.get();
        if (layoutData.groupId == null) {
            layoutData.groupId = notification2.getGroupId();
        } else {
            layoutData.groupId = null;
            layoutData.mergeData = null;
        }
        layoutData.id = notification2.id;
        layoutData.displayId = notification2.getDisplayId();
        layoutDataRef.set((Object)layoutData);
        if (layoutData.textColor == null) {
            layoutData.textColor = JBColor.namedColor((String)"Notification.foreground", (Color)DEFAULT_TEXT_COLOR);
        }
        if (layoutData.fillColor == null) {
            layoutData.fillColor = FILL_COLOR;
        }
        if (layoutData.borderColor == null) {
            layoutData.borderColor = BORDER_COLOR;
        }
        layoutData.collapseType = notification2.isSuggestionType() ? (notification2.isImportantSuggestion() ? BalloonLayoutData.Type.ImportantSuggestion : BalloonLayoutData.Type.Suggestion) : BalloonLayoutData.Type.Timeline;
        boolean actions = !notification2.getActions().isEmpty() || notification2.getContextHelpAction() != null;
        boolean showFullContent = layoutData.showFullContent || notification2 instanceof NotificationFullContent;
        JEditorPane text2 = new JEditorPane(){

            @Override
            protected void paintComponent(Graphics g) {
                Point location;
                super.paintComponent(g);
                if (layoutData.showMinSize && (location = NotificationsManagerImpl.getCollapsedTextEndLocation(this, layoutData)) != null) {
                    if (g instanceof Graphics2D) {
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    }
                    g.setColor(this.getForeground());
                    g.drawString("...", location.x, location.y + g.getFontMetrics().getAscent());
                }
            }
        };
        NotificationsUtil.configureHtmlEditorKit(text2, true);
        text2.setForeground(layoutData.textColor);
        HyperlinkListener listener2 = NotificationsUtil.wrapListener(notification2);
        if (listener2 != null) {
            text2.addHyperlinkListener(listener2);
        }
        Supplier<@Nls String> textBuilder = () -> {
            String fontStyle = NotificationsUtil.getFontStyle();
            int prefSize = new JLabel((String)NotificationsUtil.buildHtml((Notification)notification2, null, (boolean)true, null, (String)fontStyle)).getPreferredSize().width;
            String style = layoutData.showFullContent ? (prefSize > BalloonLayoutConfiguration.MaxFullContentWidth() ? BalloonLayoutConfiguration.MaxFullContentWidthStyle() : null) : (prefSize > BalloonLayoutConfiguration.MaxWidth() ? BalloonLayoutConfiguration.MaxWidthStyle() : null);
            return NotificationsUtil.buildHtml(notification2, style, true, null, fontStyle);
        };
        String textContent = textBuilder.get();
        text2.setText(textContent);
        NotificationsManagerImpl.setTextAccessibleName(text2, textContent);
        text2.setEditable(false);
        text2.setOpaque(false);
        text2.setBorder(null);
        NonOpaquePanel content2 = new NonOpaquePanel((LayoutManager)new BorderLayout(JBUI.scale((int)(ExperimentalUI.isNewUI() ? 2 : 0)), 0));
        content2.setBorder(JBUI.Borders.empty((Insets)JBUI.insets((String)"Notification.borderInsets", (JBInsets)(ExperimentalUI.isNewUI() ? JBUI.insets((int)4, (int)4, (int)6, (int)0) : JBInsets.emptyInsets()))));
        if (text2.getCaret() != null) {
            text2.setCaretPosition(0);
        }
        final JScrollPane pane2 = NotificationsManagerImpl.createBalloonScrollPane(text2, false);
        pane2.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                JScrollBar scrollBar = pane2.getVerticalScrollBar();
                if (layoutData.showMinSize && scrollBar.getValue() > 0) {
                    scrollBar.removeAdjustmentListener(this);
                    scrollBar.setValue(0);
                    scrollBar.addAdjustmentListener(this);
                }
            }
        });
        LinkLabel expandAction = null;
        int lines = 4;
        if (notification2.hasTitle()) {
            --lines;
        }
        if (actions) {
            --lines;
        }
        layoutData.fullHeight = text2.getPreferredSize().height;
        layoutData.twoLineHeight = NotificationsManagerImpl.calculateContentHeight(lines);
        layoutData.maxScrollHeight = Math.min(layoutData.fullHeight, NotificationsManagerImpl.calculateContentHeight(10));
        layoutData.configuration = BalloonLayoutConfiguration.create(notification2, layoutData, actions);
        if (layoutData.welcomeScreen) {
            layoutData.maxScrollHeight = layoutData.fullHeight;
        } else if (!showFullContent && layoutData.maxScrollHeight != layoutData.fullHeight) {
            pane2.setViewport((JViewport)((Object)new GradientViewport(text2, (Insets)JBInsets.create((int)10, (int)0), true){

                @Override
                @Nullable
                protected Color getViewColor() {
                    return layoutData.fillColor;
                }

                @Override
                protected void paintGradient(Graphics g) {
                    if (!layoutData.showMinSize) {
                        super.paintGradient(g);
                    }
                }
            }));
        }
        NotificationsManagerImpl.configureBalloonScrollPane(pane2, layoutData.fillColor);
        if (showFullContent) {
            if (windowComponent == null) {
                pane2.setPreferredSize(text2.getPreferredSize());
            } else {
                pane2.setPreferredSize(new Dimension(text2.getPreferredSize().width, (int)Math.min((double)layoutData.fullHeight, (double)windowComponent.getHeight() * 0.75)));
            }
        } else if (layoutData.twoLineHeight < layoutData.fullHeight) {
            text2.setPreferredSize(null);
            Dimension size2 = text2.getPreferredSize();
            size2.height = layoutData.twoLineHeight;
            text2.setPreferredSize(size2);
            text2.setSize(size2);
            layoutData.showMinSize = true;
            pane2.setHorizontalScrollBarPolicy(31);
            pane2.setVerticalScrollBarPolicy(21);
            pane2.setPreferredSize(size2);
            text2.setCaret(new TextCaret(layoutData));
            expandAction = new LinkLabel(null, AllIcons.Ide.Notification.Expand, (arg_0, arg_1) -> NotificationsManagerImpl.lambda$createBalloon$9(layoutData, text2, pane2, notification2, (JPanel)content2, arg_0, arg_1));
            expandAction.setHoveringIcon(AllIcons.Ide.Notification.ExpandHover);
            layoutData.isExpandable = true;
        }
        NotificationCenterPanel centerPanel = new NotificationCenterPanel(text2, layoutData);
        content2.add((Component)((Object)centerPanel), "Center");
        if (notification2.hasTitle()) {
            String titleStyle = StringUtil.defaultIfEmpty((String)NotificationsUtil.getFontStyle(), (String)"") + "white-space:nowrap;";
            JLabel title2 = new JLabel();
            String titleContent = NotificationsUtil.buildHtml(notification2, titleStyle, false, null, null);
            title2.setText(titleContent);
            NotificationsManagerImpl.setTextAccessibleName(title2, titleContent);
            title2.setOpaque(false);
            title2.setForeground(layoutData.textColor);
            centerPanel.addTitle(title2);
        }
        if (expandAction != null) {
            centerPanel.addExpandAction(expandAction);
        }
        if (notification2.hasContent()) {
            centerPanel.addContent(layoutData.welcomeScreen ? text2 : pane2);
        }
        final Icon icon2 = NotificationsUtil.getIcon(notification2);
        JComponent iconComponent = new JComponent(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                icon2.paintIcon(this, g, layoutData.configuration.iconOffset.width, layoutData.configuration.iconOffset.height);
            }
        };
        iconComponent.setOpaque(false);
        Runnable iconSizeRunnable = () -> iconComponent.setPreferredSize(new Dimension(Math.max(layoutData.configuration.iconPanelWidth, icon2.getIconWidth() + layoutData.configuration.iconOffset.width + JBUIScale.scale((int)5)), 2 * layoutData.configuration.iconOffset.height + icon2.getIconHeight()));
        iconSizeRunnable.run();
        content2.add((Component)iconComponent, "West");
        HoverAdapter hoverAdapter = new HoverAdapter();
        hoverAdapter.addSource((Component)content2);
        hoverAdapter.addSource((Component)((Object)centerPanel));
        hoverAdapter.addSource(text2);
        hoverAdapter.addSource(pane2);
        if (actions) {
            NotificationsManagerImpl.createActionPanel(notification2, centerPanel, layoutData.configuration.actionGap, hoverAdapter);
        }
        if (expandAction != null) {
            hoverAdapter.addComponent((Component)expandAction, arg_0 -> NotificationsManagerImpl.lambda$createBalloon$11((JPanel)content2, layoutData, text2, pane2, arg_0));
        }
        hoverAdapter.initListeners();
        if (layoutData.mergeData != null) {
            NotificationsManagerImpl.createMergeAction(layoutData, (JPanel)content2);
        }
        text2.setSize(text2.getPreferredSize());
        Runnable paneSizeRunnable = () -> {
            Dimension paneSize = new Dimension(text2.getPreferredSize());
            int maxWidth = JBUIScale.scale((int)600);
            if (windowComponent != null) {
                maxWidth = Math.min(maxWidth, windowComponent.getWidth() - 20);
            }
            if (paneSize.width > maxWidth) {
                pane2.setPreferredSize(new Dimension(maxWidth, paneSize.height + UIUtil.getScrollBarWidth()));
            }
        };
        paneSizeRunnable.run();
        content2.putClientProperty(NOTIFICATION_BALLOON_FLAG, new Object());
        BalloonBuilder builder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)content2);
        builder.setFillColor(layoutData.fillColor).setCloseButtonEnabled(true).setShowCallout(showCallout).setShadow(false).setAnimationCycle(200).setHideOnClickOutside(hideOnClickOutside).setHideOnAction(hideOnClickOutside).setHideOnKeyOutside(hideOnClickOutside).setHideOnFrameResize(false).setBorderColor(layoutData.borderColor).setBorderInsets((Insets)JBInsets.emptyInsets());
        Balloon balloon = builder.createBalloon();
        if (balloon instanceof BalloonImpl) {
            BalloonImpl balloonImpl = (BalloonImpl)balloon;
            balloonImpl.getContent().addMouseListener(new MouseAdapter(){});
            balloon.setAnimationEnabled(false);
            balloonImpl.setShadowBorderProvider(new NotificationBalloonRoundShadowBorderProvider(layoutData.fillColor, layoutData.borderColor));
            if (!layoutData.welcomeScreen) {
                balloonImpl.setActionProvider(new NotificationBalloonActionProvider(balloonImpl, centerPanel.getTitle(), layoutData, notification2));
            }
            if (layoutData.fadeoutTime != 0L) {
                ((BalloonImpl)balloon).startSmartFadeoutTimer((int)layoutData.fadeoutTime);
            }
        }
        notification2.setBalloon(balloon);
        int _lines = lines;
        Runnable lafCallback = () -> NotificationsManagerImpl.lambda$createBalloon$13(text2, textBuilder, layoutData, _lines, notification2, actions, showFullContent, windowComponent, pane2, iconSizeRunnable, paneSizeRunnable, (JPanel)content2);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)balloon);
        connection.subscribe(LafManagerListener.TOPIC, source -> SwingUtilities.invokeLater(lafCallback));
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> lafCallback.run());
        Disposer.register((Disposable)parentDisposable, (Disposable)balloon);
        Balloon balloon2 = balloon;
        if (balloon2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(13);
        }
        return balloon2;
    }

    public static void setTextAccessibleName(@NotNull JComponent component2, @NotNull String htmlContent) {
        if (component2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(14);
        }
        if (htmlContent == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(15);
        }
        component2.putClientProperty("AccessibleName", StringUtil.unescapeXmlEntities((String)StringUtil.stripHtml((String)htmlContent, (String)" ")));
    }

    @NotNull
    public static JScrollPane createBalloonScrollPane(@NotNull Component content2, boolean configure2) {
        if (content2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(16);
        }
        JScrollPane pane2 = ScrollPaneFactory.createScrollPane((Component)content2, (boolean)true);
        if (configure2) {
            NotificationsManagerImpl.configureBalloonScrollPane(pane2, FILL_COLOR);
        }
        JScrollPane jScrollPane = pane2;
        if (jScrollPane == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(17);
        }
        return jScrollPane;
    }

    public static void configureBalloonScrollPane(@NotNull JScrollPane pane2, @NotNull Color fillColor) {
        if (pane2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(18);
        }
        if (fillColor == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(19);
        }
        pane2.setOpaque(false);
        pane2.getViewport().setOpaque(false);
        pane2.setBackground(fillColor);
        pane2.getViewport().setBackground(fillColor);
        pane2.getVerticalScrollBar().setBackground(fillColor);
    }

    private static void createActionPanel(final Notification notification2, NotificationCenterPanel centerPanel, int gap, HoverAdapter hoverAdapter) {
        AnAction helpAction;
        NotificationActionPanel actionPanel = new NotificationActionPanel(gap, notification2.getCollapseDirection()){

            public void uiDataSnapshot(@NotNull DataSink sink) {
                if (sink == null) {
                    10.$$$reportNull$$$0(0);
                }
                sink.set(Notification.KEY, (Object)notification2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/notification/impl/NotificationsManagerImpl$10", "uiDataSnapshot"));
            }
        };
        centerPanel.addActionPanel(actionPanel);
        List actions = notification2.getActions();
        int actionsSize = actions.size();
        if (notification2.isSuggestionType()) {
            if (actionsSize > 0) {
                AnAction action2 = (AnAction)actions.get(0);
                JButton button2 = new JButton(action2.getTemplateText());
                button2.setOpaque(false);
                NotificationsManagerImpl.setButtonColor(button2, "Notification.Button.foreground", "JButton.textColor");
                NotificationsManagerImpl.setButtonColor(button2, "Notification.Button.background", "JButton.backgroundColor");
                NotificationsManagerImpl.setButtonColor(button2, "Notification.Button.borderColor", "JButton.borderColor");
                actionPanel.addAction(button2);
                button2.addActionListener(e -> {
                    NotificationCollector.getInstance().logNotificationActionInvoked(null, notification2, action2, NotificationCollector.NotificationPlace.BALLOON);
                    Notification.fire((Notification)notification2, (AnAction)action2, (DataContext)DataManager.getInstance().getDataContext((Component)button2));
                });
                boolean bl = actionPanel.checkActionWidth = actionsSize > 1;
                if (actionsSize == 2) {
                    actionPanel.addAction((JComponent)NotificationsManagerImpl.createAction(notification2, (AnAction)actions.get(1)));
                } else if (actionsSize > 2) {
                    if (notification2.isAddExtraAction()) {
                        actionPanel.addAction((JComponent)NotificationsManagerImpl.createAction(notification2, (AnAction)actions.get(1)));
                        if (actionsSize == 3) {
                            actionPanel.addAction((JComponent)NotificationsManagerImpl.createAction(notification2, (AnAction)actions.get(2)));
                        } else {
                            NotificationsManagerImpl.addDropDownAction(actionPanel, notification2, 2);
                        }
                    } else {
                        NotificationsManagerImpl.addDropDownAction(actionPanel, notification2, 1);
                    }
                }
            }
        } else {
            if (actionsSize > 1 && notification2.getCollapseDirection() == Notification.CollapseActionsDirection.KEEP_RIGHTMOST) {
                NotificationsManagerImpl.addDropDownAction(notification2, actionPanel);
            }
            for (AnAction action3 : actions) {
                actionPanel.addActionLink(NotificationsManagerImpl.createAction(notification2, action3));
            }
            if (actionsSize > 1 && notification2.getCollapseDirection() == Notification.CollapseActionsDirection.KEEP_LEFTMOST) {
                NotificationsManagerImpl.addDropDownAction(notification2, actionPanel);
            }
        }
        if ((helpAction = notification2.getContextHelpAction()) != null) {
            Presentation presentation2 = helpAction.getTemplatePresentation();
            ContextHelpLabel helpLabel = ContextHelpLabel.create((String)StringUtil.defaultIfEmpty((String)presentation2.getText(), (String)""), (String)presentation2.getDescription());
            helpLabel.setForeground(UIUtil.getLabelDisabledForeground());
            actionPanel.addAction((JComponent)helpLabel);
        }
        JBInsets hover = JBUI.insets((int)8, (int)5, (int)8, (int)7);
        int count = actionPanel.getComponentCount();
        for (int i2 = 0; i2 < count; ++i2) {
            hoverAdapter.addComponent(actionPanel.getComponent(i2), (Insets)hover);
        }
        hoverAdapter.addSource((Component)((Object)actionPanel));
    }

    private static void setButtonColor(@NotNull JButton button2, @NotNull String colorKey, @NotNull String colorProperty) {
        if (button2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(20);
        }
        if (colorKey == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(21);
        }
        if (colorProperty == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(22);
        }
        if (UIManager.getColor(colorKey) != null) {
            button2.putClientProperty(colorProperty, JBColor.namedColor((String)colorKey));
        }
    }

    @NotNull
    private static LinkLabel<AnAction> createAction(@NotNull Notification notification2, @NotNull AnAction action2) {
        if (notification2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(23);
        }
        if (action2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(24);
        }
        Presentation presentation2 = action2.getTemplatePresentation();
        String text2 = presentation2.getText();
        return new LinkLabel<AnAction>(text2, presentation2.getIcon(), (link, _action) -> {
            NotificationCollector.getInstance().logNotificationActionInvoked(null, notification2, (AnAction)_action, NotificationCollector.NotificationPlace.BALLOON);
            Notification.fire((Notification)notification2, (AnAction)_action, (DataContext)DataManager.getInstance().getDataContext((Component)link));
        }, action2){

            protected Color getTextColor() {
                return NotificationsUtil.getLinkButtonForeground();
            }
        };
    }

    private static void addDropDownAction(NotificationActionPanel actionPanel, Notification notification2, int startIndex) {
        List actions = notification2.getActions();
        int actionsSize = actions.size();
        DefaultActionGroup group2 = new DefaultActionGroup();
        for (int i2 = startIndex; i2 < actionsSize; ++i2) {
            group2.add((AnAction)actions.get(i2));
        }
        DropDownAction dropDownAction = new DropDownAction(IdeCoreBundle.message((String)"notifications.action.more", (Object[])new Object[0]), (LinkListener<Void>)((LinkListener)(link, _1) -> NotificationsManagerImpl.showPopup(notification2, link, group2, actionPanel.popupAlarm)));
        actionPanel.addAction((JComponent)((Object)dropDownAction));
    }

    private static void addDropDownAction(Notification notification2, NotificationActionPanel actionPanel) {
        DropDownAction action2 = new DropDownAction(notification2.getDropDownText(), (LinkListener<Void>)((LinkListener)(link, ignored) -> {
            NotificationActionPanel parent = (NotificationActionPanel)((Object)((Object)link.getParent()));
            DefaultActionGroup group2 = new DefaultActionGroup();
            for (LinkLabel<AnAction> actionLink : parent.actionLinks) {
                if (actionLink.isVisible()) continue;
                group2.add((AnAction)actionLink.getLinkData());
            }
            NotificationsManagerImpl.showPopup(notification2, link, group2, actionPanel.popupAlarm);
        }));
        action2.setVisible(false);
        actionPanel.addGroupedActionsLink(action2);
    }

    private static void createMergeAction(BalloonLayoutData layoutData, JPanel panel2) {
        String shortTitle = NotificationParentGroup.getShortTitle(layoutData.groupId);
        String title2 = shortTitle != null ? IdeBundle.message((String)"notification.manager.merge.n.more.from", (Object[])new Object[]{layoutData.mergeData.count, shortTitle}) : IdeBundle.message((String)"notification.manager.merge.n.more", (Object[])new Object[]{layoutData.mergeData.count});
        LinkListener listener2 = (link, _layoutData) -> ActionCenter.showLog(_layoutData.project);
        LinkLabel<BalloonLayoutData> action2 = new LinkLabel<BalloonLayoutData>(title2, null, listener2, layoutData){

            protected boolean isInClickableArea(Point pt) {
                return true;
            }

            protected Color getTextColor() {
                return NotificationsUtil.getMoreButtonForeground();
            }
        };
        action2.setFont(FontUtil.minusOne((Font)action2.getFont()));
        action2.setHorizontalAlignment(0);
        action2.setPaintUnderline(false);
        AbstractLayoutManager layout2 = new AbstractLayoutManager(){

            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(parent.getWidth(), JBUIScale.scale((int)20) + 2);
            }

            public void layoutContainer(Container parent) {
                parent.getComponent(0).setBounds(2, 1, parent.getWidth() - 4, JBUIScale.scale((int)20));
            }
        };
        NonOpaquePanel mergePanel = new NonOpaquePanel((LayoutManager)layout2){

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(NotificationsUtil.getMoreButtonBackground());
                ((Graphics2D)g).fill(new Rectangle2D.Double(1.5, 1.0, (double)this.getWidth() - 2.5, this.getHeight() - 2));
                g.setColor((Color)JBColor.namedColor((String)"Notification.MoreButton.innerBorderColor", (Color)new JBColor(0xDBDBDB, 3487544)));
                if (SystemInfo.isMac) {
                    ((Graphics2D)g).draw(new Rectangle2D.Double(2.0, 0.0, (double)this.getWidth() - 3.5, 0.5));
                } else if (SystemInfo.isWindows) {
                    ((Graphics2D)g).draw(new Rectangle2D.Double(1.5, 0.0, this.getWidth() - 3, 0.5));
                } else {
                    ((Graphics2D)g).draw(new Rectangle2D.Double(1.5, 0.0, (double)this.getWidth() - 2.5, 0.5));
                }
            }
        };
        mergePanel.add((Component)action2);
        panel2.add("South", (Component)mergePanel);
    }

    public static int calculateContentHeight(int lines) {
        String word = IdeBundle.message((String)"notification.manager.content.height.word", (Object[])new Object[0]);
        String lineBreak = IdeBundle.message((String)"notification.manager.content.height.linebreak", (Object[])new Object[0]);
        String content2 = word + StringUtil.repeat((String)(lineBreak + word), (int)(lines - 1));
        JEditorPane text2 = new JEditorPane();
        text2.setEditorKit(HTMLEditorKitBuilder.simple());
        text2.setText(NotificationsUtil.buildHtml(null, null, false, content2, null, null, null, NotificationsUtil.getFontStyle()));
        text2.setEditable(false);
        text2.setOpaque(false);
        text2.setBorder(null);
        return text2.getPreferredSize().height;
    }

    static boolean isDummyEnvironment() {
        Application app = ApplicationManager.getApplication();
        return app.isUnitTestMode() || app.isCommandLine();
    }

    private static void showPopup(@NotNull Notification notification2, @NotNull LinkLabel<?> link, @NotNull DefaultActionGroup group2, @NotNull SingleEdtTaskScheduler popupAlarm) {
        if (notification2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(25);
        }
        if (link == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(26);
        }
        if (group2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(27);
        }
        if (popupAlarm == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(28);
        }
        if (link.getClientProperty((Object)"PopupHideInProgress") != null) {
            return;
        }
        JPopupMenu menu = NotificationsManagerImpl.showPopup(link, group2);
        Balloon balloon = notification2.getBalloon();
        if (menu != null && balloon != null) {
            new BalloonPopupSupport(menu, (JComponent)link, popupAlarm).setupListeners(balloon);
        }
    }

    @Nullable
    public static JPopupMenu showPopup(@NotNull LinkLabel<?> link, @NotNull DefaultActionGroup group2) {
        if (link == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(29);
        }
        if (group2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(30);
        }
        if (link.isShowing()) {
            ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("NotificationManager", (ActionGroup)group2);
            JPopupMenu component2 = menu.getComponent();
            component2.show((Component)link, JBUIScale.scale((int)-10), link.getHeight() + JBUIScale.scale((int)2));
            return component2;
        }
        return null;
    }

    @Nullable
    private static Point getCollapsedTextEndLocation(JEditorPane text2, BalloonLayoutData layoutData) {
        try {
            int end = text2.viewToModel2D(new Point(10, layoutData.twoLineHeight + 5));
            if (end == -1) {
                end = text2.getDocument().getLength();
            }
            for (int i2 = end - 1; i2 >= 0; --i2) {
                Rectangle2D r = text2.modelToView2D(i2);
                if (r == null || !(r.getY() < (double)layoutData.twoLineHeight)) continue;
                return r.getBounds().getLocation();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    private static int getFirstLineHeight(JEditorPane text2) {
        try {
            int end = text2.getDocument().getLength();
            for (int i2 = 0; i2 < end; ++i2) {
                int height;
                Rectangle2D r = text2.modelToView2D(i2);
                if (r == null || (height = (int)r.getHeight()) <= 0) continue;
                return height;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return 0;
    }

    private static /* synthetic */ void lambda$createBalloon$13(JEditorPane text2, Supplier textBuilder, BalloonLayoutData layoutData, int _lines, Notification notification2, boolean actions, boolean showFullContent, JComponent windowComponent, JScrollPane pane2, Runnable iconSizeRunnable, Runnable paneSizeRunnable, JPanel content2) {
        Container parent;
        NotificationsUtil.configureHtmlEditorKit(text2, true);
        text2.setText((String)textBuilder.get());
        text2.setPreferredSize(null);
        Dimension size2 = text2.getPreferredSize();
        layoutData.fullHeight = size2.height;
        layoutData.twoLineHeight = NotificationsManagerImpl.calculateContentHeight(_lines);
        layoutData.maxScrollHeight = Math.min(layoutData.fullHeight, NotificationsManagerImpl.calculateContentHeight(10));
        layoutData.configuration = BalloonLayoutConfiguration.create(notification2, layoutData, actions);
        if (layoutData.welcomeScreen) {
            layoutData.maxScrollHeight = layoutData.fullHeight;
        }
        if (showFullContent) {
            if (windowComponent == null) {
                pane2.setPreferredSize(size2);
            } else {
                pane2.setPreferredSize(new Dimension(size2.width, (int)Math.min((double)layoutData.fullHeight, (double)windowComponent.getHeight() * 0.75)));
            }
        } else if (layoutData.twoLineHeight < layoutData.fullHeight) {
            size2.height = layoutData.twoLineHeight;
            text2.setPreferredSize(size2);
            text2.setSize(size2);
            layoutData.showMinSize = true;
            pane2.setPreferredSize(size2);
        }
        text2.revalidate();
        text2.repaint();
        iconSizeRunnable.run();
        paneSizeRunnable.run();
        content2.doLayout();
        Runnable doLayout = layoutData.doLayout;
        if (doLayout != null) {
            doLayout.run();
        }
        if ((parent = content2.getParent()) == null) {
            parent = content2;
        }
        parent.doLayout();
        parent.revalidate();
        parent.repaint();
    }

    private static /* synthetic */ Rectangle lambda$createBalloon$11(JPanel content2, BalloonLayoutData layoutData, JEditorPane text2, JScrollPane pane2, Component component2) {
        Rectangle bounds;
        Point location = SwingUtilities.convertPoint(content2.getParent(), content2.getLocation(), component2.getParent());
        if (layoutData.showMinSize) {
            JComponent centerComponent2 = layoutData.welcomeScreen ? text2 : pane2;
            Point centerLocation = SwingUtilities.convertPoint(centerComponent2.getParent(), centerComponent2.getLocation(), component2.getParent());
            bounds = new Rectangle(location.x, centerLocation.y, content2.getWidth(), ((Component)centerComponent2).getHeight());
        } else {
            bounds = new Rectangle(location.x, component2.getY(), content2.getWidth(), component2.getHeight());
            JBInsets.addTo((Rectangle)bounds, (Insets)JBUI.insets((int)5, (int)0, (int)7, (int)0));
        }
        return bounds;
    }

    private static /* synthetic */ void lambda$createBalloon$9(BalloonLayoutData layoutData, JEditorPane text2, JScrollPane pane2, Notification notification2, JPanel content2, LinkLabel link, Void ignored) {
        layoutData.showMinSize = !layoutData.showMinSize;
        text2.setPreferredSize(null);
        Dimension _size = text2.getPreferredSize();
        if (layoutData.showMinSize) {
            _size.height = layoutData.twoLineHeight;
            pane2.setVerticalScrollBarPolicy(21);
            link.setIcon(AllIcons.Ide.Notification.Expand);
            link.setHoveringIcon(AllIcons.Ide.Notification.ExpandHover);
            NotificationCollector.getInstance().logNotificationBalloonCollapsed(layoutData.project, notification2);
        } else {
            text2.select(0, 0);
            _size.height = layoutData.fullHeight;
            pane2.setVerticalScrollBarPolicy(20);
            link.setIcon(AllIcons.Ide.Notification.Collapse);
            link.setHoveringIcon(AllIcons.Ide.Notification.CollapseHover);
            NotificationCollector.getInstance().logNotificationBalloonExpanded(layoutData.project, notification2);
        }
        text2.setPreferredSize(_size);
        text2.setSize(_size);
        if (!layoutData.showMinSize) {
            _size = new Dimension(_size.width, layoutData.maxScrollHeight);
        }
        pane2.setPreferredSize(_size);
        content2.doLayout();
        layoutData.doLayout.run();
    }

    private /* synthetic */ Object lambda$showNotificationWithSpan$6(Notification notification2, Project project2, Span __) {
        this.showNotificationInner(notification2, project2);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 13, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 2: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/NotificationsManagerImpl";
                break;
            }
            case 4: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutDataRef";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlContent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fillColor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorKey";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorProperty";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupAlarm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/NotificationsManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationsOfType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createBalloon";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createBalloonScrollPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "expire";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNotificationsOfType";
                break;
            }
            case 2: 
            case 13: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "frameActivateBalloonListener";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createBalloon";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setTextAccessibleName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createBalloonScrollPane";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "configureBalloonScrollPane";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setButtonColor";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createAction";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 13, 17 -> new IllegalStateException(string);
        };
    }

    private static final class TextCaret
    extends DefaultCaret
    implements UIResource {
        private final BalloonLayoutData myLayoutData;

        TextCaret(@NotNull BalloonLayoutData layoutData) {
            if (layoutData == null) {
                TextCaret.$$$reportNull$$$0(0);
            }
            this.myLayoutData = layoutData;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseClicked(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseReleased(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseEntered(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseExited(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseDragged(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseMoved(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutData", "com/intellij/notification/impl/NotificationsManagerImpl$TextCaret", "<init>"));
        }
    }

    private static final class NotificationCenterPanel
    extends NonOpaquePanel {
        private final CenteredLayoutWithActions myLayout = (CenteredLayoutWithActions)this.getLayout();
        private final BalloonLayoutData myLayoutData;

        private NotificationCenterPanel(JEditorPane text2, BalloonLayoutData layoutData) {
            super((LayoutManager)new CenteredLayoutWithActions(text2, layoutData));
            this.myLayoutData = layoutData;
        }

        public void addTitle(JLabel title2) {
            this.add(title2, "North");
            this.myLayout.myTitleComponent = title2;
        }

        public Component getTitle() {
            return this.myLayout.getTitle();
        }

        public void addExpandAction(LinkLabel<Void> action2) {
            this.add((Component)action2, "East");
            this.myLayout.myExpandAction = action2;
        }

        public void addContent(JComponent component2) {
            this.add(component2, "Center");
            this.myLayout.myCenteredComponent = component2;
        }

        public void addActionPanel(NotificationActionPanel panel2) {
            this.add((Component)((Object)panel2), "South");
            this.myLayout.myActionPanel = panel2;
        }

        protected void paintChildren(Graphics g) {
            super.paintChildren(g);
            Component title2 = this.myLayout.getTitle();
            if (title2 != null && this.myLayoutData.showActions != null && ((Boolean)this.myLayoutData.showActions.compute()).booleanValue()) {
                int width = this.myLayoutData.configuration.allActionsOffset;
                int x = this.getWidth() - width - JBUIScale.scale((int)5);
                int y = this.myLayoutData.configuration.topSpaceHeight;
                int height = title2 instanceof JEditorPane ? NotificationsManagerImpl.getFirstLineHeight((JEditorPane)title2) : title2.getHeight();
                g.setColor(this.myLayoutData.fillColor);
                g.fillRect(x, y, width, height);
                width = this.myLayoutData.configuration.beforeGearSpace;
                ((Graphics2D)g).setPaint(new GradientPaint(x -= width, y, ColorUtil.withAlpha((Color)this.myLayoutData.fillColor, (double)0.2), x + width, y, this.myLayoutData.fillColor));
                g.fillRect(x, y, width, height);
            }
        }
    }

    private static final class HoverAdapter
    extends MouseAdapter
    implements MouseMotionListener {
        private final List<Pair<Component, ?>> myComponents = new ArrayList();
        private List<Component> mySources = new ArrayList<Component>();
        private Component myLastComponent;

        private HoverAdapter() {
        }

        public void addComponent(@NotNull Component component2, @NotNull Function<? super Component, ? extends Rectangle> hover) {
            if (component2 == null) {
                HoverAdapter.$$$reportNull$$$0(0);
            }
            if (hover == null) {
                HoverAdapter.$$$reportNull$$$0(1);
            }
            this.myComponents.add(Pair.create((Object)component2, hover));
        }

        public void addComponent(@NotNull Component component2, @NotNull Insets hover) {
            if (component2 == null) {
                HoverAdapter.$$$reportNull$$$0(2);
            }
            if (hover == null) {
                HoverAdapter.$$$reportNull$$$0(3);
            }
            this.myComponents.add(Pair.create((Object)component2, (Object)hover));
        }

        public void addSource(@NotNull Component component2) {
            if (component2 == null) {
                HoverAdapter.$$$reportNull$$$0(4);
            }
            this.mySources.add(component2);
        }

        public void initListeners() {
            if (!this.myComponents.isEmpty()) {
                for (Component source : this.mySources) {
                    source.addMouseMotionListener(this);
                    source.addMouseListener(this);
                }
                this.mySources = null;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handleEvent(e, true, false);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handleEvent(e, false, false);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.handleEvent(e, false, true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.myLastComponent != null) {
                HoverAdapter.mouseExited(e, this.myLastComponent);
                this.myLastComponent = null;
            }
        }

        private void handleEvent(MouseEvent e, boolean pressed, boolean moved) {
            HTMLDocument document2;
            AttributeSet attributes;
            JEditorPane pane2;
            int pos;
            Object object = e.getSource();
            if (object instanceof JEditorPane && (pos = (pane2 = (JEditorPane)object).viewToModel2D(e.getPoint())) >= 0 && (attributes = (document2 = (HTMLDocument)pane2.getDocument()).getCharacterElement(pos).getAttributes()).getAttribute(HTML.Tag.A) != null) {
                return;
            }
            for (Pair<Component, ?> p : this.myComponents) {
                Rectangle bounds;
                Component component2 = (Component)p.first;
                if (p.second instanceof Insets) {
                    bounds = component2.getBounds();
                    JBInsets.addTo((Rectangle)bounds, (Insets)((Insets)p.second));
                } else {
                    Function fun = (Function)p.second;
                    bounds = (Rectangle)fun.apply(component2);
                }
                if (bounds.contains(SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), component2.getParent()))) {
                    if (this.myLastComponent != null && this.myLastComponent != component2) {
                        HoverAdapter.mouseExited(e, this.myLastComponent);
                    }
                    this.myLastComponent = component2;
                    MouseEvent event = HoverAdapter.createEvent(e, component2);
                    if (moved) {
                        for (MouseMotionListener listener2 : component2.getMouseMotionListeners()) {
                            listener2.mouseMoved(event);
                        }
                    } else {
                        for (MouseListener listener3 : component2.getMouseListeners()) {
                            if (pressed) {
                                listener3.mousePressed(event);
                                continue;
                            }
                            listener3.mouseReleased(event);
                        }
                    }
                    e.getComponent().setCursor(component2.getCursor());
                    return;
                }
                if (component2 != this.myLastComponent) continue;
                this.myLastComponent = null;
                HoverAdapter.mouseExited(e, component2);
            }
        }

        private static void mouseExited(MouseEvent e, Component component2) {
            MouseListener[] listeners;
            e.getComponent().setCursor(null);
            MouseEvent event = HoverAdapter.createEvent(e, component2);
            for (MouseListener listener2 : listeners = component2.getMouseListeners()) {
                listener2.mouseExited(event);
            }
        }

        private static MouseEvent createEvent(MouseEvent e, Component c) {
            return new MouseEvent(c, e.getID(), e.getWhen(), e.getModifiers(), 5, 5, e.getClickCount(), e.isPopupTrigger(), e.getButton());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hover";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/notification/impl/NotificationsManagerImpl$HoverAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addSource";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class NotificationActionPanel
    extends NonOpaquePanel
    implements UiDataProvider {
        private final List<LinkLabel<AnAction>> actionLinks = new ArrayList<LinkLabel<AnAction>>();
        private final Notification.CollapseActionsDirection collapseActionsDirection;
        private DropDownAction groupedActionsLink;
        boolean checkActionWidth;
        final SingleEdtTaskScheduler popupAlarm = SingleEdtTaskScheduler.createSingleEdtTaskScheduler();

        private NotificationActionPanel(int gap, Notification.CollapseActionsDirection direction) {
            super((LayoutManager)new HorizontalLayout(gap, 0));
            this.collapseActionsDirection = direction;
        }

        public void addGroupedActionsLink(DropDownAction action2) {
            this.add((Component)((Object)action2));
            this.groupedActionsLink = action2;
        }

        public void addActionLink(LinkLabel<AnAction> label2) {
            this.add("LEFT", (Component)label2);
            this.actionLinks.add(label2);
        }

        public void addAction(JComponent component2) {
            this.add("LEFT", component2);
        }
    }

    public static class DropDownAction
    extends LinkLabel<Void> {
        public DropDownAction(@NlsContexts.LinkLabel String text2, @Nullable LinkListener<Void> listener2) {
            super(text2, null, listener2);
            this.setHorizontalTextPosition(10);
            this.setIconTextGap(JBUI.scale((int)1));
            this.setIcon(new Icon(this){
                private final Icon icon = AllIcons.General.LinkDropTriangle;

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    this.icon.paintIcon(c, g, x, y + 1);
                }

                @Override
                public int getIconWidth() {
                    return this.icon.getIconWidth();
                }

                @Override
                public int getIconHeight() {
                    return this.icon.getIconHeight();
                }
            });
        }

        protected Color getTextColor() {
            return NotificationsUtil.getLinkButtonForeground();
        }
    }

    private static final class BalloonPopupSupport
    extends PopupMenuListenerAdapter
    implements Disposable {
        private final JPopupMenu myPopupMenu;
        private final JComponent myComponent;
        private final SingleEdtTaskScheduler myAlarm;
        private boolean myHandleDispose;

        private BalloonPopupSupport(@NotNull JPopupMenu popupMenu, @NotNull JComponent component2, @NotNull SingleEdtTaskScheduler popupAlarm) {
            if (popupMenu == null) {
                BalloonPopupSupport.$$$reportNull$$$0(0);
            }
            if (component2 == null) {
                BalloonPopupSupport.$$$reportNull$$$0(1);
            }
            if (popupAlarm == null) {
                BalloonPopupSupport.$$$reportNull$$$0(2);
            }
            this.myHandleDispose = true;
            this.myPopupMenu = popupMenu;
            this.myComponent = component2;
            this.myAlarm = popupAlarm;
        }

        private void setupListeners(@NotNull Balloon balloon) {
            if (balloon == null) {
                BalloonPopupSupport.$$$reportNull$$$0(3);
            }
            this.myAlarm.cancel();
            this.myPopupMenu.addPopupMenuListener((PopupMenuListener)((Object)this));
            Disposer.register((Disposable)balloon, (Disposable)this);
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.myHandleDispose = false;
            Disposer.dispose((Disposable)this);
            this.myComponent.putClientProperty("PopupHideInProgress", Boolean.TRUE);
            this.myAlarm.request(500L, () -> this.myComponent.putClientProperty("PopupHideInProgress", null));
        }

        public void dispose() {
            this.myPopupMenu.removePopupMenuListener((PopupMenuListener)((Object)this));
            if (this.myHandleDispose) {
                this.myPopupMenu.setVisible(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "popupMenu";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "popupAlarm";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "balloon";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/notification/impl/NotificationsManagerImpl$BalloonPopupSupport";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setupListeners";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class CenteredLayoutWithActions
    extends BorderLayout {
        private final JEditorPane myText;
        private final BalloonLayoutData myLayoutData;
        private JLabel myTitleComponent;
        private Component myCenteredComponent;
        private NotificationActionPanel myActionPanel;
        private Component myExpandAction;

        CenteredLayoutWithActions(JEditorPane text2, BalloonLayoutData layoutData) {
            this.myText = text2;
            this.myLayoutData = layoutData;
        }

        @Nullable
        public Component getTitle() {
            if (this.myTitleComponent != null) {
                return this.myTitleComponent;
            }
            if (this.myCenteredComponent != null) {
                if (this.myCenteredComponent instanceof JScrollPane) {
                    return ((JScrollPane)this.myCenteredComponent).getViewport().getView();
                }
                return this.myCenteredComponent;
            }
            return null;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(component2 -> component2.getPreferredSize());
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(component2 -> component2.getMinimumSize());
        }

        private Dimension layoutSize(Function<? super Component, ? extends Dimension> size2) {
            Dimension titleSize = this.myTitleComponent == null ? new Dimension() : size2.apply(this.myTitleComponent);
            Dimension centeredSize = this.myCenteredComponent == null ? new Dimension() : size2.apply(this.myCenteredComponent);
            Dimension actionSize = this.myActionPanel == null ? new Dimension() : size2.apply((Component)((Object)this.myActionPanel));
            Dimension expandSize = this.myExpandAction == null || this.myLayoutData.showMinSize ? new Dimension() : size2.apply(this.myExpandAction);
            int height = this.myLayoutData.configuration.topSpaceHeight + titleSize.height + centeredSize.height + Math.max(actionSize.height, expandSize.height) + this.myLayoutData.configuration.bottomSpaceHeight;
            if (titleSize.height > 0 && centeredSize.height > 0) {
                height += this.myLayoutData.configuration.titleContentSpaceHeight;
            }
            if (centeredSize.height > 0 && actionSize.height > 0) {
                height += this.myLayoutData.configuration.contentActionsSpaceHeight;
            }
            if (titleSize.height > 0 && actionSize.height > 0) {
                height += this.myLayoutData.configuration.titleActionsSpaceHeight;
            }
            int titleWidth = titleSize.width + this.myLayoutData.configuration.closeOffset;
            int centerWidth = centeredSize.width + this.myLayoutData.configuration.closeOffset;
            int actionWidth = actionSize.width + expandSize.width;
            int width = Math.max(centerWidth, Math.max(titleWidth, actionWidth));
            if (!this.myLayoutData.showFullContent) {
                width = Math.min(width, BalloonLayoutConfiguration.MaxWidth());
            }
            width = Math.max(width, BalloonLayoutConfiguration.MinWidth());
            return new Dimension(width, height);
        }

        @Override
        public void layoutContainer(Container parent) {
            boolean isActions;
            int top = this.myLayoutData.configuration.topSpaceHeight;
            int width = parent.getWidth();
            Dimension centeredSize = this.myCenteredComponent == null ? new Dimension() : this.myCenteredComponent.getPreferredSize();
            boolean bl = isActions = this.myActionPanel != null || this.myExpandAction != null && !this.myLayoutData.showMinSize;
            if (this.myTitleComponent != null) {
                int titleHeight = this.myTitleComponent.getPreferredSize().height;
                this.myTitleComponent.setBounds(0, top, width - this.myLayoutData.configuration.closeOffset, titleHeight);
                top += titleHeight;
                if (this.myCenteredComponent != null) {
                    top += this.myLayoutData.configuration.titleContentSpaceHeight;
                } else if (isActions) {
                    top += this.myLayoutData.configuration.titleActionsSpaceHeight;
                }
            }
            if (this.myCenteredComponent != null) {
                int centeredWidth = width;
                if (!this.myLayoutData.showFullContent && !this.myLayoutData.showMinSize && this.myLayoutData.fullHeight != this.myLayoutData.maxScrollHeight) {
                    --centeredWidth;
                }
                this.myCenteredComponent.setBounds(0, top, centeredWidth, centeredSize.height);
                this.myCenteredComponent.revalidate();
            }
            if (this.myExpandAction != null) {
                Dimension size2 = this.myExpandAction.getPreferredSize();
                int x = width - size2.width - Objects.requireNonNull(this.myLayoutData.configuration.rightActionsOffset).width;
                if (this.myLayoutData.showMinSize) {
                    Point location = NotificationsManagerImpl.getCollapsedTextEndLocation(this.myText, this.myLayoutData);
                    if (location == null) {
                        location = new Point(10, this.myText.getHeight() - size2.height);
                    }
                    int y = SwingUtilities.convertPoint((Component)this.myText, (int)location.x, (int)location.y, (Component)parent).y;
                    this.myExpandAction.setBounds(x, y, size2.width, size2.height);
                } else {
                    int y = parent.getHeight() - size2.height - this.myLayoutData.configuration.bottomSpaceHeight;
                    this.myExpandAction.setBounds(x, y, size2.width, size2.height);
                }
            }
            if (this.myActionPanel != null) {
                int expandWidth = this.myExpandAction == null || this.myLayoutData.showMinSize ? 0 : this.myExpandAction.getPreferredSize().width;
                if (this.myActionPanel.checkActionWidth && this.myActionPanel.getPreferredSize().width - (width -= this.myLayoutData.configuration.actionGap + expandWidth) > 0 && width > 0) {
                    Component component0 = this.myActionPanel.getComponent(0);
                    Component component1 = this.myActionPanel.getComponent(1);
                    Dimension size0 = component0.getPreferredSize();
                    Dimension size1 = component1.getPreferredSize();
                    int halfWidth = width / 2;
                    if (size0.width > halfWidth && size1.width > halfWidth) {
                        CenteredLayoutWithActions.cutWidth(component0, size0, halfWidth);
                        CenteredLayoutWithActions.cutWidth(component1, size1, halfWidth);
                    } else if (size0.width > halfWidth) {
                        CenteredLayoutWithActions.cutWidth(component0, size0, size0.width - this.myActionPanel.getPreferredSize().width + width);
                    } else {
                        CenteredLayoutWithActions.cutWidth(component1, size1, size1.width - this.myActionPanel.getPreferredSize().width + width);
                    }
                    this.myActionPanel.checkActionWidth = false;
                    this.myActionPanel.doLayout();
                }
                if (this.myActionPanel.actionLinks.size() > 1) {
                    this.myActionPanel.groupedActionsLink.setVisible(false);
                    for (LinkLabel<AnAction> link : this.myActionPanel.actionLinks) {
                        link.setVisible(true);
                    }
                    this.myActionPanel.doLayout();
                    boolean keepRightmost = this.myActionPanel.collapseActionsDirection == Notification.CollapseActionsDirection.KEEP_RIGHTMOST;
                    int collapseStart = keepRightmost ? 0 : this.myActionPanel.actionLinks.size() - 1;
                    int collapseDelta = keepRightmost ? 1 : -1;
                    int collapseIndex = collapseStart;
                    if (this.myActionPanel.getPreferredSize().width > width) {
                        this.myActionPanel.groupedActionsLink.setVisible(true);
                        this.myActionPanel.actionLinks.get(collapseIndex).setVisible(false);
                        collapseIndex += collapseDelta;
                        this.myActionPanel.doLayout();
                        while (this.myActionPanel.getPreferredSize().width > width && collapseIndex >= 0 && collapseIndex < this.myActionPanel.actionLinks.size()) {
                            this.myActionPanel.actionLinks.get(collapseIndex).setVisible(false);
                            collapseIndex += collapseDelta;
                            this.myActionPanel.doLayout();
                        }
                    }
                }
                Dimension size3 = this.myActionPanel.getPreferredSize();
                int y = parent.getHeight() - size3.height - this.myLayoutData.configuration.bottomSpaceHeight;
                this.myActionPanel.setBounds(0, y, width, size3.height);
            }
        }

        private static void cutWidth(@NotNull Component component2, @NotNull Dimension size2, int width) {
            if (component2 == null) {
                CenteredLayoutWithActions.$$$reportNull$$$0(0);
            }
            if (size2 == null) {
                CenteredLayoutWithActions.$$$reportNull$$$0(1);
            }
            size2.width = width;
            component2.setPreferredSize(size2);
            if (component2 instanceof JButton) {
                JButton button2 = (JButton)component2;
                button2.setToolTipText(button2.getText());
            } else if (component2 instanceof JLabel) {
                JLabel label2 = (JLabel)component2;
                label2.setToolTipText(label2.getText());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "size";
                    break;
                }
            }
            objectArray[1] = "com/intellij/notification/impl/NotificationsManagerImpl$CenteredLayoutWithActions";
            objectArray[2] = "cutWidth";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

