/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.diagnostic.UILatencyLogger;
import com.intellij.ide.DataManager;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeEventQueue;
import com.intellij.internal.inspector.UiInspectorActionUtil;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.ActualActionUiKind;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.PlaceProvider;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.plaf.beg.BegMenuItemUI;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.messages.MessageBusConnection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.Component;
import java.awt.Point;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ActionPopupMenuImpl
implements ActionPopupMenu,
ApplicationActivationListener {
    private static final Logger LOG = Logger.getInstance(ActionPopupMenuImpl.class);
    private static final IntSet SEEN_ACTION_GROUPS = new IntOpenHashSet(50);
    private final MyMenu myMenu;
    private final ActionManagerImpl myManager;
    private Supplier<? extends DataContext> myDataContextProvider;
    private MessageBusConnection myConnection;
    private IdeFrame myFrame;

    ActionPopupMenuImpl(@NotNull String place, @NotNull ActionGroup group2, @NotNull ActionManagerImpl actionManager, @Nullable PresentationFactory factory2) {
        if (place == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(0);
        }
        if (group2 == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(1);
        }
        if (actionManager == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(2);
        }
        if ("unknown".equals(place) || place.isEmpty()) {
            LOG.warn("Do not use ActionPlaces.UNKNOWN or the empty string. Any string unique enough to deduce the popup menu location will do.", new Throwable("popup menu creation trace"));
        }
        this.myManager = actionManager;
        this.myMenu = new MyMenu(place, group2, factory2);
    }

    @NotNull
    public JPopupMenu getComponent() {
        MyMenu myMenu = this.myMenu;
        if (myMenu == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(3);
        }
        return myMenu;
    }

    @NotNull
    public String getPlace() {
        String string = this.myMenu.myPlace;
        if (string == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public ActionGroup getActionGroup() {
        ActionGroup actionGroup = this.myMenu.myGroup;
        if (actionGroup == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(5);
        }
        return actionGroup;
    }

    public void setTargetComponent(@NotNull JComponent component2) {
        if (component2 == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(6);
        }
        this.setDataContext(() -> DataManager.getInstance().getDataContext((Component)component2));
    }

    public void setDataContext(@NotNull Supplier<? extends DataContext> dataProvider) {
        if (dataProvider == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(7);
        }
        this.myDataContextProvider = dataProvider;
    }

    public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
        if (ideFrame == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(8);
        }
        if (this.myFrame == ideFrame) {
            this.myMenu.setVisible(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionPopupMenuImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionPopupMenuImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTargetComponent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setDataContext";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applicationDeactivated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    private final class MyMenu
    extends JBPopupMenu
    implements PlaceProvider {
        @NotNull
        private final String myPlace;
        @NotNull
        private final ActionGroup myGroup;
        private DataContext myContext;
        private final PresentationFactory myPresentationFactory;
        @NotNull
        private final MyPopupMenuListener myListener;
        private long myPopupTriggeredNanos;

        MyMenu(@NotNull String place, @Nullable ActionGroup group2, PresentationFactory factory2) {
            if (place == null) {
                MyMenu.$$$reportNull$$$0(0);
            }
            if (group2 == null) {
                MyMenu.$$$reportNull$$$0(1);
            }
            this.myPlace = place;
            this.myGroup = group2;
            this.myPresentationFactory = factory2 != null ? factory2 : new MenuItemPresentationFactory();
            this.myListener = new MyPopupMenuListener();
            this.addPopupMenuListener(this.myListener);
            BegMenuItemUI.registerMultiChoiceSupport((JPopupMenu)((Object)this), popupMenu -> Utils.updateMenuItems(popupMenu, this.myContext, this.myPlace, this.myPresentationFactory));
            UiInspectorUtil.registerProvider((JComponent)((Object)this), () -> UiInspectorActionUtil.collectActionGroupInfo("Menu", this.myGroup, this.myPlace, this.myPresentationFactory));
        }

        @NotNull
        public String getPlace() {
            String string = this.myPlace;
            if (string == null) {
                MyMenu.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void show(@NotNull Component component2, int x, int y) {
            if (component2 == null) {
                MyMenu.$$$reportNull$$$0(3);
            }
            if (!component2.isShowing()) {
                throw new IllegalArgumentException("component must be shown on the screen (" + String.valueOf(component2) + ")");
            }
            this.myPopupTriggeredNanos = IdeEventQueue.getInstance().getPopupTriggerTime();
            Utils.showPopupElapsedMillisIfConfigured(this.myPopupTriggeredNanos, (Component)((Object)this));
            int x2 = Math.max(0, Math.min(x, component2.getWidth() - 1));
            int y2 = Math.max(0, Math.min(y, component2.getHeight() - 1));
            this.myContext = Utils.createAsyncDataContext(ActionPopupMenuImpl.this.myDataContextProvider != null ? ActionPopupMenuImpl.this.myDataContextProvider.get() : DataManager.getInstance().getDataContext(component2, x2, y2));
            this.updateChildren(new RelativePoint(component2, new Point(x, y)));
            if (this.getComponentCount() == 0) {
                LOG.warn("'" + this.myPlace + "' popup menu fails to show: no menu items");
                return;
            }
            if (!component2.isShowing()) {
                LOG.warn("'" + this.myPlace + "' popup menu fails to show: component is not showing (" + component2.getClass().getName() + ")");
                return;
            }
            Application application = ApplicationManager.getApplication();
            if (application != null && application.isActive()) {
                Component parent = ComponentUtil.findUltimateParent((Component)component2);
                IdeFrame ideFrame = ActionPopupMenuImpl.this.myFrame = parent instanceof IdeFrame ? (IdeFrame)parent : null;
                if (ActionPopupMenuImpl.this.myConnection == null) {
                    ActionPopupMenuImpl.this.myConnection = application.getMessageBus().connect();
                    ActionPopupMenuImpl.this.myConnection.subscribe(ApplicationActivationListener.TOPIC, (Object)ActionPopupMenuImpl.this);
                }
            }
            this.myListener.targetComponent = component2;
            super.show(component2, x, y);
        }

        public void addNotify() {
            super.addNotify();
            long time = this.myPopupTriggeredNanos > 0L ? TimeoutUtil.getDurationMillis((long)this.myPopupTriggeredNanos) : -1L;
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(Utils.getCachedOnlyDataContext(this.myContext));
            Language language = psiFile == null ? null : psiFile.getLanguage();
            boolean coldStart = SEEN_ACTION_GROUPS.add(Objects.hash(this.myGroup, language));
            UILatencyLogger.ACTION_POPUP_LATENCY.log(new EventPair[]{EventFields.DurationMs.with((Object)time), EventFields.ActionPlace.with((Object)this.myPlace), UILatencyLogger.COLD_START.with((Object)coldStart), EventFields.Language.with((Object)language)});
        }

        public void setVisible(boolean b) {
            super.setVisible(b);
            if (!b) {
                ReflectionUtil.resetField((Object)((Object)this), (String)"invoker");
            }
        }

        private void updateChildren(@Nullable RelativePoint point) {
            this.removeAll();
            Utils.INSTANCE.fillPopupMenu(new ActualActionUiKind.Menu((MenuElement)((Object)this), false), this.myGroup, this.myPresentationFactory, this.myContext, this.myPlace, point);
        }

        private void disposeMenu() {
            MessageBusConnection connection = ActionPopupMenuImpl.this.myConnection;
            ActionPopupMenuImpl.this.myFrame = null;
            ActionPopupMenuImpl.this.myConnection = null;
            ActionPopupMenuImpl.this.myManager.removeActionPopup(ActionPopupMenuImpl.this);
            this.removeAll();
            if (connection != null) {
                connection.disconnect();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionPopupMenuImpl$MyMenu";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionPopupMenuImpl$MyMenu";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPlace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "show";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }

        private final class MyPopupMenuListener
        implements PopupMenuListener {
            Component targetComponent;

            private MyPopupMenuListener() {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                MyMenu.this.disposeMenu();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                HelpTooltip.enableTooltip((Component)this.targetComponent);
                Component component2 = this.targetComponent;
                if (component2 instanceof Tree) {
                    Tree tree2 = (Tree)component2;
                    tree2.unblockAutoScrollFromSource();
                }
                MyMenu.this.disposeMenu();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                HelpTooltip.disableTooltip((Component)this.targetComponent);
                if (MyMenu.this.getComponentCount() == 0) {
                    MyMenu.this.updateChildren(null);
                }
                ActionPopupMenuImpl.this.myManager.addActionPopup(ActionPopupMenuImpl.this);
            }
        }
    }
}

