/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.concurrency.ContextAwareRunnable;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.concurrency.ThreadContext;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.startup.ServiceNotReadyException;
import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.constraints.BaseConstrainedExecution;
import com.intellij.openapi.application.constraints.ConstrainedExecution;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.AsyncExecutionServiceImpl;
import com.intellij.openapi.application.impl.InSmartMode;
import com.intellij.openapi.application.impl.NbraUtilKt;
import com.intellij.openapi.application.impl.SubmissionTracker;
import com.intellij.openapi.application.impl.TestOnlyThreading;
import com.intellij.openapi.application.impl.WithDocumentsCommitted;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.locking.impl.IntelliJLockingUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.RunnableCallable;
import com.intellij.util.SlowOperations;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.ChildContext;
import com.intellij.util.concurrency.Propagation;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import kotlin.Result;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.reflect.KClass;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@VisibleForTesting
@ApiStatus.Internal
public final class NonBlockingReadActionImpl<T>
implements NonBlockingReadAction<T> {
    private static final Logger LOG = Logger.getInstance(NonBlockingReadActionImpl.class);
    private static final Executor SYNC_DUMMY_EXECUTOR = __ -> {
        throw new UnsupportedOperationException();
    };
    private final ModalityState myModalityState;
    private final Consumer<? super T> myUiThreadAction;
    private final ConstrainedExecution.ContextConstraint @NotNull [] myConstraints;
    private final BooleanSupplier @NotNull [] myCancellationConditions;
    private final @Unmodifiable Disposable[] myDisposables;
    @Nullable
    private final @Unmodifiable ListWithFixedHashCode myCoalesceEquality;
    @Nullable
    private final ProgressIndicator myProgressIndicator;
    private final Callable<? extends T> myOriginalComputation;
    private final Callable<? extends T> myActualComputation;
    @TestOnly
    private static final Set<Submission<?>> ourTasksForTestMode = ConcurrentCollectionFactory.createConcurrentSet();
    private static final Map<ListWithFixedHashCode, Submission<?>> ourTasksByEquality = new HashMap();
    private static final SubmissionTracker ourUnboundedSubmissionTracker = new SubmissionTracker();
    private static final boolean ENABLE_OTEL_MONITORING = SystemProperties.getBooleanProperty((String)"idea.non-blocking-action.enable-monitoring", (boolean)true);
    @Nullable
    private static final OTelMonitor MONITOR;
    private static final ConstrainedExecution.ContextConstraint[] EMPTY_CONSTRAINTS;
    private static final BooleanSupplier[] EMPTY_CONDITIONS;
    private static final Disposable[] EMPTY_DISPOSABLE_ARRAY;

    NonBlockingReadActionImpl(@NotNull Callable<? extends T> computation) {
        if (computation == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(0);
        }
        this(computation, null, null, EMPTY_CONSTRAINTS, EMPTY_CONDITIONS, EMPTY_DISPOSABLE_ARRAY, null, null);
    }

    private NonBlockingReadActionImpl(@NotNull Callable<? extends T> computation, @Nullable ModalityState modalityState, @Nullable Consumer<? super T> uiThreadAction, ConstrainedExecution.ContextConstraint @NotNull [] constraints, BooleanSupplier @NotNull [] cancellationConditions, @NotNull @NotNull Disposable @NotNull [] disposables, @Unmodifiable @Nullable ListWithFixedHashCode coalesceEquality, @Nullable ProgressIndicator progressIndicator) {
        if (computation == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(1);
        }
        if (constraints == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(2);
        }
        if (cancellationConditions == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(3);
        }
        if (disposables == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(4);
        }
        this.myOriginalComputation = computation;
        this.myActualComputation = MONITOR == null ? computation : MONITOR.wrap(computation);
        this.myModalityState = modalityState;
        this.myUiThreadAction = uiThreadAction;
        this.myConstraints = constraints;
        this.myCancellationConditions = cancellationConditions;
        this.myDisposables = disposables;
        this.myCoalesceEquality = coalesceEquality;
        this.myProgressIndicator = progressIndicator;
        if (modalityState == null != (uiThreadAction == null)) {
            throw new IllegalArgumentException("myModalityState and myUiThreadAction must be both null or both not-null but got: " + String.valueOf(modalityState) + ", " + String.valueOf(uiThreadAction));
        }
    }

    @NotNull
    private NonBlockingReadActionImpl<T> withConstraint(@NotNull ConstrainedExecution.ContextConstraint constraint) {
        if (constraint == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(5);
        }
        return new NonBlockingReadActionImpl<T>(this.myOriginalComputation, this.myModalityState, this.myUiThreadAction, (ConstrainedExecution.ContextConstraint[])ArrayUtil.append((Object[])this.myConstraints, (Object)constraint), this.myCancellationConditions, this.myDisposables, this.myCoalesceEquality, this.myProgressIndicator);
    }

    private static void invokeLater(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(6);
        }
        Application app = ApplicationManager.getApplication();
        IntelliJLockingUtil.getGlobalThreadingSupport().runWhenWriteActionIsCompleted(() -> {
            SideEffectGuard.computeWithAllowedSideEffectsBlocking(EnumSet.of(SideEffectGuard.EffectType.INVOKE_LATER), () -> {
                app.invokeLaterOnWriteThread(runnable2, ModalityState.any(), app.getDisposed());
                return Unit.INSTANCE;
            });
            return Unit.INSTANCE;
        });
    }

    @NotNull
    public NonBlockingReadAction<T> inSmartMode(@NotNull Project project2) {
        if (project2 == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(7);
        }
        NonBlockingReadAction<T> nonBlockingReadAction = this.withConstraint(new InSmartMode(project2)).expireWith((Disposable)project2);
        if (nonBlockingReadAction == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(8);
        }
        return nonBlockingReadAction;
    }

    @NotNull
    public NonBlockingReadAction<T> withDocumentsCommitted(@NotNull Project project2) {
        if (project2 == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(9);
        }
        NonBlockingReadAction<T> nonBlockingReadAction = this.withConstraint(new WithDocumentsCommitted(project2, ModalityState.any())).expireWith((Disposable)project2);
        if (nonBlockingReadAction == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(10);
        }
        return nonBlockingReadAction;
    }

    @NotNull
    public NonBlockingReadAction<T> expireWhen(@NotNull BooleanSupplier expireCondition) {
        if (expireCondition == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(11);
        }
        return new NonBlockingReadActionImpl<T>(this.myOriginalComputation, this.myModalityState, this.myUiThreadAction, this.myConstraints, (BooleanSupplier[])ArrayUtil.append((Object[])this.myCancellationConditions, (Object)expireCondition), this.myDisposables, this.myCoalesceEquality, this.myProgressIndicator);
    }

    @NotNull
    public NonBlockingReadAction<T> expireWith(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(12);
        }
        Disposable[] newDisposables = ArrayUtil.indexOf((Object[])this.myDisposables, (Object)parentDisposable) == -1 ? (Disposable[])ArrayUtil.append((Object[])this.myDisposables, (Object)parentDisposable) : this.myDisposables;
        return new NonBlockingReadActionImpl<T>(this.myOriginalComputation, this.myModalityState, this.myUiThreadAction, this.myConstraints, this.myCancellationConditions, newDisposables, this.myCoalesceEquality, this.myProgressIndicator);
    }

    @NotNull
    public NonBlockingReadAction<T> wrapProgress(@NotNull ProgressIndicator progressIndicator) {
        if (progressIndicator == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(13);
        }
        LOG.assertTrue(this.myProgressIndicator == null, (Object)"Unspecified behaviour. Outer progress indicator is already set for the action.");
        return new NonBlockingReadActionImpl<T>(this.myOriginalComputation, this.myModalityState, this.myUiThreadAction, this.myConstraints, this.myCancellationConditions, this.myDisposables, this.myCoalesceEquality, progressIndicator);
    }

    @NotNull
    public NonBlockingReadAction<T> finishOnUiThread(@NotNull ModalityState modality, @NotNull Consumer<? super T> uiThreadAction) {
        if (modality == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(14);
        }
        if (uiThreadAction == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(15);
        }
        return new NonBlockingReadActionImpl<T>(this.myOriginalComputation, modality, uiThreadAction, this.myConstraints, this.myCancellationConditions, this.myDisposables, this.myCoalesceEquality, this.myProgressIndicator);
    }

    @NotNull
    public NonBlockingReadAction<T> coalesceBy(Object ... equality) {
        if (equality == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(16);
        }
        if (this.myCoalesceEquality != null) {
            throw new IllegalStateException("Setting equality twice is not allowed");
        }
        if (equality.length == 0) {
            throw new IllegalArgumentException("Equality should include at least one object");
        }
        if (equality.length == 1 && NonBlockingReadActionImpl.isTooCommon(equality[0])) {
            throw new IllegalArgumentException("Equality should be unique: passing " + String.valueOf(equality[0]) + " is likely to interfere with unrelated computations from different places");
        }
        if (ArrayUtil.contains(null, (Object[])equality)) {
            throw new IllegalArgumentException("Equality must not contain null but got: " + Arrays.toString(equality));
        }
        return new NonBlockingReadActionImpl<T>(this.myOriginalComputation, this.myModalityState, this.myUiThreadAction, this.myConstraints, this.myCancellationConditions, this.myDisposables, new ListWithFixedHashCode((Object[])equality.clone()), this.myProgressIndicator);
    }

    private static boolean isTooCommon(Object o) {
        return o instanceof Project || o instanceof PsiElement || o instanceof Document || o instanceof VirtualFile || o instanceof Editor || o instanceof FileEditor || o instanceof Class || o instanceof KClass || o instanceof String || o == null;
    }

    public T executeSynchronously() throws ProcessCanceledException {
        if (this.myModalityState != null || this.myCoalesceEquality != null) {
            throw new IllegalStateException((this.myModalityState != null ? "finishOnUiThread" : "coalesceBy") + " is not supported with synchronous non-blocking read actions");
        }
        ProgressIndicator outerIndicator = this.myProgressIndicator != null ? this.myProgressIndicator : ProgressIndicatorProvider.getGlobalProgressIndicator();
        return new Submission(this, SYNC_DUMMY_EXECUTOR, outerIndicator).executeSynchronously();
    }

    private void schedule(@Async.Schedule Callable<? extends T> computation) {
    }

    @NotNull
    public CancellablePromise<T> submit(@NotNull Executor backgroundThreadExecutor) {
        if (backgroundThreadExecutor == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(17);
        }
        this.schedule(this.myOriginalComputation);
        Submission submission = new Submission(this, backgroundThreadExecutor, this.myProgressIndicator);
        if (this.myCoalesceEquality == null) {
            submission.transferToBgThread();
        } else {
            submission.submitOrScheduleCoalesced(this.myCoalesceEquality);
        }
        Submission submission2 = submission;
        if (submission2 == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(18);
        }
        return submission2;
    }

    @Nullable
    private ConstrainedExecution.ContextConstraint findUnsatisfiedConstraint() {
        return (ConstrainedExecution.ContextConstraint)ContainerUtil.find((Object[])this.myConstraints, t -> !t.isCorrectContext());
    }

    @TestOnly
    @RequiresEdt
    public static void waitForAsyncTaskCompletion() {
        ThreadingAssertions.assertEventDispatchThread();
        ThreadingAssertions.assertEventDispatchThread();
        assert (ApplicationManager.getApplication() == null || !ApplicationManager.getApplication().isWriteAccessAllowed());
        for (Submission<?> task : ourTasksForTestMode) {
            TestOnlyThreading.releaseTheAcquiredWriteIntentLockThenExecuteActionAndTakeWriteIntentLockBack(() -> {
                NonBlockingReadActionImpl.waitForTask(task);
                return Unit.INSTANCE;
            });
        }
    }

    @TestOnly
    public static void dropTestTasks() {
        ourTasksForTestMode.clear();
    }

    @TestOnly
    @RequiresEdt
    private static void waitForTask(@NotNull Submission<?> task) {
        if (task == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(19);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ThreadingAssertions.assertEventDispatchThread();
        for (ConstrainedExecution.ContextConstraint constraint : task.builder.myConstraints) {
            if (!(constraint instanceof InSmartMode) || constraint.isCorrectContext()) continue;
            return;
        }
        int iteration = 0;
        while (!task.isDone() && iteration++ < 300000) {
            UIUtil.dispatchAllInvocationEvents();
            try {
                task.blockingGet(1, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!task.isDone()) {
            System.err.println(ThreadDumper.dumpThreadsToString());
            throw new AssertionError((Object)("Too long async task " + String.valueOf(task)));
        }
    }

    @TestOnly
    @VisibleForTesting
    @NotNull
    public static Object getTasksByEquality() {
        Map<ListWithFixedHashCode, Submission<?>> map2 = ourTasksByEquality;
        if (map2 == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(20);
        }
        return map2;
    }

    static {
        LOG.info("OTel monitoring for NonBlockingReadAction is " + (ENABLE_OTEL_MONITORING ? "enabled" : "disabled"));
        if (ENABLE_OTEL_MONITORING) {
            Meter meter = TelemetryManager.getInstance().getMeter(PlatformScopesKt.EDT);
            MONITOR = new OTelMonitor(meter);
        } else {
            MONITOR = null;
        }
        EMPTY_CONSTRAINTS = new ConstrainedExecution.ContextConstraint[0];
        EMPTY_CONDITIONS = new BooleanSupplier[0];
        EMPTY_DISPOSABLE_ARRAY = new Disposable[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10, 18, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancellationConditions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposables";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 10: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/NonBlockingReadActionImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expireCondition";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiThreadAction";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equality";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundThreadExecutor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/NonBlockingReadActionImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "inSmartMode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withDocumentsCommitted";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "submit";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasksByEquality";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withConstraint";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "inSmartMode";
                break;
            }
            case 8: 
            case 10: 
            case 18: 
            case 20: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "withDocumentsCommitted";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "expireWhen";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "expireWith";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "wrapProgress";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "finishOnUiThread";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "coalesceBy";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "waitForTask";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10, 18, 20 -> new IllegalStateException(string);
        };
    }

    private static class ListWithFixedHashCode {
        private final int myHashCode;
        @NotNull
        private final @NotNull Object @NotNull [] myEquality;

        private ListWithFixedHashCode(Object ... equality) {
            if (equality == null) {
                ListWithFixedHashCode.$$$reportNull$$$0(0);
            }
            this.myHashCode = Arrays.hashCode(equality);
            this.myEquality = equality;
        }

        public int hashCode() {
            return this.myHashCode;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj2) {
            if (!(obj2 instanceof ListWithFixedHashCode)) return false;
            ListWithFixedHashCode ol = (ListWithFixedHashCode)obj2;
            if (this.myHashCode != ol.myHashCode) return false;
            if (!Arrays.equals(this.myEquality, ol.myEquality)) return false;
            return true;
        }

        public String toString() {
            return "ListWithFixedHashCode:" + this.myHashCode + ":" + Arrays.toString(this.myEquality);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "equality", "com/intellij/openapi/application/impl/NonBlockingReadActionImpl$ListWithFixedHashCode", "<init>"));
        }
    }

    private static final class OTelMonitor
    implements AutoCloseable {
        private final AtomicInteger finalizedExecutionsCount;
        private final AtomicInteger failedExecutionsCount;
        private final AtomicLong finalizedExecutionTimeUs;
        private final AtomicLong failedExecutionTimeUs;
        private final AutoCloseable otelSubscription;

        private OTelMonitor(@NotNull Meter meter) {
            if (meter == null) {
                OTelMonitor.$$$reportNull$$$0(0);
            }
            this.finalizedExecutionsCount = new AtomicInteger();
            this.failedExecutionsCount = new AtomicInteger();
            this.finalizedExecutionTimeUs = new AtomicLong();
            this.failedExecutionTimeUs = new AtomicLong();
            ObservableLongMeasurement finalizedExecutionsCounter = meter.counterBuilder("NonBlockingReadAction.finalizedExecutionsCount").buildObserver();
            ObservableLongMeasurement failedExecutionsCounter = meter.counterBuilder("NonBlockingReadAction.failedExecutionsCount").buildObserver();
            ObservableLongMeasurement finalizedExecutionTimeUsCounter = meter.counterBuilder("NonBlockingReadAction.finalizedExecutionTimeUs").buildObserver();
            ObservableLongMeasurement failedExecutionTimeUsCounter = meter.counterBuilder("NonBlockingReadAction.failedExecutionTimeUs").buildObserver();
            this.otelSubscription = meter.batchCallback(() -> {
                finalizedExecutionsCounter.record(this.finalizedExecutionsCount.longValue());
                finalizedExecutionTimeUsCounter.record(this.finalizedExecutionTimeUs.longValue());
                failedExecutionsCounter.record(this.failedExecutionsCount.longValue());
                failedExecutionTimeUsCounter.record(this.failedExecutionTimeUs.longValue());
            }, (ObservableMeasurement)finalizedExecutionsCounter, new ObservableMeasurement[]{failedExecutionsCounter, finalizedExecutionTimeUsCounter, failedExecutionTimeUsCounter});
        }

        @NotNull
        <V> Callable<V> wrap(@NotNull Callable<V> computation) {
            if (computation == null) {
                OTelMonitor.$$$reportNull$$$0(1);
            }
            return new MonitoredComputation<V>(computation);
        }

        @Contract(pure=true)
        private <V> V callWrapped(@Async.Execute @NotNull Callable<V> computation) throws Exception {
            if (computation == null) {
                OTelMonitor.$$$reportNull$$$0(2);
            }
            long startedAtNs = System.nanoTime();
            try {
                V result2 = computation.call();
                this.finalizedExecutionsCount.incrementAndGet();
                long finishedAtNs = System.nanoTime();
                long durationUs = TimeUnit.NANOSECONDS.toMicros(finishedAtNs - startedAtNs);
                this.finalizedExecutionTimeUs.addAndGet(durationUs);
                return result2;
            }
            catch (Throwable t) {
                this.failedExecutionsCount.incrementAndGet();
                long finishedAtNs = System.nanoTime();
                long durationUs = TimeUnit.NANOSECONDS.toMicros(finishedAtNs - startedAtNs);
                this.failedExecutionTimeUs.addAndGet(durationUs);
                throw t;
            }
        }

        @Override
        public void close() throws Exception {
            this.otelSubscription.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "computation";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/application/impl/NonBlockingReadActionImpl$OTelMonitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "wrap";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "callWrapped";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private final class MonitoredComputation<V>
        implements Callable<V> {
            private final Callable<V> wrappedComputation;

            private MonitoredComputation(Callable<V> wrappedComputation) {
                if (wrappedComputation == null) {
                    MonitoredComputation.$$$reportNull$$$0(0);
                }
                this.wrappedComputation = wrappedComputation;
            }

            @Override
            public V call() throws Exception {
                return OTelMonitor.this.callWrapped(this.wrappedComputation);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappedComputation", "com/intellij/openapi/application/impl/NonBlockingReadActionImpl$OTelMonitor$MonitoredComputation", "<init>"));
            }
        }
    }

    @ApiStatus.Internal
    public static final class Submission<T>
    extends AsyncPromise<T> {
        @NotNull
        private final Executor backendExecutor;
        @Nullable
        private final String myStartTrace;
        private volatile ProgressIndicator currentIndicator;
        private final ModalityState creationModality;
        @Nullable
        private Submission<?> myReplacement;
        @Nullable
        private final ProgressIndicator myProgressIndicator;
        @NotNull
        private final NonBlockingReadActionImpl<T> builder;
        @NotNull
        private final ChildContext myChildContext;
        @NotNull
        private final AccessToken childContextToken;
        private int myUseCount;
        private volatile boolean myCleaned;
        private static final VarHandle cleanedHandle;
        private final @NotNull AtomicReferenceArray<@Nullable Disposable> myExpirationDisposables;
        private static final @NotNull AtomicReferenceArray<@Nullable Disposable> EMPTY_ARRAY;

        Submission(@NotNull NonBlockingReadActionImpl<T> builder, @NotNull Executor backgroundThreadExecutor, @Nullable ProgressIndicator outerIndicator) {
            Disposable[] disposables;
            if (builder == null) {
                Submission.$$$reportNull$$$0(0);
            }
            if (backgroundThreadExecutor == null) {
                Submission.$$$reportNull$$$0(1);
            }
            this.creationModality = ModalityState.defaultModalityState();
            this.backendExecutor = backgroundThreadExecutor;
            this.builder = builder;
            this.myChildContext = Propagation.createChildContext((String)("NonBlockingReadActionImpl.Submission: " + String.valueOf((Object)this)));
            this.childContextToken = this.myChildContext.applyContextActions(false);
            if (builder.myCoalesceEquality != null) {
                this.acquire();
            }
            this.myProgressIndicator = outerIndicator;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Creating " + String.valueOf((Object)this));
            }
            String string = this.myStartTrace = this.hasUnboundedExecutor() ? ourUnboundedSubmissionTracker.preventTooManySubmissions() : null;
            if (this.shouldTrackInTests()) {
                ourTasksForTestMode.add(this);
            }
            if ((disposables = this.builder.myDisposables).length == 0) {
                this.myExpirationDisposables = EMPTY_ARRAY;
            } else {
                this.myExpirationDisposables = new AtomicReferenceArray(disposables.length);
                this.expireWithDisposables(disposables);
            }
        }

        @Nullable
        public T get() {
            if (!this.isDone()) {
                SlowOperations.assertSlowOperationsAreAllowed();
            }
            return (T)super.get();
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public T get(long timeout, @NotNull TimeUnit timeUnit) {
            void unit;
            if (timeUnit == null) {
                Submission.$$$reportNull$$$0(2);
            }
            if (!this.isDone() && unit.toMillis(timeout) > 50L) {
                SlowOperations.assertSlowOperationsAreAllowed();
            }
            return (T)super.get(timeout, (TimeUnit)unit);
        }

        private void expireWithDisposables(Disposable @NotNull [] disposables) {
            if (disposables == null) {
                Submission.$$$reportNull$$$0(3);
            }
            for (int i2 = 0; i2 < disposables.length; ++i2) {
                Disposable parentDisposable;
                Disposable parent = disposables[i2];
                if (parent instanceof Project ? ((Project)parent).isDisposed() : Disposer.isDisposed((Disposable)parent)) {
                    this.cancel();
                    break;
                }
                Disposable child = new Disposable(){

                    public void dispose() {
                        Submission.super.cancel();
                    }
                };
                try {
                    parentDisposable = parent instanceof ProjectImpl && ((ProjectEx)parent).isLight() ? ((ProjectImpl)parent).getEarlyDisposable() : parent;
                }
                catch (Exception e) {
                    this.cancel();
                    break;
                }
                try {
                    if (!Disposer.tryRegister((Disposable)parentDisposable, (Disposable)child)) {
                        this.cancel();
                        break;
                    }
                }
                catch (IncorrectOperationException e) {
                    this.cancel();
                    throw e;
                }
                this.myExpirationDisposables.set(i2, child);
            }
        }

        private boolean shouldTrackInTests() {
            return this.backendExecutor != SYNC_DUMMY_EXECUTOR && ApplicationManager.getApplication().isUnitTestMode();
        }

        private boolean hasUnboundedExecutor() {
            return this.backendExecutor == AppExecutorUtil.getAppExecutorService();
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean result2 = super.cancel(mayInterruptIfRunning);
            if (!this.isSucceeded()) {
                this.cancelJob(null);
            }
            this.cleanupIfNeeded();
            return result2;
        }

        public void setResult(@Nullable T t) {
            super.setResult(t);
            this.cleanupIfNeeded();
        }

        public boolean setError(@NotNull Throwable error2) {
            if (error2 == null) {
                Submission.$$$reportNull$$$0(4);
            }
            boolean result2 = super.setError(error2);
            this.cleanupIfNeeded();
            return result2;
        }

        protected boolean shouldLogErrors() {
            return this.backendExecutor != SYNC_DUMMY_EXECUTOR;
        }

        private void cleanupIfNeeded() {
            if (cleanedHandle.compareAndSet(this, false, true)) {
                this.cleanup();
            }
            this.disposeExpirationDisposables();
        }

        private void cleanup() {
            ProgressIndicator indicator2;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Cleaning " + String.valueOf((Object)this));
            }
            if ((indicator2 = this.currentIndicator) != null) {
                indicator2.cancel();
            }
            if (this.builder.myCoalesceEquality != null) {
                this.release();
            }
            if (this.hasUnboundedExecutor()) {
                ourUnboundedSubmissionTracker.unregisterSubmission(this.myStartTrace);
            }
            if (this.shouldTrackInTests()) {
                ourTasksForTestMode.remove((Object)this);
            }
        }

        private void disposeExpirationDisposables() {
            for (int i2 = 0; i2 < this.myExpirationDisposables.length(); ++i2) {
                Disposable disposable = this.myExpirationDisposables.getAndSet(i2, null);
                if (disposable == null) continue;
                Disposer.dispose((Disposable)disposable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void acquire() {
            assert (this.builder.myCoalesceEquality != null);
            Map<ListWithFixedHashCode, Submission<?>> map2 = ourTasksByEquality;
            synchronized (map2) {
                ++this.myUseCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void release() {
            assert (this.builder.myCoalesceEquality != null);
            Map<ListWithFixedHashCode, Submission<?>> map2 = ourTasksByEquality;
            synchronized (map2) {
                if (--this.myUseCount == 0 && ourTasksByEquality.get(this.builder.myCoalesceEquality) == this) {
                    this.scheduleReplacementIfAny();
                }
            }
        }

        private void scheduleReplacementIfAny() {
            if (this.myReplacement == null || this.myReplacement.isDone()) {
                ourTasksByEquality.remove(this.builder.myCoalesceEquality, (Object)this);
            } else {
                ourTasksByEquality.put(this.builder.myCoalesceEquality, this.myReplacement);
                this.myReplacement.transferToBgThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void submitOrScheduleCoalesced(@NotNull ListWithFixedHashCode coalesceEquality) {
            if (coalesceEquality == null) {
                Submission.$$$reportNull$$$0(5);
            }
            Map<ListWithFixedHashCode, Submission<?>> map2 = ourTasksByEquality;
            synchronized (map2) {
                if (this.isDone()) {
                    return;
                }
                Submission current = ourTasksByEquality.putIfAbsent(coalesceEquality, this);
                if (current == null) {
                    this.transferToBgThread();
                } else {
                    if (!current.getComputationOrigin().equals(this.getComputationOrigin())) {
                        this.reportCoalescingConflict(current);
                    }
                    if (current.myReplacement != null) {
                        current.myReplacement.cancel();
                        assert (current == ourTasksByEquality.get(coalesceEquality));
                    }
                    current.myReplacement = this;
                    current.cancel();
                }
            }
        }

        private void reportCoalescingConflict(@NotNull Submission<?> current) {
            if (current == null) {
                Submission.$$$reportNull$$$0(6);
            }
            ourTasksForTestMode.remove((Object)this);
            LOG.error("Same coalesceBy arguments are already used by " + current.getComputationOrigin() + " so they can cancel each other. Please make them more unique.");
        }

        @NotNull
        private String getComputationOrigin() {
            String name2;
            int dollars;
            Callable computation = this.builder.myOriginalComputation;
            if (computation instanceof RunnableCallable) {
                computation = ((RunnableCallable)computation).getDelegate();
            }
            String string = (dollars = (name2 = computation.getClass().getName()).indexOf("$$Lambda")) >= 0 ? name2.substring(0, dollars) : name2;
            if (string == null) {
                Submission.$$$reportNull$$$0(7);
            }
            return string;
        }

        void transferToBgThread() {
            ApplicationEx app;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Submitting " + String.valueOf((Object)this));
            }
            if ((app = ApplicationManagerEx.getApplicationEx()).isWriteActionInProgress() || app.isWriteActionPending() || app.isReadAccessAllowed() && this.builder.findUnsatisfiedConstraint() != null) {
                this.rescheduleLater();
                return;
            }
            if (this.builder.myCoalesceEquality != null) {
                this.acquire();
            }
            try {
                ContextAwareRunnable r = () -> {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Running in background " + String.valueOf((Object)this));
                    }
                    try {
                        boolean computationSuccessful = AppExecutorUtil.propagateContext() ? ((Boolean)ThreadContext.installThreadContext((CoroutineContext)this.myChildContext.getContext(), (boolean)true, () -> this.attemptComputation())).booleanValue() : this.attemptComputation();
                        if (!computationSuccessful) {
                            this.rescheduleLater();
                        }
                    }
                    finally {
                        if (this.builder.myCoalesceEquality != null) {
                            if (AppExecutorUtil.propagateContext()) {
                                ThreadContext.installThreadContext((CoroutineContext)this.myChildContext.getContext(), (boolean)true, () -> {
                                    this.release();
                                    return Unit.INSTANCE;
                                });
                            } else {
                                this.release();
                            }
                        }
                    }
                };
                this.backendExecutor.execute((Runnable)r);
            }
            catch (RejectedExecutionException e) {
                LOG.warn("Rejected: " + String.valueOf((Object)this));
                throw e;
            }
        }

        T executeSynchronously() {
            try {
                Object object = NbraUtilKt.runSynchronousNonBlockingReadActionWithCompensation(() -> {
                    while (true) {
                        CoroutineContext context2;
                        boolean couldRun;
                        if (!(couldRun = ((Boolean)ThreadContext.installThreadContext((CoroutineContext)(context2 = this.myChildContext.getJob() != null ? this.myChildContext.getContext() : (Cancellation.isInNonCancelableSection() ? ThreadContext.currentThreadContext().minusKey((CoroutineContext.Key)Job.Key) : ThreadContext.currentThreadContext())), (boolean)true, this::attemptComputation)).booleanValue())) {
                            Submission.blockUntilWriteActionIsDone(context2);
                        }
                        if (this.isDone()) {
                            if (this.isCancelled()) {
                                throw new ProcessCanceledException();
                            }
                            try {
                                return this.blockingGet(0, TimeUnit.MILLISECONDS);
                            }
                            catch (TimeoutException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled((ProgressIndicator)this.myProgressIndicator);
                        ConstrainedExecution.ContextConstraint[] constraints = this.builder.myConstraints;
                        if (!this.shouldFinishOnEdt() && constraints.length == 0) continue;
                        Semaphore semaphore = new Semaphore(1);
                        NonBlockingReadActionImpl.invokeLater((Runnable)((ContextAwareRunnable)() -> {
                            if (this.checkObsolete()) {
                                semaphore.up();
                            } else {
                                BaseConstrainedExecution.scheduleWithinConstraints(() -> ((Semaphore)semaphore).up(), null, constraints);
                            }
                        }));
                        ProgressIndicatorUtils.awaitWithCheckCanceled((Semaphore)semaphore, (ProgressIndicator)this.myProgressIndicator);
                        if (this.isCancelled()) break;
                    }
                    throw new ProcessCanceledException();
                });
                return (T)object;
            }
            catch (ProcessCanceledException e) {
                this.cancelJob((CancellationException)((Object)e));
                throw e;
            }
            finally {
                this.cleanupIfNeeded();
            }
        }

        private static void blockUntilWriteActionIsDone(CoroutineContext context2) {
            ThreadingAssertions.assertNoReadAccess();
            CompletableFuture future = FutureKt.asCompletableFuture((Job)JobKt.Job((Job)((Job)context2.get((CoroutineContext.Key)Job.Key))));
            Objects.requireNonNull(ApplicationManager.getApplication().getThreadingSupport()).runWhenWriteActionIsCompleted(() -> {
                future.complete(Unit.INSTANCE);
                return Unit.INSTANCE;
            });
            try {
                future.get();
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean attemptComputation() {
            Object indicator2;
            Object object = indicator2 = this.myProgressIndicator == null ? new EmptyProgressIndicator(this.creationModality) : new SensitiveProgressWrapper(this.myProgressIndicator){

                @NotNull
                public ModalityState getModalityState() {
                    ModalityState modalityState = creationModality;
                    if (modalityState == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return modalityState;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/NonBlockingReadActionImpl$Submission$2", "getModalityState"));
                }
            };
            if (this.myProgressIndicator != null) {
                indicator2.setIndeterminate(this.myProgressIndicator.isIndeterminate());
            }
            this.currentIndicator = indicator2;
            try {
                boolean success2;
                Ref unsatisfiedConstraint = Ref.create();
                if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                    this.insideReadAction((ProgressIndicator)indicator2, (Ref<ConstrainedExecution.ContextConstraint>)unsatisfiedConstraint);
                    success2 = true;
                    if (!unsatisfiedConstraint.isNull()) {
                        throw new IllegalStateException("Constraint " + String.valueOf(unsatisfiedConstraint) + " cannot be satisfied");
                    }
                } else {
                    if (this.myProgressIndicator != null) {
                        try {
                            this.myProgressIndicator.checkCanceled();
                        }
                        catch (ProcessCanceledException e) {
                            boolean bl = false;
                            this.currentIndicator = null;
                            return bl;
                        }
                    }
                    success2 = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> this.lambda$attemptComputation$6((ProgressIndicator)indicator2, unsatisfiedConstraint), (ProgressIndicator)indicator2);
                }
                boolean bl = success2 && unsatisfiedConstraint.isNull();
                return bl;
            }
            finally {
                this.currentIndicator = null;
            }
        }

        private void rescheduleLater() {
            if (Promises.isPending((Promise)this)) {
                NonBlockingReadActionImpl.invokeLater((Runnable)((ContextAwareRunnable)() -> this.reschedule()));
            }
        }

        private void reschedule() {
            if (!this.checkObsolete()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Rescheduling " + String.valueOf((Object)this));
                }
                BaseConstrainedExecution.scheduleWithinConstraints(() -> this.transferToBgThread(), null, this.builder.myConstraints);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void insideReadAction(@NotNull ProgressIndicator indicator2, @NotNull Ref<? super ConstrainedExecution.ContextConstraint> outUnsatisfiedConstraint) {
            block13: {
                if (indicator2 == null) {
                    Submission.$$$reportNull$$$0(8);
                }
                if (outUnsatisfiedConstraint == null) {
                    Submission.$$$reportNull$$$0(9);
                }
                try {
                    if (this.checkObsolete()) {
                        this.cancelJob(null);
                        return;
                    }
                    ConstrainedExecution.ContextConstraint constraint = this.builder.findUnsatisfiedConstraint();
                    if (constraint != null) {
                        outUnsatisfiedConstraint.set((Object)constraint);
                        return;
                    }
                    Object result2 = this.builder.myActualComputation.call();
                    if (this.shouldFinishOnEdt()) {
                        this.safeTransferToEdt(result2);
                        break block13;
                    }
                    try {
                        this.setResult(result2);
                    }
                    finally {
                        this.completeJob();
                    }
                }
                catch (ServiceNotReadyException e) {
                    this.failJob((Throwable)((Object)e));
                    throw e;
                }
                catch (ProcessCanceledException e) {
                    if (!indicator2.isCanceled()) {
                        this.failJob(e);
                        this.setError(e);
                    }
                    throw e;
                }
                catch (Throwable e) {
                    this.failJob(e);
                    this.setError(e);
                }
            }
        }

        public void cancel() {
            super.cancel();
            this.cancelJob(null);
        }

        public boolean isCancelled() {
            if (super.isCancelled()) {
                return true;
            }
            Job job2 = this.myChildContext.getJob();
            return job2 != null && job2.isCancelled();
        }

        private boolean shouldFinishOnEdt() {
            return this.builder.myModalityState != null;
        }

        private void cancelJob(@Nullable CancellationException e) {
            Job job2 = this.myChildContext.getJob();
            if (job2 != null) {
                job2.cancel(e);
            }
            this.childContextToken.finish();
        }

        private void completeJob() {
            Continuation continuation = this.myChildContext.getContinuation();
            if (continuation != null) {
                continuation.resumeWith((Object)Unit.INSTANCE);
            }
            this.childContextToken.finish();
        }

        private void failJob(@NotNull Throwable reason) {
            Continuation continuation;
            if (reason == null) {
                Submission.$$$reportNull$$$0(10);
            }
            if ((continuation = this.myChildContext.getContinuation()) != null) {
                continuation.resumeWith((Object)new Result.Failure(reason));
            }
            this.childContextToken.finish();
        }

        private boolean checkObsolete() {
            if (Promises.isRejected((Promise)this)) {
                this.cancelJob(new CancellationException("Cancelled by rejection"));
                return true;
            }
            for (BooleanSupplier condition : this.builder.myCancellationConditions) {
                if (!condition.getAsBoolean()) continue;
                this.cancel();
                return true;
            }
            if (this.myProgressIndicator != null && this.myProgressIndicator.isCanceled()) {
                this.cancel();
                return true;
            }
            return false;
        }

        private void safeTransferToEdt(T result2) {
            if (Promises.isRejected((Promise)this)) {
                this.cancelJob(null);
                return;
            }
            long stamp = AsyncExecutionServiceImpl.getWriteActionCounter();
            ApplicationManager.getApplication().invokeLater((Runnable)((ContextAwareRunnable)() -> {
                if (stamp != AsyncExecutionServiceImpl.getWriteActionCounter()) {
                    this.reschedule();
                    return;
                }
                if (this.checkObsolete()) {
                    this.cancelJob(null);
                    return;
                }
                this.setResult(result2);
                if (this.isSucceeded()) {
                    try {
                        if (AppExecutorUtil.propagateContext()) {
                            ThreadContext.installThreadContext((CoroutineContext)this.myChildContext.getContext(), (boolean)false, () -> {
                                this.builder.myUiThreadAction.accept(result2);
                                return Unit.INSTANCE;
                            });
                        } else {
                            this.builder.myUiThreadAction.accept(result2);
                        }
                    }
                    finally {
                        this.completeJob();
                    }
                }
            }), this.builder.myModalityState, __ -> this.isCancelled());
        }

        public String toString() {
            return "Submission{" + String.valueOf(this.builder.myOriginalComputation) + ", " + String.valueOf(this.getState()) + "}";
        }

        private /* synthetic */ void lambda$attemptComputation$6(ProgressIndicator indicator2, Ref unsatisfiedConstraint) {
            this.insideReadAction(indicator2, (Ref<ConstrainedExecution.ContextConstraint>)unsatisfiedConstraint);
        }

        static {
            try {
                cleanedHandle = MethodHandles.privateLookupIn(Submission.class, MethodHandles.lookup()).findVarHandle(Submission.class, "myCleaned", Boolean.TYPE);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            EMPTY_ARRAY = new AtomicReferenceArray(0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "backgroundThreadExecutor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposables";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "coalesceEquality";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "current";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/application/impl/NonBlockingReadActionImpl$Submission";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outUnsatisfiedConstraint";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/application/impl/NonBlockingReadActionImpl$Submission";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComputationOrigin";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "expireWithDisposables";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setError";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "submitOrScheduleCoalesced";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "reportCoalescingConflict";
                    break;
                }
                case 7: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "insideReadAction";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "failJob";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7 -> new IllegalStateException(string);
            };
        }
    }
}

