/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl.islands;

import com.intellij.ide.ui.GradientTextureCache;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/application/impl/islands/GradientCache;", "", "<init>", "()V", "left", "Lcom/intellij/ide/ui/GradientTextureCache;", "getLeft", "()Lcom/intellij/ide/ui/GradientTextureCache;", "right", "getRight", "mainRgb", "", "centerRgb", "blendedColor", "Ljava/awt/Color;", "getBlendedColor", "mainColor", "centerColor", "intellij.platform.ide.impl"})
final class GradientCache {
    @NotNull
    private final GradientTextureCache left = new GradientTextureCache();
    @NotNull
    private final GradientTextureCache right = new GradientTextureCache();
    private int mainRgb;
    private int centerRgb;
    @Nullable
    private Color blendedColor;

    @NotNull
    public final GradientTextureCache getLeft() {
        return this.left;
    }

    @NotNull
    public final GradientTextureCache getRight() {
        return this.right;
    }

    @NotNull
    public final Color getBlendedColor(@NotNull Color mainColor, @NotNull Color centerColor) {
        Intrinsics.checkNotNullParameter((Object)mainColor, (String)"mainColor");
        Intrinsics.checkNotNullParameter((Object)centerColor, (String)"centerColor");
        if (this.blendedColor == null || this.mainRgb != mainColor.getRGB() || this.centerRgb != centerColor.getRGB()) {
            this.mainRgb = mainColor.getRGB();
            this.centerRgb = centerColor.getRGB();
            this.blendedColor = ColorUtil.blendColorsInRgb((Color)mainColor, (Color)centerColor, (double)(0.85 * ((double)centerColor.getAlpha() / (double)255)));
        }
        Color color = this.blendedColor;
        Intrinsics.checkNotNull((Object)color);
        return color;
    }
}

