/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

final class NonUndoableAction
implements UndoableAction {
    private static final Logger LOG = Logger.getInstance(NonUndoableAction.class);
    private long myPerformedTimestamp;
    private final DocumentReference[] myRefs;
    private final boolean myGlobal;

    NonUndoableAction(@NotNull DocumentReference ref2, boolean isGlobal) {
        if (ref2 == null) {
            NonUndoableAction.$$$reportNull$$$0(0);
        }
        this.myPerformedTimestamp = -1L;
        this.myGlobal = isGlobal;
        this.myRefs = new DocumentReference[]{ref2};
        if (LOG.isDebugEnabled()) {
            LOG.debug("global=" + isGlobal + "; doc=" + String.valueOf(ref2));
        }
    }

    public void undo() {
        LOG.error("Cannot undo");
    }

    public void redo() {
        LOG.error("Cannot redo");
    }

    public DocumentReference[] getAffectedDocuments() {
        return this.myRefs;
    }

    public boolean isGlobal() {
        return this.myGlobal;
    }

    public long getPerformedNanoTime() {
        return this.myPerformedTimestamp;
    }

    public void setPerformedNanoTime(long l) {
        this.myPerformedTimestamp = l;
    }

    public String toString() {
        return "NonUndoableAction{ref=%s%s, performed=%sms}".formatted(this.myRefs[0], this.isGlobal() ? ", global" : "", this.getPerformedNanoTime() / 1000L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/openapi/command/impl/NonUndoableAction", "<init>"));
    }
}

