/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.SeparatedCommandListener;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.cmd.CmdEvent;
import com.intellij.openapi.command.impl.cmd.CmdEventTransparent;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UndoCommandListener
implements SeparatedCommandListener {
    private static final Logger LOG = Logger.getInstance(UndoCommandListener.class);
    @Nullable
    private final Project project;
    @NotNull
    private final UndoManagerImpl undoManager;

    UndoCommandListener(@NotNull Project project2) {
        if (project2 == null) {
            UndoCommandListener.$$$reportNull$$$0(0);
        }
        this(project2, UndoManager.getInstance((Project)project2));
    }

    UndoCommandListener() {
        this(null, UndoManager.getGlobalInstance());
    }

    private UndoCommandListener(@Nullable Project project2, @NotNull UndoManager undoManager) {
        if (undoManager == null) {
            UndoCommandListener.$$$reportNull$$$0(1);
        }
        this.project = project2;
        this.undoManager = (UndoManagerImpl)undoManager;
    }

    @Override
    public void onCommandStarted(@NotNull CmdEvent cmdStartEvent) {
        if (cmdStartEvent == null) {
            UndoCommandListener.$$$reportNull$$$0(2);
        }
        if (this.projectNotDisposed()) {
            this.undoManager.onCommandStarted(this.eventWithProject(cmdStartEvent));
        }
    }

    @Override
    public void onCommandFinished(@NotNull CmdEvent cmdFinishEvent) {
        if (cmdFinishEvent == null) {
            UndoCommandListener.$$$reportNull$$$0(3);
        }
        if (this.projectNotDisposed()) {
            this.undoManager.onCommandFinished(this.eventWithProject(cmdFinishEvent));
        }
    }

    @Override
    public void onCommandFakeFinished(@NotNull CmdEvent cmdFakeFinishEvent) {
        if (cmdFakeFinishEvent == null) {
            UndoCommandListener.$$$reportNull$$$0(4);
        }
        if (this.projectNotDisposed()) {
            this.undoManager.onCommandFakeFinished(cmdFakeFinishEvent);
        }
    }

    @NotNull
    private CmdEvent eventWithProject(@NotNull CmdEvent cmdEvent) {
        if (cmdEvent == null) {
            UndoCommandListener.$$$reportNull$$$0(5);
        }
        CmdEvent cmdEvent2 = cmdEvent.isTransparent() ? ((CmdEventTransparent)cmdEvent).withProject(this.project) : cmdEvent;
        if (cmdEvent2 == null) {
            UndoCommandListener.$$$reportNull$$$0(6);
        }
        return cmdEvent2;
    }

    private boolean projectNotDisposed() {
        boolean isDisposed;
        boolean bl = isDisposed = this.project != null && this.project.isDisposed();
        if (isDisposed) {
            LOG.error("Cannot perform a command, project is disposed " + String.valueOf(this.project));
        }
        return !isDisposed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdStartEvent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdFinishEvent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdFakeFinishEvent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdEvent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/UndoCommandListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/UndoCommandListener";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "eventWithProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onCommandStarted";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onCommandFinished";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onCommandFakeFinished";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "eventWithProject";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

