/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Key;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public final class SplitLineAction
extends EditorAction {
    public static Key<Boolean> SPLIT_LINE_KEY = Key.create((String)"com.intellij.openapi.editor.actions.SplitLineAction");

    public SplitLineAction() {
        super((EditorActionHandler)new Handler());
        this.setEnabledInModalContext(false);
    }

    private static final class Handler
    extends EditorWriteActionHandler.ForEachCaret {
        private Handler() {
        }

        public boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            return Handler.getEnterHandler().isEnabled(editor2, caret, dataContext2) && !((EditorEx)editor2).isEmbeddedIntoDialogWrapper();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeWriteAction(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(2);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(3);
            }
            CopyPasteManager.getInstance().stopKillRings();
            Document document2 = editor2.getDocument();
            RangeMarker rangeMarker = document2.createRangeMarker(editor2.getCaretModel().getOffset(), editor2.getCaretModel().getOffset());
            CharSequence chars = document2.getCharsSequence();
            int offset = editor2.getCaretModel().getOffset();
            int lineStart = document2.getLineStartOffset(document2.getLineNumber(offset));
            CharSequence beforeCaret = chars.subSequence(lineStart, offset);
            if (CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)beforeCaret)) {
                Object strToInsert = "";
                strToInsert = (String)strToInsert + beforeCaret.toString();
                strToInsert = (String)strToInsert + "\n";
                document2.insertString(lineStart, (CharSequence)strToInsert);
                editor2.getCaretModel().moveToOffset(offset);
            } else {
                DataManager.getInstance().saveInDataContext(dataContext2, SPLIT_LINE_KEY, (Object)true);
                try {
                    Handler.getEnterHandler().execute(editor2, caret, dataContext2);
                }
                finally {
                    DataManager.getInstance().saveInDataContext(dataContext2, SPLIT_LINE_KEY, null);
                }
                editor2.getCaretModel().moveToOffset(Math.min(document2.getTextLength(), rangeMarker.getStartOffset()));
                editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }

        private static EditorActionHandler getEnterHandler() {
            return EditorActionManager.getInstance().getActionHandler("EditorEnter");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/actions/SplitLineAction$Handler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeWriteAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

