/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.IndentSelectionAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public final class UnindentSelectionAction
extends EditorAction {
    public UnindentSelectionAction() {
        super((EditorActionHandler)new Handler());
    }

    private static void unindentSelection(Editor editor2, Project project2) {
        int endIndex;
        Document document2;
        int startIndex;
        int oldSelectionStart = editor2.getSelectionModel().getSelectionStart();
        int oldSelectionEnd = editor2.getSelectionModel().getSelectionEnd();
        if (!editor2.getSelectionModel().hasSelection()) {
            oldSelectionEnd = oldSelectionStart = editor2.getCaretModel().getOffset();
        }
        if ((startIndex = (document2 = editor2.getDocument()).getLineNumber(oldSelectionStart)) == -1) {
            startIndex = document2.getLineCount() - 1;
        }
        if ((endIndex = document2.getLineNumber(oldSelectionEnd)) > 0 && document2.getLineStartOffset(endIndex) == oldSelectionEnd && endIndex > startIndex) {
            --endIndex;
        }
        if (endIndex == -1) {
            endIndex = document2.getLineCount() - 1;
        }
        if (startIndex < 0 || endIndex < 0) {
            return;
        }
        int blockIndent = CodeStyle.getIndentOptions((Project)project2, (Document)document2).INDENT_SIZE;
        IndentSelectionAction.doIndent(endIndex, startIndex, document2, project2, editor2, -blockIndent);
    }

    private static final class Handler
    extends EditorWriteActionHandler.ForEachCaret {
        private Handler() {
        }

        public void executeWriteAction(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
            UnindentSelectionAction.unindentSelection(editor2, project2);
        }

        public boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(2);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(3);
            }
            return !editor2.isViewer() && !editor2.isOneLineMode() && !((EditorEx)editor2).isEmbeddedIntoDialogWrapper();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/actions/UnindentSelectionAction$Handler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeWriteAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

