/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.impl.inspector.RedesignedInspectionsManager;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001:\u0001%B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001cH\u0014J0\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001cH\u0014J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001aH\u0014J\b\u0010$\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/openapi/editor/impl/EditorInspectionsActionToolbar;", "Lcom/intellij/openapi/actionSystem/impl/ActionToolbarImpl;", "actions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "editorButtonLook", "Lcom/intellij/openapi/actionSystem/ex/ActionButtonLook;", "nextErrorAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "prevErrorAction", "<init>", "(Lcom/intellij/openapi/actionSystem/DefaultActionGroup;Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/openapi/actionSystem/ex/ActionButtonLook;Lcom/intellij/openapi/actionSystem/AnAction;Lcom/intellij/openapi/actionSystem/AnAction;)V", "addNotify", "", "paintComponent", "g", "Ljava/awt/Graphics;", "getSeparatorHeight", "", "createTextButton", "Lcom/intellij/openapi/actionSystem/impl/ActionButtonWithText;", "action", "place", "", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "minimumSize", "Ljava/util/function/Supplier;", "Ljava/awt/Dimension;", "createIconButton", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "canReuseActionButton", "", "oldActionButton", "newPresentation", "doLayout", "ToolbarActionButton", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public class EditorInspectionsActionToolbar
extends ActionToolbarImpl {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final ActionButtonLook editorButtonLook;
    @Nullable
    private final AnAction nextErrorAction;
    @Nullable
    private final AnAction prevErrorAction;

    public EditorInspectionsActionToolbar(@NotNull DefaultActionGroup actions, @NotNull EditorImpl editor2, @NotNull ActionButtonLook editorButtonLook, @Nullable AnAction nextErrorAction, @Nullable AnAction prevErrorAction) {
        Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)editorButtonLook, (String)"editorButtonLook");
        super("EditorInspectionsToolbar", (ActionGroup)actions, true, false, false, 24, null);
        this.editor = editor2;
        this.editorButtonLook = editorButtonLook;
        this.nextErrorAction = nextErrorAction;
        this.prevErrorAction = prevErrorAction;
        ClientProperty.put((JComponent)this, ActionToolbarImpl.Companion.getSUPPRESS_FAST_TRACK(), (Object)true);
    }

    @Override
    public void addNotify() {
        this.setTargetComponent(this.editor.getContentComponent());
        super.addNotify();
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.editorButtonLook.paintBackground(g, (JComponent)this, this.editor.getBackgroundColor());
    }

    @Override
    protected int getSeparatorHeight() {
        return EditorMarkupModelImpl.Companion.getStatusIconSize$intellij_platform_ide_impl();
    }

    @Override
    @NotNull
    protected ActionButtonWithText createTextButton(@NotNull AnAction action2, @NotNull String place, @NotNull Presentation presentation2, @NotNull Supplier<? extends Dimension> minimumSize) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        Intrinsics.checkNotNullParameter(minimumSize, (String)"minimumSize");
        if (RedesignedInspectionsManager.isAvailable()) {
            return super.createTextButton(action2, place, presentation2, minimumSize);
        }
        ActionButtonWithText button2 = super.createTextButton(action2, place, presentation2, minimumSize);
        JBColor jBColor = JBColor.lazy(() -> EditorInspectionsActionToolbar.createTextButton$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"lazy(...)");
        JBColor color = jBColor;
        button2.setForeground((Color)color);
        return button2;
    }

    @Override
    @NotNull
    protected ActionButton createIconButton(@NotNull AnAction action2, @NotNull String place, @NotNull Presentation presentation2, @NotNull Supplier<? extends Dimension> minimumSize) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        Intrinsics.checkNotNullParameter(minimumSize, (String)"minimumSize");
        if (RedesignedInspectionsManager.isAvailable()) {
            return super.createIconButton(action2, place, presentation2, minimumSize);
        }
        return new ToolbarActionButton(action2, presentation2, place, minimumSize);
    }

    @Override
    protected boolean canReuseActionButton(@NotNull ActionButton oldActionButton, @NotNull Presentation newPresentation) {
        Intrinsics.checkNotNullParameter((Object)oldActionButton, (String)"oldActionButton");
        Intrinsics.checkNotNullParameter((Object)newPresentation, (String)"newPresentation");
        if (RedesignedInspectionsManager.isAvailable()) {
            return super.canReuseActionButton(oldActionButton, newPresentation);
        }
        boolean shouldHaveText = Intrinsics.areEqual((Object)newPresentation.getClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR), (Object)true);
        if (shouldHaveText) {
            return Intrinsics.areEqual(oldActionButton.getClass(), ActionButtonWithText.class);
        }
        return Intrinsics.areEqual(oldActionButton.getClass(), ToolbarActionButton.class);
    }

    @Override
    public void doLayout() {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager != null) {
            layoutManager.layoutContainer(this);
        } else {
            super.doLayout();
        }
    }

    private static final Color createTextButton$lambda$0(EditorInspectionsActionToolbar this$0) {
        Color color = this$0.editor.getColorsScheme().getColor(EditorMarkupModelImpl.Companion.getICON_TEXT_COLOR$intellij_platform_ide_impl());
        if (color == null) {
            color = EditorMarkupModelImpl.Companion.getICON_TEXT_COLOR$intellij_platform_ide_impl().getDefaultColor();
        }
        return color;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0097\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/editor/impl/EditorInspectionsActionToolbar$ToolbarActionButton;", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "minimumSize", "Ljava/util/function/Supplier;", "Ljava/awt/Dimension;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorInspectionsActionToolbar;Lcom/intellij/openapi/actionSystem/AnAction;Lcom/intellij/openapi/actionSystem/Presentation;Ljava/lang/String;Ljava/util/function/Supplier;)V", "updateIcon", "", "getInsets", "Ljava/awt/Insets;", "getPreferredSize", "intellij.platform.ide.impl"})
    @ApiStatus.Internal
    public class ToolbarActionButton
    extends ActionButton {
        public ToolbarActionButton(@NotNull AnAction action2, @NotNull Presentation presentation2, @NotNull String place, Supplier<? extends Dimension> minimumSize) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            Intrinsics.checkNotNullParameter(minimumSize, (String)"minimumSize");
            super(action2, presentation2, place, minimumSize);
        }

        @Override
        public void updateIcon() {
            super.updateIcon();
            this.revalidate();
            this.repaint();
        }

        @Override
        @NotNull
        public Insets getInsets() {
            Insets insets;
            if (this.myAction == EditorInspectionsActionToolbar.this.nextErrorAction) {
                JBInsets jBInsets = JBUI.insets((int)2, (int)1);
                Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
                insets = (Insets)jBInsets;
            } else if (this.myAction == EditorInspectionsActionToolbar.this.prevErrorAction) {
                JBInsets jBInsets = JBUI.insets((int)2, (int)1, (int)2, (int)2);
                Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
                insets = (Insets)jBInsets;
            } else {
                JBInsets jBInsets = JBUI.insets((int)2);
                Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
                insets = (Insets)jBInsets;
            }
            return insets;
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            Icon icon2 = this.getIcon();
            Dimension size2 = new Dimension(icon2.getIconWidth(), icon2.getIconHeight());
            int minSize = EditorMarkupModelImpl.Companion.getStatusIconSize$intellij_platform_ide_impl();
            size2.width = Math.max(size2.width, minSize);
            size2.height = Math.max(size2.height, minSize);
            JBInsets.addTo((Dimension)size2, (Insets)this.getInsets());
            return size2;
        }
    }
}

