/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.EditorThreading;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.EDT;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J1\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u0007\"\b\b\u0001\u0010\b*\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/editor/impl/EditorThreadingImpl;", "Lcom/intellij/openapi/editor/EditorThreading;", "<init>", "()V", "doAssertInteractionAllowed", "", "doCompute", "T", "E", "", "action", "Lcom/intellij/openapi/util/ThrowableComputable;", "(Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;", "doRun", "Ljava/lang/Runnable;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class EditorThreadingImpl
implements EditorThreading {
    public void doAssertInteractionAllowed() {
        if (Registry.Companion.is("editor.allow.raw.access.on.edt")) {
            if (!EDT.isCurrentThreadEdt() && !ApplicationKt.getApplication().isReadAccessAllowed()) {
                throw new IllegalStateException("Access to Editor models (caret, selection, etc.) is allowed either from EDT, or under read action. Current thread: " + Thread.currentThread());
            }
        } else {
            ThreadingAssertions.assertReadAccess();
        }
    }

    public <T, E extends Throwable> T doCompute(@NotNull ThrowableComputable<T, E> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        return (T)(Registry.Companion.is("editor.allow.raw.access.on.edt") ? (EDT.isCurrentThreadEdt() ? action2.compute() : ApplicationKt.getApplication().runReadAction(action2)) : ApplicationKt.getApplication().runReadAction(action2));
    }

    public void doRun(@NotNull Runnable action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        if (Registry.Companion.is("editor.allow.raw.access.on.edt")) {
            if (EDT.isCurrentThreadEdt()) {
                action2.run();
            } else {
                ApplicationKt.getApplication().runReadAction(action2);
            }
        } else {
            ApplicationKt.getApplication().runReadAction(action2);
        }
    }
}

