/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.ErrorStripeEvent;
import com.intellij.openapi.editor.ex.ErrorStripeListener;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

final class ErrorStripeMarkersModel {
    @NotNull
    private final EditorImpl myEditor;
    private final List<ErrorStripeListener> myListeners;

    ErrorStripeMarkersModel(@NotNull EditorImpl editor2) {
        if (editor2 == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(0);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myEditor = editor2;
    }

    void fireErrorMarkerClicked(@NotNull RangeHighlighter highlighter, @NotNull MouseEvent e) {
        if (highlighter == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(1);
        }
        if (e == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ErrorStripeEvent event = new ErrorStripeEvent(this.myEditor, e, highlighter);
        this.logMarkerClicked(event);
        this.myListeners.forEach(listener2 -> listener2.errorMarkerClicked(event));
    }

    void addErrorMarkerClickListener(@NotNull Disposable parent, @NotNull ErrorStripeListener listener2) {
        if (parent == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(3);
        }
        if (listener2 == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(4);
        }
        ContainerUtil.add((Object)listener2, this.myListeners, (Disposable)parent);
    }

    static boolean isErrorStripeHighlighter(@NotNull RangeHighlighterEx highlighter, @NotNull EditorImpl editor2) {
        if (highlighter == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(6);
        }
        return highlighter.getEditorFilter().avaliableIn((Editor)editor2) && editor2.isHighlighterAvailable((RangeHighlighter)highlighter) && highlighter.getErrorStripeMarkColor(editor2.getColorsScheme()) != null;
    }

    private void logMarkerClicked(@NotNull ErrorStripeEvent event) {
        Project project2;
        if (event == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(7);
        }
        if ((project2 = event.getEditor().getProject()) != null) {
            HighlightInfo info = HighlightInfo.fromRangeHighlighter((RangeHighlighter)event.getHighlighter());
            int severity = info != null ? info.getSeverity().myVal : -1;
            VirtualFile vFile = event.getEditor().getVirtualFile();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                int totalMarkersInFile = (Integer)ReadAction.compute(() -> this.countErrorStripeMarkers());
                FileType fileType2 = vFile != null && vFile.isValid() ? vFile.getFileType() : null;
                UIEventLogger.ErrorStripeNavigate.log(project2, (Object)severity, (Object)totalMarkersInFile, (Object)fileType2);
            });
        }
    }

    private int countErrorStripeMarkers() {
        if (this.myEditor.isDisposed()) {
            return 0;
        }
        return this.countErrorStripeMarkers(DocumentMarkupModel.forDocument((Document)this.myEditor.getDocument(), (Project)this.myEditor.getProject(), (boolean)true)) + this.countErrorStripeMarkers((MarkupModel)this.myEditor.getMarkupModel());
    }

    private int countErrorStripeMarkers(@NotNull MarkupModel model2) {
        if (model2 == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(8);
        }
        AtomicInteger c = new AtomicInteger();
        try (MarkupIterator iterator2 = ((MarkupModelEx)model2).overlappingErrorStripeIterator(0, model2.getDocument().getTextLength());){
            ContainerUtil.process((Iterator)iterator2, __ -> c.getAndIncrement() >= 0);
        }
        return c.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/ErrorStripeMarkersModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fireErrorMarkerClicked";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addErrorMarkerClickListener";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isErrorStripeHighlighter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "logMarkerClicked";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "countErrorStripeMarkers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

