/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorThreading;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FocusModeModel
implements Disposable {
    public static final Key<TextAttributes> FOCUS_MODE_ATTRIBUTES = Key.create((String)"editor.focus.mode.attributes");
    private static final int LAYER = 10000;
    private final List<RangeHighlighter> myFocusModeMarkup;
    @NotNull
    private final EditorImpl myEditor;
    private RangeMarker myFocusModeRange;
    private final List<FocusModeModelListener> mySegmentListeners;
    private final RangeMarkerTree<RangeMarkerEx> myFocusMarkerTree;

    @ApiStatus.Internal
    public FocusModeModel(@NotNull EditorImpl editor2) {
        if (editor2 == null) {
            FocusModeModel.$$$reportNull$$$0(0);
        }
        this.myFocusModeMarkup = new SmartList();
        this.mySegmentListeners = new SmartList();
        this.myEditor = editor2;
        this.myFocusMarkerTree = new RangeMarkerTree((Document)editor2.getDocument());
        this.myEditor.getScrollingModel().addVisibleAreaListener(e -> EditorThreading.run(() -> {
            AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
            if (event instanceof MouseEvent && !EditorUtil.isPrimaryCaretVisible(this.myEditor)) {
                this.clearFocusMode();
            } else {
                this.myEditor.applyFocusMode();
            }
        }));
        final CaretModelImpl caretModel = this.myEditor.getCaretModel();
        caretModel.addCaretListener(new CaretListener(){

            public void caretAdded(@NotNull CaretEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.process(event);
            }

            public void caretPositionChanged(@NotNull CaretEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.process(event);
            }

            public void caretRemoved(@NotNull CaretEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.process(event);
            }

            private void process(@NotNull CaretEvent event) {
                Caret caret;
                if (event == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((caret = event.getCaret()) == caretModel.getPrimaryCaret()) {
                    FocusModeModel.this.applyFocusMode(caret);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/editor/impl/FocusModeModel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretPositionChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretRemoved";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myEditor.getSelectionModel().addSelectionListener(new SelectionListener(){

            public void selectionChanged(@NotNull SelectionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                FocusModeModel.this.myEditor.applyFocusMode();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/FocusModeModel$2", "selectionChanged"));
            }
        });
    }

    RangeMarker getFocusModeRange() {
        return this.myFocusModeRange;
    }

    void applyFocusMode(@NotNull Caret caret) {
        if (caret == null) {
            FocusModeModel.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        RangeMarkerEx[] startRange = new RangeMarkerEx[1];
        RangeMarkerEx[] endRange = new RangeMarkerEx[1];
        this.myFocusMarkerTree.processContaining(caret.getSelectionStart(), startMarker -> {
            if (startRange[0] == null || startRange[0].getStartOffset() < startMarker.getStartOffset()) {
                startRange[0] = startMarker;
            }
            return true;
        });
        this.myFocusMarkerTree.processContaining(caret.getSelectionEnd(), endMarker -> {
            if (endRange[0] == null || endRange[0].getEndOffset() > endMarker.getEndOffset()) {
                endRange[0] = endMarker;
            }
            return true;
        });
        this.clearFocusMode();
        if (startRange[0] != null && endRange[0] != null) {
            this.applyFocusMode(this.enlargeFocusRangeIfNeeded((Segment)new TextRange(startRange[0].getStartOffset(), endRange[0].getEndOffset())));
        }
    }

    void clearFocusMode() {
        this.myFocusModeMarkup.forEach(arg_0 -> ((MarkupModelEx)this.myEditor.getMarkupModel()).removeHighlighter(arg_0));
        this.myFocusModeMarkup.clear();
        if (this.myFocusModeRange != null) {
            this.myFocusModeRange.dispose();
            this.myFocusModeRange = null;
        }
    }

    @ApiStatus.Internal
    public boolean isInFocusMode(@NotNull RangeMarker region) {
        if (region == null) {
            FocusModeModel.$$$reportNull$$$0(2);
        }
        return this.myFocusModeRange != null && !FocusModeModel.intersects(this.myFocusModeRange, region);
    }

    @ApiStatus.Internal
    @NotNull
    public RangeMarker createFocusRegion(int start2, int end) {
        RangeMarkerImpl marker = new RangeMarkerImpl(this.myEditor.getDocument(), start2, end, false, false);
        this.myFocusMarkerTree.addInterval((RangeMarkerEx)marker, start2, end, false, false, true, 0);
        this.mySegmentListeners.forEach(arg_0 -> FocusModeModel.lambda$createFocusRegion$4((RangeMarkerEx)marker, arg_0));
        RangeMarkerImpl rangeMarkerImpl = marker;
        if (rangeMarkerImpl == null) {
            FocusModeModel.$$$reportNull$$$0(3);
        }
        return rangeMarkerImpl;
    }

    @ApiStatus.Internal
    @Nullable
    public RangeMarker findFocusRegion(int start2, int end) {
        RangeMarker[] found = new RangeMarker[1];
        this.myFocusMarkerTree.processOverlappingWith(start2, end, range -> {
            if (range.getStartOffset() == start2 && range.getEndOffset() == end) {
                found[0] = range;
                return false;
            }
            return true;
        });
        return found[0];
    }

    @ApiStatus.Internal
    public void removeFocusRegion(@NotNull RangeMarker marker) {
        boolean removed;
        if (marker == null) {
            FocusModeModel.$$$reportNull$$$0(4);
        }
        if (removed = this.myFocusMarkerTree.removeInterval((RangeMarkerEx)marker)) {
            this.mySegmentListeners.forEach(l -> l.focusRegionRemoved((Segment)marker));
        }
    }

    @ApiStatus.Internal
    public void addFocusSegmentListener(FocusModeModelListener newListener, Disposable disposable) {
        this.mySegmentListeners.add(newListener);
        Disposer.register((Disposable)disposable, () -> this.mySegmentListeners.remove(newListener));
    }

    @NotNull
    private Segment enlargeFocusRangeIfNeeded(@NotNull Segment range) {
        int originalEnd;
        int end;
        DocumentEx document2;
        int originalStart;
        int start2;
        if (range == null) {
            FocusModeModel.$$$reportNull$$$0(5);
        }
        if ((start2 = DocumentUtil.getLineStartOffset((int)(originalStart = range.getStartOffset()), (Document)(document2 = this.myEditor.getDocument()))) < originalStart) {
            range = new TextRange(start2, range.getEndOffset());
        }
        if ((end = DocumentUtil.getLineEndOffset((int)(originalEnd = range.getEndOffset()), (Document)document2)) >= originalEnd) {
            range = new TextRange(range.getStartOffset(), end < document2.getTextLength() ? end + 1 : end);
        }
        Segment segment = range;
        if (segment == null) {
            FocusModeModel.$$$reportNull$$$0(6);
        }
        return segment;
    }

    private void applyFocusMode(@NotNull Segment focusRange) {
        EditorColorsScheme scheme;
        Color background;
        if (focusRange == null) {
            FocusModeModel.$$$reportNull$$$0(7);
        }
        Color foreground = Registry.getColor((String)(ColorUtil.isDark((Color)(background = (scheme = (EditorColorsScheme)ObjectUtils.notNull((Object)this.myEditor.getColorsScheme(), (Object)EditorColorsManager.getInstance().getGlobalScheme())).getDefaultBackground())) ? "editor.focus.mode.color.dark" : "editor.focus.mode.color.light"), (Color)Color.GRAY);
        TextAttributes attributes = new TextAttributes(foreground, background, background, EffectType.LINE_UNDERSCORE, 0);
        this.myEditor.putUserData(FOCUS_MODE_ATTRIBUTES, attributes);
        MarkupModelEx markupModel = this.myEditor.getMarkupModel();
        DocumentEx document2 = this.myEditor.getDocument();
        int textLength = document2.getTextLength();
        int start2 = focusRange.getStartOffset();
        int end = focusRange.getEndOffset();
        if (start2 <= textLength) {
            this.myFocusModeMarkup.add(markupModel.addRangeHighlighter(0, start2, 10000, attributes, HighlighterTargetArea.EXACT_RANGE));
        }
        if (end <= textLength) {
            this.myFocusModeMarkup.add(markupModel.addRangeHighlighter(end, textLength, 10000, attributes, HighlighterTargetArea.EXACT_RANGE));
        }
        this.myFocusModeRange = document2.createRangeMarker(start2, end);
    }

    public void dispose() {
        this.myFocusMarkerTree.dispose((Document)this.myEditor.getDocument());
    }

    private static boolean intersects(RangeMarker a, RangeMarker b) {
        return Math.max(a.getStartOffset(), b.getStartOffset()) < Math.min(a.getEndOffset(), b.getEndOffset());
    }

    private static /* synthetic */ void lambda$createFocusRegion$4(RangeMarkerEx marker, FocusModeModelListener l) {
        l.focusRegionAdded((Segment)marker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FocusModeModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FocusModeModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFocusRegion";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "enlargeFocusRangeIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFocusMode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInFocusMode";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeFocusRegion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "enlargeFocusRangeIfNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static interface FocusModeModelListener {
        public void focusRegionAdded(@NotNull Segment var1);

        public void focusRegionRemoved(@NotNull Segment var1);
    }
}

