/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserDialogHelper;
import com.intellij.openapi.fileChooser.impl.FileChooserUsageCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.UIBundle;
import com.intellij.util.Consumer;
import com.intellij.util.ui.OwnerOptional;
import com.jetbrains.JBRFileDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NativeFileChooserDialogImpl
implements FileChooserDialog,
PathChooserDialog {
    private final FileChooserDescriptor myDescriptor;
    private final Component myParent;
    private final FileChooserDialogHelper myHelper;
    @NlsContexts.DialogTitle
    private final String myTitle;
    private final FileDialog myFileDialog;
    private VirtualFile[] myChosenFiles;

    NativeFileChooserDialogImpl(@NotNull FileChooserDescriptor descriptor2, Component parent, Project project2) {
        if (descriptor2 == null) {
            NativeFileChooserDialogImpl.$$$reportNull$$$0(0);
        }
        this.myChosenFiles = VirtualFile.EMPTY_ARRAY;
        this.myDescriptor = descriptor2;
        this.myParent = parent != null ? parent : IdeFocusManager.getInstance((Project)project2).getFocusOwner();
        this.myHelper = new FileChooserDialogHelper(descriptor2);
        this.myHelper.setNativeDialogProperties();
        this.myTitle = Objects.requireNonNullElseGet(descriptor2.getTitle(), () -> UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]));
        this.myFileDialog = OwnerOptional.create(parent, owner -> new FileDialog((Dialog)owner, this.myTitle, 0), owner -> new FileDialog((Frame)owner, this.myTitle, 0));
        JBRFileDialog jbrDialog = JBRFileDialog.get((FileDialog)this.myFileDialog);
        if (jbrDialog != null) {
            int hints = jbrDialog.getHints();
            if (this.myDescriptor.isChooseFolders()) {
                hints |= 2;
            }
            if (this.myDescriptor.isChooseFiles() || this.myDescriptor.isChooseJarContents()) {
                hints |= 1;
            }
            jbrDialog.setHints(hints);
            jbrDialog.setLocalizationString("jbrFileDialogOpenFile", IdeBundle.message((String)"windows.native.common.dialog.open", (Object[])new Object[0]));
            jbrDialog.setLocalizationString("jbrFileDialogSelectDir", IdeBundle.message((String)"windows.native.common.dialog.select.folder", (Object[])new Object[0]));
            jbrDialog.setLocalizationString("jbrFileDialogAllFiles", IdeBundle.message((String)"windows.native.common.dialog.all", (Object[])new Object[0]));
            this.myHelper.setFileFilter(jbrDialog, descriptor2);
        }
    }

    public void choose(@Nullable VirtualFile toSelect, @NotNull Consumer<? super List<VirtualFile>> callback) {
        if (callback == null) {
            NativeFileChooserDialogImpl.$$$reportNull$$$0(1);
        }
        if (toSelect != null && toSelect.getParent() != null) {
            String fileName;
            String directoryName;
            if (toSelect.isDirectory()) {
                directoryName = toSelect.getCanonicalPath();
                fileName = null;
            } else {
                directoryName = toSelect.getParent().getCanonicalPath();
                fileName = toSelect.getPath();
            }
            this.myFileDialog.setDirectory(directoryName);
            this.myFileDialog.setFile(fileName);
        }
        this.myFileDialog.setMultipleMode(this.myDescriptor.isChooseMultiple());
        this.myHelper.showNativeDialog(this.myFileDialog);
        File[] selectedFiles2 = this.myFileDialog.getFiles();
        if (selectedFiles2.length != 0) {
            List<Path> selectedPaths = Stream.of(selectedFiles2).map(File::toPath).toList();
            this.myChosenFiles = this.myHelper.selectedFiles(selectedPaths, this.myParent, this.myTitle);
            if (this.myChosenFiles.length != 0) {
                FileChooserUsageCollector.log(this, this.myDescriptor, this.myChosenFiles);
                callback.consume(List.of(this.myChosenFiles));
            }
        } else if (callback instanceof FileChooser.FileChooserConsumer) {
            ((FileChooser.FileChooserConsumer)callback).cancelled();
        }
    }

    public VirtualFile @NotNull [] choose(@Nullable Project project2, VirtualFile ... toSelect) {
        if (toSelect == null) {
            NativeFileChooserDialogImpl.$$$reportNull$$$0(2);
        }
        this.choose(toSelect.length > 0 ? toSelect[0] : null, (Consumer<? super List<VirtualFile>>)((Consumer)__ -> {}));
        FileChooserUsageCollector.log(this, this.myDescriptor, this.myChosenFiles);
        if (this.myChosenFiles == null) {
            NativeFileChooserDialogImpl.$$$reportNull$$$0(3);
        }
        return this.myChosenFiles;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/impl/NativeFileChooserDialogImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/impl/NativeFileChooserDialogImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "choose";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "choose";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

