/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorCompositePanel;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.tabs.TabInfo;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001e\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u0002\u001a \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0016\u001a\u00020\u0017*\u00020\u00188@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "shouldReservePreview", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "options", "Lcom/intellij/openapi/fileEditor/impl/FileEditorOpenOptions;", "project", "Lcom/intellij/openapi/project/Project;", "hasClientPropertyInHierarchy", "owner", "Ljava/awt/Component;", "propertyKey", "Lcom/intellij/openapi/util/Key;", "swapComponents", "", "parent", "Ljavax/swing/JPanel;", "toAdd", "Ljavax/swing/JComponent;", "toRemove", "composite", "Lcom/intellij/openapi/fileEditor/impl/EditorComposite;", "Lcom/intellij/ui/tabs/TabInfo;", "getComposite", "(Lcom/intellij/ui/tabs/TabInfo;)Lcom/intellij/openapi/fileEditor/impl/EditorComposite;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nEditorWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorWindow.kt\ncom/intellij/openapi/fileEditor/impl/EditorWindowKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1306:1\n13#2:1307\n*S KotlinDebug\n*F\n+ 1 EditorWindow.kt\ncom/intellij/openapi/fileEditor/impl/EditorWindowKt\n*L\n67#1:1307\n*E\n"})
public final class EditorWindowKt {
    @NotNull
    private static final Logger LOG;

    private static final boolean shouldReservePreview(VirtualFile file2, FileEditorOpenOptions options2, Project project2) {
        boolean bl;
        if (!UISettings.Companion.getInstance().getOpenInPreviewTabIfPossible()) {
            bl = false;
        } else if (((Boolean)FileEditorManagerImpl.FORBID_PREVIEW_TAB.get((UserDataHolder)file2, (Object)false)).booleanValue()) {
            bl = false;
        } else if (options2.usePreviewTab) {
            bl = true;
        } else if (!options2.selectAsCurrent || options2.requestFocus) {
            bl = false;
        } else {
            Component component2 = IdeFocusManager.getInstance((Project)project2).getFocusOwner();
            if (component2 == null) {
                return false;
            }
            Component focusOwner = component2;
            bl = EditorWindowKt.hasClientPropertyInHierarchy(focusOwner, FileEditorManagerImpl.OPEN_IN_PREVIEW_TAB);
        }
        return bl;
    }

    private static final boolean hasClientPropertyInHierarchy(Component owner, Key<Boolean> propertyKey) {
        Component component2 = owner;
        while (true) {
            if (component2 instanceof JComponent && Intrinsics.areEqual((Object)((JComponent)component2).getClientProperty(propertyKey), (Object)true)) {
                return true;
            }
            Container container = component2.getParent();
            if (container == null) {
                break;
            }
            component2 = container;
        }
        return false;
    }

    private static final void swapComponents(JPanel parent, JComponent toAdd, JComponent toRemove) {
        if (parent instanceof Splitter) {
            if (((Splitter)parent).getFirstComponent() == toRemove) {
                ((Splitter)parent).setFirstComponent(toAdd);
            } else {
                if (!(((Splitter)parent).getSecondComponent() == toRemove)) {
                    throw new IllegalStateException("Check failed.");
                }
                ((Splitter)parent).setSecondComponent(toAdd);
            }
        } else {
            if (!(parent instanceof EditorsSplitters)) {
                throw new IllegalStateException("Check failed.");
            }
            parent.remove(toRemove);
            parent.add((Component)toAdd, "Center");
        }
    }

    @NotNull
    public static final EditorComposite getComposite(@NotNull TabInfo $this$composite) {
        Intrinsics.checkNotNullParameter((Object)$this$composite, (String)"<this>");
        JComponent jComponent = $this$composite.getComponent();
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.EditorCompositePanel");
        return ((EditorCompositePanel)jComponent).composite;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ boolean access$shouldReservePreview(VirtualFile file2, FileEditorOpenOptions options2, Project project2) {
        return EditorWindowKt.shouldReservePreview(file2, options2, project2);
    }

    public static final /* synthetic */ void access$swapComponents(JPanel parent, JComponent toAdd, JComponent toRemove) {
        EditorWindowKt.swapComponents(parent, toAdd, toRemove);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(EditorWindow.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }
}

