/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.fileTypes.impl.FileTypeDetectionService;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class DetectedByContentFileType
implements FileType {
    public static final DetectedByContentFileType INSTANCE = new DetectedByContentFileType();

    private DetectedByContentFileType() {
    }

    @NonNls
    @NotNull
    public String getName() {
        return "AUTO_DETECTED";
    }

    @NlsContexts.Label
    @NotNull
    public String getDescription() {
        String string = FileTypesBundle.message("filetype.autodetected.description", new Object[0]);
        if (string == null) {
            DetectedByContentFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = FileTypesBundle.message("filetype.autodetected.display.name", new Object[0]);
        if (string == null) {
            DetectedByContentFileType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String getDefaultExtension() {
        return "";
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Text;
    }

    public boolean isBinary() {
        return false;
    }

    static boolean isMyFileType(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DetectedByContentFileType.$$$reportNull$$$0(2);
        }
        return !(file2 instanceof StubVirtualFile) && FileTypeDetectionService.isDetectable(file2) && file2.getLength() == 0L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/DetectedByContentFileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/DetectedByContentFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isMyFileType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

