/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/fileTypes/impl/HashBangFileTypeDetector;", "Lcom/intellij/openapi/fileTypes/FileTypeRegistry$FileTypeDetector;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "marker", "", "<init>", "(Lcom/intellij/openapi/fileTypes/FileType;Ljava/lang/String;)V", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "getMarker", "()Ljava/lang/String;", "detect", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "firstBytes", "Lcom/intellij/openapi/util/io/ByteSequence;", "firstCharsIfText", "", "getDesiredContentPrefixLength", "", "intellij.platform.ide.impl"})
public class HashBangFileTypeDetector
implements FileTypeRegistry.FileTypeDetector {
    @NotNull
    private final FileType fileType;
    @NotNull
    private final String marker;

    public HashBangFileTypeDetector(@NotNull FileType fileType2, @NotNull String marker) {
        Intrinsics.checkNotNullParameter((Object)fileType2, (String)"fileType");
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        this.fileType = fileType2;
        this.marker = marker;
    }

    @NotNull
    public final FileType getFileType() {
        return this.fileType;
    }

    @NotNull
    public final String getMarker() {
        return this.marker;
    }

    @Nullable
    public FileType detect(@NotNull VirtualFile file2, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)firstBytes, (String)"firstBytes");
        return FileUtil.isHashBangLine((CharSequence)firstCharsIfText, (String)this.marker) ? this.fileType : null;
    }

    public int getDesiredContentPrefixLength() {
        return 256;
    }
}

