/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.keymap.impl.ui.ShortcutPanel;
import com.intellij.openapi.keymap.impl.ui.ShortcutTextField;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.KeyStroke;

final class KeyboardShortcutPanel
extends ShortcutPanel<KeyboardShortcut> {
    final ShortcutTextField myFirstStroke;
    final ShortcutTextField mySecondStroke;
    final JCheckBox mySecondStrokeEnable = new JCheckBox();
    private final ItemListener myItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent event) {
            boolean enabled2 = KeyboardShortcutPanel.this.mySecondStrokeEnable.isSelected();
            KeyboardShortcutPanel.this.mySecondStroke.setEnabled(enabled2);
            ShortcutTextField component2 = !enabled2 || null == KeyboardShortcutPanel.this.myFirstStroke.getKeyStroke() ? KeyboardShortcutPanel.this.myFirstStroke : KeyboardShortcutPanel.this.mySecondStroke;
            KeyboardShortcutPanel.this.setShortcut(KeyboardShortcutPanel.this.newShortcut());
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)component2), true));
        }
    };
    private final PropertyChangeListener myPropertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (KeyboardShortcutPanel.this != event.getSource()) {
                KeyboardShortcutPanel.this.setShortcut(KeyboardShortcutPanel.this.newShortcut());
                if (null == KeyboardShortcutPanel.this.myFirstStroke.getKeyStroke()) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)KeyboardShortcutPanel.this.myFirstStroke), true));
                } else if (null == KeyboardShortcutPanel.this.mySecondStroke.getKeyStroke() && KeyboardShortcutPanel.this.mySecondStrokeEnable.isSelected()) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)KeyboardShortcutPanel.this.mySecondStroke), true));
                }
            } else {
                Object object = event.getNewValue();
                if (object instanceof KeyboardShortcut) {
                    KeyboardShortcut shortcut = (KeyboardShortcut)object;
                    KeyboardShortcutPanel.this.myFirstStroke.setKeyStroke(shortcut.getFirstKeyStroke());
                    KeyboardShortcutPanel.this.mySecondStroke.setKeyStroke(shortcut.getSecondKeyStroke());
                } else {
                    KeyboardShortcutPanel.this.myFirstStroke.setKeyStroke(null);
                    KeyboardShortcutPanel.this.mySecondStroke.setKeyStroke(null);
                }
            }
        }
    };

    KeyboardShortcutPanel(boolean isFocusTraversalKeysEnabled, LayoutManager layout2) {
        super(layout2);
        this.myFirstStroke = new ShortcutTextField(isFocusTraversalKeysEnabled);
        this.mySecondStroke = new ShortcutTextField(isFocusTraversalKeysEnabled);
        this.addPropertyChangeListener("shortcut", this.myPropertyListener);
        this.myFirstStroke.addPropertyChangeListener("keyStroke", this.myPropertyListener);
        this.mySecondStroke.addPropertyChangeListener("keyStroke", this.myPropertyListener);
        this.mySecondStroke.setEnabled(false);
        this.mySecondStrokeEnable.addItemListener(this.myItemListener);
    }

    private KeyboardShortcut newShortcut() {
        KeyStroke key = this.myFirstStroke.getKeyStroke();
        return key == null ? null : new KeyboardShortcut(key, !this.mySecondStrokeEnable.isSelected() ? null : this.mySecondStroke.getKeyStroke());
    }
}

