/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor.settings;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.tabActions.CloseTab;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.options.newEditor.SettingsEditor;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.options.newEditor.settings.SettingsFileEditor;
import com.intellij.openapi.options.newEditor.settings.SettingsVirtualFileHolder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.UIBundle;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 #2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002#$B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\fH\u0016J\u001f\u0010\u001f\u001a\t\u0018\u00010\u0016\u00a2\u0006\u0002\b 2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\fH\u0016J\u001f\u0010!\u001a\t\u0018\u00010\u0016\u00a2\u0006\u0002\b\"2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\fH\u0016\u00a8\u0006%"}, d2={"Lcom/intellij/openapi/options/newEditor/settings/SettingsFileEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/vcs/impl/FileStatusProvider;", "Lcom/intellij/openapi/fileEditor/impl/EditorTabTitleProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "installCloseGotItHookIfNecessary", "", "settingsFile", "Lcom/intellij/openapi/options/newEditor/settings/SettingsVirtualFileHolder$SettingsVirtualFile;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "isDumbAware", "disposeEditor", "editor", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "virtualFile", "getEditorTabTooltipText", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "getEditorTabTitle", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "Companion", "GotItAwareCloseTab", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSettingsFileEditorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsFileEditorProvider.kt\ncom/intellij/openapi/options/newEditor/settings/SettingsFileEditorProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,143:1\n11705#2:144\n12052#2,3:145\n*S KotlinDebug\n*F\n+ 1 SettingsFileEditorProvider.kt\ncom/intellij/openapi/options/newEditor/settings/SettingsFileEditorProvider\n*L\n57#1:144\n57#1:145,3\n*E\n"})
public final class SettingsFileEditorProvider
implements FileEditorProvider,
FileStatusProvider,
EditorTabTitleProvider,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "SettingsFileEditor";

    public boolean accept(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return file2 instanceof SettingsVirtualFileHolder.SettingsVirtualFile;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        SettingsVirtualFileHolder.SettingsVirtualFile settingsFile = (SettingsVirtualFileHolder.SettingsVirtualFile)file2;
        SettingsDialog dialog2 = settingsFile.getOrCreateDialog();
        AbstractEditor abstractEditor = dialog2.getEditor();
        JComponent jComponent = abstractEditor instanceof SettingsEditor ? (SettingsEditor)abstractEditor : null;
        SimpleTree tree2 = jComponent != null && (jComponent = ((SettingsEditor)jComponent).getTreeView()) != null ? ((SettingsTreeView)jComponent).getTree() : null;
        Disposable disposable = dialog2.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        this.installCloseGotItHookIfNecessary(project2, settingsFile, disposable);
        JRootPane jRootPane = dialog2.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
        JComponent jComponent2 = jRootPane;
        JComponent jComponent3 = (JComponent)tree2;
        Disposable disposable2 = dialog2.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"getDisposable(...)");
        return new SettingsFileEditor(settingsFile, jComponent2, jComponent3, disposable2);
    }

    /*
     * WARNING - void declaration
     */
    private final void installCloseGotItHookIfNecessary(Project project2, SettingsVirtualFileHolder.SettingsVirtualFile settingsFile, Disposable parentDisposable) {
        Collection destination$iv$iv;
        String string = UIBundle.message((String)"settings.tab.close.gotit.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        GotItTooltip gotItTooltip = GotItTooltip.withTimeout$default(new GotItTooltip("close.non.modal.settings", string, parentDisposable), 0, 1, null);
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
        Intrinsics.checkNotNull((Object)fileEditorManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.ex.FileEditorManagerEx");
        FileEditorManagerEx fileEditorManager2 = (FileEditorManagerEx)fileEditorManager;
        EditorWindow editorWindow = fileEditorManager2.getCurrentWindow();
        if (editorWindow == null) {
            return;
        }
        EditorWindow curWin = editorWindow;
        TabLabel tabLabel = curWin.getTabbedPane().editorTabs.getSelectedLabel();
        if (tabLabel == null) {
            return;
        }
        TabLabel currentTabLabelComponent = tabLabel;
        TabInfo info = currentTabLabelComponent.getInfo();
        ActionGroup actionGroup = info.getTabLabelActions();
        AnAction[] anActionArray = actionGroup instanceof DefaultActionGroup ? (AnAction[])actionGroup : null;
        if (anActionArray != null && (anActionArray = anActionArray.getChildActionsOrStubs()) != null) {
            void $this$mapTo$iv$iv;
            AnAction[] $this$map$iv = anActionArray;
            boolean $i$f$map = false;
            AnAction[] anActionArray2 = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void action2;
                void item$iv$iv;
                void var20_18 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(!(action2 instanceof CloseTab) ? action2 : (AnAction)new GotItAwareCloseTab((CloseTab)action2, currentTabLabelComponent, gotItTooltip, settingsFile));
            }
        } else {
            return;
        }
        List children2 = (List)destination$iv$iv;
        DefaultActionGroup updatedGroup = new DefaultActionGroup(children2);
        info.setTabLabelActions((ActionGroup)updatedGroup, "EditorTab");
    }

    @NotNull
    public String getEditorTypeId() {
        return ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_OTHER_EDITORS;
    }

    public boolean isDumbAware() {
        return true;
    }

    public void disposeEditor(@NotNull FileEditor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Disposer.dispose((Disposable)((Disposable)((SettingsFileEditor)editor2)));
    }

    @Override
    @Nullable
    public FileStatus getFileStatus(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        SettingsVirtualFileHolder.SettingsVirtualFile settingsVirtualFile = virtualFile2 instanceof SettingsVirtualFileHolder.SettingsVirtualFile ? (SettingsVirtualFileHolder.SettingsVirtualFile)virtualFile2 : null;
        if (settingsVirtualFile == null) {
            return null;
        }
        boolean isModified2 = settingsVirtualFile.isModified();
        return isModified2 ? FileStatus.MODIFIED : FileStatus.NOT_CHANGED;
    }

    @Nullable
    public String getEditorTabTooltipText(@NotNull Project project2, @NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        if (!(virtualFile2 instanceof SettingsVirtualFileHolder.SettingsVirtualFile)) {
            return super.getEditorTabTooltipText(project2, virtualFile2);
        }
        return CommonBundle.settingsTitle();
    }

    @Nullable
    public String getEditorTabTitle(@NotNull Project project2, @NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        if (!(virtualFile2 instanceof SettingsVirtualFileHolder.SettingsVirtualFile)) {
            return null;
        }
        return CommonBundle.settingsTitle();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/options/newEditor/settings/SettingsFileEditorProvider$Companion;", "", "<init>", "()V", "ID", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/options/newEditor/settings/SettingsFileEditorProvider$GotItAwareCloseTab;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "closeTabAction", "Lcom/intellij/openapi/fileEditor/impl/tabActions/CloseTab;", "currentTabLabelComponent", "Lcom/intellij/ui/tabs/impl/TabLabel;", "gotItTooltip", "Lcom/intellij/ui/GotItTooltip;", "settingsFile", "Lcom/intellij/openapi/options/newEditor/settings/SettingsVirtualFileHolder$SettingsVirtualFile;", "<init>", "(Lcom/intellij/openapi/fileEditor/impl/tabActions/CloseTab;Lcom/intellij/ui/tabs/impl/TabLabel;Lcom/intellij/ui/GotItTooltip;Lcom/intellij/openapi/options/newEditor/settings/SettingsVirtualFileHolder$SettingsVirtualFile;)V", "clicked", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.platform.ide.impl"})
    public static final class GotItAwareCloseTab
    extends AnAction
    implements DumbAware {
        @NotNull
        private final CloseTab closeTabAction;
        @NotNull
        private final TabLabel currentTabLabelComponent;
        @NotNull
        private final GotItTooltip gotItTooltip;
        @NotNull
        private final SettingsVirtualFileHolder.SettingsVirtualFile settingsFile;
        private boolean clicked;

        public GotItAwareCloseTab(@NotNull CloseTab closeTabAction, @NotNull TabLabel currentTabLabelComponent, @NotNull GotItTooltip gotItTooltip, @NotNull SettingsVirtualFileHolder.SettingsVirtualFile settingsFile) {
            Intrinsics.checkNotNullParameter((Object)((Object)closeTabAction), (String)"closeTabAction");
            Intrinsics.checkNotNullParameter((Object)currentTabLabelComponent, (String)"currentTabLabelComponent");
            Intrinsics.checkNotNullParameter((Object)gotItTooltip, (String)"gotItTooltip");
            Intrinsics.checkNotNullParameter((Object)settingsFile, (String)"settingsFile");
            this.closeTabAction = closeTabAction;
            this.currentTabLabelComponent = currentTabLabelComponent;
            this.gotItTooltip = gotItTooltip;
            this.settingsFile = settingsFile;
            this.copyFrom(this.closeTabAction);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return this.closeTabAction.getActionUpdateThread();
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.closeTabAction.update(e);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!this.gotItTooltip.canShow() || this.clicked || !this.settingsFile.isModified()) {
                if (this.clicked) {
                    this.gotItTooltip.gotIt();
                }
                this.closeTabAction.actionPerformed(e);
                return;
            }
            this.clicked = true;
            String string = UIBundle.message((String)"settings.tab.close.gotit.header", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.gotItTooltip.withHeader(string).withPosition(Balloon.Position.below).show((JComponent)this.currentTabLabelComponent, (Function2<? super Component, ? super Balloon, ? extends Point>)((Function2)GotItAwareCloseTab::actionPerformed$lambda$0));
        }

        private static final Point actionPerformed$lambda$0(Component component2, Balloon baloon) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Intrinsics.checkNotNullParameter((Object)baloon, (String)"baloon");
            Dimension dimension = component2.getSize();
            return new Point(dimension.width - 16, dimension.height - 12);
        }
    }
}

