/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\rH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/progress/util/ProgressBarUtil;", "", "<init>", "()V", "STATUS_KEY", "", "PASSED_VALUE", "WARNING_VALUE", "FAILED_VALUE", "PROGRESS_PAINT_KEY", "createMultiProgressPaint", "Ljava/awt/Paint;", "quantityAndColors", "", "Lkotlin/Pair;", "", "Ljava/awt/Color;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nProgressBarUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProgressBarUtil.kt\ncom/intellij/openapi/progress/util/ProgressBarUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,53:1\n1#2:54\n777#3:55\n873#3,2:56\n37#4,2:58\n*S KotlinDebug\n*F\n+ 1 ProgressBarUtil.kt\ncom/intellij/openapi/progress/util/ProgressBarUtil\n*L\n34#1:55\n34#1:56,2\n50#1:58,2\n*E\n"})
public final class ProgressBarUtil {
    @NotNull
    public static final ProgressBarUtil INSTANCE = new ProgressBarUtil();
    @NotNull
    public static final String STATUS_KEY = "ProgressBar.status";
    @NotNull
    public static final String PASSED_VALUE = "passed";
    @NotNull
    public static final String WARNING_VALUE = "warning";
    @NotNull
    public static final String FAILED_VALUE = "failed";
    @ApiStatus.Internal
    @NotNull
    public static final String PROGRESS_PAINT_KEY = "ProgressBar.progressPaint";

    private ProgressBarUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @Nullable
    public final Paint createMultiProgressPaint(@NotNull List<? extends Pair<Integer, ? extends Color>> quantityAndColors) {
        void $this$filterTo$iv$iv;
        Object object2;
        Intrinsics.checkNotNullParameter(quantityAndColors, (String)"quantityAndColors");
        float minimalStep = 1.0E-6f;
        Iterable iterable = quantityAndColors;
        int n = 0;
        for (Object object2 : iterable) {
            void it;
            Pair pair = (Pair)object2;
            int n2 = n;
            boolean bl = false;
            int n3 = ((Number)it.getFirst()).intValue();
            n = n2 + n3;
        }
        float fullWeight = n;
        Iterable $this$filter$iv = quantityAndColors;
        boolean $i$f$filter = false;
        object2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((Number)it.getFirst()).floatValue() / fullWeight > minimalStep)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filtered = (List)destination$iv$iv;
        if (filtered.isEmpty()) {
            return null;
        }
        List fractions = new ArrayList();
        List colors = new ArrayList();
        float colorPos = 0.0f;
        for (Pair $i$f$filterTo2 : filtered) {
            int quantity = ((Number)$i$f$filterTo2.component1()).intValue();
            Color color = (Color)$i$f$filterTo2.component2();
            float weight = (float)quantity / fullWeight;
            Collection collection = fractions;
            Object[] objectArray = new Float[]{Float.valueOf(colorPos), Float.valueOf(colorPos + weight - minimalStep)};
            CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
            collection = colors;
            objectArray = new Color[]{color, color};
            CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
            colorPos += weight;
        }
        Collection $this$toTypedArray$iv = colors;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new LinearGradientPaint(0.0f, 0.0f, 1.0f, 0.0f, CollectionsKt.toFloatArray((Collection)fractions), thisCollection$iv.toArray(new Color[0]), MultipleGradientPaint.CycleMethod.NO_CYCLE);
    }
}

