/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutineSupport;
import com.intellij.openapi.application.InstantShutdown;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalContextProjectLocator;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.application.impl.TestOnlyThreading;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.BlockingProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressDialog;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorWithDelayedPresentation;
import com.intellij.openapi.progress.util.TitledIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.EdtScheduler;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import kotlin.Unit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressWindow
extends ProgressIndicatorBase
implements BlockingProgressIndicator,
TitledIndicator,
ProgressIndicatorWithDelayedPresentation,
Disposable,
ModalContextProjectLocator {
    private static final Logger LOG = Logger.getInstance(ProgressWindow.class);
    private Runnable myDialogInitialization;
    private ProgressDialog myDialog;
    @Nullable
    protected final Project myProject;
    final boolean myShouldShowCancel;
    @Nls
    private String myTitle;
    private boolean myStoppedAlready;
    protected boolean myBackgrounded;
    int delayInMillis = 300;
    private boolean myModalityEntered;
    @Topic.AppLevel
    public static final Topic<Listener> TOPIC = new Topic(Listener.class, Topic.BroadcastDirection.NONE, true);

    @ApiStatus.Obsolete
    public ProgressWindow(boolean shouldShowCancel, @Nullable Project project2) {
        this(shouldShowCancel, false, project2);
    }

    @ApiStatus.Obsolete
    public ProgressWindow(boolean shouldShowCancel, boolean shouldShowBackground, @Nullable Project project2) {
        this(shouldShowCancel, shouldShowBackground, project2, null);
    }

    @ApiStatus.Obsolete
    public ProgressWindow(boolean shouldShowCancel, boolean shouldShowBackground, @Nullable Project project2, @NlsContexts.Button @Nullable String cancelText) {
        this(shouldShowCancel, shouldShowBackground, project2, null, cancelText);
    }

    @ApiStatus.Obsolete
    public ProgressWindow(boolean shouldShowCancel, boolean shouldShowBackground, @Nullable Project project2, @Nullable JComponent parentComponent, @NlsContexts.Button @Nullable String cancelText) {
        this.myProject = project2;
        this.myShouldShowCancel = shouldShowCancel;
        if (project2 != null) {
            Disposer.register((Disposable)project2, (Disposable)this);
        }
        this.myDialogInitialization = () -> {
            ThreadingAssertions.assertEventDispatchThread();
            Window parentWindow = ProgressWindow.calcParentWindow(parentComponent, this.myProject);
            this.myDialog = new ProgressDialog(this, shouldShowBackground, cancelText, parentWindow);
            Disposer.register((Disposable)this, (Disposable)this.myDialog);
        };
        UIUtil.invokeLaterIfNeeded(this::initializeDialog);
        this.setModalityProgress((ProgressIndicator)(shouldShowBackground ? null : this));
        this.addStateDelegate(new MyDelegate());
        ((Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).progressWindowCreated(this);
    }

    protected void initializeOnEdtIfNeeded() {
        ThreadingAssertions.assertEventDispatchThread();
        this.initializeDialog();
    }

    private void initializeDialog() {
        ThreadingAssertions.assertEventDispatchThread();
        Runnable initialization = this.myDialogInitialization;
        if (initialization == null) {
            return;
        }
        this.myDialogInitialization = null;
        initialization.run();
    }

    @ApiStatus.Internal
    @Nullable
    public static Window calcParentWindow(@Nullable Component parent, @Nullable Project project2) {
        if (parent == null && project2 == null && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            parent = JOptionPane.getRootFrame();
        }
        if (parent != null) {
            return ComponentUtil.getWindow((Component)parent);
        }
        Window parentWindow = WindowManager.getInstance().suggestParentWindow(project2);
        return parentWindow != null ? parentWindow : WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.getLock();
        synchronized (object) {
            LOG.assertTrue(!this.isRunning());
            LOG.assertTrue(!this.myStoppedAlready);
            super.start();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                this.prepareShowDialog();
            }
        }
    }

    public void setDelayInMillis(int delayInMillis) {
        this.delayInMillis = delayInMillis;
    }

    protected void prepareShowDialog() {
        EdtScheduler.getInstance().schedule(this.delayInMillis, this.getModalityState(), CoroutineSupport.UiDispatcherKind.RELAX, () -> {
            if (this.isRunning()) {
                this.showDialog();
            } else if (this.isPopupWasShown()) {
                Disposer.dispose((Disposable)this);
            }
        });
    }

    final void executeInModalContext(@NotNull Runnable modalAction) {
        if (modalAction == null) {
            ProgressWindow.$$$reportNull$$$0(0);
        }
        if (!this.isModalEntity()) {
            modalAction.run();
            return;
        }
        if (this.myModalityEntered) {
            throw new IllegalStateException("Modality already entered: " + String.valueOf(this.getModalityState()));
        }
        LaterInvocator.enterModal((Object)((Object)this), (ModalityStateEx)((ModalityStateEx)this.getModalityState()));
        this.myModalityEntered = true;
        try {
            modalAction.run();
        }
        finally {
            LaterInvocator.leaveModal((Object)((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBlocking(@NotNull Runnable init2, boolean isSynchronousHeadlessExecution, @NotNull CompletableFuture<?> stopCondition) {
        if (init2 == null) {
            ProgressWindow.$$$reportNull$$$0(1);
        }
        if (stopCondition == null) {
            ProgressWindow.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Object object = this.getLock();
        synchronized (object) {
            LOG.assertTrue(!this.isRunning());
            LOG.assertTrue(!this.myStoppedAlready);
        }
        try {
            this.executeInModalContext(() -> {
                init2.run();
                Runnable r = () -> {
                    this.initializeOnEdtIfNeeded();
                    stopCondition.thenRun(() -> SwingUtilities.invokeLater(EmptyRunnable.INSTANCE));
                    IdeEventQueue.getInstance().pumpEventsForHierarchy(this.myDialog.getPanel(), stopCondition, event -> {
                        if (this.isCancellationEvent((AWTEvent)event)) {
                            this.cancel();
                        }
                    });
                };
                if (isSynchronousHeadlessExecution) {
                    TestOnlyThreading.releaseTheAcquiredWriteIntentLockThenExecuteActionAndTakeWriteIntentLockBack(() -> {
                        r.run();
                        return Unit.INSTANCE;
                    });
                } else {
                    r.run();
                }
            });
        }
        finally {
            this.myDialog.hideImmediately();
        }
    }

    final boolean isCancellationEvent(@NotNull AWTEvent event) {
        if (event == null) {
            ProgressWindow.$$$reportNull$$$0(3);
        }
        return this.myShouldShowCancel && event instanceof KeyEvent && event.getID() == 401 && ((KeyEvent)event).getKeyCode() == 27 && ((KeyEvent)event).getModifiers() == 0;
    }

    protected void showDialog() {
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.isRunning() || this.isCanceled()) {
            return;
        }
        if (app.isExitInProgress() && InstantShutdown.isAllowed()) {
            return;
        }
        this.initializeOnEdtIfNeeded();
        this.myDialog.show();
        if (this.myDialog != null) {
            this.myDialog.getRepaintRunnable().run();
        }
    }

    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.getLock();
        synchronized (object) {
            LOG.assertTrue(!this.myStoppedAlready);
            super.stop();
            UIUtil.invokeLaterIfNeeded(() -> {
                if (this.myDialog != null) {
                    this.myDialog.hide();
                }
                Object object = this.getLock();
                synchronized (object) {
                    this.myStoppedAlready = true;
                }
                Disposer.dispose((Disposable)this);
            });
            SwingUtilities.invokeLater(EmptyRunnable.INSTANCE);
        }
    }

    @ApiStatus.Internal
    @Nullable
    public ProgressDialog getDialog() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.myDialog;
    }

    public void background() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myDialog != null) {
            this.myBackgrounded = true;
            this.myDialog.background();
            this.myDialog = null;
        }
    }

    protected boolean isBackgrounded() {
        return this.myBackgrounded;
    }

    public void setText(@NlsContexts.ProgressText String text2) {
        if (!Objects.equals(text2, this.getText())) {
            super.setText(text2);
            this.update();
        }
    }

    public void setFraction(double fraction) {
        if (fraction != this.getFraction()) {
            super.setFraction(fraction);
            this.update();
        }
    }

    public void setText2(@NlsContexts.ProgressDetails String text2) {
        if (!Objects.equals(text2, this.getText2())) {
            super.setText2(text2);
            this.update();
        }
    }

    private void update() {
        ProgressDialog dialog2 = this.myDialog;
        if (dialog2 != null) {
            dialog2.scheduleUpdate();
        }
    }

    public void setTitle(@NotNull @Nls String title2) {
        if (title2 == null) {
            ProgressWindow.$$$reportNull$$$0(4);
        }
        if (!title2.equals(this.myTitle)) {
            this.myTitle = title2;
            this.delegateProgressChange(each -> {
                if (each instanceof TitledIndicator) {
                    ((TitledIndicator)each).setTitle(title2);
                }
            });
            this.update();
        }
    }

    @NlsContexts.ProgressTitle
    public String getTitle() {
        return this.myTitle;
    }

    public void dispose() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myDialogInitialization = null;
        this.stopSystemActivity();
        if (this.isRunning()) {
            this.cancel();
        }
    }

    public boolean isPopupWasShown() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.myDialog != null && this.myDialog.getPopup() != null && this.myDialog.getPopup().isShowing();
    }

    private void enableCancelButton(boolean enable2) {
        ProgressDialog dialog2 = this.myDialog;
        if (dialog2 != null) {
            dialog2.enableCancelButtonIfNeeded(enable2);
        }
    }

    public boolean isPartOf(@NotNull JFrame frame, @Nullable Project project2) {
        DialogWrapper popup2;
        if (frame == null) {
            ProgressWindow.$$$reportNull$$$0(5);
        }
        if (project2 != null && this.myProject != null) {
            return project2 == this.myProject;
        }
        if (this.myDialog != null && (popup2 = this.myDialog.getPopup()) != null) {
            return UIUtil.isAncestor((Component)frame, (Component)popup2.getOwner());
        }
        return false;
    }

    public String toString() {
        return this.getTitle() + " " + System.identityHashCode((Object)this) + ": running=" + this.isRunning() + "; canceled=" + this.isCanceled();
    }

    @ApiStatus.Internal
    @NotNull
    protected AbstractProgressIndicatorBase.State getState() {
        return new WindowState(this.myTitle, super.getState());
    }

    @ApiStatus.Internal
    protected void restoreFrom(@NotNull AbstractProgressIndicatorBase.State state2) {
        if (state2 == null) {
            ProgressWindow.$$$reportNull$$$0(6);
        }
        super.restoreFrom(state2);
        if (state2 instanceof WindowState) {
            WindowState w = (WindowState)state2;
            if (w.myTitle != null) {
                this.setTitle(w.myTitle);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "init";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopCondition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/progress/util/ProgressWindow";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeInModalContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "startBlocking";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCancellationEvent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setTitle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isPartOf";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreFrom";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyDelegate
    extends AbstractProgressIndicatorBase
    implements ProgressIndicatorEx {
        private long myLastUpdatedButtonTimestamp;

        private MyDelegate() {
        }

        public void cancel() {
            super.cancel();
            ProgressDialog dialog2 = ProgressWindow.this.myDialog;
            if (dialog2 != null) {
                dialog2.cancel();
            }
        }

        public void checkCanceled() {
            super.checkCanceled();
            long now = System.currentTimeMillis();
            if (now - this.myLastUpdatedButtonTimestamp > 10L) {
                ProgressWindow.this.enableCancelButton(!ProgressManager.getInstance().isInNonCancelableSection());
                this.myLastUpdatedButtonTimestamp = now;
            }
        }

        public void addStateDelegate(@NotNull ProgressIndicatorEx delegate) {
            if (delegate == null) {
                MyDelegate.$$$reportNull$$$0(0);
            }
            throw new IncorrectOperationException();
        }

        public void finish(@NotNull TaskInfo task) {
            if (task == null) {
                MyDelegate.$$$reportNull$$$0(1);
            }
        }

        public boolean isFinished(@NotNull TaskInfo task) {
            if (task == null) {
                MyDelegate.$$$reportNull$$$0(2);
            }
            return true;
        }

        public boolean wasStarted() {
            return false;
        }

        public void processFinish() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/progress/util/ProgressWindow$MyDelegate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addStateDelegate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "finish";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @FunctionalInterface
    public static interface Listener {
        public void progressWindowCreated(@NotNull ProgressWindow var1);
    }

    private static class WindowState
    extends AbstractProgressIndicatorBase.State {
        private final String myTitle;

        WindowState(String title2, @NotNull AbstractProgressIndicatorBase.State delegate) {
            if (delegate == null) {
                WindowState.$$$reportNull$$$0(0);
            }
            super(delegate);
            this.myTitle = title2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/progress/util/ProgressWindow$WindowState", "<init>"));
        }
    }
}

