/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.impl;

import com.intellij.concurrency.ThreadContext;
import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.ui.MaximizeDialogKt;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.impl.AbstractDialog;
import com.intellij.openapi.ui.impl.HeadlessDialog;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomFrameDialogContent;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomHeader;
import com.intellij.platform.ide.bootstrap.SplashManagerKt;
import com.intellij.platform.locking.impl.IntelliJLockingUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.AppUIUtilKt;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DisposableWindow;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.ToolbarService;
import com.intellij.ui.WindowDeactivationManager;
import com.intellij.ui.WindowRoundedCornersManager;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.ui.mac.touchbar.TouchbarSupport;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.OwnerOptional;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlinx.coroutines.EventLoop;
import kotlinx.coroutines.ThreadLocalEventLoop;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DialogWrapperPeerImpl
extends DialogWrapperPeer {
    private static final Logger LOG = Logger.getInstance(DialogWrapper.class);
    private final DialogWrapper myWrapper;
    private final AbstractDialog myDialog;
    private final boolean myCanBeParent;
    private final List<Runnable> myDisposeActions;
    private Project myProject;
    private static final Function0<Unit> emptyFunction = () -> Unit.INSTANCE;

    public static boolean isHeadlessEnv() {
        Application app = ApplicationManager.getApplication();
        return app == null ? GraphicsEnvironment.isHeadless() : app.isUnitTestMode() || app.isHeadlessEnvironment();
    }

    protected DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper2, @Nullable Project project2, boolean canBeParent, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        WindowManagerEx windowManager;
        if (wrapper2 == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(0);
        }
        if (ideModalityType == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(1);
        }
        this.myDisposeActions = new ArrayList<Runnable>();
        boolean headless = DialogWrapperPeerImpl.isHeadlessEnv();
        this.myWrapper = wrapper2;
        Window window = null;
        if (LoadingState.COMPONENTS_LOADED.isOccurred() && (windowManager = DialogWrapperPeerImpl.getWindowManager()) != null) {
            Window curWindow = (Window)ObjectUtils.chooseNotNull((Object)windowManager.getMostRecentFocusedWindow(), (Object)KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow());
            if (project2 == null && curWindow != null) {
                project2 = ProjectUtil.getProjectForWindow(curWindow);
            }
            this.myProject = project2;
            window = windowManager.suggestParentWindow(project2);
            if (window == null && curWindow instanceof IdeFrameImpl) {
                window = curWindow;
            }
            if (window == null) {
                for (ProjectFrameHelper frameHelper : windowManager.getProjectFrameHelpers()) {
                    IdeFrameImpl frame = frameHelper.getFrame();
                    if (!frame.isActive()) continue;
                    window = frameHelper.getFrame();
                    break;
                }
            }
        }
        Window owner = window != null ? window : (!headless ? JOptionPane.getRootFrame() : null);
        this.myDialog = DialogWrapperPeerImpl.createDialog(headless, owner, wrapper2, this.myProject, ideModalityType);
        this.myCanBeParent = headless || canBeParent;
    }

    protected DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper2, @Nullable Project project2, boolean canBeParent) {
        if (wrapper2 == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(2);
        }
        this(wrapper2, project2, canBeParent, DialogWrapper.IdeModalityType.IDE);
    }

    protected DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper2, boolean canBeParent) {
        if (wrapper2 == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(3);
        }
        this(wrapper2, (Project)null, canBeParent);
    }

    protected DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper2, @NotNull Component parent, boolean canBeParent) {
        if (wrapper2 == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(5);
        }
        this.myDisposeActions = new ArrayList<Runnable>();
        boolean headless = DialogWrapperPeerImpl.isHeadlessEnv();
        this.myWrapper = wrapper2;
        this.myDialog = DialogWrapperPeerImpl.createDialog(headless, OwnerOptional.findOwner(parent), wrapper2, null, DialogWrapper.IdeModalityType.IDE);
        this.myCanBeParent = headless || canBeParent;
    }

    protected DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper2, Window owner, boolean canBeParent, DialogWrapper.IdeModalityType ideModalityType) {
        if (wrapper2 == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(6);
        }
        this.myDisposeActions = new ArrayList<Runnable>();
        boolean headless = DialogWrapperPeerImpl.isHeadlessEnv();
        this.myWrapper = wrapper2;
        this.myDialog = DialogWrapperPeerImpl.createDialog(headless, owner, wrapper2, null, DialogWrapper.IdeModalityType.IDE);
        boolean bl = this.myCanBeParent = headless || canBeParent;
        if (!headless) {
            Dialog.ModalityType modalityType = DialogWrapper.IdeModalityType.IDE.toAwtModality();
            this.myDialog.setModalityType(modalityType);
        }
    }

    private static WindowManagerEx getWindowManager() {
        Application app = LoadingState.COMPONENTS_LOADED.isOccurred() ? ApplicationManager.getApplication() : null;
        return app == null ? null : WindowManagerEx.getInstanceEx();
    }

    private static AbstractDialog createDialog(boolean headless, Window owner, DialogWrapper wrapper2, Project project2, DialogWrapper.IdeModalityType ideModalityType) {
        if (headless) {
            return new HeadlessDialog(wrapper2);
        }
        MyDialog dialog2 = new MyDialog(OwnerOptional.findOwner(owner), wrapper2, project2);
        dialog2.setModalityType(ideModalityType.toAwtModality());
        return dialog2;
    }

    public boolean isHeadless() {
        return this.myDialog instanceof HeadlessDialog;
    }

    public void setOnDeactivationAction(@NotNull Disposable disposable, @NotNull Runnable onDialogDeactivated) {
        if (disposable == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(7);
        }
        if (onDialogDeactivated == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(8);
        }
        WindowDeactivationManager.getInstance().addWindowDeactivationListener(this.getWindow(), this.myProject, disposable, onDialogDeactivated);
    }

    public Object[] getCurrentModalEntities() {
        return LaterInvocator.getCurrentModalEntities();
    }

    public void setUndecorated(boolean undecorated) {
        this.myDialog.setUndecorated(undecorated);
    }

    public void addMouseListener(MouseListener listener2) {
        this.myDialog.addMouseListener(listener2);
    }

    public void addMouseListener(MouseMotionListener listener2) {
        this.myDialog.addMouseMotionListener(listener2);
    }

    public void addKeyListener(KeyListener listener2) {
        this.myDialog.addKeyListener(listener2);
    }

    public void toFront() {
        this.myDialog.toFront();
    }

    public void toBack() {
        this.myDialog.toBack();
    }

    protected void dispose() {
        LOG.assertTrue(EventQueue.isDispatchThread(), (Object)"Access is allowed from event dispatch thread only");
        for (Runnable runnable2 : this.myDisposeActions) {
            runnable2.run();
        }
        this.myDisposeActions.clear();
        Runnable disposer = () -> {
            Disposer.dispose((Disposable)this.myDialog);
            this.myProject = null;
            SwingUtilities.invokeLater(() -> {
                if (this.myDialog.getRootPane() != null) {
                    this.myDialog.remove(this.myDialog.getRootPane());
                }
            });
        };
        EdtInvocationManager.invokeLaterIfNeeded((Runnable)disposer);
    }

    private boolean isProgressDialog() {
        return this.myWrapper.isModalProgress();
    }

    @Nullable
    public Container getContentPane() {
        return this.getRootPane() != null ? this.myDialog.getContentPane() : null;
    }

    public void validate() {
        this.myDialog.validate();
    }

    public void repaint() {
        this.myDialog.repaint();
    }

    public Window getOwner() {
        return this.myDialog.getOwner();
    }

    public Window getWindow() {
        return this.myDialog.getWindow();
    }

    public JRootPane getRootPane() {
        return this.myDialog.getRootPane();
    }

    public Dimension getSize() {
        return this.myDialog.getSize();
    }

    public String getTitle() {
        return this.myDialog.getTitle();
    }

    public void pack() {
        this.myDialog.pack();
    }

    public void setAppIcons() {
        AppUIUtilKt.updateAppWindowIcon(this.getWindow());
    }

    public Dimension getPreferredSize() {
        return this.myDialog.getPreferredSize();
    }

    public void setModal(boolean modal) {
        this.myDialog.setModal(modal);
    }

    public boolean isModal() {
        return this.myDialog.isModal();
    }

    public boolean isVisible() {
        return this.myDialog.isVisible();
    }

    public boolean isShowing() {
        return this.myDialog.isShowing();
    }

    public void setSize(int width, int height) {
        this.myDialog.setSize(width, height);
    }

    public void setTitle(String title2) {
        this.myDialog.setTitle(title2);
    }

    public boolean isResizable() {
        return this.myDialog.isResizable();
    }

    public void setResizable(boolean resizable) {
        this.myDialog.setResizable(resizable);
    }

    public boolean isMaximizable() {
        AbstractDialog abstractDialog = this.myDialog;
        if (!(abstractDialog instanceof JDialog)) {
            return false;
        }
        JDialog jDialog = (JDialog)((Object)abstractDialog);
        return MaximizeDialogKt.isMaximizable(jDialog);
    }

    public void setMaximizable(boolean maximizable) {
        AbstractDialog abstractDialog = this.myDialog;
        if (!(abstractDialog instanceof JDialog)) {
            return;
        }
        JDialog jDialog = (JDialog)((Object)abstractDialog);
        MaximizeDialogKt.setMaximizable(jDialog, maximizable);
    }

    @NotNull
    public Point getLocation() {
        Point point = this.myDialog.getLocation();
        if (point == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(9);
        }
        return point;
    }

    public void setLocation(@NotNull Point p) {
        if (p == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(10);
        }
        this.myDialog.setLocation(p);
    }

    public void setLocation(int x, int y) {
        this.myDialog.setLocation(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<?> show() {
        Disposable tb;
        Container pane2;
        Function0 lockCleanup;
        Consumer<Runnable> lockContextWrapper;
        WindowManagerEx windowManager;
        Application app;
        Container contentPane;
        LOG.assertTrue(EventQueue.isDispatchThread(), (Object)"Access is allowed from event dispatch thread only");
        AnCancelAction anCancelAction = new AnCancelAction();
        JRootPane rootPane = this.getRootPane();
        ComponentUtil.decorateWindowHeader((JRootPane)rootPane);
        Window window = this.getWindow();
        if (window instanceof JDialog && !((JDialog)window).isUndecorated() && rootPane != null && LoadingState.COMPONENTS_LOADED.isOccurred()) {
            ToolbarService.Companion.getInstance().setTransparentTitleBar(window, rootPane, runnable2 -> {
                Disposer.register((Disposable)this.myWrapper.getDisposable(), () -> runnable2.run());
                return Unit.INSTANCE;
            });
        }
        if ((contentPane = this.getContentPane()) instanceof CustomFrameDialogContent) {
            ((CustomFrameDialogContent)contentPane).updateLayout();
        }
        Object object = app = LoadingState.COMPONENTS_LOADED.isOccurred() ? ApplicationManager.getApplication() : null;
        if (app != null && app.getServiceIfCreated(ActionManager.class) != null) {
            anCancelAction.registerCustomShortcutSet(ActionUtil.getShortcutSet((String)"EditorEscape"), rootPane);
        } else {
            anCancelAction.registerCustomShortcutSet(CommonShortcuts.ESCAPE, rootPane);
        }
        if (rootPane != null) {
            this.myDisposeActions.add(() -> anCancelAction.unregisterCustomShortcutSet(rootPane));
        }
        if (app != null && !this.myCanBeParent && (windowManager = DialogWrapperPeerImpl.getWindowManager()) != null) {
            windowManager.doNotSuggestAsParent(this.myDialog.getWindow());
        }
        CommandProcessorEx commandProcessor = app == null ? null : (CommandProcessorEx)CommandProcessor.getInstance();
        boolean appStarted2 = commandProcessor != null;
        boolean changeModalityState = appStarted2 && this.myDialog.isModal() && !this.isProgressDialog();
        Project project2 = this.myProject;
        if (changeModalityState) {
            commandProcessor.enterModal();
            LaterInvocator.enterModal((Object)this.myDialog);
            Pair pair = ApplicationManager.getApplication().isWriteAccessAllowed() ? new Pair((Object)EmptyCoroutineContext.INSTANCE, emptyFunction) : IntelliJLockingUtil.getGlobalThreadingSupport().parallelizeLock();
            lockContextWrapper = r -> ThreadContext.installThreadContext((CoroutineContext)((CoroutineContext)pair.getFirst()), (boolean)true, () -> {
                r.run();
                return Unit.INSTANCE;
            });
            lockCleanup = (Function0)pair.getSecond();
        } else {
            lockContextWrapper = r -> ThreadContext.resetThreadContext(() -> {
                r.run();
                return null;
            });
            lockCleanup = emptyFunction;
        }
        if (appStarted2) {
            this.hidePopupsIfNeeded();
        }
        if (SystemInfoRt.isMac && (pane2 = this.myDialog.getContentPane()) != null && (tb = TouchbarSupport.showWindowActions(pane2)) != null) {
            this.myDisposeActions.add(() -> Disposer.dispose((Disposable)tb));
        }
        Component componentToRestoreFocus = null;
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (UIUtil.isSimpleWindow((Window)kfm.getFocusedWindow())) {
            componentToRestoreFocus = kfm.getPermanentFocusOwner();
        }
        CompletableFuture result2 = new CompletableFuture();
        SplashManagerKt.hideSplash();
        try (AccessToken ignore5 = AccessToken.create(() -> {
            if (changeModalityState) {
                LaterInvocator.leaveModal((Object)this.myDialog);
            }
        });
             AccessToken ignore4 = AccessToken.create(() -> {
            if (changeModalityState) {
                commandProcessor.leaveModal();
            }
        });
             AccessToken ignore3 = AccessToken.create(() -> lockCleanup.invoke());
             AccessToken ignore2 = SlowOperations.startSection((String)"  reset  ");
             AccessToken ignore1 = DialogWrapperPeerImpl.resetCoroutinesEventLoop();){
            lockContextWrapper.accept(() -> {
                if (!this.isProgressDialog() && ApplicationManager.getApplication() != null && !ApplicationManager.getApplication().isReadAccessAllowed()) {
                    WriteIntentReadAction.run(() -> this.myDialog.show());
                } else {
                    this.myDialog.show();
                }
            });
        }
        finally {
            this.myDialog.getFocusManager().doWhenFocusSettlesDown(() -> result2.complete(null));
        }
        if (componentToRestoreFocus != null) {
            componentToRestoreFocus.requestFocus();
        }
        return result2;
    }

    private void hidePopupsIfNeeded() {
        if (!SystemInfoRt.isMac) {
            return;
        }
        StackingPopupDispatcher.getInstance().hidePersistentPopups();
        this.myDisposeActions.add(() -> StackingPopupDispatcher.getInstance().restorePersistentPopups());
    }

    @RequiresEdt
    private static AccessToken resetCoroutinesEventLoop() {
        ThreadingAssertions.assertEventDispatchThread();
        final EventLoop currentEventLoop = ThreadLocalEventLoop.INSTANCE.currentOrNull$kotlinx_coroutines_core();
        ThreadLocalEventLoop.INSTANCE.resetEventLoop$kotlinx_coroutines_core();
        return new AccessToken(){

            public void finish() {
                if (currentEventLoop != null) {
                    ThreadLocalEventLoop.INSTANCE.resetEventLoop$kotlinx_coroutines_core();
                }
            }
        };
    }

    private static void setupSelectionOnPreferredComponent(JComponent component2) {
        if (component2 instanceof JTextField) {
            JTextField field = (JTextField)component2;
            String text2 = field.getText();
            if (text2 != null && field.getClientProperty(HAVE_INITIAL_SELECTION) == null) {
                field.setSelectionStart(0);
                field.setSelectionEnd(text2.length());
            }
        } else if (component2 instanceof JComboBox) {
            ((JComboBox)component2).getEditor().selectAll();
        }
    }

    public void setContentPane(JComponent content2) {
        boolean undecorated = this.myDialog.getWindow() != null && this.myDialog.getWindow().isUndecorated();
        this.myDialog.setContentPane(IdeFrameDecorator.Companion.isCustomDecorationActive() && !undecorated && !DialogWrapperPeerImpl.isHeadlessEnv() ? CustomFrameDialogContent.Companion.getCustomContentHolder(this.getWindow(), content2, false) : content2);
    }

    public void centerInParent() {
        this.myDialog.centerInParent();
    }

    public void setAutoRequestFocus(boolean b) {
        UIUtil.setAutoRequestFocus((Window)((JDialog)((Object)this.myDialog)), (boolean)b);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModalityType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDialogDeactivated";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setOnDeactivationAction";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }

    private static final class MyDialog
    extends JDialog
    implements DialogWrapperDialog,
    UiDataProvider,
    Queryable,
    AbstractDialog,
    DisposableWindow {
        private final WeakReference<DialogWrapper> myDialogWrapper;
        private Dimension myInitialSize;
        private String myDimensionServiceKey;
        private static final String NORMAL_BOUNDS_SUFFIX = "_normalized";
        private boolean myOpened = false;
        private boolean myDisposed = false;
        private MyWindowListener myWindowListener;
        private final WeakReference<Project> myProject;
        @Nullable
        private MacDirtySizeHack myMacDirtySizeHack;

        MyDialog(Window owner, DialogWrapper dialogWrapper, Project project2) {
            super(owner);
            this.myDialogWrapper = new WeakReference<DialogWrapper>(dialogWrapper);
            this.myProject = project2 != null ? new WeakReference<Project>(project2) : null;
            this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

                @Override
                public boolean accept(Component aComponent) {
                    return !ComponentUtil.isFocusProxy((Component)aComponent) && super.accept(aComponent);
                }
            });
            this.setDefaultCloseOperation(0);
            this.myWindowListener = new MyWindowListener();
            this.addWindowListener(this.myWindowListener);
            this.addWindowFocusListener(this.myWindowListener);
        }

        @Override
        public JDialog getWindow() {
            return this;
        }

        public boolean isWindowDisposed() {
            return this.myDisposed;
        }

        public void putInfo(@NotNull Map<? super String, ? super String> info) {
            if (info == null) {
                MyDialog.$$$reportNull$$$0(0);
            }
            info.put("dialog", this.getTitle());
        }

        public DialogWrapper getDialogWrapper() {
            return (DialogWrapper)this.myDialogWrapper.get();
        }

        @Override
        public void centerInParent() {
            this.setLocationRelativeTo(this.getOwner());
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                MyDialog.$$$reportNull$$$0(1);
            }
            DialogWrapper wrapper2 = (DialogWrapper)this.myDialogWrapper.get();
            DataSink.uiDataSnapshot((DataSink)sink, (Object)wrapper2);
            Project project2 = this.getProject();
            if (project2 != null && project2.isInitialized()) {
                sink.set(CommonDataKeys.PROJECT, (Object)project2);
            }
        }

        private void fitToScreen(Rectangle rect) {
            if (this.myDialogWrapper == null) {
                return;
            }
            DialogWrapper wrapper2 = (DialogWrapper)this.myDialogWrapper.get();
            if (wrapper2 != null) {
                wrapper2.fitToScreen(rect);
            }
        }

        @Override
        public void pack() {
            super.pack();
            DialogWrapper dialogWrapper = this.getDialogWrapper();
            if (dialogWrapper == null || dialogWrapper.setSizeDuringPack()) {
                Dimension preferredSize = this.getPreferredSize();
                super.setSize(preferredSize.width, preferredSize.height);
            }
        }

        @Override
        public void setLocation(int x, int y) {
            MacDirtySizeHack sizeHack = this.myMacDirtySizeHack;
            if (sizeHack == null) {
                super.setLocation(x, y);
            } else {
                Dimension hackSize = this.getSize();
                super.setBounds(x, y, hackSize.width, hackSize.height);
            }
        }

        @Override
        public void setSize(int width, int height) {
            this._setSizeForLocation(width, height, null);
        }

        private void _setSizeForLocation(int width, int height, @Nullable Point initial) {
            Point location;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting the size (" + width + "," + height + ") for location " + String.valueOf(initial));
            }
            Point point = location = initial != null ? initial : this.getLocation();
            if (initial == null && LOG.isDebugEnabled()) {
                LOG.debug("Falling back to the actual location because the specified one is null: " + String.valueOf(location));
            }
            Rectangle rect = new Rectangle(location.x, location.y, width, height);
            Rectangle before = null;
            if (LOG.isDebugEnabled()) {
                before = new Rectangle(rect);
            }
            this.fitToScreen(rect);
            if (LOG.isDebugEnabled() && !Objects.equals(before, rect)) {
                LOG.debug("Fitted these bounds to the screen: " + String.valueOf(before) + " -> " + String.valueOf(rect));
            }
            if (initial != null || location.x != rect.x || location.y != rect.y) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Setting the location to (" + rect.x + "," + rect.y + ")");
                }
                this.setLocation(rect.x, rect.y);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting the size to (" + rect.width + "," + rect.height + ")");
            }
            super.setSize(rect.width, rect.height);
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            Rectangle rect = new Rectangle(x, y, width, height);
            this.fitToScreen(rect);
            super.setBounds(rect.x, rect.y, rect.width, rect.height);
        }

        @Override
        public void setBounds(Rectangle r) {
            this.fitToScreen(r);
            super.setBounds(r);
        }

        @Override
        public void reshape(int x, int y, int width, int height) {
            MacDirtySizeHack sizeHack;
            if (LOG.isTraceEnabled()) {
                LOG.trace(new Throwable("DialogWrapperPeerImpl.MyDialog.reshape(title='" + this.getTitle() + "'): " + String.valueOf(new Rectangle(x, y, width, height))));
            }
            if ((sizeHack = this.myMacDirtySizeHack) != null) {
                sizeHack.updateSize(width, height);
            }
            super.reshape(x, y, width, height);
        }

        @Override
        public Dimension getSize() {
            Dimension actualSize = super.getSize();
            MacDirtySizeHack sizeHack = this.myMacDirtySizeHack;
            if (sizeHack != null) {
                Dimension hackSize = sizeHack.getSize();
                if (LOG.isDebugEnabled() && !hackSize.equals(actualSize)) {
                    LOG.debug("MacOS hack size override: actual size is " + String.valueOf(actualSize) + ", but we use " + String.valueOf(hackSize) + " instead");
                }
                return hackSize;
            }
            return actualSize;
        }

        @Override
        @NotNull
        public Rectangle getBounds() {
            return new Rectangle(this.getLocation(), this.getSize());
        }

        @Override
        @NotNull
        protected JRootPane createRootPane() {
            return new DialogRootPane();
        }

        @Override
        public void addNotify() {
            if (IdeFrameDecorator.Companion.isCustomDecorationActive()) {
                CustomHeader.Companion.enableCustomHeader(this);
            }
            super.addNotify();
            if (SystemInfo.isMacOSVentura && Registry.is((String)"ide.mac.stage.manager.support", (boolean)false)) {
                Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> {
                    ID window = MacUtil.getWindowFromJavaWindow((Window)this);
                    Foundation.invoke((ID)window, (String)"setCollectionBehavior:", (Object[])new Object[]{16});
                });
            }
        }

        @Override
        public void show() {
            DialogWrapper wrapper2;
            DialogWrapper dialogWrapper = this.getDialogWrapper();
            boolean isAutoAdjustable = dialogWrapper.isAutoAdjustable();
            Point location = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("START preparing to show a dialog titled '" + this.getTitle() + "', isAutoAdjustable=" + isAutoAdjustable + ", the monitor configuration is:");
                this.logMonitorConfiguration();
            }
            if (isAutoAdjustable) {
                if (SystemInfoRt.isMac) {
                    this.myMacDirtySizeHack = new MacDirtySizeHack(this.getWidth(), this.getHeight());
                    this.addComponentListener(this.myMacDirtySizeHack);
                }
                this.pack();
                Dimension initial = dialogWrapper.getInitialSize();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The initial size of the dialog as set/overridden by the API user: " + String.valueOf(initial));
                }
                if (initial == null) {
                    initial = new Dimension();
                }
                if (initial.width <= 0 || initial.height <= 0) {
                    Dimension packedSize = this.getSize();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("The size of the dialog after packing: " + String.valueOf(packedSize));
                    }
                    MyDialog.maximize(initial, packedSize);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("The initial size after coercing it to be at least the packed size: " + String.valueOf(initial));
                    }
                    if (!SystemInfoRt.isLinux && Registry.is((String)"ide.dialog.wrapper.resize.by.tables", (boolean)false)) {
                        MyDialog.maximize(initial, MyDialog.getSizeForTableContainer(this.getContentPane()));
                    }
                }
                Dimension minimumSize = this.getMinimumSize();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The minimum size of the dialog: " + String.valueOf(minimumSize));
                }
                MyDialog.maximize(initial, minimumSize);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The initial size after coercing it to be at least the minimum size: " + String.valueOf(initial));
                }
                float hs = dialogWrapper.getHorizontalStretch();
                initial.width *= (int)hs;
                float vs = dialogWrapper.getVerticalStretch();
                initial.height *= (int)vs;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Setting the initial size after stretching it by (" + hs + "," + vs + "): " + String.valueOf(initial));
                }
                this.setSize(initial);
                this.myDimensionServiceKey = dialogWrapper.getDimensionKey();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The dimension service key is '" + this.myDimensionServiceKey + "'");
                }
                if (this.myDimensionServiceKey != null) {
                    Rectangle normalBounds;
                    Project projectGuess = this.guessProjectDependingOnKey(this.myDimensionServiceKey);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("The project is " + String.valueOf(projectGuess));
                    }
                    WindowStateService windowStateService = MyDialog.getWindowStateService(projectGuess);
                    location = windowStateService.getLocation(this.myDimensionServiceKey);
                    Dimension size2 = windowStateService.getSize(this.myDimensionServiceKey);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("The stored location and size are " + String.valueOf(location) + " and " + String.valueOf(size2) + (size2 != null ? ", using them to set the initial bounds" : ""));
                    }
                    if (size2 != null) {
                        this.myInitialSize = new Dimension(size2);
                        this._setSizeForLocation(this.myInitialSize.width, this.myInitialSize.height, location);
                    }
                    if ((normalBounds = windowStateService.getBounds(this.myDimensionServiceKey + NORMAL_BOUNDS_SUFFIX)) != null) {
                        MaximizeDialogKt.setNormalBounds(this, normalBounds);
                    }
                }
                if (this.myInitialSize == null) {
                    Dimension initialSize = dialogWrapper.getInitialSize();
                    Dimension dimension = this.myInitialSize = initialSize != null ? initialSize : this.getSize();
                }
            }
            if (location == null) {
                location = dialogWrapper.getInitialLocation();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The initial location is " + String.valueOf(location));
                }
            }
            if (location != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Setting the location to " + String.valueOf(location));
                }
                this.setLocation(location);
            } else {
                Window owner = this.getOwner();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Setting the location relative to " + String.valueOf(owner));
                }
                this.setLocationRelativeTo(owner);
            }
            if (isAutoAdjustable) {
                Rectangle bounds = this.getBounds();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Performing auto-adjustment for the resulting bounds: " + String.valueOf(bounds));
                }
                this.fitToScreen(bounds);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The bounds after fitting to screen: " + String.valueOf(bounds));
                }
                this.setBounds(bounds);
            }
            DialogWrapper dialogWrapper2 = wrapper2 = this.myDialogWrapper == null ? null : (DialogWrapper)this.myDialogWrapper.get();
            if (wrapper2 != null) {
                wrapper2.beforeShowCallback();
            }
            if (!SystemInfoRt.isMac || !WindowRoundedCornersManager.isAvailable()) {
                this.setBackground(UIUtil.getPanelBackground());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("END preparing to show the dialog, the resulting bounds: " + String.valueOf(this.getBounds()));
            }
            if (dialogWrapper.isDisposed()) {
                LOG.warn("The dialog wrapper for " + dialogWrapper.getTitle() + " is already disposed");
                return;
            }
            super.show();
        }

        private void logMonitorConfiguration() {
            JFrame ideFrame = WindowManager.getInstance().getFrame((Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this)));
            for (String message : ScreenUtil.loggableMonitorConfiguration((JFrame)ideFrame)) {
                LOG.debug(message);
            }
        }

        @Nullable
        private Project guessProjectDependingOnKey(String key) {
            return !key.startsWith("APPLICATION_WIDE_STORE_") ? (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this)) : null;
        }

        private static void maximize(@NotNull Dimension size2, @Nullable Dimension alternativeSize) {
            if (size2 == null) {
                MyDialog.$$$reportNull$$$0(2);
            }
            if (alternativeSize != null) {
                size2.width = Math.max(size2.width, alternativeSize.width);
                size2.height = Math.max(size2.height, alternativeSize.height);
            }
        }

        @Nullable
        private static Dimension getSizeForTableContainer(@Nullable Component component2) {
            if (component2 == null) {
                return null;
            }
            JBIterable tables = UIUtil.uiTraverser((Component)component2).filter(JTable.class);
            if (!tables.isNotEmpty()) {
                return null;
            }
            Dimension size2 = component2.getPreferredSize();
            for (JTable table2 : tables) {
                Dimension tableSize = table2.getPreferredSize();
                size2.width = Math.max(size2.width, tableSize.width);
                size2.height = Math.max(size2.height, tableSize.height + size2.height - table2.getParent().getHeight());
            }
            size2.width = Math.min(1000, Math.max(600, size2.width));
            size2.height = Math.min(800, size2.height);
            return size2;
        }

        @Nullable
        private Project getProject() {
            return (Project)SoftReference.dereference(this.myProject);
        }

        @Override
        @NotNull
        public IdeFocusManager getFocusManager() {
            Project project2 = this.getProject();
            if (project2 != null && !project2.isDisposed()) {
                IdeFocusManager ideFocusManager = IdeFocusManager.getInstance((Project)project2);
                if (ideFocusManager == null) {
                    MyDialog.$$$reportNull$$$0(3);
                }
                return ideFocusManager;
            }
            IdeFocusManager ideFocusManager = IdeFocusManager.findInstance();
            if (ideFocusManager == null) {
                MyDialog.$$$reportNull$$$0(4);
            }
            return ideFocusManager;
        }

        @Override
        public void hide() {
            ThreadContext.resetThreadContext(() -> {
                super.hide();
                return null;
            });
        }

        @Override
        public void dispose() {
            BufferStrategy strategy;
            DialogWrapper wrapper2;
            if (this.isShowing()) {
                this.hide();
            }
            if (this.myWindowListener != null) {
                this.myWindowListener.saveSize();
                this.removeWindowListener(this.myWindowListener);
                this.removeWindowFocusListener(this.myWindowListener);
                this.myWindowListener = null;
            }
            if ((wrapper2 = this.getDialogWrapper()) != null) {
                wrapper2.disposeIfNeeded();
            }
            if ((strategy = this.getBufferStrategy()) != null) {
                if (!EDT.isCurrentThreadEdt()) {
                    LOG.error("Component dispose must be called on EDT", new Throwable());
                }
                strategy.dispose();
            }
            super.dispose();
            this.removeAll();
            DialogWrapper.cleanupRootPane((JRootPane)this.rootPane);
            DialogWrapper.cleanupWindowListeners((Window)this);
            this.rootPane = null;
            this.myDisposed = true;
        }

        @Override
        public Component getMostRecentFocusOwner() {
            JComponent toFocus;
            DialogWrapper wrapper2;
            if (!this.myOpened && (wrapper2 = this.getDialogWrapper()) != null && (toFocus = wrapper2.getPreferredFocusedComponent()) != null) {
                return toFocus;
            }
            return super.getMostRecentFocusOwner();
        }

        @Override
        public void paint(Graphics g) {
            if (!SystemInfoRt.isMac) {
                UISettings.setupAntialiasing((Graphics)g);
            }
            if (!EDT.isCurrentThreadEdt()) {
                LOG.error("paint must be called on EDT", new Throwable());
            }
            super.paint(g);
        }

        @NotNull
        private static WindowStateService getWindowStateService(@Nullable Project project2) {
            WindowStateService windowStateService = project2 == null ? WindowStateService.getInstance() : WindowStateService.getInstance((Project)project2);
            if (windowStateService == null) {
                MyDialog.$$$reportNull$$$0(5);
            }
            return windowStateService;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "size";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$MyDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$MyDialog";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFocusManager";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWindowStateService";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "putInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "maximize";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }

        private final class MyWindowListener
        extends WindowAdapter {
            private MyWindowListener() {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                DialogWrapper dialogWrapper = MyDialog.this.getDialogWrapper();
                if (dialogWrapper.shouldCloseOnCross()) {
                    dialogWrapper.doCancelAction((AWTEvent)e);
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                this.saveSize();
            }

            public void saveSize() {
                if (MyDialog.this.myDimensionServiceKey != null && MyDialog.this.myInitialSize != null && MyDialog.this.myOpened) {
                    Rectangle normalBounds;
                    Dimension size2;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Saving the bounds of a dialog titled '" + MyDialog.this.getTitle() + "', the monitor configuration is:");
                        MyDialog.this.logMonitorConfiguration();
                    }
                    Project projectGuess = MyDialog.this.guessProjectDependingOnKey(MyDialog.this.myDimensionServiceKey);
                    Point location = MyDialog.this.getLocation();
                    WindowStateService windowStateService = MyDialog.getWindowStateService(projectGuess);
                    windowStateService.putLocation(MyDialog.this.myDimensionServiceKey, location);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Saved location: " + String.valueOf(location));
                    }
                    if (!MyDialog.this.myInitialSize.equals(size2 = MyDialog.this.getSize())) {
                        windowStateService.putSize(MyDialog.this.myDimensionServiceKey, size2);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Saved size: " + String.valueOf(size2) + " (the initial size was " + String.valueOf(MyDialog.this.myInitialSize) + ")");
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Didn't save size because it's the same as the initial size: " + String.valueOf(size2));
                    }
                    if ((normalBounds = MaximizeDialogKt.getNormalBounds(MyDialog.this)) != null) {
                        windowStateService.putBounds(MyDialog.this.myDimensionServiceKey + MyDialog.NORMAL_BOUNDS_SUFFIX, normalBounds);
                    }
                    MyDialog.this.myOpened = false;
                }
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                MyDialog.this.removeWindowFocusListener(this);
                MyDialog.this.myOpened = true;
                DialogWrapper wrapper2 = MyDialog.this.getDialogWrapper();
                JComponent toFocus = wrapper2 == null ? null : wrapper2.getPreferredFocusedComponent();
                JRootPane pane2 = MyDialog.this.getRootPane();
                if (pane2 != null && toFocus == null) {
                    toFocus = pane2.getDefaultButton();
                }
                if (pane2 != null) {
                    IJSwingUtilities.moveMousePointerOn(pane2.getDefaultButton());
                }
                DialogWrapperPeerImpl.setupSelectionOnPreferredComponent(toFocus);
                if (toFocus != null && toFocus.isEnabled()) {
                    if (MyDialog.this.isShowing() && (!LoadingState.COMPONENTS_REGISTERED.isOccurred() || ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isActive())) {
                        toFocus.requestFocus();
                    } else {
                        toFocus.requestFocusInWindow();
                    }
                }
            }
        }

        private final class MacDirtySizeHack
        extends ComponentAdapter {
            private int width;
            private int height;

            MacDirtySizeHack(int width, int height) {
                this.width = width;
                this.height = height;
            }

            void updateSize(int width, int height) {
                this.width = width;
                this.height = height;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Manually set size for the mac hack: width = " + width + ", height = " + height);
                }
            }

            Dimension getSize() {
                return new Dimension(this.width, this.height);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                MyDialog.this.removeComponentListener(this);
                MyDialog.this.myMacDirtySizeHack = null;
                int width = MyDialog.this.getWidth();
                int height = MyDialog.this.getHeight();
                if (width != this.width || height != this.height) {
                    LOG.warn("The size of the dialog '" + MyDialog.this.getTitle() + "' has changed after showing, set width = " + this.width + ", height = " + this.height + ", now width = " + width + ", height = " + height + ", resetting it back");
                    MyDialog.this.setSize(this.width, this.height);
                }
            }
        }

        private final class DialogRootPane
        extends JRootPane
        implements UiDataProvider {
            private final boolean myGlassPaneIsSet;
            private Dimension myLastMinimumSize;

            private DialogRootPane() {
                this.setGlassPane(new IdeGlassPaneImpl(this));
                this.myGlassPaneIsSet = true;
                this.putClientProperty("DIALOG_ROOT_PANE", true);
                this.setBorder(JBUI.CurrentTheme.Window.getBorder((boolean)MyDialog.this.isUndecorated()));
            }

            @Override
            @NotNull
            protected JLayeredPane createLayeredPane() {
                JBLayeredPane p = new JBLayeredPane(){

                    protected Graphics getComponentGraphics(Graphics g) {
                        return JBSwingUtilities.runGlobalCGTransform((JComponent)((Object)this), (Graphics)super.getComponentGraphics(g));
                    }
                };
                p.setName(this.getName() + ".layeredPane");
                JBLayeredPane jBLayeredPane = p;
                if (jBLayeredPane == null) {
                    DialogRootPane.$$$reportNull$$$0(0);
                }
                return jBLayeredPane;
            }

            @Override
            public void validate() {
                Dimension size2;
                Window window;
                super.validate();
                DialogWrapper wrapper2 = (DialogWrapper)MyDialog.this.myDialogWrapper.get();
                if (wrapper2 != null && wrapper2.isAutoAdjustable() && (window = wrapper2.getWindow()) != null && !Objects.equals(size2 = this.getMinimumSize(), this.myLastMinimumSize)) {
                    if (size2 == null) {
                        this.myLastMinimumSize = null;
                    } else {
                        this.myLastMinimumSize = new Dimension(size2);
                        JBInsets.addTo((Dimension)size2, (Insets)window.getInsets());
                        Rectangle screen = ScreenUtil.getScreenRectangle((Component)window);
                        if (size2.width > screen.width || size2.height > screen.height) {
                            Application application = ApplicationManager.getApplication();
                            if (application != null && application.isInternal()) {
                                StringBuilder sb = new StringBuilder("dialog minimum size is bigger than screen: ");
                                sb.append(size2.width).append("x").append(size2.height);
                                IJSwingUtilities.appendComponentClassNames(sb, this);
                                LOG.warn(sb.toString());
                            }
                            if (size2.width > screen.width) {
                                size2.width = screen.width;
                            }
                            if (size2.height > screen.height) {
                                size2.height = screen.height;
                            }
                        }
                    }
                    window.setMinimumSize(size2);
                }
            }

            @Override
            public void setGlassPane(Component glass) {
                if (this.myGlassPaneIsSet) {
                    LOG.warn("Setting of glass pane for DialogWrapper is prohibited", (Throwable)new Exception());
                    return;
                }
                super.setGlassPane(glass);
            }

            @Override
            public void setContentPane(Container contentPane) {
                super.setContentPane(contentPane);
                if (contentPane != null) {
                    contentPane.addMouseMotionListener(new MouseMotionAdapter(this){});
                }
            }

            public void uiDataSnapshot(@NotNull DataSink sink) {
                DialogWrapper wrapper2;
                if (sink == null) {
                    DialogRootPane.$$$reportNull$$$0(1);
                }
                if ((wrapper2 = (DialogWrapper)MyDialog.this.myDialogWrapper.get()) == null) {
                    return;
                }
                sink.set(PlatformDataKeys.UI_DISPOSABLE, (Object)wrapper2.getDisposable());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$MyDialog$DialogRootPane";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sink";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createLayeredPane";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$MyDialog$DialogRootPane";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "uiDataSnapshot";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        }
    }

    private final class AnCancelAction
    extends AnAction
    implements DumbAware {
        private AnCancelAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AnCancelAction.$$$reportNull$$$0(0);
            }
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            e.getPresentation().setEnabled(false);
            if (focusOwner instanceof JComponent && SpeedSearchBase.hasActiveSpeedSearch((JComponent)focusOwner)) {
                return;
            }
            if (StackingPopupDispatcher.getInstance().isPopupFocused()) {
                return;
            }
            JTree tree2 = (JTree)ComponentUtil.getParentOfType(JTree.class, (Component)focusOwner);
            JTable table2 = (JTable)ComponentUtil.getParentOfType(JTable.class, (Component)focusOwner);
            if ((tree2 != null || table2 != null) && AnCancelAction.hasNoEditingTreesOrTablesUpward(focusOwner)) {
                e.getPresentation().setEnabled(true);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                AnCancelAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        private static boolean hasNoEditingTreesOrTablesUpward(Component comp) {
            while (comp != null) {
                if (AnCancelAction.isEditingTreeOrTable(comp)) {
                    return false;
                }
                comp = comp.getParent();
            }
            return true;
        }

        private static boolean isEditingTreeOrTable(Component comp) {
            if (comp instanceof JTree) {
                return ((JTree)comp).isEditing();
            }
            if (comp instanceof JTable) {
                return ((JTable)comp).isEditing();
            }
            return false;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AnCancelAction.$$$reportNull$$$0(2);
            }
            DialogWrapperPeerImpl.this.myWrapper.doCancelAction((AWTEvent)e.getInputEvent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$AnCancelAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$AnCancelAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

