/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginInstallOperation;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagementPolicy;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.InstallPluginTask;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/InstallPluginTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "pluginIds", "", "Lcom/intellij/openapi/extensions/PluginId;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "<init>", "(Ljava/util/Set;Lcom/intellij/openapi/application/ModalityState;)V", "getModalityState", "()Lcom/intellij/openapi/application/ModalityState;", "plugins", "", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "customPlugins", "", "Lcom/intellij/ide/plugins/PluginNode;", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "onSuccess", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nInstallPluginTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallPluginTask.kt\ncom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/InstallPluginTask\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n4474#2,2:70\n777#3:72\n873#3,2:73\n1661#3,3:75\n*S KotlinDebug\n*F\n+ 1 InstallPluginTask.kt\ncom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/InstallPluginTask\n*L\n25#1:70,2\n29#1:72\n29#1:73,2\n30#1:75,3\n*E\n"})
public final class InstallPluginTask
extends Task.Modal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<PluginId> pluginIds;
    @NotNull
    private final ModalityState modalityState;
    @NotNull
    private final Set<PluginDownloader> plugins;
    private List<PluginNode> customPlugins;

    public InstallPluginTask(@NotNull Set<PluginId> pluginIds, @NotNull ModalityState modalityState) {
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        super(null, IdeBundle.message((String)"plugins.advertiser.task.searching.for.plugins", (Object[])new Object[0]), true);
        this.pluginIds = pluginIds;
        this.modalityState = modalityState;
        this.plugins = new LinkedHashSet();
    }

    @NotNull
    public final ModalityState getModalityState() {
        return this.modalityState;
    }

    /*
     * WARNING - void declaration
     */
    public void run(@NotNull ProgressIndicator indicator2) {
        void $this$mapTo$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable $this$filterTo$iv;
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        List marketplacePlugins = MarketplaceRequests.Companion.loadLastCompatiblePluginDescriptors$default(MarketplaceRequests.Companion, this.pluginIds, null, false, 6, null);
        List<PluginNode> list2 = RepositoryHelper.loadPluginsFromCustomRepositories(indicator2);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"loadPluginsFromCustomRepositories(...)");
        this.customPlugins = list2;
        List<PluginNode> list3 = this.customPlugins;
        if (list3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"customPlugins");
            list3 = null;
        }
        List descriptors2 = new ArrayList<PluginNode>(RepositoryHelper.mergePluginsFromRepositories(marketplacePlugins, list3, true));
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins();
        Collection destination$iv = descriptors2;
        boolean $i$f$filterTo22 = false;
        for (IdeaPluginDescriptor element$iv : $this$filterTo$iv) {
            void it = element$iv;
            boolean bl = false;
            if (!(!it.isEnabled() && PluginManagerCore.isCompatible((IdeaPluginDescriptor)it) && PluginManagementPolicy.Companion.getInstance().canInstallPlugin((IdeaPluginDescriptor)it))) continue;
            destination$iv.add(element$iv);
        }
        $this$filterTo$iv = descriptors2;
        boolean $i$f$filter = false;
        void $i$f$filterTo22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IdeaPluginDescriptor it = (IdeaPluginDescriptor)element$iv$iv;
            boolean bl = false;
            if (!this.pluginIds.contains(it.getPluginId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        destination$iv = this.plugins;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            IdeaPluginDescriptor element$iv;
            element$iv = (IdeaPluginDescriptor)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(PluginDownloader.createDownloader((IdeaPluginDescriptor)it));
        }
    }

    public void onSuccess() {
        List pluginsToEnable = new ArrayList();
        List nodes = new ArrayList();
        for (PluginDownloader downloader : this.plugins) {
            IdeaPluginDescriptor plugin;
            Intrinsics.checkNotNullExpressionValue((Object)downloader.getDescriptor(), (String)"getDescriptor(...)");
            pluginsToEnable.add(plugin);
            if (!plugin.isEnabled()) continue;
            PluginNode pluginNode = downloader.toPluginNode();
            Intrinsics.checkNotNullExpressionValue((Object)pluginNode, (String)"toPluginNode(...)");
            nodes.add(pluginNode);
        }
        PluginManagerMain.suggestToEnableInstalledDependantPlugins((PluginEnabler)PluginEnabler.HEADLESS, nodes);
        PluginEnabler.HEADLESS.enable((Collection)pluginsToEnable);
        if (!((Collection)nodes).isEmpty()) {
            List<PluginNode> list2 = this.customPlugins;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customPlugins");
                list2 = null;
            }
            InstallPluginTask.Companion.downloadPlugins(nodes, list2, this.modalityState);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/InstallPluginTask$Companion;", "", "<init>", "()V", "downloadPlugins", "", "plugins", "", "Lcom/intellij/ide/plugins/PluginNode;", "customPlugins", "", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void downloadPlugins(List<PluginNode> plugins2, Collection<PluginNode> customPlugins2, ModalityState modalityState) {
            String string = IdeBundle.message((String)"progress.download.plugins", (Object[])new Object[0]);
            ProgressManager.getInstance().run((Task)new Task.Modal(plugins2, customPlugins2, modalityState, string){
                final /* synthetic */ List<PluginNode> $plugins;
                final /* synthetic */ Collection<PluginNode> $customPlugins;
                final /* synthetic */ ModalityState $modalityState;
                {
                    this.$plugins = $plugins;
                    this.$customPlugins = $customPlugins;
                    this.$modalityState = $modalityState;
                    super(null, $super_call_param$1, true);
                }

                public void run(ProgressIndicator indicator2) {
                    Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
                    PluginInstallOperation operation2 = new PluginInstallOperation(this.$plugins, this.$customPlugins, (PluginEnabler)PluginEnabler.HEADLESS, indicator2);
                    operation2.setAllowInstallWithoutRestart(true);
                    operation2.run();
                    if (operation2.isSuccess()) {
                        ActionsKt.invokeLater((ModalityState)this.$modalityState, () -> downloadPlugins.1.run$lambda$0(operation2));
                    }
                }

                private static final Unit run$lambda$0(PluginInstallOperation $operation) {
                    for (PendingDynamicPluginInstall pendingDynamicPluginInstall : $operation.getPendingDynamicPluginInstalls()) {
                        Path file2 = pendingDynamicPluginInstall.component1();
                        IdeaPluginDescriptorImpl pluginDescriptor = pendingDynamicPluginInstall.component2();
                        PluginInstaller.installAndLoadDynamicPlugin(file2, pluginDescriptor);
                    }
                    return Unit.INSTANCE;
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

