/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeLinkMouseListener
extends LinkMouseListenerBase<Object> {
    private final ColoredTreeCellRenderer myRenderer;
    private WeakReference<Object> myLastHitNode;

    public TreeLinkMouseListener(ColoredTreeCellRenderer renderer2) {
        this.myRenderer = renderer2;
    }

    protected void showTooltip(JTree tree2, MouseEvent e, HaveTooltip launcher) {
        String newText;
        String text2 = tree2.getToolTipText(e);
        String string = newText = launcher == null ? null : launcher.getTooltip();
        if (!Objects.equals(text2, newText)) {
            tree2.setToolTipText(newText);
        }
    }

    @Override
    @Nullable
    protected Object getTagAt(@NotNull MouseEvent e) {
        if (e == null) {
            TreeLinkMouseListener.$$$reportNull$$$0(0);
        }
        JTree tree2 = (JTree)e.getSource();
        Object tag = null;
        HaveTooltip haveTooltip = null;
        TreePath path = tree2.getPathForLocation(e.getX(), e.getY());
        if (path != null) {
            boolean isLeaf;
            int dx = this.getRendererRelativeX(e, tree2, path);
            Object node = path.getLastPathComponent();
            if (node instanceof TreeNode) {
                TreeNode treeNode = (TreeNode)node;
                isLeaf = treeNode.isLeaf();
            } else {
                isLeaf = tree2.getModel().isLeaf(node);
            }
            AppUIUtil.targetToDevice((Component)this.myRenderer, tree2);
            if (this.myLastHitNode == null || this.myLastHitNode.get() != node || e.getButton() != 0) {
                if (this.doCacheLastNode()) {
                    this.myLastHitNode = new WeakReference<Object>(node);
                }
                this.myRenderer.getTreeCellRendererComponent(tree2, node, false, false, isLeaf, tree2.getRowForPath(path), false);
            }
            if ((tag = this.myRenderer.getFragmentTagAt(dx)) != null && node instanceof HaveTooltip) {
                haveTooltip = (HaveTooltip)node;
            }
        }
        this.showTooltip(tree2, e, haveTooltip);
        return tag;
    }

    protected int getRendererRelativeX(@NotNull MouseEvent e, @NotNull JTree tree2, @NotNull TreePath path) {
        if (e == null) {
            TreeLinkMouseListener.$$$reportNull$$$0(1);
        }
        if (tree2 == null) {
            TreeLinkMouseListener.$$$reportNull$$$0(2);
        }
        if (path == null) {
            TreeLinkMouseListener.$$$reportNull$$$0(3);
        }
        Rectangle rectangle = tree2.getPathBounds(path);
        assert (rectangle != null);
        return e.getX() - rectangle.x;
    }

    protected boolean doCacheLastNode() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/issueLinks/TreeLinkMouseListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTagAt";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getRendererRelativeX";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface HaveTooltip {
        @NlsContexts.Tooltip
        public String getTooltip();
    }
}

