/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.progress.ContextKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.util.ExceptionUtil;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DiskQueryRelay<Param, Result> {
    private final Function<? super Param, ? extends Result> myFunction;
    private final Map<Param, Future<Result>> myTasks;
    private final ExecutorService executor;
    private static final AtomicLong taskExecutionTotalTimeNs = new AtomicLong();
    private static final AtomicLong taskWaitingTotalTimeNs = new AtomicLong();
    private static final AtomicInteger tasksExecutedCount = new AtomicInteger();
    private static final AtomicInteger tasksRequestedCount = new AtomicInteger();

    public DiskQueryRelay(@NotNull Function<? super Param, ? extends Result> function) {
        if (function == null) {
            DiskQueryRelay.$$$reportNull$$$0(0);
        }
        this(function, ProcessIOExecutorService.INSTANCE);
    }

    public DiskQueryRelay(@NotNull Function<? super Param, ? extends Result> function, @NotNull ExecutorService executor) {
        if (function == null) {
            DiskQueryRelay.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            DiskQueryRelay.$$$reportNull$$$0(2);
        }
        this.myTasks = new ConcurrentHashMap<Param, Future<Result>>();
        this.myFunction = arg -> {
            long startedAtNs = System.nanoTime();
            try {
                Object r = function.apply((Object)arg);
                return r;
            }
            finally {
                long elapsedNs = System.nanoTime() - startedAtNs;
                taskExecutionTotalTimeNs.addAndGet(elapsedNs);
                tasksExecutedCount.incrementAndGet();
            }
        };
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result accessDiskWithCheckCanceled(@NotNull Param arg) {
        if (arg == null) {
            DiskQueryRelay.$$$reportNull$$$0(3);
        }
        long startedAtNs = System.nanoTime();
        try {
            if (!ContextKt.isInCancellableContext()) {
                Result Result2 = this.myFunction.apply(arg);
                return Result2;
            }
            Future future = this.myTasks.computeIfAbsent(arg, eachArg -> this.executor.submit(() -> {
                try {
                    Result Result2 = this.myFunction.apply(eachArg);
                    return Result2;
                }
                finally {
                    this.myTasks.remove(eachArg);
                }
            }));
            if (future.isDone()) {
                this.myTasks.remove(arg, future);
            }
            Object object = ProgressIndicatorUtils.awaitWithCheckCanceled((Future)future);
            return (Result)object;
        }
        finally {
            long elapsedNs = System.nanoTime() - startedAtNs;
            taskWaitingTotalTimeNs.addAndGet(elapsedNs);
            tasksRequestedCount.incrementAndGet();
        }
    }

    public static <Result, E extends Exception> Result compute(@NotNull ThrowableComputable<Result, E> task) throws E, ProcessCanceledException {
        if (task == null) {
            DiskQueryRelay.$$$reportNull$$$0(4);
        }
        return DiskQueryRelay.compute(task, ProcessIOExecutorService.INSTANCE);
    }

    public static <Result, E extends Exception> Result compute(@NotNull ThrowableComputable<Result, E> task, @NotNull ExecutorService executor) throws E, ProcessCanceledException {
        if (task == null) {
            DiskQueryRelay.$$$reportNull$$$0(5);
        }
        if (executor == null) {
            DiskQueryRelay.$$$reportNull$$$0(6);
        }
        if (!ContextKt.isInCancellableContext()) {
            return (Result)task.compute();
        }
        Future<Object> future = executor.submit(() -> task.compute());
        try {
            Object object = ProgressIndicatorUtils.awaitWithCheckCanceled(future);
            return (Result)object;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException wrapper2) {
            Throwable outerCause = wrapper2.getCause();
            if (outerCause instanceof ExecutionException) {
                Throwable t = outerCause.getCause();
                ExceptionUtil.rethrowUnchecked((Throwable)t);
                Exception innerCause = (Exception)t;
                throw innerCause;
            }
            throw wrapper2;
        }
        finally {
            future.cancel(false);
        }
    }

    public static long taskExecutionTotalTime(@NotNull TimeUnit unit) {
        if (unit == null) {
            DiskQueryRelay.$$$reportNull$$$0(7);
        }
        return unit.convert(taskExecutionTotalTimeNs.get(), TimeUnit.NANOSECONDS);
    }

    public static long taskWaitingTotalTime(@NotNull TimeUnit unit) {
        if (unit == null) {
            DiskQueryRelay.$$$reportNull$$$0(8);
        }
        return unit.convert(taskWaitingTotalTimeNs.get(), TimeUnit.NANOSECONDS);
    }

    public static int tasksExecuted() {
        return tasksExecutedCount.get();
    }

    public static int tasksRequested() {
        return tasksRequestedCount.get();
    }

    static {
        Meter otelMeter = TelemetryManager.getInstance().getMeter(PlatformScopesKt.PlatformMetrics);
        ObservableLongMeasurement taskExecutionTimeUs = otelMeter.counterBuilder("DiskQueryRelay.taskExecutionTotalTimeUs").buildObserver();
        ObservableLongMeasurement taskWaitingTimeUs = otelMeter.counterBuilder("DiskQueryRelay.taskWaitingTotalTimeUs").buildObserver();
        ObservableLongMeasurement tasksExecuted = otelMeter.counterBuilder("DiskQueryRelay.tasksExecuted").buildObserver();
        ObservableLongMeasurement tasksRequested = otelMeter.counterBuilder("DiskQueryRelay.tasksRequested").buildObserver();
        otelMeter.batchCallback(() -> {
            taskExecutionTimeUs.record(DiskQueryRelay.taskExecutionTotalTime(TimeUnit.MICROSECONDS));
            taskWaitingTimeUs.record(DiskQueryRelay.taskWaitingTotalTime(TimeUnit.MICROSECONDS));
            tasksExecuted.record((long)DiskQueryRelay.tasksExecuted());
            tasksRequested.record((long)DiskQueryRelay.tasksRequested());
        }, (ObservableMeasurement)taskExecutionTimeUs, new ObservableMeasurement[]{taskWaitingTimeUs, tasksExecuted, tasksRequested});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/DiskQueryRelay";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "accessDiskWithCheckCanceled";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "compute";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "taskExecutionTotalTime";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "taskWaitingTotalTime";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

