/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerListener;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.openapi.vfs.encoding.EncodingReference;
import com.intellij.util.concurrency.AppJavaExecutorUtil;
import com.intellij.util.concurrency.CoroutineDispatcherBackedExecutor;
import com.intellij.util.xmlb.annotations.Attribute;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@com.intellij.openapi.components.State(name="Encoding", storages={@Storage(value="encoding.xml")}, category=SettingsCategory.CODE)
@ApiStatus.Internal
public final class EncodingManagerImpl
extends EncodingManager
implements PersistentStateComponent<State>,
Disposable {
    private static final Logger LOG = Logger.getInstance(EncodingManagerImpl.class);
    private State myState;
    private static final Key<Charset> CACHED_CHARSET_FROM_CONTENT = Key.create((String)"CACHED_CHARSET_FROM_CONTENT");
    private final CoroutineDispatcherBackedExecutor changedDocumentExecutor;
    private final AtomicBoolean myDisposed;
    @NonNls
    public static final String PROP_CACHED_ENCODING_CHANGED = "cachedEncoding";
    private static final Key<AtomicInteger> RUNNING_REDETECTS_KEY = Key.create((String)"DETECTING_ENCODING_KEY");

    public EncodingManagerImpl(@NotNull CoroutineScope coroutineScope) {
        if (coroutineScope == null) {
            EncodingManagerImpl.$$$reportNull$$$0(0);
        }
        this.myState = new State();
        this.myDisposed = new AtomicBoolean();
        this.changedDocumentExecutor = AppJavaExecutorUtil.createBoundedTaskExecutor((String)"EncodingManagerImpl Document Pool", (CoroutineScope)coroutineScope, (int)JobSchedulerImpl.getJobPoolParallelism());
        ApplicationManager.getApplication().getMessageBus().connect(coroutineScope).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            public void appClosing() {
                EncodingManagerImpl.this.myDisposed.set(true);
                EncodingManagerImpl.this.clearDocumentQueue();
            }
        });
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                Document document2;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (EncodingManagerImpl.isEditorOpenedFor(document2 = e.getDocument())) {
                    EncodingManagerImpl.this.queueUpdateEncodingFromContent(document2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vfs/encoding/EncodingManagerImpl$2", "documentChanged"));
            }
        }, (Disposable)this);
        editorFactory.addEditorFactoryListener(new EditorFactoryListener(){

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                EncodingManagerImpl.this.queueUpdateEncodingFromContent(event.getEditor().getDocument());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/encoding/EncodingManagerImpl$3", "editorCreated"));
            }
        }, (Disposable)this);
    }

    private static boolean isEditorOpenedFor(@NotNull Document document2) {
        VirtualFile virtualFile2;
        if (document2 == null) {
            EncodingManagerImpl.$$$reportNull$$$0(1);
        }
        if ((virtualFile2 = FileDocumentManager.getInstance().getFile(document2)) == null) {
            return false;
        }
        Project project2 = EncodingManagerImpl.guessProject(virtualFile2);
        return project2 != null && !project2.isDisposed() && FileEditorManager.getInstance((Project)project2).isFileOpen(virtualFile2);
    }

    private void handleDocument(@NotNull Document document2) {
        VirtualFile virtualFile2;
        if (document2 == null) {
            EncodingManagerImpl.$$$reportNull$$$0(2);
        }
        if ((virtualFile2 = FileDocumentManager.getInstance().getFile(document2)) == null) {
            return;
        }
        Project project2 = EncodingManagerImpl.guessProject(virtualFile2);
        while (project2 == null || !project2.isDisposed()) {
            Charset oldCached;
            int nRequests = EncodingManagerImpl.addNumberOfRequestedRedetects(document2, 0);
            Charset charset = LoadTextUtil.charsetFromContentOrNull((Project)project2, (VirtualFile)virtualFile2, (CharSequence)document2.getImmutableCharSequence());
            if (!Comparing.equal((Object)charset, (Object)(oldCached = this.getCachedCharsetFromContent(document2)))) {
                EncodingManagerImpl.setCachedCharsetFromContent(charset, oldCached, document2);
            }
            if (EncodingManagerImpl.addNumberOfRequestedRedetects(document2, -nRequests) != 0) continue;
            break;
        }
    }

    private static void setCachedCharsetFromContent(Charset charset, Charset oldCached, @NotNull Document document2) {
        if (document2 == null) {
            EncodingManagerImpl.$$$reportNull$$$0(3);
        }
        document2.putUserData(CACHED_CHARSET_FROM_CONTENT, (Object)charset);
        EncodingManagerImpl.firePropertyChange(document2, PROP_CACHED_ENCODING_CHANGED, oldCached, charset);
    }

    @ApiStatus.Internal
    @VisibleForTesting
    @Nullable(value="returns null if charset set cannot be determined from content")
    public static @Nullable(value="returns null if charset set cannot be determined from content") Charset computeCharsetFromContent(@NotNull VirtualFile virtualFile2) {
        Document document2;
        if (virtualFile2 == null) {
            EncodingManagerImpl.$$$reportNull$$$0(4);
        }
        if ((document2 = FileDocumentManager.getInstance().getDocument(virtualFile2)) == null) {
            return null;
        }
        Charset cached = EncodingManagerImpl.getInstance().getCachedCharsetFromContent(document2);
        if (cached != null) {
            return cached;
        }
        Project project2 = ProjectLocator.getInstance().guessProjectForFile(virtualFile2);
        return (Charset)ReadAction.compute(() -> {
            Charset charsetFromContent = LoadTextUtil.charsetFromContentOrNull((Project)project2, (VirtualFile)virtualFile2, (CharSequence)document2.getImmutableCharSequence());
            if (charsetFromContent != null) {
                EncodingManagerImpl.setCachedCharsetFromContent(charsetFromContent, null, document2);
            }
            return charsetFromContent;
        });
    }

    public void dispose() {
        this.myDisposed.set(true);
    }

    private static int addNumberOfRequestedRedetects(@NotNull Document document2, int delta) {
        AtomicInteger data2;
        if (document2 == null) {
            EncodingManagerImpl.$$$reportNull$$$0(5);
        }
        if ((data2 = (AtomicInteger)document2.getUserData(RUNNING_REDETECTS_KEY)) == null) {
            data2 = (AtomicInteger)((UserDataHolderEx)document2).putUserDataIfAbsent(RUNNING_REDETECTS_KEY, (Object)new AtomicInteger());
        }
        return data2.addAndGet(delta);
    }

    @VisibleForTesting
    public void queueUpdateEncodingFromContent(@NotNull Document document2) {
        if (document2 == null) {
            EncodingManagerImpl.$$$reportNull$$$0(6);
        }
        if (this.myDisposed.get()) {
            return;
        }
        if (EncodingManagerImpl.addNumberOfRequestedRedetects(document2, 1) == 1) {
            this.changedDocumentExecutor.execute((Runnable)new DocumentEncodingDetectRequest(document2, this.myDisposed));
        }
    }

    @Nullable
    public Charset getCachedCharsetFromContent(@NotNull Document document2) {
        if (document2 == null) {
            EncodingManagerImpl.$$$reportNull$$$0(7);
        }
        return (Charset)document2.getUserData(CACHED_CHARSET_FROM_CONTENT);
    }

    @NotNull
    public State getState() {
        State state2 = this.myState;
        if (state2 == null) {
            EncodingManagerImpl.$$$reportNull$$$0(8);
        }
        return state2;
    }

    public void loadState(@NotNull State state2) {
        if (state2 == null) {
            EncodingManagerImpl.$$$reportNull$$$0(9);
        }
        this.myState = state2;
    }

    @NotNull
    public Collection<Charset> getFavorites() {
        Project[] projects;
        HashSet<Charset> result2 = new HashSet<Charset>();
        for (Project project2 : projects = ProjectManager.getInstance().getOpenProjects()) {
            result2.addAll(EncodingProjectManager.getInstance((Project)project2).getFavorites());
        }
        result2.addAll(EncodingProjectManagerImpl.widelyKnownCharsets());
        HashSet<Charset> hashSet = result2;
        if (hashSet == null) {
            EncodingManagerImpl.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @Nullable
    public Charset getEncoding(@Nullable VirtualFile virtualFile2, boolean useParentDefaults) {
        Project project2 = EncodingManagerImpl.guessProject(virtualFile2);
        if (project2 == null) {
            return null;
        }
        EncodingProjectManager encodingManager = EncodingProjectManager.getInstance((Project)project2);
        if (encodingManager == null) {
            return null;
        }
        return encodingManager.getEncoding(virtualFile2, useParentDefaults);
    }

    public void clearDocumentQueue() {
        if (this.changedDocumentExecutor.isEmpty()) {
            return;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not call clearDocumentQueue() from under write action because some queued detectors require read action");
        }
        this.changedDocumentExecutor.cancelAndWaitAllTasksExecuted(1L, TimeUnit.MINUTES);
    }

    @TestOnly
    public void waitAllTasksExecuted() {
        try {
            this.changedDocumentExecutor.waitAllTasksExecuted(1L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    private static Project guessProject(@Nullable VirtualFile virtualFile2) {
        Project project2;
        Project project3 = project2 = virtualFile2 == null ? null : ProjectLocator.getInstance().guessProjectForFile(virtualFile2);
        if (project2 != null) {
            return project2;
        }
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        if (projectManager == null) {
            return null;
        }
        Project[] openProjects = projectManager.getOpenProjects();
        if (openProjects.length == 1) {
            return openProjects[0];
        }
        return null;
    }

    public void setEncoding(@Nullable VirtualFile virtualFileOrDir, @Nullable Charset charset) {
        Project project2 = EncodingManagerImpl.guessProject(virtualFileOrDir);
        if (project2 != null) {
            EncodingProjectManager.getInstance((Project)project2).setEncoding(virtualFileOrDir, charset);
        }
    }

    public boolean isNative2Ascii(@NotNull VirtualFile virtualFile2) {
        Project project2;
        if (virtualFile2 == null) {
            EncodingManagerImpl.$$$reportNull$$$0(11);
        }
        return (project2 = EncodingManagerImpl.guessProject(virtualFile2)) != null && EncodingProjectManager.getInstance((Project)project2).isNative2Ascii(virtualFile2);
    }

    public boolean isNative2AsciiForPropertiesFiles() {
        Project project2 = EncodingManagerImpl.guessProject(null);
        return project2 != null && EncodingProjectManager.getInstance((Project)project2).isNative2AsciiForPropertiesFiles();
    }

    public void setNative2AsciiForPropertiesFiles(VirtualFile virtualFile2, boolean native2Ascii) {
        Project project2 = EncodingManagerImpl.guessProject(virtualFile2);
        if (project2 == null) {
            return;
        }
        EncodingProjectManager.getInstance((Project)project2).setNative2AsciiForPropertiesFiles(virtualFile2, native2Ascii);
    }

    @NotNull
    public Charset getDefaultCharset() {
        Charset charset = this.myState.myDefaultEncoding.dereference();
        if (charset == null) {
            EncodingManagerImpl.$$$reportNull$$$0(12);
        }
        return charset;
    }

    @NotNull
    public String getDefaultCharsetName() {
        String string = this.myState.getDefaultCharsetName();
        if (string == null) {
            EncodingManagerImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    public void setDefaultCharsetName(@NotNull String name2) {
        if (name2 == null) {
            EncodingManagerImpl.$$$reportNull$$$0(14);
        }
        this.myState.setDefaultCharsetName(name2);
    }

    @Nullable
    public Charset getDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile2) {
        Project project2 = EncodingManagerImpl.guessProject(virtualFile2);
        if (project2 == null) {
            return null;
        }
        return EncodingProjectManager.getInstance((Project)project2).getDefaultCharsetForPropertiesFiles(virtualFile2);
    }

    public void setDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile2, Charset charset) {
        Project project2 = EncodingManagerImpl.guessProject(virtualFile2);
        if (project2 == null) {
            return;
        }
        EncodingProjectManager.getInstance((Project)project2).setDefaultCharsetForPropertiesFiles(virtualFile2, charset);
    }

    @NotNull
    public Charset getDefaultConsoleEncoding() {
        Charset charset = this.myState.myDefaultConsoleEncoding.dereference();
        if (charset == null) {
            EncodingManagerImpl.$$$reportNull$$$0(15);
        }
        return charset;
    }

    @NotNull
    public EncodingReference getDefaultConsoleEncodingReference() {
        EncodingReference encodingReference = this.myState.myDefaultConsoleEncoding;
        if (encodingReference == null) {
            EncodingManagerImpl.$$$reportNull$$$0(16);
        }
        return encodingReference;
    }

    public void setDefaultConsoleEncodingReference(@NotNull EncodingReference encodingReference) {
        if (encodingReference == null) {
            EncodingManagerImpl.$$$reportNull$$$0(17);
        }
        this.myState.myDefaultConsoleEncoding = encodingReference;
    }

    static void firePropertyChange(@Nullable Document document2, @NotNull String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null) {
            EncodingManagerImpl.$$$reportNull$$$0(18);
        }
        EncodingManagerListener publisher = (EncodingManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(EncodingManagerListener.ENCODING_MANAGER_CHANGES);
        publisher.propertyChanged(document2, propertyName, oldValue, newValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10, 12, 13, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/encoding/EncodingManagerImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encodingReference";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/encoding/EncodingManagerImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavorites";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCharset";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCharsetName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConsoleEncoding";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConsoleEncodingReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEditorOpenedFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleDocument";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setCachedCharsetFromContent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeCharsetFromContent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addNumberOfRequestedRedetects";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "queueUpdateEncodingFromContent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCachedCharsetFromContent";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isNative2Ascii";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultCharsetName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultConsoleEncodingReference";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "firePropertyChange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10, 12, 13, 15, 16 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static final class State {
        @NotNull
        private EncodingReference myDefaultEncoding = new EncodingReference(StandardCharsets.UTF_8);
        @NotNull
        private EncodingReference myDefaultConsoleEncoding = EncodingReference.DEFAULT;

        @Attribute(value="default_encoding")
        @NotNull
        public String getDefaultCharsetName() {
            String string = this.myDefaultEncoding.getCharset() == null ? "" : this.myDefaultEncoding.getCharset().name();
            if (string == null) {
                State.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void setDefaultCharsetName(@NotNull String name2) {
            if (name2 == null) {
                State.$$$reportNull$$$0(1);
            }
            this.myDefaultEncoding = new EncodingReference(StringUtil.nullize((String)name2));
        }

        @Attribute(value="default_console_encoding")
        @NotNull
        public String getDefaultConsoleEncodingName() {
            String string = this.myDefaultConsoleEncoding.getCharset() == null ? "" : this.myDefaultConsoleEncoding.getCharset().name();
            if (string == null) {
                State.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void setDefaultConsoleEncodingName(@NotNull String name2) {
            if (name2 == null) {
                State.$$$reportNull$$$0(3);
            }
            this.myDefaultConsoleEncoding = new EncodingReference(StringUtil.nullize((String)name2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/encoding/EncodingManagerImpl$State";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultCharsetName";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/encoding/EncodingManagerImpl$State";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultConsoleEncodingName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setDefaultCharsetName";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setDefaultConsoleEncodingName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class DocumentEncodingDetectRequest
    implements Runnable {
        private final Reference<Document> ref;
        @NotNull
        private final AtomicBoolean myDisposed;

        private DocumentEncodingDetectRequest(@NotNull Document document2, @NotNull AtomicBoolean disposed) {
            if (document2 == null) {
                DocumentEncodingDetectRequest.$$$reportNull$$$0(0);
            }
            if (disposed == null) {
                DocumentEncodingDetectRequest.$$$reportNull$$$0(1);
            }
            this.ref = new WeakReference<Document>(document2);
            this.myDisposed = disposed;
        }

        @Override
        public void run() {
            if (this.myDisposed.get()) {
                return;
            }
            Document document2 = this.ref.get();
            if (document2 == null) {
                return;
            }
            ((EncodingManagerImpl)EncodingManager.getInstance()).handleDocument(document2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "disposed";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vfs/encoding/EncodingManagerImpl$DocumentEncodingDetectRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

