/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.FilePartNode;
import com.intellij.openapi.vfs.impl.UrlPartNode;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class FilePartNodeRoot
extends FilePartNode {
    private FilePartNodeRoot(@NotNull NewVirtualFileSystem fs) {
        if (fs == null) {
            FilePartNodeRoot.$$$reportNull$$$0(0);
        }
        super(fs);
    }

    @Override
    public String toString() {
        return "root -> " + this.children.length;
    }

    @Override
    @NotNull
    CharSequence getName() {
        return "";
    }

    @NotNull
    VirtualFilePointerManagerImpl.NodeToUpdate findOrCreateByFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FilePartNodeRoot.$$$reportNull$$$0(1);
        }
        int nameId = FilePartNodeRoot.getNameId(file2);
        NewVirtualFileSystem fs = (NewVirtualFileSystem)file2.getFileSystem();
        VirtualFile parent = FilePartNodeRoot.getParentThroughJar(file2, fs);
        VirtualFilePointerManagerImpl.NodeToUpdate nodeToUpdate = this.matchById(parent, file2, nameId, (MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl>)new MultiMap(), true, true, fs);
        if (nodeToUpdate == null) {
            FilePartNodeRoot.$$$reportNull$$$0(2);
        }
        return nodeToUpdate;
    }

    void addRelevantPointersFrom(@NotNull VirtualFileSystemEntry parent, @Nullable VirtualFile file2, int childNameId, @NotNull MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl> toFirePointers, @NotNull List<? super VirtualFilePointerManagerImpl.NodeToUpdate> toUpdateNodes, boolean addSubdirectoryPointers, @NotNull NewVirtualFileSystem fs, boolean addRecursiveDirectoryPointers, @NotNull VFileEvent event) {
        VirtualFilePointerManagerImpl.NodeToUpdate toUpdate;
        if (parent == null) {
            FilePartNodeRoot.$$$reportNull$$$0(3);
        }
        if (toFirePointers == null) {
            FilePartNodeRoot.$$$reportNull$$$0(4);
        }
        if (toUpdateNodes == null) {
            FilePartNodeRoot.$$$reportNull$$$0(5);
        }
        if (fs == null) {
            FilePartNodeRoot.$$$reportNull$$$0(6);
        }
        if (event == null) {
            FilePartNodeRoot.$$$reportNull$$$0(7);
        }
        if ((toUpdate = this.matchById((VirtualFile)parent, file2, childNameId, toFirePointers, false, addRecursiveDirectoryPointers, fs)) != null) {
            toUpdate.myEvent = event;
            toUpdateNodes.add(toUpdate);
            toUpdate.node.processPointers(pointer -> toFirePointers.putValue((Object)pointer.myListener, (Object)pointer));
            if (addSubdirectoryPointers) {
                FilePartNodeRoot.addAllPointersStrictlyUnder(toUpdate.node, toFirePointers);
            }
        }
    }

    private static void addAllPointersStrictlyUnder(@NotNull FilePartNode node, @NotNull MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl> toFirePointers) {
        if (node == null) {
            FilePartNodeRoot.$$$reportNull$$$0(8);
        }
        if (toFirePointers == null) {
            FilePartNodeRoot.$$$reportNull$$$0(9);
        }
        for (FilePartNode child : node.children) {
            child.processPointers(pointer -> toFirePointers.putValue((Object)pointer.myListener, (Object)pointer));
            FilePartNodeRoot.addAllPointersStrictlyUnder(child, toFirePointers);
        }
    }

    @Contract(value="_, _, _, _, true, _, _ -> !null")
    private VirtualFilePointerManagerImpl.NodeToUpdate matchById(@Nullable VirtualFile parent, @Nullable VirtualFile file2, int childNameId, @NotNull MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl> toFirePointers, boolean createIfNotFound, boolean addRecursiveDirectoryPtr, @NotNull NewVirtualFileSystem childFs) {
        if (toFirePointers == null) {
            FilePartNodeRoot.$$$reportNull$$$0(10);
        }
        if (childFs == null) {
            FilePartNodeRoot.$$$reportNull$$$0(11);
        }
        if (childNameId <= 0 && childNameId != -2) {
            throw new IllegalArgumentException("invalid argument childNameId: " + childNameId);
        }
        if (file2 != null) {
            VirtualFileSystem fsFromFile = file2.getFileSystem();
            assert (childFs == fsFromFile) : "fs=" + String.valueOf(childFs) + "; file.fs=" + String.valueOf(fsFromFile) + "; parent=" + String.valueOf(parent) + "; file=" + String.valueOf(file2);
        }
        List<Object> hierarchy = parent == null ? Collections.emptyList() : FilePartNodeRoot.getHierarchy(parent);
        FilePartNode node = this;
        for (int i2 = hierarchy.size() - 1; i2 >= 0; --i2) {
            int nameId;
            VirtualFile part = (VirtualFile)hierarchy.get(i2);
            FilePartNode child = node.findChildByNameId(part, nameId = FilePartNodeRoot.getNameId(part), createIfNotFound, (NewVirtualFileSystem)part.getFileSystem());
            if (child == null) {
                return null;
            }
            if (child instanceof UrlPartNode) {
                child = child.replaceWithFPPN(part, node);
            }
            if (addRecursiveDirectoryPtr) {
                child.addRecursiveDirectoryPtrTo(toFirePointers);
            }
            node = child;
        }
        FilePartNode child = node.findChildByNameId(file2, childNameId, createIfNotFound, childFs);
        return child == null ? null : new VirtualFilePointerManagerImpl.NodeToUpdate(node, child);
    }

    @NotNull
    private static List<VirtualFile> getHierarchy(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FilePartNodeRoot.$$$reportNull$$$0(12);
        }
        NewVirtualFileSystem fs = (NewVirtualFileSystem)file2.getFileSystem();
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        while (true) {
            result2.add(file2);
            file2 = FilePartNodeRoot.getParentThroughJar(file2, fs);
            if (file2 == null) break;
            fs = (NewVirtualFileSystem)file2.getFileSystem();
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            FilePartNodeRoot.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    VirtualFilePointerManagerImpl.NodeToUpdate findOrCreateByPath(@NotNull String path, @NotNull NewVirtualFileSystem fs) {
        String relativePathInsideJar;
        LocalFileSystem currentFS;
        if (path == null) {
            FilePartNodeRoot.$$$reportNull$$$0(14);
        }
        if (fs == null) {
            FilePartNodeRoot.$$$reportNull$$$0(15);
        }
        if (fs instanceof ArchiveFileSystem) {
            currentFS = LocalFileSystem.getInstance();
            int i2 = path.lastIndexOf("!/");
            if (i2 == -1) {
                relativePathInsideJar = "!/";
            } else {
                relativePathInsideJar = path.substring(i2);
                path = path.substring(0, i2);
            }
        } else {
            currentFS = fs;
            relativePathInsideJar = "";
        }
        NewVirtualFileSystem.PathFromRoot pair = NewVirtualFileSystem.extractRootFromPath((NewVirtualFileSystem)currentFS, (String)path);
        Object pathFromRoot = pair == null ? path : pair.pathFromRoot();
        pathFromRoot = (String)pathFromRoot + relativePathInsideJar;
        List<String> names = FilePartNodeRoot.splitNames((String)pathFromRoot);
        NewVirtualFile fsRoot = pair == null ? null : pair.root();
        FilePartNode currentNode = this;
        FilePartNodeRoot parentNode = this;
        if (fsRoot != null) {
            FilePartNode child = new FilePartNode(FilePartNodeRoot.getNameId((VirtualFile)fsRoot), fsRoot, (NewVirtualFileSystem)currentFS);
            int index = this.binarySearchChildByName(fsRoot.getNameSequence());
            if (index >= 0) {
                currentNode = currentNode.children[index];
            } else {
                currentNode.children = (FilePartNode[])ArrayUtil.insert((Object[])currentNode.children, (int)(-index - 1), (Object)child);
                if (currentNode.children.length >= 2) {
                    Arrays.sort(currentNode.children, (c1, c2) -> StringUtil.compare((CharSequence)c1.getName(), (CharSequence)c2.getName(), (!this.isCaseSensitive() ? 1 : 0) != 0));
                }
                currentNode = child;
            }
        }
        return FilePartNodeRoot.trieDescend(fs, (NewVirtualFileSystem)currentFS, names, fsRoot, currentNode, parentNode);
    }

    @NotNull
    private static VirtualFilePointerManagerImpl.NodeToUpdate trieDescend(@NotNull NewVirtualFileSystem fs, @NotNull NewVirtualFileSystem currentFS, @NotNull List<String> names, @Nullable NewVirtualFile fsRoot, @NotNull FilePartNode currentNode, @NotNull FilePartNode parentNode) {
        NullVirtualFile NEVER_TRIED_TO_FIND;
        if (fs == null) {
            FilePartNodeRoot.$$$reportNull$$$0(16);
        }
        if (currentFS == null) {
            FilePartNodeRoot.$$$reportNull$$$0(17);
        }
        if (names == null) {
            FilePartNodeRoot.$$$reportNull$$$0(18);
        }
        if (currentNode == null) {
            FilePartNodeRoot.$$$reportNull$$$0(19);
        }
        if (parentNode == null) {
            FilePartNodeRoot.$$$reportNull$$$0(20);
        }
        NullVirtualFile currentFile = NEVER_TRIED_TO_FIND = NullVirtualFile.INSTANCE;
        for (int i2 = names.size() - 1; i2 >= 0; --i2) {
            String name2 = names.get(i2);
            currentFS = FilePartNodeRoot.enterJar(fs, currentFS, name2);
            int index = currentNode.binarySearchChildByName(name2);
            if (index >= 0) {
                parentNode = currentNode;
                currentNode = currentNode.children[index];
                currentFile = currentFile == NEVER_TRIED_TO_FIND || currentFile == null ? currentFile : currentFile.findChild(name2);
                continue;
            }
            if (currentFile == NEVER_TRIED_TO_FIND) {
                currentFile = (fsRoot = FilePartNodeRoot.findRoot(fs, names, fsRoot)) == null ? null : FilePartNodeRoot.findFileFromRoot(fsRoot, currentFS, names, i2);
            } else {
                VirtualFile virtualFile2 = currentFile = currentFile == null ? null : FilePartNodeRoot.findChildThroughJar((VirtualFile)currentFile, name2, currentFS);
            }
            if (currentFile != null && currentFile != NEVER_TRIED_TO_FIND && !currentFile.getName().equals(name2) && (index = currentNode.binarySearchChildByName(name2 = currentFile.getName())) >= 0) {
                parentNode = currentNode;
                currentNode = currentNode.children[index];
                continue;
            }
            FilePartNode child = FilePartNodeRoot.createNode(currentFS, currentNode, (VirtualFile)currentFile, name2);
            currentNode.children = (FilePartNode[])ArrayUtil.insert((Object[])currentNode.children, (int)(-index - 1), (Object)child);
            parentNode = currentNode;
            currentNode = child;
        }
        return new VirtualFilePointerManagerImpl.NodeToUpdate(parentNode, currentNode);
    }

    @NotNull
    private static FilePartNode createNode(@NotNull NewVirtualFileSystem currentFS, @NotNull FilePartNode currentNode, @Nullable VirtualFile currentFile, @NotNull String name2) {
        if (currentFS == null) {
            FilePartNodeRoot.$$$reportNull$$$0(21);
        }
        if (currentNode == null) {
            FilePartNodeRoot.$$$reportNull$$$0(22);
        }
        if (name2 == null) {
            FilePartNodeRoot.$$$reportNull$$$0(23);
        }
        if (currentFile == null) {
            return new UrlPartNode(name2, FilePartNodeRoot.urlOf(currentNode.fileOrUrl), currentFS);
        }
        int nameId = name2.equals("!/") ? -2 : FilePartNodeRoot.getNameId(currentFile);
        return new FilePartNode(nameId, currentFile, currentFS);
    }

    @Nullable
    private static NewVirtualFile findRoot(@NotNull NewVirtualFileSystem fs, @NotNull List<String> names, @Nullable NewVirtualFile fsRoot) {
        if (fs == null) {
            FilePartNodeRoot.$$$reportNull$$$0(24);
        }
        if (names == null) {
            FilePartNodeRoot.$$$reportNull$$$0(25);
        }
        if (fsRoot == null) {
            String rootName = (String)ContainerUtil.getLastItem(names);
            fsRoot = ManagingFS.getInstance().findRoot(rootName, (NewVirtualFileSystem)(fs instanceof ArchiveFileSystem ? LocalFileSystem.getInstance() : fs));
            if (fsRoot != null && !StringUtilRt.equal((CharSequence)fsRoot.getName(), (CharSequence)rootName, (boolean)fsRoot.isCaseSensitive())) {
                fsRoot = null;
            }
        }
        return fsRoot;
    }

    private static NewVirtualFileSystem enterJar(@NotNull NewVirtualFileSystem fs, @NotNull NewVirtualFileSystem currentFS, @NotNull String name2) {
        if (fs == null) {
            FilePartNodeRoot.$$$reportNull$$$0(26);
        }
        if (currentFS == null) {
            FilePartNodeRoot.$$$reportNull$$$0(27);
        }
        if (name2 == null) {
            FilePartNodeRoot.$$$reportNull$$$0(28);
        }
        if (name2.equals("!/") && currentFS instanceof LocalFileSystem) {
            currentFS = fs;
        }
        return currentFS;
    }

    @NotNull
    static List<String> splitNames(@NotNull String path) {
        int end;
        if (path == null) {
            FilePartNodeRoot.$$$reportNull$$$0(29);
        }
        if ((end = path.length()) == 0) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                FilePartNodeRoot.$$$reportNull$$$0(30);
            }
            return list2;
        }
        ArrayList<String> names = new ArrayList<String>(Math.max(20, end / 4));
        while (true) {
            boolean isJarSeparator;
            boolean bl = isJarSeparator = StringUtil.endsWith((CharSequence)path, (int)0, (int)end, (CharSequence)"!/") && (end == 2 && SystemInfo.isWindows || end > 2 && path.charAt(end - 3) != '/');
            if (isJarSeparator) {
                names.add("!/");
                end -= 2;
            }
            if (end != 0 && path.charAt(end - 1) == '/') {
                --end;
            }
            if (end == 0) break;
            int startIndex = FilePartNodeRoot.extractName(path, end);
            assert (startIndex != end) : "startIndex: " + startIndex + "; end: " + end + "; path:'" + path + "'; toExtract: '" + path.substring(0, end) + "'";
            names.add(path.substring(startIndex, end));
            if (startIndex == 0) break;
            end = startIndex;
        }
        ArrayList<String> arrayList = names;
        if (arrayList == null) {
            FilePartNodeRoot.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    private static VirtualFile findFileFromRoot(@NotNull NewVirtualFile root, @NotNull NewVirtualFileSystem fs, @NotNull List<String> names, int startIndex) {
        String name2;
        if (root == null) {
            FilePartNodeRoot.$$$reportNull$$$0(32);
        }
        if (fs == null) {
            FilePartNodeRoot.$$$reportNull$$$0(33);
        }
        if (names == null) {
            FilePartNodeRoot.$$$reportNull$$$0(34);
        }
        NewVirtualFile file2 = root;
        for (int i2 = names.size() - 1; i2 >= startIndex && (file2 = FilePartNodeRoot.findChildThroughJar((VirtualFile)file2, name2 = names.get(i2), fs)) != null; --i2) {
        }
        return file2;
    }

    private static int extractName(@NotNull CharSequence path, int endOffset) {
        int i2;
        if (path == null) {
            FilePartNodeRoot.$$$reportNull$$$0(35);
        }
        if ((i2 = StringUtil.lastIndexOf((CharSequence)path, (char)'/', (int)0, (int)endOffset)) != -1 && PathUtilRt.isWindowsUNCRoot((CharSequence)path, (int)i2)) {
            return 0;
        }
        return i2 + 1;
    }

    void removePointer(@NotNull VirtualFilePointerImpl pointer) {
        FilePartNode node;
        int remainingLeaves;
        if (pointer == null) {
            FilePartNodeRoot.$$$reportNull$$$0(36);
        }
        if ((remainingLeaves = (node = pointer.myNode).removeLeaf(pointer)) == 0) {
            VirtualFile file2 = FilePartNodeRoot.fileOrNull(node.fileOrUrl);
            if (file2 == null) {
                this.removeEmptyNodesByPath(VfsUtilCore.urlToPath((String)FilePartNodeRoot.urlOf(node.fileOrUrl)));
            } else {
                List<VirtualFile> parts = FilePartNodeRoot.getHierarchy(file2);
                this.removeEmptyNodesByFile(parts);
            }
        }
    }

    void checkConsistency() {
        if (VirtualFilePointerManagerImpl.shouldCheckConsistency()) {
            this.doCheckConsistency(null, "", this.fs.getProtocol() + "://");
        }
    }

    @VisibleForTesting
    @NotNull
    public static FilePartNodeRoot createFakeRoot(@NotNull NewVirtualFileSystem fs) {
        if (fs == null) {
            FilePartNodeRoot.$$$reportNull$$$0(37);
        }
        return new FilePartNodeRoot(fs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 13, 30, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 13: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/FilePartNodeRoot";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFirePointers";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toUpdateNodes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childFs";
                break;
            }
            case 14: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 17: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFS";
                break;
            }
            case 18: 
            case 25: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentNode";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/FilePartNodeRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateByFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchy";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "splitNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateByFile";
                break;
            }
            case 2: 
            case 13: 
            case 30: 
            case 31: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addRelevantPointersFrom";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addAllPointersStrictlyUnder";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "matchById";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchy";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateByPath";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "trieDescend";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createNode";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findRoot";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "enterJar";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "splitNames";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findFileFromRoot";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "extractName";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removePointer";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createFakeRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 13, 30, 31 -> new IllegalStateException(string);
        };
    }
}

