/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.monitoring;

import com.intellij.ide.util.RunOnceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.vfs.newvfs.monitoring.VFSInitKind;
import com.intellij.openapi.vfs.newvfs.monitoring.VfsUsageCollector;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecordsImpl;
import com.intellij.openapi.vfs.newvfs.persistent.VFSInitException;
import com.intellij.openapi.vfs.newvfs.persistent.recovery.VFSInitializationResult;
import com.intellij.openapi.vfs.newvfs.persistent.recovery.VFSRecoveryInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0005H\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vfs/newvfs/monitoring/VFSInitializationConditionsToFusReporter;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reportToFUS", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nVFSInitializationConditionsToFusReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VFSInitializationConditionsToFusReporter.kt\ncom/intellij/openapi/vfs/newvfs/monitoring/VFSInitializationConditionsToFusReporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n812#2,12:143\n1586#2:155\n1661#2,3:156\n812#2,12:159\n1586#2:171\n1661#2,3:172\n1586#2:175\n1661#2,3:176\n*S KotlinDebug\n*F\n+ 1 VFSInitializationConditionsToFusReporter.kt\ncom/intellij/openapi/vfs/newvfs/monitoring/VFSInitializationConditionsToFusReporter\n*L\n48#1:143,12\n49#1:155\n49#1:156,3\n75#1:159,12\n76#1:171\n76#1:172,3\n77#1:175\n77#1:176,3\n*E\n"})
public final class VFSInitializationConditionsToFusReporter
implements ProjectActivity {
    @Nullable
    public Object execute(@NotNull Project project2, @NotNull Continuation<? super Unit> $completion) {
        String string = VFSInitializationConditionsToFusReporter.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        RunOnceUtil.runOnceForApp((String)string, () -> VFSInitializationConditionsToFusReporter.execute$lambda$0(this));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportToFUS() {
        VFSInitException it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Iterable $this$map$iv;
        boolean $i$f$map;
        void $this$filterIsInstanceTo$iv$iv;
        boolean $i$f$filterIsInstanceTo;
        Collection destination$iv$iv;
        boolean $i$f$filterIsInstance;
        Iterable $this$filterIsInstance$iv;
        VFSInitKind vFSInitKind;
        FSRecordsImpl fSRecordsImpl = FSRecords.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fSRecordsImpl, (String)"getInstance(...)");
        FSRecordsImpl vfs = fSRecordsImpl;
        int vfsImplementationVersion = vfs.getVersion();
        long creationTimestamp = vfs.getCreationTimestamp();
        VFSInitializationResult initializationResult = vfs.initializationResult();
        VFSRecoveryInfo vFSRecoveryInfo = vfs.connection().recoveryInfo();
        Intrinsics.checkNotNullExpressionValue((Object)vFSRecoveryInfo, (String)"recoveryInfo(...)");
        VFSRecoveryInfo recoveryInfo = vFSRecoveryInfo;
        List<Throwable> list2 = initializationResult.attemptsFailures;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"attemptsFailures");
        List<Throwable> initializationFailures = list2;
        boolean wasCreateANew = initializationResult.vfsCreatedAnew;
        long totalInitializationDurationMs = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((long)initializationResult.totalInitializationDurationNs, (DurationUnit)DurationUnit.NANOSECONDS));
        if (initializationFailures.isEmpty()) {
            vFSInitKind = wasCreateANew ? VFSInitKind.CREATED_EMPTY : (recoveryInfo.recoveredErrors.isEmpty() ? VFSInitKind.LOADED_NORMALLY : VFSInitKind.RECOVERED);
        } else {
            $this$filterIsInstance$iv = initializationFailures;
            $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof VFSInitException)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                VFSInitException vFSInitException = (VFSInitException)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.category());
            }
            VFSInitException.ErrorCategory errorCategory = (VFSInitException.ErrorCategory)((Object)CollectionsKt.firstOrNull((List)((List)destination$iv$iv)));
            switch (errorCategory == null ? -1 : WhenMappings.$EnumSwitchMapping$0[errorCategory.ordinal()]) {
                case -1: {
                    vFSInitKind = VFSInitKind.UNRECOGNIZED;
                    break;
                }
                case 1: {
                    vFSInitKind = VFSInitKind.UNRECOGNIZED;
                    break;
                }
                case 2: {
                    vFSInitKind = VFSInitKind.HAS_ERRORS_IN_PREVIOUS_SESSION;
                    break;
                }
                case 3: {
                    vFSInitKind = VFSInitKind.SCHEDULED_REBUILD;
                    break;
                }
                case 4: {
                    vFSInitKind = VFSInitKind.DEFRAGMENTATION_REQUESTED;
                    break;
                }
                case 5: {
                    vFSInitKind = VFSInitKind.NOT_CLOSED_PROPERLY;
                    break;
                }
                case 6: {
                    vFSInitKind = VFSInitKind.IMPL_VERSION_MISMATCH;
                    break;
                }
                case 7: {
                    vFSInitKind = VFSInitKind.NAME_STORAGE_INCOMPLETE;
                    break;
                }
                case 8: {
                    vFSInitKind = VFSInitKind.ATTRIBUTES_STORAGE_CORRUPTED;
                    break;
                }
                case 9: {
                    vFSInitKind = VFSInitKind.CONTENT_STORAGES_INCOMPLETE;
                    break;
                }
                case 10: {
                    vFSInitKind = VFSInitKind.CONTENT_STORAGES_NOT_MATCH;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        VFSInitKind vfsInitKind = vFSInitKind;
        $this$filterIsInstance$iv = initializationFailures;
        $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof VFSInitException)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (VFSInitException)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.category());
        }
        Collection collection2 = (List)destination$iv$iv;
        List<VFSInitException> list3 = recoveryInfo.recoveredErrors;
        Intrinsics.checkNotNullExpressionValue(list3, (String)"recoveredErrors");
        $this$map$iv = list3;
        collection = collection2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (VFSInitException)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add(it.category());
        }
        List errorsHappenedDuringInit = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        VfsUsageCollector.logVfsInitialization(vfsImplementationVersion, creationTimestamp, vfsInitKind, errorsHappenedDuringInit, initializationFailures.size() + 1, totalInitializationDurationMs);
    }

    private static final void execute$lambda$0(VFSInitializationConditionsToFusReporter this$0) {
        this$0.reportToFUS();
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VFSInitException.ErrorCategory.values().length];
            try {
                nArray[VFSInitException.ErrorCategory.UNRECOGNIZED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VFSInitException.ErrorCategory.HAS_ERRORS_IN_PREVIOUS_SESSION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VFSInitException.ErrorCategory.SCHEDULED_REBUILD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VFSInitException.ErrorCategory.DEFRAGMENTATION_REQUESTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VFSInitException.ErrorCategory.NOT_CLOSED_PROPERLY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VFSInitException.ErrorCategory.IMPL_VERSION_MISMATCH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VFSInitException.ErrorCategory.NAME_STORAGE_INCOMPLETE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VFSInitException.ErrorCategory.ATTRIBUTES_STORAGE_CORRUPTED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VFSInitException.ErrorCategory.CONTENT_STORAGES_INCOMPLETE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VFSInitException.ErrorCategory.CONTENT_STORAGES_NOT_MATCH.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

