/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.ContentTooBigException;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.ZipHandlerBase;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.persistent.DefaultInMemoryInvertedNameIndex;
import com.intellij.openapi.vfs.newvfs.persistent.FileRecordLock;
import com.intellij.openapi.vfs.newvfs.persistent.IPersistentFSRecordsStorage;
import com.intellij.openapi.vfs.newvfs.persistent.InvertedNameIndex;
import com.intellij.openapi.vfs.newvfs.persistent.ListResult;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSAttributeAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnector;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSContentAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorage;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorageFactory;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSTreeAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSTreeRawAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFsConnectorHelper;
import com.intellij.openapi.vfs.newvfs.persistent.namecache.FileNameCache;
import com.intellij.openapi.vfs.newvfs.persistent.namecache.MRUFileNameCache;
import com.intellij.openapi.vfs.newvfs.persistent.namecache.SLRUFileNameCache;
import com.intellij.openapi.vfs.newvfs.persistent.recovery.VFSInitializationResult;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.BitUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.SlowOperations;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.ClosedStorageException;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.io.DataEnumeratorEx;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.blobstorage.ByteBufferReader;
import com.intellij.util.io.blobstorage.ByteBufferWriter;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.zip.ZipException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class FSRecordsImpl
implements Closeable {
    private static final Logger LOG = Logger.getInstance(FSRecordsImpl.class);
    private static final boolean BACKGROUND_VFS_FLUSH = SystemProperties.getBooleanProperty((String)"vfs.flushing.use-background-flush", (boolean)true);
    private static final boolean USE_GENTLE_FLUSHER = SystemProperties.getBooleanProperty((String)"vfs.flushing.use-gentle-flusher", (boolean)false);
    private static final String NAME_CACHE_IMPL = System.getProperty("vfs.name-cache.impl", "mru");
    private static final boolean USE_FILE_NAME_CACHE = !"none".equals(NAME_CACHE_IMPL);
    private static final boolean USE_MRU_FILE_NAME_CACHE = "mru".equals(NAME_CACHE_IMPL);
    private static final String CONTENT_STORAGE_IMPL = System.getProperty("vfs.content-storage.impl", "over-mmapped-file");
    public static final boolean USE_CONTENT_STORAGE_OVER_NEW_FILE_PAGE_CACHE = "over-lock-free-page-cache".equals(CONTENT_STORAGE_IMPL);
    public static final boolean USE_CONTENT_STORAGE_OVER_MMAPPED_FILE = "over-mmapped-file".equals(CONTENT_STORAGE_IMPL);
    private static final String CONTENT_HASH_IMPL = System.getProperty("vfs.content-hash-storage.impl", "over-mmapped-file");
    public static final boolean USE_CONTENT_HASH_STORAGE_OVER_MMAPPED_FILE = "over-mmapped-file".equals(CONTENT_HASH_IMPL);
    public static final int COMPRESS_CONTENT_IF_LARGER_THAN = SystemProperties.getIntProperty((String)"vfs.content-storage.compress-if-larger", (int)8000);
    public static final String COMPRESSION_ALGO = System.getProperty("vfs.content-storage-compression", "lz4");
    public static final boolean REUSE_DELETED_FILE_IDS = SystemProperties.getBooleanProperty((String)"vfs.reuse-deleted-file-ids", (boolean)false);
    private static final long EMULATE_FAILURES_WITH_DELAY_MS = SystemProperties.getLongProperty((String)"vfs.debug.emulate-failures-starting-with-ms", (long)-1L);
    private static final FileAttribute SYMLINK_TARGET_ATTRIBUTE = new FileAttribute("FsRecords.SYMLINK_TARGET");
    public static final ErrorHandler ON_ERROR_MARK_CORRUPTED_AND_SCHEDULE_REBUILD = (records, error2) -> {
        if (!records.isClosed()) {
            records.connection.markAsCorruptedAndScheduleRebuild(error2);
        } else {
            error2.addSuppressed(records.alreadyClosedException());
        }
        if (error2 instanceof IOException) {
            IOException ioException = (IOException)error2;
            throw new UncheckedIOException(ioException);
        }
        ExceptionUtil.rethrow((Throwable)error2);
    };
    public static final ErrorHandler ON_ERROR_RETHROW = (__, error2) -> ExceptionUtil.rethrow((Throwable)error2);
    @NotNull
    private final PersistentFSConnection connection;
    @NotNull
    private final PersistentFSContentAccessor contentAccessor;
    @NotNull
    private final PersistentFSAttributeAccessor attributeAccessor;
    @NotNull
    private final PersistentFSTreeAccessor treeAccessor;
    @NotNull
    private final PersistentFSRecordAccessor recordAccessor;
    @NotNull
    private final ErrorHandler errorHandler;
    @NotNull
    private final VFSInitializationResult initializationResult;
    @NotNull
    private final Supplier<InvertedNameIndex> invertedNameIndexLazy;
    private final AtomicLong invertedNameIndexModCount;
    private final AtomicLong invertedNameIndexRequestsServed;
    @Nullable
    private final Closeable flushingTask;
    private final DataEnumeratorEx<String> fileNamesEnumerator;
    private final int currentVersion;
    private final FileRecordLock fileRecordLock;
    private volatile Exception closedStackTrace;
    private final Set<AutoCloseable> closeables;
    private final CopyOnWriteArraySet<FileIdIndexedStorage> fileIdIndexedStorages;

    public static ErrorHandler defaultErrorHandler() {
        return ON_ERROR_MARK_CORRUPTED_AND_SCHEDULE_REBUILD;
    }

    private static int nextMask(int value, int bits, int prevMask) {
        assert (value < 1 << bits && value >= 0) : value;
        int mask = prevMask << bits | value;
        if (mask < 0) {
            throw new IllegalStateException("Too many flags, int mask overflown");
        }
        return mask;
    }

    private static int nextMask(boolean value, int prevMask) {
        return FSRecordsImpl.nextMask(value ? 1 : 0, 1, prevMask);
    }

    public static int currentImplementationVersion() {
        int mainVFSFormatVersion = 64;
        return FSRecordsImpl.nextMask(mainVFSFormatVersion + PersistentFSRecordsStorageFactory.storageImplementation().getId(), 8, FSRecordsImpl.nextMask(!USE_CONTENT_STORAGE_OVER_MMAPPED_FILE, FSRecordsImpl.nextMask(IOUtil.useNativeByteOrderForByteBuffers(), FSRecordsImpl.nextMask(false, FSRecordsImpl.nextMask(true, FSRecordsImpl.nextMask(SystemProperties.getBooleanProperty((String)"idea.fs.roots.data.loader", (boolean)false), FSRecordsImpl.nextMask(true, FSRecordsImpl.nextMask(true, FSRecordsImpl.nextMask(true, FSRecordsImpl.nextMask(false, FSRecordsImpl.nextMask(ZipHandlerBase.getUseCrcInsteadOfTimestampPropertyValue(), FSRecordsImpl.nextMask(true, FSRecordsImpl.nextMask(true, 0)))))))))))));
    }

    public static FSRecordsImpl connect(@NotNull Path storagesDirectoryPath) throws UncheckedIOException {
        if (storagesDirectoryPath == null) {
            FSRecordsImpl.$$$reportNull$$$0(0);
        }
        return FSRecordsImpl.connect(storagesDirectoryPath, FSRecordsImpl.defaultErrorHandler());
    }

    public static FSRecordsImpl connect(@NotNull Path storagesDirectoryPath, @NotNull ErrorHandler errorHandler) throws UncheckedIOException {
        if (storagesDirectoryPath == null) {
            FSRecordsImpl.$$$reportNull$$$0(1);
        }
        if (errorHandler == null) {
            FSRecordsImpl.$$$reportNull$$$0(2);
        }
        if (IOUtil.isSharedCachesEnabled()) {
            IOUtil.OVERRIDE_BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER_PROP.set(false);
        }
        try {
            int currentVersion = FSRecordsImpl.currentImplementationVersion();
            VFSInitializationResult initializationResult = PersistentFSConnector.connect(storagesDirectoryPath, currentVersion);
            PersistentFSConnection connection = initializationResult.connection;
            Supplier<InvertedNameIndex> invertedNameIndexLazy = FSRecordsImpl.asyncFillInvertedNameIndex(connection.records());
            LOG.info("VFS initialized: " + TimeUnit.NANOSECONDS.toMillis(initializationResult.totalInitializationDurationNs) + " ms, " + initializationResult.attemptsFailures.size() + " failed attempts, " + initializationResult.connection.recoveryInfo().recoveredErrors.size() + " error(s) were recovered");
            PersistentFSContentAccessor contentAccessor = new PersistentFSContentAccessor(connection);
            PersistentFSAttributeAccessor attributeAccessor = new PersistentFSAttributeAccessor(connection);
            PersistentFSRecordAccessor recordAccessor = new PersistentFSRecordAccessor(contentAccessor, attributeAccessor, connection);
            PersistentFSTreeAccessor treeAccessor = attributeAccessor.supportsRawAccess() ? new PersistentFSTreeRawAccessor(attributeAccessor, recordAccessor, connection) : new PersistentFSTreeAccessor(attributeAccessor, recordAccessor, connection);
            try {
                treeAccessor.ensureLoaded();
                FSRecordsImpl fSRecordsImpl = new FSRecordsImpl(connection, contentAccessor, attributeAccessor, treeAccessor, recordAccessor, invertedNameIndexLazy, currentVersion, errorHandler, initializationResult);
                return fSRecordsImpl;
            }
            catch (Throwable e) {
                try {
                    invertedNameIndexLazy.get();
                }
                catch (Throwable scanningEx) {
                    e.addSuppressed(scanningEx);
                }
                try {
                    connection.close();
                }
                catch (Throwable closingEx) {
                    e.addSuppressed(closingEx);
                }
                LOG.error(e);
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new UncheckedIOException((IOException)e);
            }
        }
        finally {
            IOUtil.OVERRIDE_BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER_PROP.remove();
        }
    }

    private FSRecordsImpl(@NotNull PersistentFSConnection connection, @NotNull PersistentFSContentAccessor contentAccessor, @NotNull PersistentFSAttributeAccessor attributeAccessor, @NotNull PersistentFSTreeAccessor treeAccessor, @NotNull PersistentFSRecordAccessor recordAccessor, @NotNull Supplier<InvertedNameIndex> invertedNameIndexLazy, int currentVersion, @NotNull ErrorHandler errorHandler, @NotNull VFSInitializationResult initializationResult) {
        if (connection == null) {
            FSRecordsImpl.$$$reportNull$$$0(3);
        }
        if (contentAccessor == null) {
            FSRecordsImpl.$$$reportNull$$$0(4);
        }
        if (attributeAccessor == null) {
            FSRecordsImpl.$$$reportNull$$$0(5);
        }
        if (treeAccessor == null) {
            FSRecordsImpl.$$$reportNull$$$0(6);
        }
        if (recordAccessor == null) {
            FSRecordsImpl.$$$reportNull$$$0(7);
        }
        if (invertedNameIndexLazy == null) {
            FSRecordsImpl.$$$reportNull$$$0(8);
        }
        if (errorHandler == null) {
            FSRecordsImpl.$$$reportNull$$$0(9);
        }
        if (initializationResult == null) {
            FSRecordsImpl.$$$reportNull$$$0(10);
        }
        this.invertedNameIndexModCount = new AtomicLong();
        this.invertedNameIndexRequestsServed = new AtomicLong();
        this.fileRecordLock = new FileRecordLock();
        this.closedStackTrace = null;
        this.closeables = new HashSet<AutoCloseable>();
        this.fileIdIndexedStorages = new CopyOnWriteArraySet();
        this.connection = connection;
        this.contentAccessor = contentAccessor;
        this.attributeAccessor = attributeAccessor;
        this.treeAccessor = treeAccessor;
        this.recordAccessor = recordAccessor;
        this.errorHandler = errorHandler;
        this.invertedNameIndexLazy = invertedNameIndexLazy;
        this.currentVersion = currentVersion;
        this.initializationResult = initializationResult;
        if (USE_FILE_NAME_CACHE) {
            FileNameCache cacheOverEnumerator = USE_MRU_FILE_NAME_CACHE ? new MRUFileNameCache((DataEnumeratorEx<String>)connection.names()) : new SLRUFileNameCache((DataEnumeratorEx<String>)connection.names());
            this.closeables.add(cacheOverEnumerator);
            this.fileNamesEnumerator = cacheOverEnumerator;
        } else {
            this.fileNamesEnumerator = connection.names();
        }
        if (BACKGROUND_VFS_FLUSH) {
            ScheduledExecutorService scheduler = AppExecutorUtil.getAppScheduledExecutorService();
            this.flushingTask = PersistentFSConnection.startFlusher(scheduler, connection, USE_GENTLE_FLUSHER);
        } else {
            this.flushingTask = null;
        }
    }

    @Override
    public synchronized void close() {
        if (!this.connection.isClosed()) {
            LOG.info("VFS closing");
            Exception stackTraceEx = new Exception("FSRecordsImpl close stacktrace");
            if (this.flushingTask != null) {
                try {
                    this.flushingTask.close();
                }
                catch (Exception stoppingEx) {
                    LOG.warn("Can't close VFS flushing task", (Throwable)stoppingEx);
                    stackTraceEx.addSuppressed(stoppingEx);
                }
            }
            try {
                InvertedNameIndex invertedNameIndex = this.invertedNameIndexLazy.get();
                invertedNameIndex.clear();
            }
            catch (Throwable t) {
                LOG.warn("VFS: invertedNameIndex building is not terminated properly", t);
                stackTraceEx.addSuppressed(t);
            }
            for (AutoCloseable toClose : this.closeables) {
                try {
                    toClose.close();
                }
                catch (Exception e) {
                    LOG.warn("Can't close " + String.valueOf(toClose), (Throwable)e);
                    stackTraceEx.addSuppressed(e);
                }
            }
            try {
                this.connection.close();
            }
            catch (IOException e) {
                stackTraceEx.addSuppressed(e);
            }
            this.closedStackTrace = stackTraceEx;
        }
    }

    boolean isClosed() {
        return this.connection.isClosed();
    }

    void checkNotClosed() {
        if (this.connection.isClosed()) {
            throw this.alreadyClosedException();
        }
    }

    @NotNull
    private RuntimeException alreadyClosedException() {
        AlreadyDisposedException alreadyDisposed = new AlreadyDisposedException("VFS is already closed (disposed)");
        if (this.closedStackTrace != null) {
            alreadyDisposed.addSuppressed((Throwable)this.closedStackTrace);
        }
        AlreadyDisposedException alreadyDisposedException = alreadyDisposed;
        if (alreadyDisposedException == null) {
            FSRecordsImpl.$$$reportNull$$$0(11);
        }
        return alreadyDisposedException;
    }

    public int getVersion() {
        return this.currentVersion;
    }

    public long getCreationTimestamp() {
        this.checkNotClosed();
        try {
            return this.connection.creationTimestamp();
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    public VFSInitializationResult initializationResult() {
        return this.initializationResult;
    }

    public long getInvertedNameIndexModCount() {
        return this.invertedNameIndexModCount.get();
    }

    @TestOnly
    int getPersistentModCount() {
        this.checkNotClosed();
        return this.connection.persistentModCount();
    }

    @TestOnly
    public void force() {
        this.checkNotClosed();
        try {
            this.connection.force();
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    @TestOnly
    public boolean isDirty() {
        this.checkNotClosed();
        return this.connection.isDirty();
    }

    @VisibleForTesting
    public int createRecord() {
        this.checkNotClosed();
        try {
            return this.recordAccessor.createRecord(this.fileIdIndexedStorages);
        }
        catch (Exception e) {
            throw this.handleError(e);
        }
    }

    @NotNull
    IntList getRemainFreeRecords() {
        this.checkNotClosed();
        IntList intList = this.connection.freeRecords();
        if (intList == null) {
            FSRecordsImpl.$$$reportNull$$$0(12);
        }
        return intList;
    }

    @NotNull
    IntList getNewFreeRecords() {
        IntList intList = this.recordAccessor.getNewFreeRecords();
        if (intList == null) {
            FSRecordsImpl.$$$reportNull$$$0(13);
        }
        return intList;
    }

    void deleteRecordRecursively(int fileId) {
        this.checkNotClosed();
        try {
            this.markAsDeletedRecursively(fileId);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAsDeletedRecursively(int fileId) throws IOException {
        IntArrayList childrenIds = new IntArrayList();
        childrenIds.add(fileId);
        for (int i2 = 0; i2 < childrenIds.size(); ++i2) {
            int id2 = childrenIds.getInt(i2);
            this.forEachChildOf(id2, arg_0 -> FSRecordsImpl.lambda$markAsDeletedRecursively$2((IntList)childrenIds, arg_0));
        }
        PersistentFSRecordsStorage records = this.connection.records();
        InvertedNameIndex invertedNameIndex = this.invertedNameIndexLazy.get();
        for (int i3 = childrenIds.size() - 1; i3 >= 0; --i3) {
            int childId = childrenIds.getInt(i3);
            long lockStamp = this.fileRecordLock.lockForWrite(childId);
            try {
                int nameId = records.getNameId(childId);
                int flags = records.getFlags(childId);
                if (PersistentFS.isDirectory(flags)) {
                    this.treeAccessor.deleteDirectoryRecord(childId);
                }
                this.recordAccessor.markRecordAsDeleted(childId);
                invertedNameIndex.updateFileName(childId, nameId, 0);
                continue;
            }
            finally {
                this.fileRecordLock.unlockForWrite(childId, lockStamp);
            }
        }
        this.invertedNameIndexModCount.incrementAndGet();
    }

    @VisibleForTesting
    public int @NotNull [] listRoots() {
        int[] nArray;
        this.checkNotClosed();
        try {
            nArray = (int[])this.withRecordReadLock(1, this.treeAccessor::listRoots);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
        if (nArray == null) {
            FSRecordsImpl.$$$reportNull$$$0(14);
        }
        return nArray;
    }

    @VisibleForTesting
    public int findOrCreateRootRecord(@NotNull String rootUrl) {
        if (rootUrl == null) {
            FSRecordsImpl.$$$reportNull$$$0(15);
        }
        this.checkNotClosed();
        this.fileRecordLock.lockForHierarchyUpdate(1);
        try {
            int n = (Integer)this.withRecordWriteLock(1, () -> this.treeAccessor.findOrCreateRootRecord(rootUrl));
            return n;
        }
        catch (Throwable t) {
            throw this.handleError(t);
        }
        finally {
            this.fileRecordLock.unlockForHierarchyUpdate(1);
        }
    }

    @VisibleForTesting
    public void forEachRoot(@NotNull ObjIntConsumer<? super String> rootConsumer) {
        if (rootConsumer == null) {
            FSRecordsImpl.$$$reportNull$$$0(16);
        }
        this.forEachRoot((int rootId, int rootUrlId) -> {
            String rootUrl = this.getNameByNameId(rootUrlId);
            rootConsumer.accept(rootUrl, rootId);
            return true;
        });
    }

    @VisibleForTesting
    public void forEachRoot(@NotNull PersistentFSTreeAccessor.RootsConsumer rootConsumer) {
        if (rootConsumer == null) {
            FSRecordsImpl.$$$reportNull$$$0(17);
        }
        this.checkNotClosed();
        try {
            this.withRecordReadLock(1, () -> {
                this.treeAccessor.forEachRoot(rootConsumer);
                return null;
            });
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    void loadRootData(int fileId, @NotNull String path, @NotNull NewVirtualFileSystem fs) {
        if (path == null) {
            FSRecordsImpl.$$$reportNull$$$0(18);
        }
        if (fs == null) {
            FSRecordsImpl.$$$reportNull$$$0(19);
        }
        try {
            this.treeAccessor.loadRootData(fileId, path, fs);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    void deleteRootRecord(int fileId) {
        this.fileRecordLock.lockForHierarchyUpdate(1);
        try {
            this.withRecordWriteLock(1, () -> {
                this.treeAccessor.deleteRootRecord(fileId);
                return null;
            });
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
        finally {
            this.fileRecordLock.unlockForHierarchyUpdate(1);
        }
    }

    void loadDirectoryData(int id2, @NotNull VirtualFile parent, @NotNull CharSequence path, @NotNull NewVirtualFileSystem fs) {
        if (parent == null) {
            FSRecordsImpl.$$$reportNull$$$0(20);
        }
        if (path == null) {
            FSRecordsImpl.$$$reportNull$$$0(21);
        }
        if (fs == null) {
            FSRecordsImpl.$$$reportNull$$$0(22);
        }
        try {
            this.treeAccessor.loadDirectoryData(id2, parent, path, fs);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean maybeHaveChildren(int fileId) {
        StampedLock lock = this.fileRecordLock.lockFor(fileId);
        long readLockStamp = lock.readLock();
        try {
            boolean bl = this.treeAccessor.maybeHaveChildren(fileId);
            lock.unlockRead(readLockStamp);
            return bl;
        }
        catch (Throwable throwable) {
            try {
                lock.unlockRead(readLockStamp);
                throw throwable;
            }
            catch (IOException e) {
                throw this.handleError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean wereChildrenAccessed(int fileId) {
        StampedLock lock = this.fileRecordLock.lockFor(fileId);
        long readLockStamp = lock.readLock();
        try {
            boolean bl = this.treeAccessor.wereChildrenAccessed(fileId);
            lock.unlockRead(readLockStamp);
            return bl;
        }
        catch (Throwable throwable) {
            try {
                lock.unlockRead(readLockStamp);
                throw throwable;
            }
            catch (IOException e) {
                throw this.handleError(e);
            }
        }
    }

    public boolean forEachChildOf(int parentId, @NotNull IntPredicate childConsumer) {
        if (childConsumer == null) {
            FSRecordsImpl.$$$reportNull$$$0(23);
        }
        StampedLock lock = this.fileRecordLock.lockFor(parentId);
        long readLockStamp = lock.readLock();
        try {
            boolean bl = this.treeAccessor.forEachChild(parentId, childConsumer);
            return bl;
        }
        catch (IOException | IllegalArgumentException e) {
            throw this.handleError(e);
        }
        finally {
            lock.unlockRead(readLockStamp);
        }
    }

    @NotNull
    public ListResult list(int parentId) {
        try {
            return this.loadChildrenUnderRecordLock(parentId);
        }
        catch (IOException | IllegalArgumentException e) {
            throw this.handleError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NotNull
    public ListResult update(@NotNull VirtualFile parent, int parentId, @NotNull Function<? super ListResult, ListResult> childrenConvertor, boolean setAllChildrenCached) {
        ListResult listResult;
        if (parent == null) {
            FSRecordsImpl.$$$reportNull$$$0(24);
        }
        if (childrenConvertor == null) {
            FSRecordsImpl.$$$reportNull$$$0(25);
        }
        SlowOperations.assertSlowOperationsAreAllowed();
        PersistentFSConnection.ensureIdIsValid(parentId);
        this.checkNotClosed();
        this.fileRecordLock.lockForHierarchyUpdate(parentId);
        try {
            ListResult children2 = this.loadChildrenUnderRecordLock(parentId);
            ListResult modifiedChildren = childrenConvertor.apply(children2);
            if (!modifiedChildren.equals(children2)) {
                this.updateSymlinksForNewChildren(parent, children2, modifiedChildren);
                this.saveChildrenUnderRecordLock(parentId, modifiedChildren, setAllChildrenCached);
            } else if (setAllChildrenCached) {
                StampedLock recordLock = this.fileRecordLock.lockFor(parentId);
                long stamp = recordLock.writeLock();
                try {
                    this.connection.records().updateRecord(parentId, record -> record.addFlags(1));
                }
                finally {
                    recordLock.unlockWrite(stamp);
                }
            }
            ListResult listResult2 = modifiedChildren;
            listResult = listResult2;
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw this.handleError(e);
        }
        finally {
            this.fileRecordLock.unlockForHierarchyUpdate(parentId);
        }
        if (listResult == null) {
            FSRecordsImpl.$$$reportNull$$$0(26);
        }
        return listResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveChildren(int fromParentId, int toParentId) {
        assert (fromParentId > 0) : fromParentId;
        assert (toParentId > 0) : toParentId;
        this.checkNotClosed();
        if (fromParentId == toParentId) {
            return;
        }
        PersistentFSRecordsStorage records = this.connection.records();
        int minId = Math.min(fromParentId, toParentId);
        int maxId = Math.max(fromParentId, toParentId);
        this.fileRecordLock.lockForHierarchyUpdate(minId);
        try {
            this.fileRecordLock.lockForHierarchyUpdate(maxId);
            try {
                try {
                    ListResult childrenToMove = this.loadChildrenUnderRecordLock(fromParentId);
                    for (ChildInfo childInfo : childrenToMove.children) {
                        int fileId = childInfo.getId();
                        if (fileId == toParentId) {
                            LOG.error("Cyclic parent/child relations");
                            continue;
                        }
                        records.setParent(fileId, toParentId);
                    }
                    this.saveChildrenUnderRecordLock(toParentId, childrenToMove, false);
                    this.saveChildrenUnderRecordLock(fromParentId, new ListResult(childrenToMove.parentModCount(), Collections.emptyList(), fromParentId), false);
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw this.handleError(e);
                }
            }
            finally {
                this.fileRecordLock.unlockForHierarchyUpdate(maxId);
            }
        }
        finally {
            this.fileRecordLock.unlockForHierarchyUpdate(minId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveChild(@NotNull Supplier<Boolean> caseSensitivityAccessor, int fromParentId, int toParentId, int childToMoveId) {
        if (caseSensitivityAccessor == null) {
            FSRecordsImpl.$$$reportNull$$$0(27);
        }
        assert (fromParentId > 0) : fromParentId;
        assert (toParentId > 0) : toParentId;
        this.checkNotClosed();
        if (fromParentId == toParentId) {
            return;
        }
        int minId = Math.min(fromParentId, toParentId);
        int maxId = Math.max(fromParentId, toParentId);
        this.fileRecordLock.lockForHierarchyUpdate(minId);
        try {
            this.fileRecordLock.lockForHierarchyUpdate(maxId);
            try {
                try {
                    int childToMoveNameId;
                    ListResult fromParentChildren = this.loadChildrenUnderRecordLock(fromParentId);
                    ListResult fromParentChildrenWithoutChildMoved = fromParentChildren.remove(childToMoveId);
                    if (fromParentChildrenWithoutChildMoved == fromParentChildren) {
                        throw new IllegalArgumentException("Can't move child(#" + childToMoveId + ") from parent(#" + fromParentId + ") to (#" + toParentId + "): child doesn't belong to parent(#" + fromParentId + "), child.parent(#" + this.connection.records().getParent(childToMoveId) + ")");
                    }
                    ListResult toParentChildren = this.loadChildrenUnderRecordLock(toParentId);
                    ChildInfo alreadyExistingChild = this.findChild(caseSensitivityAccessor, toParentChildren, childToMoveNameId = this.connection.records().getNameId(childToMoveId));
                    if (alreadyExistingChild != null) {
                        String childToMoveName = this.getNameByNameId(childToMoveNameId);
                        throw new IllegalArgumentException("Can't move child(#" + childToMoveId + ", name='" + childToMoveName + "', nameId=" + childToMoveNameId + "), parent (" + fromParentId + " -> " + toParentId + "): new parent already has a child with same name (=" + String.valueOf(alreadyExistingChild) + ")\nfromParent.children=" + String.valueOf(fromParentChildren) + "\ntoParent.children=" + String.valueOf(toParentChildren));
                    }
                    ListResult toParentChildrenUpdated = toParentChildren.insert(new ChildInfoImpl(childToMoveId, childToMoveNameId, null, null, null));
                    this.connection.records().setParent(childToMoveId, toParentId);
                    this.saveChildrenUnderRecordLock(fromParentId, fromParentChildrenWithoutChildMoved, false);
                    this.saveChildrenUnderRecordLock(toParentId, toParentChildrenUpdated, false);
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (IllegalArgumentException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw this.handleError(e);
                }
            }
            finally {
                this.fileRecordLock.unlockForHierarchyUpdate(maxId);
            }
        }
        finally {
            this.fileRecordLock.unlockForHierarchyUpdate(minId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ListResult loadChildrenUnderRecordLock(int parentId) throws IOException {
        long elapsedMs;
        if (EMULATE_FAILURES_WITH_DELAY_MS >= 0L && (elapsedMs = System.currentTimeMillis() - this.getCreationTimestamp()) > EMULATE_FAILURES_WITH_DELAY_MS) {
            throw new CorruptedException("Emulated VFS failure at time " + elapsedMs);
        }
        StampedLock recordLock = this.fileRecordLock.lockFor(parentId);
        long stamp = recordLock.readLock();
        ListResult listResult = this.treeAccessor.doLoadChildren(parentId);
        ListResult listResult2 = listResult;
        if (listResult2 == null) {
            FSRecordsImpl.$$$reportNull$$$0(28);
        }
        return listResult2;
        finally {
            recordLock.unlockRead(stamp);
        }
    }

    static boolean areAllChildrenCached(@PersistentFS.Attributes int flags) {
        return BitUtil.isSet((int)flags, (int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveChildrenUnderRecordLock(int parentId, @NotNull ListResult modifiedChildren, boolean setAllChildrenCached) throws IOException {
        if (modifiedChildren == null) {
            FSRecordsImpl.$$$reportNull$$$0(29);
        }
        StampedLock recordLock = this.fileRecordLock.lockFor(parentId);
        long stamp = recordLock.writeLock();
        try {
            this.treeAccessor.doSaveChildren(parentId, modifiedChildren);
            if (setAllChildrenCached) {
                this.connection.records().updateRecord(parentId, record -> record.addFlags(1));
            }
        }
        finally {
            recordLock.unlockWrite(stamp);
        }
    }

    @Nullable
    private ChildInfo findChild(@NotNull Supplier<Boolean> caseSensitivityAccessor, @NotNull ListResult children2, int childNameId) {
        if (caseSensitivityAccessor == null) {
            FSRecordsImpl.$$$reportNull$$$0(30);
        }
        if (children2 == null) {
            FSRecordsImpl.$$$reportNull$$$0(31);
        }
        if (children2.children.isEmpty()) {
            return null;
        }
        for (ChildInfo childInfo : children2.children) {
            if (childNameId != childInfo.getNameId()) continue;
            return childInfo;
        }
        boolean caseSensitive = caseSensitivityAccessor.get();
        if (!caseSensitive) {
            String string = this.getNameByNameId(childNameId);
            for (ChildInfo childInfo : children2.children) {
                if (!Comparing.equal((String)string, (String)this.getNameByNameId(childInfo.getNameId()), (boolean)false)) continue;
                return childInfo;
            }
        }
        return null;
    }

    @VisibleForTesting
    public void updateSymlinksForNewChildren(@NotNull VirtualFile parent, @NotNull ListResult oldChildren, @NotNull ListResult newChildren) {
        if (parent == null) {
            FSRecordsImpl.$$$reportNull$$$0(32);
        }
        if (oldChildren == null) {
            FSRecordsImpl.$$$reportNull$$$0(33);
        }
        if (newChildren == null) {
            FSRecordsImpl.$$$reportNull$$$0(34);
        }
        ContainerUtil.processSortedListsInOrder(oldChildren.children, newChildren.children, (Comparator)ChildInfo.BY_ID, (boolean)true, (childInfo, mergeResult) -> {
            if (mergeResult != ContainerUtil.MergeResult.COPIED_FROM_LIST1) {
                this.updateSymlinkInfoForNewChild(parent, (ChildInfo)childInfo);
            }
        });
    }

    private void updateSymlinkInfoForNewChild(@NotNull VirtualFile parent, @NotNull ChildInfo info) {
        int attributes;
        if (parent == null) {
            FSRecordsImpl.$$$reportNull$$$0(35);
        }
        if (info == null) {
            FSRecordsImpl.$$$reportNull$$$0(36);
        }
        if ((attributes = info.getFileAttributeFlags()) != -1 && PersistentFS.isSymLink(attributes)) {
            int id2 = info.getId();
            String symlinkTarget = info.getSymlinkTarget();
            this.storeSymlinkTarget(id2, symlinkTarget);
            CharSequence name2 = info.getName();
            VirtualFileSystem fs = parent.getFileSystem();
            if (fs instanceof LocalFileSystemImpl) {
                String linkPath = parent.getPath() + "/" + String.valueOf(name2);
                ((LocalFileSystemImpl)fs).symlinkUpdated(id2, parent, name2, linkPath, symlinkTarget);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    String readSymlinkTarget(int fileId) {
        try (AttributeInputStream stream = this.readAttribute(fileId, SYMLINK_TARGET_ATTRIBUTE);){
            if (stream != null) {
                try {
                    String result2 = StringUtil.nullize((String)IOUtil.readUTF((DataInput)stream));
                    String string = result2 == null ? null : FileUtil.toSystemIndependentName((String)result2);
                    return string;
                }
                catch (EOFException eof) {
                    AttributeInputStream attrStream = this.readAttribute(fileId, SYMLINK_TARGET_ATTRIBUTE);
                    try {
                        int size2 = attrStream.available();
                        byte[] content2 = new byte[size2];
                        attrStream.readFully(content2);
                        throw this.handleError(new IOException("Can't read symLink from attribute[fileId:" + fileId + "][=" + IOUtil.toHexString((byte[])content2) + "]", eof));
                    }
                    catch (Throwable throwable) {
                        if (attrStream == null) throw throwable;
                        try {
                            attrStream.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    void storeSymlinkTarget(int fileId, @Nullable String symlinkTarget) {
        this.checkNotClosed();
        try (AttributeOutputStream stream = this.writeAttribute(fileId, SYMLINK_TARGET_ATTRIBUTE);){
            IOUtil.writeUTF((DataOutput)stream, (String)StringUtil.notNullize((String)symlinkTarget));
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    boolean processAllNames(@NotNull Processor<? super CharSequence> processor2) {
        if (processor2 == null) {
            FSRecordsImpl.$$$reportNull$$$0(37);
        }
        this.checkNotClosed();
        try {
            return this.connection.names().forEach((nameId, name2) -> processor2.process(name2));
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    boolean processFilesWithNames(@NotNull Set<String> names, @NotNull IntPredicate processor2) {
        if (names == null) {
            FSRecordsImpl.$$$reportNull$$$0(38);
        }
        if (processor2 == null) {
            FSRecordsImpl.$$$reportNull$$$0(39);
        }
        this.checkNotClosed();
        if (names.isEmpty()) {
            return true;
        }
        try {
            IntArrayList nameIds = new IntArrayList(names.size());
            for (String name2 : names) {
                int nameId = this.fileNamesEnumerator.tryEnumerate((Object)name2);
                if (nameId == 0) continue;
                nameIds.add(nameId);
            }
            this.invertedNameIndexRequestsServed.incrementAndGet();
            return this.invertedNameIndexLazy.get().forEachFileIds((IntCollection)nameIds, processor2);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    public @PersistentFS.Attributes int getFlags(int fileId) {
        this.checkNotClosed();
        try {
            return this.connection.records().getFlags(fileId);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    public boolean isDeleted(int fileId) {
        this.checkNotClosed();
        try {
            return this.recordAccessor.isDeleted(fileId);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    public int getModCount(int fileId) {
        this.checkNotClosed();
        try {
            return this.connection.records().getModCount(fileId);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    public int getParent(int fileId) {
        this.checkNotClosed();
        try {
            int parentId = this.connection.records().getParent(fileId);
            if (parentId == fileId) {
                throw new IllegalStateException("Cyclic parent child relations in the database: fileId = " + fileId + " == parentId");
            }
            return parentId;
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    @ApiStatus.Obsolete
    @VisibleForTesting
    public void setParent(int fileId, int parentId) {
        if (fileId == parentId) {
            LOG.error("Cyclic parent/child relations");
            return;
        }
        this.checkNotClosed();
        try {
            this.connection.records().setParent(fileId, parentId);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    public int getNameId(@NotNull String name2) {
        if (name2 == null) {
            FSRecordsImpl.$$$reportNull$$$0(40);
        }
        this.checkNotClosed();
        try {
            return this.fileNamesEnumerator.enumerate((Object)name2);
        }
        catch (Throwable e) {
            throw this.handleError(e);
        }
    }

    @NotNull
    public String getName(int fileId) {
        String string;
        this.checkNotClosed();
        try {
            int nameId = this.connection.records().getNameId(fileId);
            string = nameId == 0 ? "" : (String)this.fileNamesEnumerator.valueOf(nameId);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
        if (string == null) {
            FSRecordsImpl.$$$reportNull$$$0(41);
        }
        return string;
    }

    public int getNameIdByFileId(int fileId) {
        this.checkNotClosed();
        try {
            return this.connection.records().getNameId(fileId);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    public String getNameByNameId(int nameId) {
        assert (nameId >= 0) : "nameId(=" + nameId + ") must be positive";
        this.checkNotClosed();
        try {
            return nameId == 0 ? "" : (String)this.fileNamesEnumerator.valueOf(nameId);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    public void setName(int fileId, @NotNull String name2) {
        if (name2 == null) {
            FSRecordsImpl.$$$reportNull$$$0(42);
        }
        this.checkNotClosed();
        int newNameId = this.getNameId(name2);
        InvertedNameIndex invertedNameIndex = this.invertedNameIndexLazy.get();
        this.updateRecordFields(fileId, record -> {
            int previousNameId = record.getNameId();
            if (previousNameId == newNameId) {
                return false;
            }
            record.setNameId(newNameId);
            invertedNameIndex.updateFileName(fileId, previousNameId, newNameId);
            return true;
        });
        this.invertedNameIndexModCount.incrementAndGet();
    }

    @ApiStatus.Obsolete
    @VisibleForTesting
    public void setFlags(int fileId, @PersistentFS.Attributes int flags) {
        this.checkNotClosed();
        try {
            this.connection.records().setFlags(fileId, flags);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    @VisibleForTesting
    public long getLength(int fileId) {
        this.checkNotClosed();
        try {
            return this.connection.records().getLength(fileId);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    @ApiStatus.Obsolete
    @VisibleForTesting
    public void setLength(int fileId, long len) {
        this.checkNotClosed();
        try {
            this.connection.records().setLength(fileId, len);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    @VisibleForTesting
    public long getTimestamp(int fileId) {
        this.checkNotClosed();
        try {
            return this.connection.records().getTimestamp(fileId);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    @ApiStatus.Obsolete
    @VisibleForTesting
    public void setTimestamp(int fileId, long value) {
        this.checkNotClosed();
        try {
            this.connection.records().setTimestamp(fileId, value);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    int getContentRecordId(int fileId) {
        this.checkNotClosed();
        try {
            return this.connection.records().getContentRecordId(fileId);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    @VisibleForTesting
    public int getAttributeRecordId(int fileId) {
        this.checkNotClosed();
        try {
            return this.connection.records().getAttributeRecordId(fileId);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    public int updateRecordFields(int fileId, int parentId, @NotNull FileAttributes attributes, @NotNull String name2, boolean cleanAttributeRef) {
        if (attributes == null) {
            FSRecordsImpl.$$$reportNull$$$0(43);
        }
        if (name2 == null) {
            FSRecordsImpl.$$$reportNull$$$0(44);
        }
        this.checkNotClosed();
        int nameId = this.getNameId(name2);
        long timestamp = attributes.lastModified;
        long length = attributes.isDirectory() ? -1L : attributes.length;
        int flags = PersistentFSImpl.fileAttributesToFlags(attributes);
        InvertedNameIndex filenameIndex = this.invertedNameIndexLazy.get();
        this.updateRecordFields(fileId, record -> {
            int oldNameId = record.getNameId();
            record.setParent(parentId);
            record.setNameId(nameId);
            record.setFlags(flags);
            if (cleanAttributeRef) {
                record.setAttributeRecordId(0);
            }
            record.setTimestamp(timestamp);
            record.setLength(length);
            filenameIndex.updateFileName(fileId, oldNameId, nameId);
            return true;
        });
        this.invertedNameIndexModCount.incrementAndGet();
        return nameId;
    }

    int updateRecordFields(int fileId, @NotNull IPersistentFSRecordsStorage.RecordUpdater updater) {
        if (updater == null) {
            FSRecordsImpl.$$$reportNull$$$0(45);
        }
        this.checkNotClosed();
        PersistentFSRecordsStorage fileRecords = this.connection.records();
        long lockStamp = this.fileRecordLock.lockForWrite(fileId);
        try {
            int n = fileRecords.updateRecord(fileId, updater);
            return n;
        }
        catch (IOException ex) {
            throw this.handleError(ex);
        }
        finally {
            this.fileRecordLock.unlockForWrite(fileId, lockStamp);
        }
    }

    <R> R readRecordFields(int fileId, @NotNull IPersistentFSRecordsStorage.RecordReader<R> reader) {
        if (reader == null) {
            FSRecordsImpl.$$$reportNull$$$0(46);
        }
        this.checkNotClosed();
        PersistentFSRecordsStorage fileRecords = this.connection.records();
        long lockStamp = this.fileRecordLock.lockForRead(fileId);
        try {
            R r = fileRecords.readRecord(fileId, reader);
            return r;
        }
        catch (IOException ex) {
            throw this.handleError(ex);
        }
        finally {
            this.fileRecordLock.unlockForRead(fileId, lockStamp);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <R> R readRecordFieldsOptimistic(int fileId, @NotNull IPersistentFSRecordsStorage.RecordReader<R> reader) {
        if (reader == null) {
            FSRecordsImpl.$$$reportNull$$$0(47);
        }
        this.checkNotClosed();
        PersistentFSRecordsStorage fileRecords = this.connection.records();
        StampedLock lock = this.fileRecordLock.lockFor(fileId);
        long lockStamp = lock.tryOptimisticRead();
        try {
            while (true) {
                if (lockStamp != 0L) {
                    R result2 = fileRecords.readRecord(fileId, reader);
                    if (lock.validate(lockStamp)) {
                        R r = result2;
                        return r;
                    }
                }
                lockStamp = lock.readLock();
                continue;
                break;
            }
        }
        catch (IOException ex) {
            throw this.handleError(ex);
        }
        finally {
            if (StampedLock.isReadLockStamp(lockStamp)) {
                lock.unlockRead(lockStamp);
            }
        }
    }

    @VisibleForTesting
    @Nullable
    public AttributeInputStream readAttribute(int fileId, @NotNull FileAttribute attribute) {
        if (attribute == null) {
            FSRecordsImpl.$$$reportNull$$$0(48);
        }
        StampedLock lock = this.fileRecordLock.lockFor(fileId);
        long lockStamp = lock.readLock();
        try {
            AttributeInputStream attributeInputStream = this.attributeAccessor.readAttribute(fileId, attribute);
            return attributeInputStream;
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
        finally {
            lock.unlockRead(lockStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NotNull
    public AttributeOutputStream writeAttribute(final int fileId, final @NotNull FileAttribute attribute) {
        if (attribute == null) {
            FSRecordsImpl.$$$reportNull$$$0(49);
        }
        final StampedLock lock = this.fileRecordLock.lockFor(fileId);
        long lockStamp = lock.writeLock();
        final AttributeOutputStream stream = this.attributeAccessor.writeAttribute(fileId, attribute);
        AttributeOutputStream attributeOutputStream = new AttributeOutputStream((OutputStream)stream){

            public void writeEnumeratedString(String str) throws IOException {
                stream.writeEnumeratedString(str);
            }

            public void close() throws IOException {
                long lockStamp = lock.writeLock();
                try {
                    super.close();
                }
                catch (FileTooBigException e) {
                    LOG.warn("Error storing " + String.valueOf(attribute) + " of file(" + fileId + ")", (Throwable)e);
                    throw e;
                }
                catch (Throwable t) {
                    LOG.warn("Error storing " + String.valueOf(attribute) + " of file(" + fileId + ")", t);
                    throw FSRecordsImpl.this.handleError(t);
                }
                finally {
                    lock.unlockWrite(lockStamp);
                }
            }
        };
        AttributeOutputStream attributeOutputStream2 = attributeOutputStream;
        if (attributeOutputStream2 == null) {
            FSRecordsImpl.$$$reportNull$$$0(50);
        }
        return attributeOutputStream2;
        finally {
            lock.unlockWrite(lockStamp);
        }
    }

    @ApiStatus.Internal
    boolean supportsRawAttributesAccess() {
        return this.attributeAccessor.supportsRawAccess();
    }

    @ApiStatus.Internal
    @Nullable
    <R> R readAttributeRaw(int fileId, @NotNull FileAttribute attribute, @NotNull ByteBufferReader<R> reader) {
        if (attribute == null) {
            FSRecordsImpl.$$$reportNull$$$0(51);
        }
        if (reader == null) {
            FSRecordsImpl.$$$reportNull$$$0(52);
        }
        StampedLock lock = this.fileRecordLock.lockFor(fileId);
        long lockStamp = lock.readLock();
        try {
            R r = this.attributeAccessor.readAttributeRaw(fileId, attribute, reader);
            return r;
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
        finally {
            lock.unlockRead(lockStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    void writeAttributeRaw(int fileId, @NotNull FileAttribute attribute, @NotNull ByteBufferWriter writer) {
        if (attribute == null) {
            FSRecordsImpl.$$$reportNull$$$0(53);
        }
        if (writer == null) {
            FSRecordsImpl.$$$reportNull$$$0(54);
        }
        StampedLock lock = this.fileRecordLock.lockFor(fileId);
        long lockStamp = lock.writeLock();
        try {
            this.attributeAccessor.writeAttributeRaw(fileId, attribute, writer);
        }
        finally {
            lock.unlockWrite(lockStamp);
        }
    }

    @VisibleForTesting
    @Nullable
    public InputStream readContent(int fileId) {
        try {
            return this.contentAccessor.readContent(fileId);
        }
        catch (InterruptedIOException ie) {
            throw new RuntimeException(ie);
        }
        catch (OutOfMemoryError oom) {
            throw oom;
        }
        catch (ZipException e) {
            String fileName = this.getName(fileId);
            long length = this.getLength(fileId);
            IOException diagnosticException = new IOException("Failed to decompress file's content for file. File name = " + fileName + ", length = " + length);
            diagnosticException.addSuppressed(e);
            throw this.handleError(diagnosticException);
        }
        catch (Throwable e) {
            throw this.handleError(e);
        }
    }

    @NotNull
    InputStream readContentById(int contentId) {
        InputStream inputStream;
        try {
            inputStream = this.contentAccessor.readContentByContentId(contentId);
        }
        catch (InterruptedIOException ie) {
            throw new RuntimeException(ie);
        }
        catch (OutOfMemoryError oom) {
            throw oom;
        }
        catch (Throwable e) {
            throw this.handleError(e);
        }
        if (inputStream == null) {
            FSRecordsImpl.$$$reportNull$$$0(55);
        }
        return inputStream;
    }

    int acquireFileContent(int fileId) {
        try {
            return this.contentAccessor.acquireContentRecord(fileId);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    void releaseContent(int contentId) {
        try {
            this.contentAccessor.releaseContentRecord(contentId);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    @VisibleForTesting
    @NotNull
    public DataOutputStream writeContent(int fileId, boolean fixedSize) {
        PersistentFSContentAccessor persistentFSContentAccessor = this.contentAccessor;
        Objects.requireNonNull(persistentFSContentAccessor);
        return new DataOutputStream((OutputStream)((Object)new PersistentFSContentAccessor.ContentOutputStream(persistentFSContentAccessor, fileId, fixedSize))){

            public void close() {
                try {
                    super.close();
                }
                catch (IOException e) {
                    throw FSRecordsImpl.this.handleError(e);
                }
            }
        };
    }

    @VisibleForTesting
    public void writeContent(int fileId, @NotNull ByteArraySequence bytes, boolean fixedSize) {
        if (bytes == null) {
            FSRecordsImpl.$$$reportNull$$$0(56);
        }
        try {
            this.contentAccessor.writeContent(fileId, bytes, fixedSize);
        }
        catch (Throwable t) {
            throw this.handleError(t);
        }
    }

    @TestOnly
    byte[] getContentHash(int fileId) {
        try {
            return this.contentAccessor.getContentHash(fileId);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    int writeContentRecord(@NotNull ByteArraySequence content2) throws ContentTooBigException {
        if (content2 == null) {
            FSRecordsImpl.$$$reportNull$$$0(57);
        }
        try {
            return this.contentAccessor.writeContentRecord(content2);
        }
        catch (IOException e) {
            throw this.handleError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E extends Exception> T withRecordReadLock(int fileId, @NotNull ThrowableComputable<T, E> lambda) throws E {
        if (lambda == null) {
            FSRecordsImpl.$$$reportNull$$$0(58);
        }
        StampedLock lock = this.fileRecordLock.lockFor(fileId);
        long stamp = lock.readLock();
        try {
            Object object = lambda.compute();
            return (T)object;
        }
        finally {
            lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E extends Exception> T withRecordWriteLock(int fileId, @NotNull ThrowableComputable<T, E> lambda) throws E {
        if (lambda == null) {
            FSRecordsImpl.$$$reportNull$$$0(59);
        }
        StampedLock lock = this.fileRecordLock.lockFor(fileId);
        long stamp = lock.writeLock();
        try {
            Object object = lambda.compute();
            return (T)object;
        }
        finally {
            lock.unlockWrite(stamp);
        }
    }

    public void scheduleRebuild(@Nullable String diagnosticMessage, @Nullable Throwable cause) {
        this.checkNotClosed();
        this.connection.scheduleVFSRebuild(diagnosticMessage, cause);
    }

    public void scheduleDefragmentation() throws IOException {
        this.connection.scheduleDefragmentation();
    }

    @Contract(value="_->fail")
    RuntimeException handleError(Throwable e) throws RuntimeException, Error {
        if (e instanceof ClosedStorageException || this.isClosed()) {
            RuntimeException alreadyDisposed = this.alreadyClosedException();
            alreadyDisposed.addSuppressed(e);
            throw alreadyDisposed;
        }
        if (e instanceof ProcessCanceledException) {
            throw (ProcessCanceledException)e;
        }
        this.errorHandler.handleError(this, e);
        throw new AssertionError("Bug: should be unreachable, since ErrorHandle must throw some exception", e);
    }

    public synchronized void addCloseable(@NotNull Closeable closeable) {
        if (closeable == null) {
            FSRecordsImpl.$$$reportNull$$$0(60);
        }
        this.checkNotClosed();
        this.closeables.add(closeable);
    }

    public void addFileIdIndexedStorage(@NotNull FileIdIndexedStorage storage) {
        if (storage == null) {
            FSRecordsImpl.$$$reportNull$$$0(61);
        }
        this.fileIdIndexedStorages.add(storage);
    }

    @TestOnly
    void checkFilenameIndexConsistency() {
        this.invertedNameIndexLazy.get().checkConsistency();
    }

    public int corruptionsDetected() {
        return this.connection.corruptionsDetected();
    }

    public long invertedNameIndexRequestsServed() {
        return this.invertedNameIndexRequestsServed.get();
    }

    public PersistentFSConnection connection() {
        return this.connection;
    }

    PersistentFSContentAccessor contentAccessor() {
        return this.contentAccessor;
    }

    @VisibleForTesting
    public PersistentFSAttributeAccessor attributeAccessor() {
        return this.attributeAccessor;
    }

    @VisibleForTesting
    public PersistentFSTreeAccessor treeAccessor() {
        return this.treeAccessor;
    }

    @VisibleForTesting
    public PersistentFSRecordAccessor recordAccessor() {
        return this.recordAccessor;
    }

    @VisibleForTesting
    @NotNull
    public static @NotNull Supplier<@NotNull InvertedNameIndex> asyncFillInvertedNameIndex(@NotNull PersistentFSRecordsStorage recordsStorage) {
        if (recordsStorage == null) {
            FSRecordsImpl.$$$reportNull$$$0(62);
        }
        CompletableFuture<InvertedNameIndex> fillUpInvertedNameIndexTask = PersistentFsConnectorHelper.INSTANCE.executor().async(() -> {
            DefaultInMemoryInvertedNameIndex invertedNameIndex = new DefaultInMemoryInvertedNameIndex();
            int maxAllocatedID = recordsStorage.maxAllocatedID();
            for (int fileId = 1; fileId <= maxAllocatedID; ++fileId) {
                int flags = recordsStorage.getFlags(fileId);
                int nameId = recordsStorage.getNameId(fileId);
                if (PersistentFSRecordAccessor.hasDeletedFlag(flags) || nameId == 0) continue;
                invertedNameIndex.updateFileName(fileId, 0, nameId);
            }
            LOG.info("VFS scanned: file-by-name index was populated");
            return invertedNameIndex;
        });
        Supplier<InvertedNameIndex> supplier = () -> {
            try {
                return (InvertedNameIndex)fillUpInvertedNameIndexTask.join();
            }
            catch (Throwable e) {
                throw new IllegalStateException("Lazy invertedNameIndex computation is failed", e);
            }
        };
        if (supplier == null) {
            FSRecordsImpl.$$$reportNull$$$0(63);
        }
        return supplier;
    }

    private static /* synthetic */ boolean lambda$markAsDeletedRecursively$2(IntList childrenIds, int childId) {
        childrenIds.add(childId);
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13, 14, 26, 28, 41, 50, 55, 63 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storagesDirectoryPath";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentAccessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeAccessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeAccessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordAccessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invertedNameIndexLazy";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializationResult";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 26: 
            case 28: 
            case 41: 
            case 50: 
            case 55: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/FSRecordsImpl";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootUrl";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootConsumer";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 20: 
            case 24: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childConsumer";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenConvertor";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseSensitivityAccessor";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiedChildren";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldChildren";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChildren";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 40: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 46: 
            case 47: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 48: 
            case 49: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambda";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeable";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordsStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/FSRecordsImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "alreadyClosedException";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemainFreeRecords";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFreeRecords";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "listRoots";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "update";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "loadChildrenUnderRecordLock";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "writeAttribute";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "readContentById";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncFillInvertedNameIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 26: 
            case 28: 
            case 41: 
            case 50: 
            case 55: 
            case 63: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateRootRecord";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "forEachRoot";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadRootData";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadDirectoryData";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "forEachChildOf";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "moveChild";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "saveChildrenUnderRecordLock";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "updateSymlinksForNewChildren";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "updateSymlinkInfoForNewChild";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "processAllNames";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processFilesWithNames";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getNameId";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "updateRecordFields";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "readRecordFields";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "readRecordFieldsOptimistic";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "readAttribute";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "readAttributeRaw";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "writeAttributeRaw";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "writeContent";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "writeContentRecord";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "withRecordReadLock";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "withRecordWriteLock";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "addCloseable";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "addFileIdIndexedStorage";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "asyncFillInvertedNameIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13, 14, 26, 28, 41, 50, 55, 63 -> new IllegalStateException(string);
        };
    }

    public static interface ErrorHandler {
        public void handleError(@NotNull FSRecordsImpl var1, @NotNull Throwable var2) throws Error, RuntimeException;
    }

    public static interface FileIdIndexedStorage {
        public void clear(int var1) throws IOException;
    }
}

