/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.scale.JBUIScale;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/wm/impl/EventLogger;", "Ljava/awt/event/ComponentAdapter;", "frame", "Lcom/intellij/openapi/wm/impl/IdeFrameImpl;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Lcom/intellij/openapi/wm/impl/IdeFrameImpl;Lcom/intellij/openapi/diagnostic/Logger;)V", "componentResized", "", "e", "Ljava/awt/event/ComponentEvent;", "componentMoved", "logBounds", "action", "", "Companion", "intellij.platform.ide.impl"})
final class EventLogger
extends ComponentAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IdeFrameImpl frame;
    @NotNull
    private final Logger log;

    public EventLogger(@NotNull IdeFrameImpl frame, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.frame = frame;
        this.log = log;
    }

    @Override
    public void componentResized(@NotNull ComponentEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.logBounds("resized");
    }

    @Override
    public void componentMoved(@NotNull ComponentEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.logBounds("moved");
    }

    private final void logBounds(String action2) {
        Rectangle windowBounds = this.frame.getBounds();
        GraphicsConfiguration graphicsConfiguration = this.frame.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            return;
        }
        GraphicsConfiguration gc = graphicsConfiguration;
        Object object = gc.getDevice();
        if (object == null || (object = ((GraphicsDevice)object).getDisplayMode()) == null) {
            return;
        }
        Object mode = object;
        float scale = JBUIScale.sysScale((GraphicsConfiguration)gc);
        Rectangle screenBounds = gc.getBounds();
        IdeFrameImpl.FrameHelper frameHelper = this.frame.getFrameHelper();
        String string = frameHelper != null && (frameHelper = frameHelper.getProject()) != null ? frameHelper.getName() : null;
        Intrinsics.checkNotNull((Object)windowBounds);
        String string2 = EventLogger.Companion.toDebugString(windowBounds);
        int n = ((DisplayMode)mode).getWidth();
        int n2 = ((DisplayMode)mode).getHeight();
        Intrinsics.checkNotNull((Object)screenBounds);
        this.log.debug("IDE frame '" + string + "' " + action2 + "; frame bounds: " + string2 + "; resolution: " + n + "x" + n2 + "; scale: " + scale + "; screen bounds: " + EventLogger.Companion.toDebugString(screenBounds));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/wm/impl/EventLogger$Companion;", "", "<init>", "()V", "toDebugString", "", "rectangle", "Ljava/awt/Rectangle;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final String toDebugString(Rectangle rectangle) {
            return rectangle.width + "x" + rectangle.height + " @ (" + rectangle.x + "," + rectangle.y + ")";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

