/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.icons.IconUtilKt;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.SVGLoader;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageFilter;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.VolatileImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PainterHelper
implements Painter.Listener {
    private static final Logger LOG = Logger.getInstance(PainterHelper.class);
    private final Set<Painter> painters;
    private final Map<Painter, Component> painterToComponent;
    private final JComponent rootComponent;

    PainterHelper(@NotNull JComponent component2) {
        if (component2 == null) {
            PainterHelper.$$$reportNull$$$0(0);
        }
        this.painters = new LinkedHashSet<Painter>();
        this.painterToComponent = new LinkedHashMap<Painter, Component>();
        this.rootComponent = component2;
    }

    boolean hasPainters() {
        return !this.painters.isEmpty();
    }

    public boolean needsRepaint() {
        for (Painter painter : this.painters) {
            if (!painter.needsRepaint()) continue;
            return true;
        }
        return false;
    }

    void addPainter(@NotNull Painter painter, @Nullable Component component2) {
        if (painter == null) {
            PainterHelper.$$$reportNull$$$0(1);
        }
        this.painters.add(painter);
        this.painterToComponent.put(painter, component2 == null ? this.rootComponent : component2);
        painter.addListener((Painter.Listener)this);
    }

    void removePainter(@NotNull Painter painter) {
        if (painter == null) {
            PainterHelper.$$$reportNull$$$0(2);
        }
        painter.removeListener((Painter.Listener)this);
        this.painters.remove(painter);
        this.painterToComponent.remove(painter);
    }

    public void clear() {
        for (Painter painter : this.painters) {
            painter.removeListener((Painter.Listener)this);
        }
        this.painters.clear();
        this.painterToComponent.clear();
    }

    public void paint(@NotNull Graphics g) {
        if (g == null) {
            PainterHelper.$$$reportNull$$$0(3);
        }
        this.runAllPainters(g, this.computeOffsets(g, this.rootComponent));
    }

    void runAllPainters(Graphics gg, @Nullable Offsets offsets) {
        if (this.painters.isEmpty() || offsets == null) {
            return;
        }
        Graphics2D g = (Graphics2D)gg;
        AffineTransform orig = g.getTransform();
        int i2 = 0;
        for (Painter painter : this.painters) {
            if (!painter.needsRepaint()) continue;
            Component cur = this.painterToComponent.get(painter);
            g.setTransform(offsets.transform);
            g.translate(offsets.offsets[i2++], offsets.offsets[i2++]);
            painter.paint(cur, g);
        }
        g.setTransform(orig);
    }

    @Nullable
    Offsets computeOffsets(Graphics gg, @NotNull JComponent component2) {
        if (component2 == null) {
            PainterHelper.$$$reportNull$$$0(4);
        }
        if (this.painters.isEmpty()) {
            return null;
        }
        Offsets offsets = new Offsets();
        offsets.offsets = new int[this.painters.size() * 2];
        Graphics2D g = (Graphics2D)gg;
        offsets.transform = new AffineTransform(g.getTransform());
        Rectangle r = null;
        Component prev = null;
        int i2 = 0;
        for (Painter painter : this.painters) {
            if (!painter.needsRepaint()) continue;
            Component cur = this.painterToComponent.get(painter);
            if (cur != prev || r == null) {
                Container curParent = cur.getParent();
                if (curParent == null) continue;
                r = SwingUtilities.convertRectangle(curParent, cur.getBounds(), component2);
                prev = cur;
            }
            offsets.offsets[i2++] = r.x;
            offsets.offsets[i2++] = r.y;
        }
        return offsets;
    }

    public void onNeedsRepaint(@NotNull Painter painter, JComponent dirtyComponent) {
        if (painter == null) {
            PainterHelper.$$$reportNull$$$0(5);
        }
        if (dirtyComponent != null && dirtyComponent.isShowing()) {
            Rectangle rec = SwingUtilities.convertRectangle(dirtyComponent, dirtyComponent.getBounds(), this.rootComponent);
            this.rootComponent.repaint(rec);
        } else {
            this.rootComponent.repaint();
        }
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    void addFallbackBackgroundPainter(@NotNull Painter fallbackBackgroundPainter) {
        if (fallbackBackgroundPainter == null) {
            PainterHelper.$$$reportNull$$$0(6);
        }
        this.addPainter(fallbackBackgroundPainter, null);
    }

    static void initWallpaperPainter(@NotNull String propertyName, @NotNull PainterHelper painters) {
        if (propertyName == null) {
            PainterHelper.$$$reportNull$$$0(7);
        }
        if (painters == null) {
            PainterHelper.$$$reportNull$$$0(8);
        }
        painters.addPainter((Painter)new MyImagePainter(painters.rootComponent, propertyName), null);
    }

    static void resetWallpaperPainterCache() {
        MyImagePainter.ourImageCache.clear();
    }

    static AbstractPainter newImagePainter(final @NotNull Image image2, final @NotNull IdeBackgroundUtil.Fill fillType, final @NotNull IdeBackgroundUtil.Anchor anchor, final float alpha, final @NotNull Insets insets) {
        if (image2 == null) {
            PainterHelper.$$$reportNull$$$0(9);
        }
        if (fillType == null) {
            PainterHelper.$$$reportNull$$$0(10);
        }
        if (anchor == null) {
            PainterHelper.$$$reportNull$$$0(11);
        }
        if (insets == null) {
            PainterHelper.$$$reportNull$$$0(12);
        }
        return new ImagePainter(){

            public boolean needsRepaint() {
                return true;
            }

            public void executePaint(@NotNull Component component2, @NotNull Graphics2D g) {
                if (component2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (g == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.executePaint(g, component2, image2, fillType, anchor, alpha, insets);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "component";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "g";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/wm/impl/PainterHelper$1";
                objectArray[2] = "executePaint";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "painter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbackBackgroundPainter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "painters";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fillType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/PainterHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addPainter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removePainter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "computeOffsets";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "onNeedsRepaint";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addFallbackBackgroundPainter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "initWallpaperPainter";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "newImagePainter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Offsets {
        AffineTransform transform;
        int[] offsets;
    }

    private static final class MyImagePainter
    extends ImagePainter {
        private static final Map<ImageLoadSettings, Image> ourImageCache = ContainerUtil.createWeakValueMap();
        private final JComponent rootComponent;
        private final String propertyName;
        private ImageLoadSettings imageLoadSettings;
        private Image image;
        private float alpha;
        private Insets insets;
        private IdeBackgroundUtil.Fill fillType;
        private IdeBackgroundUtil.Anchor anchor;
        private String current;

        private MyImagePainter(@NotNull JComponent rootComponent, @NotNull String propertyName) {
            if (rootComponent == null) {
                MyImagePainter.$$$reportNull$$$0(0);
            }
            if (propertyName == null) {
                MyImagePainter.$$$reportNull$$$0(1);
            }
            this.rootComponent = rootComponent;
            this.propertyName = propertyName;
        }

        public boolean needsRepaint() {
            return this.ensureImageLoaded();
        }

        public void executePaint(@NotNull Component component2, @NotNull Graphics2D g) {
            if (component2 == null) {
                MyImagePainter.$$$reportNull$$$0(2);
            }
            if (g == null) {
                MyImagePainter.$$$reportNull$$$0(3);
            }
            if (this.image == null) {
                return;
            }
            this.executePaint(g, component2, this.image, this.fillType, this.anchor, this.alpha, this.insets);
        }

        boolean ensureImageLoaded() {
            Project project2 = ProjectUtil.getProjectForComponent(this.rootComponent);
            String value = IdeBackgroundUtil.getBackgroundSpec(project2, this.propertyName);
            if (!Objects.equals(value, this.current)) {
                this.current = value;
                this.loadImageAsync(value);
            }
            return this.image != null;
        }

        private void resetImage(String value, ImageLoadSettings newImageLoadSettings, Image newImage, float newAlpha, IdeBackgroundUtil.Fill newFill, IdeBackgroundUtil.Anchor newAnchor, boolean invokeRepaintAllLater) {
            boolean newOk;
            if (!Objects.equals(this.current, value)) {
                return;
            }
            boolean prevOk = this.image != null;
            this.clearImages(-1L);
            this.imageLoadSettings = newImageLoadSettings;
            this.image = newImage;
            this.insets = JBInsets.emptyInsets();
            this.alpha = newAlpha;
            this.fillType = newFill;
            this.anchor = newAnchor;
            boolean bl = newOk = newImage != null;
            if (prevOk || newOk) {
                ModalityState modalityState = ModalityState.stateForComponent((Component)this.rootComponent);
                if (!modalityState.accepts(ModalityState.nonModal())) {
                    ComponentUtil.getActiveWindow().repaint();
                } else if (invokeRepaintAllLater) {
                    ApplicationManager.getApplication().invokeLater(IdeBackgroundUtil::repaintAllWindows, modalityState);
                } else {
                    IdeBackgroundUtil.repaintAllWindows();
                }
            }
        }

        private void loadImageAsync(@Nullable String propertyValue) {
            String[] parts = ((String)(propertyValue == null ? this.propertyName + ".png" : propertyValue)).split(",");
            float newAlpha = Math.abs(Math.min((float)StringUtil.parseInt((String)(parts.length > 1 ? parts[1] : ""), (int)10) / 100.0f, 1.0f));
            IdeBackgroundUtil.Fill newFillType = (IdeBackgroundUtil.Fill)StringUtil.parseEnum((String)(parts.length > 2 ? Strings.toUpperCase((String)parts[2]) : ""), (Enum)IdeBackgroundUtil.Fill.SCALE, IdeBackgroundUtil.Fill.class);
            IdeBackgroundUtil.Anchor newAnchor = (IdeBackgroundUtil.Anchor)StringUtil.parseEnum((String)(parts.length > 3 ? Strings.toUpperCase((String)parts[3]) : ""), (Enum)IdeBackgroundUtil.Anchor.CENTER, IdeBackgroundUtil.Anchor.class);
            String flip = parts.length > 4 ? parts[4] : "none";
            String filePath = parts[0];
            boolean flipH = "flipHV".equals(flip) || "flipH".equals(flip);
            boolean flipV = "flipHV".equals(flip) || "flipV".equals(flip);
            ImageLoadSettings newLoadSettings = new ImageLoadSettings(filePath, flipH, flipV);
            if (Strings.isEmpty((String)filePath)) {
                this.resetImage(propertyValue, newLoadSettings, null, newAlpha, newFillType, newAnchor, true);
                return;
            }
            if (Objects.equals(this.imageLoadSettings, newLoadSettings)) {
                this.resetImage(propertyValue, newLoadSettings, this.image, newAlpha, newFillType, newAnchor, true);
                return;
            }
            Image cachedImage = ourImageCache.get(newLoadSettings);
            if (cachedImage != null) {
                this.resetImage(propertyValue, newLoadSettings, cachedImage, newAlpha, newFillType, newAnchor, true);
                return;
            }
            ModalityState modalityState = ModalityState.stateForComponent((Component)this.rootComponent);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                Image newImage = MyImagePainter.filterImage(MyImagePainter.loadImage(newLoadSettings), newLoadSettings);
                ourImageCache.put(newLoadSettings, newImage);
                ApplicationManager.getApplication().invokeLater(() -> this.resetImage(propertyValue, newLoadSettings, newImage, newAlpha, newFillType, newAnchor, false), modalityState);
            });
        }

        private static InputStream openImageInputStream(String filePath) throws IOException {
            InputStream stream;
            if (filePath.contains("://") && !filePath.startsWith("http")) {
                stream = new URL(filePath).openStream();
            } else {
                Path path = Paths.get(filePath, new String[0]);
                if (!path.isAbsolute()) {
                    path = PathManager.getConfigDir().resolve(path);
                }
                stream = Files.newInputStream(path.normalize(), new OpenOption[0]);
            }
            return stream;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        private static Image loadImage(ImageLoadSettings imageLoadSettings) {
            String filePath = imageLoadSettings.filePath();
            try (InputStream stream = MyImagePainter.openImageInputStream(filePath);){
                if (MyImagePainter.isSvg(filePath)) {
                    Image image2 = SVGLoader.load((InputStream)stream, (float)1.0f);
                    return image2;
                }
                BufferedImage bufferedImage = ImageIO.read(new MemoryCacheImageInputStream(stream));
                return bufferedImage;
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                return null;
            }
        }

        @Nullable
        private static Image filterImage(@Nullable Image image2, ImageLoadSettings imageLoadSettings) {
            if (image2 == null) {
                return null;
            }
            try {
                boolean flipV = imageLoadSettings.flipV();
                boolean flipH = imageLoadSettings.flipH();
                BufferedImageFilter flipFilter = flipV || flipH ? MyImagePainter.flipFilter(flipV, flipH) : null;
                return IconUtilKt.filterImage((Image)image2, (List)ContainerUtil.createMaybeSingletonList((Object)flipFilter));
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                return null;
            }
        }

        private static boolean isSvg(String filePath) {
            return filePath.endsWith(".svg");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootComponent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/wm/impl/PainterHelper$MyImagePainter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executePaint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        record ImageLoadSettings(String filePath, boolean flipH, boolean flipV) {
            public boolean isSvg() {
                return this.filePath.endsWith(".svg");
            }
        }
    }

    private static abstract class ImagePainter
    extends AbstractPainter {
        final Map<GraphicsConfiguration, Cached> cachedMap = new HashMap<GraphicsConfiguration, Cached>();

        private ImagePainter() {
        }

        void executePaint(@NotNull Graphics2D g, @NotNull Component component2, @NotNull Image image2, @NotNull IdeBackgroundUtil.Fill fillType, @NotNull IdeBackgroundUtil.Anchor anchor, float alpha, @NotNull Insets insets) {
            if (g == null) {
                ImagePainter.$$$reportNull$$$0(0);
            }
            if (component2 == null) {
                ImagePainter.$$$reportNull$$$0(1);
            }
            if (image2 == null) {
                ImagePainter.$$$reportNull$$$0(2);
            }
            if (fillType == null) {
                ImagePainter.$$$reportNull$$$0(3);
            }
            if (anchor == null) {
                ImagePainter.$$$reportNull$$$0(4);
            }
            if (insets == null) {
                ImagePainter.$$$reportNull$$$0(5);
            }
            ScaleContext scaleContext = ScaleContext.create((Graphics2D)g);
            int componentWidth = PaintUtil.alignIntToInt((int)component2.getWidth(), (ScaleContext)scaleContext, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL, null);
            int componentHeight = PaintUtil.alignIntToInt((int)component2.getHeight(), (ScaleContext)scaleContext, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL, null);
            this.executePaint(g, componentWidth, componentHeight, image2, fillType, anchor, alpha, insets);
        }

        private void executePaint(@NotNull Graphics2D g, int componentWidth, int componentHeight, @NotNull Image image2, @NotNull IdeBackgroundUtil.Fill fillType, @NotNull IdeBackgroundUtil.Anchor anchor, float alpha, @NotNull Insets insets) {
            long currentTime;
            boolean repaint;
            if (g == null) {
                ImagePainter.$$$reportNull$$$0(6);
            }
            if (image2 == null) {
                ImagePainter.$$$reportNull$$$0(7);
            }
            if (fillType == null) {
                ImagePainter.$$$reportNull$$$0(8);
            }
            if (anchor == null) {
                ImagePainter.$$$reportNull$$$0(9);
            }
            if (insets == null) {
                ImagePainter.$$$reportNull$$$0(10);
            }
            JBInsets i2 = JBUI.insets((int)(insets.top * componentHeight / 100), (int)(insets.left * componentWidth / 100), (int)(insets.bottom * componentHeight / 100), (int)(insets.right * componentWidth / 100));
            int cw = componentWidth - i2.left - i2.right;
            int ch = componentHeight - i2.top - i2.bottom;
            int w = image2.getWidth(null);
            int h = image2.getHeight(null);
            if (w <= 0 || h <= 0) {
                return;
            }
            @Nullable GraphicsConfiguration cfg = g.getDeviceConfiguration();
            Cached cached = this.cachedMap.get(cfg);
            VolatileImage scaled = cached == null ? null : cached.image;
            Rectangle src0 = new Rectangle();
            Rectangle dst0 = new Rectangle();
            ImagePainter.calcSrcDst(src0, dst0, w, h, cw, ch, fillType);
            ImagePainter.alignRect(src0, w, h, anchor);
            if (fillType == IdeBackgroundUtil.Fill.TILE) {
                ImagePainter.alignRect(dst0, cw, ch, anchor);
            }
            int sw0 = scaled == null ? -1 : scaled.getWidth(null);
            int sh0 = scaled == null ? -1 : scaled.getHeight(null);
            boolean bl = repaint = cached == null || !cached.src.equals(src0) || !cached.dst.equals(dst0);
            while ((scaled = ImagePainter.validateImage(cfg, scaled)) == null || repaint) {
                int sw = Math.min(cw, dst0.width);
                int sh = Math.min(ch, dst0.height);
                if (scaled == null || sw0 < sw || sh0 < sh) {
                    scaled = ImagePainter.createImage(cfg, sw, sh);
                    cached = new Cached(scaled, src0, dst0);
                    this.cachedMap.put(cfg, cached);
                } else {
                    cached.src.setBounds(src0);
                    cached.dst.setBounds(dst0);
                }
                Graphics2D gg = scaled.createGraphics();
                gg.setComposite(AlphaComposite.Src);
                if (fillType == IdeBackgroundUtil.Fill.SCALE) {
                    gg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    StartupUiUtil.drawImage((Graphics)gg, (Image)image2, (Rectangle)dst0, (Rectangle)src0, null);
                } else if (fillType == IdeBackgroundUtil.Fill.TILE) {
                    Rectangle r = new Rectangle(0, 0, 0, 0);
                    for (int x = 0; x < dst0.width; x += w) {
                        for (int y = 0; y < dst0.height; y += h) {
                            r.setBounds(dst0.x + x, dst0.y + y, src0.width, src0.height);
                            StartupUiUtil.drawImage((Graphics)gg, (Image)image2, (Rectangle)r, (Rectangle)src0, null);
                        }
                    }
                } else {
                    StartupUiUtil.drawImage((Graphics)gg, (Image)image2, (Rectangle)dst0, (Rectangle)src0, null);
                }
                gg.dispose();
                repaint = false;
            }
            cached.touched = currentTime = System.currentTimeMillis();
            if (this.cachedMap.size() > 2) {
                this.clearImages(currentTime);
            }
            Rectangle src = new Rectangle(0, 0, cw, ch);
            Rectangle dst = new Rectangle(i2.left, i2.top, cw, ch);
            if (fillType != IdeBackgroundUtil.Fill.TILE) {
                ImagePainter.alignRect(src, dst0.width, dst0.height, anchor);
            }
            float adjustedAlpha = Boolean.TRUE.equals(g.getRenderingHint(IdeBackgroundUtil.ADJUST_ALPHA)) ? 0.65f * alpha : alpha;
            Object hintedAdjustedAlphaObject = g.getRenderingHint(JBSwingUtilities.ADJUSTED_BACKGROUND_ALPHA);
            if (hintedAdjustedAlphaObject instanceof Float) {
                Float hintedAdjustedAlpha = (Float)hintedAdjustedAlphaObject;
                adjustedAlpha = hintedAdjustedAlpha.floatValue();
            }
            GraphicsConfig gc = new GraphicsConfig((Graphics)g).setAlpha(adjustedAlpha);
            StartupUiUtil.drawImage((Graphics)g, (Image)scaled, (Rectangle)dst, (Rectangle)src, null, null);
            gc.restore();
        }

        static void calcSrcDst(Rectangle src, Rectangle dst, int w, int h, int cw, int ch, IdeBackgroundUtil.Fill fillType) {
            if (fillType == IdeBackgroundUtil.Fill.SCALE) {
                boolean useWidth = cw * h > ch * w;
                int sw = useWidth ? w : cw * h / ch;
                int sh = useWidth ? ch * w / cw : h;
                src.setBounds(0, 0, sw, sh);
                dst.setBounds(0, 0, cw, ch);
            } else if (fillType == IdeBackgroundUtil.Fill.TILE) {
                int dw = cw < w ? w : ((cw / w + 1) / 2 * 2 + 1) * w;
                int dh = ch < h ? h : ((ch / h + 1) / 2 * 2 + 1) * h;
                src.setBounds(0, 0, w, h);
                dst.setBounds(0, 0, dw, dh);
            } else {
                src.setBounds(0, 0, Math.min(w, cw), Math.min(h, ch));
                dst.setBounds(src);
            }
        }

        static void alignRect(Rectangle r, int w, int h, IdeBackgroundUtil.Anchor anchor) {
            if (anchor == IdeBackgroundUtil.Anchor.TOP_CENTER || anchor == IdeBackgroundUtil.Anchor.CENTER || anchor == IdeBackgroundUtil.Anchor.BOTTOM_CENTER) {
                r.x = (w - r.width) / 2;
                r.y = anchor == IdeBackgroundUtil.Anchor.TOP_CENTER ? 0 : (anchor == IdeBackgroundUtil.Anchor.BOTTOM_CENTER ? h - r.height : (h - r.height) / 2);
            } else {
                int n = r.x = anchor == IdeBackgroundUtil.Anchor.TOP_LEFT || anchor == IdeBackgroundUtil.Anchor.MIDDLE_LEFT || anchor == IdeBackgroundUtil.Anchor.BOTTOM_LEFT ? 0 : w - r.width;
                r.y = anchor == IdeBackgroundUtil.Anchor.TOP_LEFT || anchor == IdeBackgroundUtil.Anchor.TOP_RIGHT ? 0 : (anchor == IdeBackgroundUtil.Anchor.BOTTOM_LEFT || anchor == IdeBackgroundUtil.Anchor.BOTTOM_RIGHT ? h - r.height : (h - r.height) / 2);
            }
        }

        void clearImages(long currentTime) {
            boolean all = currentTime <= 0L;
            Iterator<GraphicsConfiguration> it = this.cachedMap.keySet().iterator();
            while (it.hasNext()) {
                GraphicsConfiguration cfg = it.next();
                Cached c = this.cachedMap.get(cfg);
                if (!all && currentTime - c.touched <= 120000L) continue;
                it.remove();
                LOG.info(ImagePainter.logPrefix(cfg, c.image) + "image flushed" + (String)(all ? "" : "; untouched for " + StringUtil.formatDuration((long)(currentTime - c.touched))));
                c.image.flush();
            }
        }

        @Nullable
        private static VolatileImage validateImage(@Nullable GraphicsConfiguration cfg, @Nullable VolatileImage image2) {
            if (image2 == null) {
                return null;
            }
            boolean lost1 = image2.contentsLost();
            int validated = image2.validate(cfg);
            boolean lost2 = image2.contentsLost();
            if (lost1 || lost2 || validated != 0) {
                LOG.info(ImagePainter.logPrefix(cfg, image2) + "image flushed: contentsLost=" + lost1 + "||" + lost2 + "; validate=" + validated);
                image2.flush();
                return null;
            }
            return image2;
        }

        @NotNull
        private static VolatileImage createImage(@Nullable GraphicsConfiguration cfg, int w, int h) {
            VolatileImage image2;
            GraphicsConfiguration safe = cfg != null ? cfg : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            try {
                image2 = safe.createCompatibleVolatileImage(w, h, new ImageCapabilities(true), 3);
            }
            catch (Exception e) {
                image2 = safe.createCompatibleVolatileImage(w, h, 3);
            }
            image2.validate(cfg);
            image2.setAccelerationPriority(1.0f);
            ImageCapabilities caps = image2.getCapabilities();
            LOG.info(ImagePainter.logPrefix(cfg, image2) + (caps.isAccelerated() ? "" : "non-") + "accelerated " + (caps.isTrueVolatile() ? "" : "non-") + "volatile image created");
            VolatileImage volatileImage = image2;
            if (volatileImage == null) {
                ImagePainter.$$$reportNull$$$0(11);
            }
            return volatileImage;
        }

        @NotNull
        private static String logPrefix(@Nullable GraphicsConfiguration cfg, @NotNull VolatileImage image2) {
            if (image2 == null) {
                ImagePainter.$$$reportNull$$$0(12);
            }
            String string = "(" + (cfg == null ? "null" : cfg.getClass().getSimpleName()) + ") " + image2.getWidth() + "x" + image2.getHeight() + " ";
            if (string == null) {
                ImagePainter.$$$reportNull$$$0(13);
            }
            return string;
        }

        @NotNull
        static BufferedImageFilter flipFilter(final boolean flipV, final boolean flipH) {
            return new BufferedImageFilter(new BufferedImageOp(){

                @Override
                public BufferedImage filter(BufferedImage src, BufferedImage dest) {
                    AffineTransform tx = AffineTransform.getScaleInstance(flipH ? -1.0 : 1.0, flipV ? -1.0 : 1.0);
                    tx.translate(flipH ? (double)(-src.getWidth(null)) : 0.0, flipV ? (double)(-src.getHeight(null)) : 0.0);
                    AffineTransformOp op = new AffineTransformOp(tx, 1);
                    return op.filter(src, dest);
                }

                @Override
                public Rectangle2D getBounds2D(BufferedImage src) {
                    return null;
                }

                @Override
                public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
                    return null;
                }

                @Override
                public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
                    return null;
                }

                @Override
                public RenderingHints getRenderingHints() {
                    return null;
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 11, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 2: 
                case 7: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "image";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fillType";
                    break;
                }
                case 4: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 5: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insets";
                    break;
                }
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/PainterHelper$ImagePainter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/PainterHelper$ImagePainter";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createImage";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "logPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "executePaint";
                    break;
                }
                case 11: 
                case 13: {
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "logPrefix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 11, 13 -> new IllegalStateException(string);
            };
        }
    }

    private static final class Cached {
        final VolatileImage image;
        final Rectangle src;
        final Rectangle dst;
        long touched;

        Cached(VolatileImage image2, Rectangle src, Rectangle dst) {
            this.image = image2;
            this.src = src;
            this.dst = dst;
        }
    }
}

