/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.ClipboardSynchronizer;
import com.intellij.notification.ActionCenter;
import com.intellij.notification.Notification;
import com.intellij.notification.impl.ApplicationNotificationsModel;
import com.intellij.notification.impl.StatusMessage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ClickListener;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StatusPanel
extends JPanel {
    private Notification myCurrentNotification;
    @NlsSafe
    @Nullable
    private String myTimeText;
    private boolean myDirty;
    private boolean myAfterClick;
    private Alarm myLogAlarm;
    private Action myCopyAction;
    private final TextPanel myTextPanel = new TextPanel(){

        @Override
        protected String getTextForPreferredSize() {
            return this.getText();
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, y, Math.min(w, StatusPanel.this.getWidth()), h);
        }

        @Override
        protected String truncateText(String text2, Rectangle bounds, FontMetrics fm, Rectangle textR, Rectangle iconR, int maxWidth) {
            if (StatusPanel.this.myTimeText != null && text2.endsWith(StatusPanel.this.myTimeText)) {
                int withoutTime = maxWidth - fm.stringWidth(StatusPanel.this.myTimeText);
                Rectangle boundsForTrim = new Rectangle(withoutTime, bounds.height);
                return super.truncateText(text2, boundsForTrim, fm, textR, iconR, withoutTime) + StatusPanel.this.myTimeText;
            }
            return super.truncateText(text2, bounds, fm, textR, iconR, maxWidth);
        }
    };

    StatusPanel() {
        super(new BorderLayout());
        this.setOpaque(false);
        this.myTextPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (StatusPanel.this.myCurrentNotification != null || StatusPanel.this.myAfterClick) {
                    Project project2 = StatusPanel.this.getActiveProject();
                    if (project2 != null) {
                        ActionCenter.toggleLog(project2);
                    }
                    StatusPanel.this.myAfterClick = true;
                    StatusPanel.this.myTextPanel.setExplicitSize(StatusPanel.this.myTextPanel.getSize());
                    UIUtil.setCursor((Component)StatusPanel.this.myTextPanel, (Cursor)Cursor.getPredefinedCursor(12));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/status/StatusPanel$2", "onClick"));
            }
        }.installOn((Component)this.myTextPanel);
        this.myTextPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                StatusPanel.this.myTextPanel.setExplicitSize(null);
                StatusPanel.this.myTextPanel.revalidate();
                StatusPanel.this.myAfterClick = false;
                if (StatusPanel.this.myCurrentNotification == null) {
                    UIUtil.setCursor((Component)StatusPanel.this.myTextPanel, (Cursor)Cursor.getDefaultCursor());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    if (StatusPanel.this.myCopyAction == null) {
                        StatusPanel.this.myCopyAction = StatusPanel.this.createCopyAction();
                    }
                    JBPopupMenu menu = new JBPopupMenu();
                    menu.add((JMenuItem)new JBMenuItem(StatusPanel.this.myCopyAction));
                    JBPopupMenu.showByEvent((MouseEvent)e, (JPopupMenu)menu);
                }
            }
        });
        this.add((Component)this.myTextPanel, "West");
    }

    private Action createCopyAction() {
        ActionManager actionManager = ActionManager.getInstance();
        if (actionManager == null) {
            return null;
        }
        AnAction action2 = actionManager.getAction("$Copy");
        if (action2 == null) {
            return null;
        }
        return new AbstractAction(action2.getTemplatePresentation().getText(), action2.getTemplatePresentation().getIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringSelection content2 = new StringSelection(StatusPanel.this.getText());
                ClipboardSynchronizer.getInstance().setContent(content2, content2);
            }

            @Override
            public boolean isEnabled() {
                return !StatusPanel.this.getText().isEmpty();
            }
        };
    }

    @Nullable
    private Project getActiveProject() {
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            JComponent frame;
            IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(project2);
            if (ideFrame == null || !SwingUtilities.isDescendingFrom(this.myTextPanel, frame = ideFrame.getComponent())) continue;
            return project2;
        }
        return null;
    }

    @Nullable
    private Alarm getAlarm() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myLogAlarm == null || this.myLogAlarm.isDisposed()) {
            this.myLogAlarm = null;
            Project project2 = this.getActiveProject();
            if (project2 != null && !project2.isDisposed()) {
                this.myLogAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project2);
            }
        }
        return this.myLogAlarm;
    }

    public boolean updateText(@NlsContexts.StatusBarText @Nullable String nonLogText) {
        ThreadingAssertions.assertEventDispatchThread();
        Project project2 = this.getActiveProject();
        final StatusMessage statusMessage = project2 != null ? ApplicationNotificationsModel.getStatusMessage(project2) : null;
        final Alarm alarm = this.getAlarm();
        Notification notification2 = this.myCurrentNotification = StringUtil.isEmpty((String)nonLogText) && statusMessage != null && alarm != null ? statusMessage.notification() : null;
        if (alarm != null) {
            alarm.cancelAllRequests();
        }
        if (this.myCurrentNotification != null) {
            UIUtil.setCursor((Component)this.myTextPanel, (Cursor)Cursor.getPredefinedCursor(12));
            new Runnable(){

                @Override
                public void run() {
                    assert (statusMessage != null);
                    Object text2 = statusMessage.text();
                    if (StatusPanel.this.myDirty || System.currentTimeMillis() - statusMessage.stamp() >= 60000L) {
                        StatusPanel.this.myTimeText = " (" + StringUtil.decapitalize((String)DateFormatUtil.formatPrettyDateTime((long)statusMessage.stamp())) + ")";
                        text2 = (String)text2 + StatusPanel.this.myTimeText;
                    } else {
                        StatusPanel.this.myTimeText = null;
                    }
                    StatusPanel.this.setStatusText((String)text2);
                    alarm.addRequest((Runnable)this, 30000);
                }
            }.run();
        } else {
            this.myTimeText = null;
            UIUtil.setCursor((Component)this.myTextPanel, (Cursor)Cursor.getDefaultCursor());
            this.myDirty = true;
            this.setStatusText(nonLogText);
        }
        return this.myCurrentNotification != null;
    }

    private void setStatusText(@NlsContexts.StatusBarText String text2) {
        this.myTextPanel.setText(text2);
    }

    @Nls
    public String getText() {
        return this.myTextPanel.getText();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleStatusPanel();
        }
        return this.accessibleContext;
    }

    protected final class AccessibleStatusPanel
    extends JPanel.AccessibleJPanel {
        protected AccessibleStatusPanel() {
            super(StatusPanel.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.STATUS_BAR;
        }
    }
}

