/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.UIBundle;
import com.intellij.util.LazyInitializer;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class VfsRefreshIndicatorWidgetFactory
implements StatusBarWidgetFactory {
    private static final String ID = "VfsRefresh";
    private volatile boolean myAvailable = ExperimentalUI.isNewUI() && UISettings.getInstance().getShowNavigationBarInBottom();

    public VfsRefreshIndicatorWidgetFactory() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(UISettingsListener.TOPIC, newUiSettings -> {
            this.myAvailable = ExperimentalUI.isNewUI() && newUiSettings.getShowNavigationBarInBottom();
            ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
            if (projectManager != null) {
                for (Project project2 : projectManager.getOpenProjects()) {
                    ((StatusBarWidgetsManager)((Object)((Object)project2.getService(StatusBarWidgetsManager.class)))).updateWidget(this);
                }
            }
        });
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        String string = UIBundle.message((String)"status.bar.vfs.refresh.widget.name", (Object[])new Object[0]);
        if (string == null) {
            VfsRefreshIndicatorWidgetFactory.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2) {
        if (project2 == null) {
            VfsRefreshIndicatorWidgetFactory.$$$reportNull$$$0(1);
        }
        return this.myAvailable;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @NotNull
    public StatusBarWidget createWidget(@NotNull Project project2) {
        if (project2 == null) {
            VfsRefreshIndicatorWidgetFactory.$$$reportNull$$$0(2);
        }
        return new VfsRefreshWidget();
    }

    @RequiresEdt
    public static void start(@NotNull StatusBar statusBar, @NlsContexts.Tooltip @NotNull String tooltipText) {
        if (statusBar == null) {
            VfsRefreshIndicatorWidgetFactory.$$$reportNull$$$0(3);
        }
        if (tooltipText == null) {
            VfsRefreshIndicatorWidgetFactory.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.assertEventDispatchThread();
        StatusBarWidget statusBarWidget = statusBar.getWidget(ID);
        if (statusBarWidget instanceof VfsRefreshWidget) {
            VfsRefreshWidget widget2 = (VfsRefreshWidget)statusBarWidget;
            widget2.getComponent().start(tooltipText);
        }
    }

    @RequiresEdt
    public static void stop(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            VfsRefreshIndicatorWidgetFactory.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.assertEventDispatchThread();
        StatusBarWidget statusBarWidget = statusBar.getWidget(ID);
        if (statusBarWidget instanceof VfsRefreshWidget) {
            VfsRefreshWidget widget2 = (VfsRefreshWidget)statusBarWidget;
            widget2.getComponent().stop();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/VfsRefreshIndicatorWidgetFactory";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/VfsRefreshIndicatorWidgetFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createWidget";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "stop";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    private static final class VfsRefreshWidget
    implements CustomStatusBarWidget {
        private final LazyInitializer.LazyValue<WidgetComponent> myComponent = LazyInitializer.create(WidgetComponent::new);

        private VfsRefreshWidget() {
        }

        @NotNull
        public String ID() {
            return VfsRefreshIndicatorWidgetFactory.ID;
        }

        public WidgetComponent getComponent() {
            return (WidgetComponent)this.myComponent.get();
        }

        private static class WidgetComponent
        extends JLabel {
            private final Icon INACTIVE_ICON = EmptyIcon.ICON_16;
            private final Icon PROGRESS_ICON = new AnimatedIcon.FS();

            private WidgetComponent() {
                this.setIcon(this.INACTIVE_ICON);
                this.setEnabled(false);
            }

            private void start(@NlsContexts.Tooltip String tooltipText) {
                this.setIcon(this.PROGRESS_ICON);
                this.setEnabled(true);
                this.setToolTipText(tooltipText);
            }

            private void stop() {
                this.setIcon(this.INACTIVE_ICON);
                this.setEnabled(false);
                this.setToolTipText(UIBundle.message((String)"status.bar.vfs.refresh.widget.tooltip", (Object[])new Object[0]));
            }
        }
    }
}

