/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.impl.customization;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0007\u001a\u0018\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u001a\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a8\u0006\b"}, d2={"currentOsNameForIntelliJSupport", "", "computePatchFileName", "from", "Lcom/intellij/openapi/util/BuildNumber;", "to", "computeCustomPatchDownloadUrl", "Lcom/intellij/util/Url;", "intellij.platform.ide.impl"})
public final class BaseJetBrainsExternalProductResourceUrlsKt {
    @ApiStatus.Internal
    @NotNull
    public static final String currentOsNameForIntelliJSupport() {
        OS oS = OS.CURRENT;
        return switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 1 -> "win-" + (OS.CURRENT.isAtLeast(10, 0) ? "-10" : "-8") + (CpuArch.CURRENT.width == 64 ? "-64" : "");
            case 2 -> "mac";
            case 3 -> "linux";
            default -> "other-os";
        };
    }

    @NotNull
    public static final String computePatchFileName(@NotNull BuildNumber from, @NotNull BuildNumber to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        String string = ApplicationInfo.getInstance().getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        String product = string;
        String runtime = CpuArch.isArm64() ? "-aarch64" : "";
        return product + "-" + from.withoutProductCode().asString() + "-" + to.withoutProductCode().asString() + "-patch" + runtime + "-" + PatchInfo.Companion.getOS_SUFFIX() + ".jar";
    }

    @Nullable
    public static final Url computeCustomPatchDownloadUrl(@NotNull BuildNumber from, @NotNull BuildNumber to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        String string = System.getProperty("idea.patches.url");
        if (string == null) {
            return null;
        }
        String customPatchesUrl = string;
        return Urls.newFromEncoded((String)customPatchesUrl).resolve(BaseJetBrainsExternalProductResourceUrlsKt.computePatchFileName(from, to));
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.macOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Linux.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

