/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.impl.presentationAssistant;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.ide.impl.presentationAssistant.KeymapKindKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0000J\u0014\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u0096\u0080\u0004J\n\u0010\u0014\u001a\u00020\u0003H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/ide/impl/presentationAssistant/KeymapKind;", "", "value", "", "displayName", "defaultLabel", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "getDisplayName", "getDefaultLabel", "isMac", "", "()Z", "getAlternativeKind", "equals", "other", "hashCode", "", "toString", "Companion", "intellij.platform.ide.impl"})
public final class KeymapKind {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;
    @NotNull
    private final String displayName;
    @NotNull
    private final String defaultLabel;
    private final boolean isMac;
    @NotNull
    private static final KeymapKind MAC;
    @NotNull
    private static final KeymapKind WIN;

    public KeymapKind(@NotNull String value, @Nls @NotNull String displayName, @Nls @NotNull String defaultLabel) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)defaultLabel, (String)"defaultLabel");
        this.value = value;
        this.displayName = displayName;
        this.defaultLabel = defaultLabel;
        this.isMac = KeymapKindKt.access$getContainsMacOS(this.value);
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public final String getDefaultLabel() {
        return this.defaultLabel;
    }

    public final boolean isMac() {
        return this.isMac;
    }

    @NotNull
    public final KeymapKind getAlternativeKind() {
        return KeymapKindKt.access$getContainsMacOS(this.value) ? WIN : MAC;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.platform.ide.impl.presentationAssistant.KeymapKind");
        KeymapKind cfr_ignored_0 = (KeymapKind)object2;
        return Intrinsics.areEqual((Object)this.value, (Object)((KeymapKind)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @NotNull
    public String toString() {
        return "KeymapKind(value='" + this.value + "', displayName='" + this.displayName + "', defaultLabel='" + this.defaultLabel + "', isMac=" + this.isMac + ")";
    }

    static {
        String string = IdeBundle.message((String)"presentation.assistant.configurable.keymap.mac", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = IdeBundle.message((String)"presentation.assistant.configurable.keymap.mac", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        MAC = new KeymapKind("Mac OS X 10.5+", string, string2);
        String string3 = IdeBundle.message((String)"presentation.assistant.configurable.keymap.win", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String string4 = IdeBundle.message((String)"presentation.assistant.configurable.keymap.win.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        WIN = new KeymapKind("$default", string3, string4);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u00052\b\b\u0001\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/ide/impl/presentationAssistant/KeymapKind$Companion;", "", "<init>", "()V", "MAC", "Lcom/intellij/platform/ide/impl/presentationAssistant/KeymapKind;", "getMAC", "()Lcom/intellij/platform/ide/impl/presentationAssistant/KeymapKind;", "WIN", "getWIN", "from", "value", "", "defaultForOS", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KeymapKind getMAC() {
            return MAC;
        }

        @NotNull
        public final KeymapKind getWIN() {
            return WIN;
        }

        @NotNull
        public final KeymapKind from(@NlsSafe @NotNull String value) {
            KeymapKind keymapKind;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = value;
            if (Intrinsics.areEqual((Object)string, (Object)"Mac OS X 10.5+")) {
                keymapKind = this.getMAC();
            } else if (Intrinsics.areEqual((Object)string, (Object)"$default")) {
                keymapKind = this.getWIN();
            } else {
                Keymap keymap2 = KeymapManagerEx.getInstanceEx().getKeymap(value);
                if (keymap2 != null) {
                    Keymap it = keymap2;
                    boolean bl = false;
                    String string2 = it.getPresentableName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPresentableName(...)");
                    String string3 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                    String string4 = KeymapKindKt.access$getContainsMacOS(string3) ? IdeBundle.message((String)"presentation.assistant.configurable.keymap.mac", (Object[])new Object[0]) : it.getPresentableName();
                    Intrinsics.checkNotNull((Object)string4);
                    KeymapKind keymapKind2 = new KeymapKind(value, string2, string4);
                    keymapKind = keymapKind2;
                } else {
                    keymapKind = new KeymapKind(value, value, value);
                }
            }
            return keymapKind;
        }

        @NotNull
        public final KeymapKind defaultForOS() {
            return SystemInfo.isMac ? this.getMAC() : this.getWIN();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

