/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.impl.statistic;

import com.intellij.internal.statistic.collectors.fus.actions.persistence.ToolWindowCollector;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060\rR\u00020\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/ide/impl/statistic/ToolWindowStateCollector;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "windowsSize", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "collectors", "Lcom/intellij/platform/ide/impl/statistic/ToolWindowStateCollector$Collector;", "reportResizeEvent", "", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "toolWindow", "Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "stateChanged", "Lcom/intellij/openapi/wm/ToolWindow;", "changeType", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener$ToolWindowManagerEventType;", "toolWindowUnregistered", "id", "Collector", "intellij.platform.ide.impl"})
final class ToolWindowStateCollector {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConcurrentHashMap<String, Integer> windowsSize;
    @NotNull
    private final ConcurrentHashMap<String, Collector> collectors;

    public ToolWindowStateCollector(@NotNull Project project2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project2;
        this.coroutineScope = coroutineScope;
        this.windowsSize = new ConcurrentHashMap();
        this.collectors = new ConcurrentHashMap();
    }

    private final void reportResizeEvent(ToolWindowManager toolWindowManager, ToolWindowImpl toolWindow2) {
        block5: {
            WindowInfo windowInfo;
            int size2;
            block4: {
                size2 = toolWindow2.getAnchor().isHorizontal() ? toolWindow2.getComponent().getHeight() : toolWindow2.getComponent().getWidth();
                Integer oldSize = this.windowsSize.get(toolWindow2.getId());
                if (oldSize == null) break block4;
                int n = size2;
                if (oldSize == n) break block5;
            }
            WindowInfoImpl windowInfoImpl = (windowInfo = toolWindow2.getWindowInfo()) instanceof WindowInfoImpl ? (WindowInfoImpl)windowInfo : null;
            if (windowInfoImpl == null) {
                return;
            }
            WindowInfoImpl windowInfo2 = windowInfoImpl;
            ToolWindowCollector.getInstance().recordResized(this.project, windowInfo2, toolWindowManager.isMaximized((ToolWindow)toolWindow2));
            ((Map)this.windowsSize).put(toolWindow2.getId(), size2);
        }
    }

    public final void stateChanged(@NotNull ToolWindowManager toolWindowManager, @NotNull ToolWindow toolWindow2, @NotNull ToolWindowManagerListener.ToolWindowManagerEventType changeType) {
        Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)((Object)changeType), (String)"changeType");
        if (changeType == ToolWindowManagerListener.ToolWindowManagerEventType.MovedOrResized && toolWindow2.getType() == ToolWindowType.DOCKED && toolWindow2 instanceof ToolWindowImpl) {
            this.collectors.computeIfAbsent(((ToolWindowImpl)toolWindow2).getId(), arg_0 -> ToolWindowStateCollector.stateChanged$lambda$1(arg_0 -> ToolWindowStateCollector.stateChanged$lambda$0(this, toolWindowManager, toolWindow2, arg_0), arg_0)).ping();
        }
    }

    public final void toolWindowUnregistered(@NotNull String id2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Collector collector = this.collectors.remove(id2);
            if (collector == null) break block0;
            collector.cancel();
        }
    }

    private static final Collector stateChanged$lambda$0(ToolWindowStateCollector this$0, ToolWindowManager $toolWindowManager, ToolWindow $toolWindow, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.new Collector($toolWindowManager, (ToolWindowImpl)$toolWindow);
    }

    private static final Collector stateChanged$lambda$1(Function1 $tmp0, Object p0) {
        return (Collector)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$reportResizeEvent(ToolWindowStateCollector $this, ToolWindowManager toolWindowManager, ToolWindowImpl toolWindow2) {
        $this.reportResizeEvent(toolWindowManager, toolWindow2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\r\u001a\u00020\nJ\u0006\u0010\u000e\u001a\u00020\nR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/ide/impl/statistic/ToolWindowStateCollector$Collector;", "", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "toolWindow", "Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "<init>", "(Lcom/intellij/platform/ide/impl/statistic/ToolWindowStateCollector;Lcom/intellij/openapi/wm/ToolWindowManager;Lcom/intellij/openapi/wm/impl/ToolWindowImpl;)V", "flow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "job", "Lkotlinx/coroutines/Job;", "ping", "cancel", "intellij.platform.ide.impl"})
    private final class Collector {
        @NotNull
        private final MutableSharedFlow<Unit> flow;
        @NotNull
        private final Job job;

        public Collector(@NotNull ToolWindowManager toolWindowManager, ToolWindowImpl toolWindow2) {
            Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
            Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
            this.flow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
            this.job = BuildersKt.launch$default((CoroutineScope)ToolWindowStateCollector.this.coroutineScope, (CoroutineContext)new CoroutineName("Tool window resize collector for " + toolWindow2.getId()).plus(CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, ToolWindowStateCollector.this, toolWindowManager, toolWindow2, null){
                int label;
                final /* synthetic */ Collector this$0;
                final /* synthetic */ ToolWindowStateCollector this$1;
                final /* synthetic */ ToolWindowManager $toolWindowManager;
                final /* synthetic */ ToolWindowImpl $toolWindow;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$toolWindowManager = $toolWindowManager;
                    this.$toolWindow = $toolWindow;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = FlowKt.debounce((Flow)((Flow)Collector.access$getFlow$p(this.this$0)), (long)500L).collect(new FlowCollector(this.this$1, this.$toolWindowManager, this.$toolWindow){
                                final /* synthetic */ ToolWindowStateCollector this$0;
                                final /* synthetic */ ToolWindowManager $toolWindowManager;
                                final /* synthetic */ ToolWindowImpl $toolWindow;
                                {
                                    this.this$0 = $receiver;
                                    this.$toolWindowManager = $toolWindowManager;
                                    this.$toolWindow = $toolWindow;
                                }

                                public final Object emit(Unit it, Continuation<? super Unit> $completion) {
                                    ToolWindowStateCollector.access$reportResizeEvent(this.this$0, this.$toolWindowManager, this.$toolWindow);
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        public final void ping() {
            if (!this.flow.tryEmit((Object)Unit.INSTANCE)) {
                throw new IllegalStateException("Check failed.");
            }
        }

        public final void cancel() {
            Job.DefaultImpls.cancel$default((Job)this.job, null, (int)1, null);
        }

        public static final /* synthetic */ MutableSharedFlow access$getFlow$p(Collector $this) {
            return $this.flow;
        }
    }
}

