/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.menu;

import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/ide/menu/FloatingMenuBarExitFullScreenButton;", "Ljavax/swing/JButton;", "<init>", "()V", "getPreferredSize", "Ljava/awt/Dimension;", "getMaximumSize", "paint", "", "g", "Ljava/awt/Graphics;", "intellij.platform.ide.impl"})
final class FloatingMenuBarExitFullScreenButton
extends JButton {
    public FloatingMenuBarExitFullScreenButton() {
        this.setFocusable(false);
        this.addActionListener(arg_0 -> FloatingMenuBarExitFullScreenButton._init_$lambda$0(this, arg_0));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                model.setRollover(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                model.setRollover(false);
            }
        });
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Container parent = this.getParent();
        int height = this.isVisible() && parent != null ? parent.getSize().height - parent.getInsets().top - parent.getInsets().bottom : super.getPreferredSize().height;
        return new Dimension(height, height);
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        try {
            g2d.setColor(UIManager.getColor("Label.background"));
            g2d.fillRect(0, 0, this.getWidth() + 1, this.getHeight() + 1);
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            double s = (double)this.getHeight() / (double)13;
            g2d.translate(s, s);
            RoundRectangle2D.Double plate = new RoundRectangle2D.Double(0.0, 0.0, s * (double)11, s * (double)11, s, s);
            Color color = UIManager.getColor("Label.foreground");
            boolean hover = this.model.isRollover() || this.model.isPressed();
            g2d.setColor(ColorUtil.withAlpha((Color)color, (double)(hover ? 0.25 : 0.18)));
            g2d.fill(plate);
            g2d.setColor(ColorUtil.withAlpha((Color)color, (double)(hover ? 0.4 : 0.33)));
            g2d.draw(plate);
            g2d.setColor(ColorUtil.withAlpha((Color)color, (double)(hover ? 0.7 : 0.66)));
            GeneralPath path = new GeneralPath();
            path.moveTo(s * (double)2, s * (double)6);
            path.lineTo(s * (double)5, s * (double)6);
            path.lineTo(s * (double)5, s * (double)9);
            path.lineTo(s * (double)4, s * (double)8);
            path.lineTo(s * (double)2, s * (double)10);
            path.quadTo(s * (double)2 - s / Math.sqrt(2.0), s * (double)9 + s / Math.sqrt(2.0), s, s * (double)9);
            path.lineTo(s * (double)3, s * (double)7);
            path.lineTo(s * (double)2, s * (double)6);
            path.closePath();
            g2d.fill(path);
            g2d.draw(path);
            path = new GeneralPath();
            path.moveTo(s * (double)6, s * (double)2);
            path.lineTo(s * (double)6, s * (double)5);
            path.lineTo(s * (double)9, s * (double)5);
            path.lineTo(s * (double)8, s * (double)4);
            path.lineTo(s * (double)10, s * (double)2);
            path.quadTo(s * (double)9 + s / Math.sqrt(2.0), s * (double)2 - s / Math.sqrt(2.0), s * (double)9, s);
            path.lineTo(s * (double)7, s * (double)3);
            path.lineTo(s * (double)6, s * (double)2);
            path.closePath();
            g2d.fill(path);
            g2d.draw(path);
        }
        finally {
            g2d.dispose();
        }
    }

    private static final void _init_$lambda$0(FloatingMenuBarExitFullScreenButton this$0, ActionEvent it) {
        block0: {
            ProjectFrameHelper projectFrameHelper = ProjectFrameHelper.Companion.getFrameHelper(SwingUtilities.getWindowAncestor(this$0));
            if (projectFrameHelper == null) break block0;
            projectFrameHelper.toggleFullScreen(false);
        }
    }
}

