/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.menu;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.status.ClockPanel;
import com.intellij.platform.ide.menu.FloatingMenuBarExitFullScreenButton;
import com.intellij.platform.ide.menu.IdeJMenuBar;
import com.intellij.platform.ide.menu.IdeJMenuBarKt;
import com.intellij.platform.ide.menu.IdeMenuBarState;
import com.intellij.platform.ide.menu.IdeMenuFlavor;
import com.intellij.platform.ide.menu.MyMouseListener;
import com.intellij.ui.ClientProperty;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u000223B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\b\u0010\u001f\u001a\u00020\u001dH\u0002J\b\u0010 \u001a\u00020\u001dH\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0014H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0016J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020(H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010+\u001a\u00020\u001dH\u0016J\b\u0010,\u001a\u00020\u001dH\u0002J\b\u0010-\u001a\u00020\u001dH\u0016J\b\u0010.\u001a\u00020\u001dH\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u00064"}, d2={"Lcom/intellij/platform/ide/menu/FloatingMenuBarFlavor;", "Lcom/intellij/platform/ide/menu/IdeMenuFlavor;", "menuBar", "Lcom/intellij/platform/ide/menu/IdeJMenuBar;", "<init>", "(Lcom/intellij/platform/ide/menu/IdeJMenuBar;)V", "clockPanel", "Lcom/intellij/openapi/wm/impl/status/ClockPanel;", "getClockPanel", "()Lcom/intellij/openapi/wm/impl/status/ClockPanel;", "exitFullScreenButton", "Lcom/intellij/platform/ide/menu/FloatingMenuBarExitFullScreenButton;", "getExitFullScreenButton", "()Lcom/intellij/platform/ide/menu/FloatingMenuBarExitFullScreenButton;", "animator", "Lcom/intellij/platform/ide/menu/FloatingMenuBarFlavor$MyAnimator;", "activationWatcher", "Ljavax/swing/Timer;", "Lorg/jetbrains/annotations/NotNull;", "activated", "", "value", "Lcom/intellij/platform/ide/menu/IdeMenuBarState;", "state", "getState", "()Lcom/intellij/platform/ide/menu/IdeMenuBarState;", "setState", "(Lcom/intellij/platform/ide/menu/IdeMenuBarState;)V", "updateFullScreenControls", "", "fullScreen", "addClockAndFullScreenButton", "removeClockAndFullScreenExitButton", "jMenuSelectionChanged", "isIncluded", "getPreferredSize", "Ljava/awt/Dimension;", "size", "considerRestartingAnimator", "mouseEvent", "Ljava/awt/event/MouseEvent;", "findActualComponent", "Ljava/awt/Component;", "suspendAnimator", "restartAnimator", "updateAppMenu", "layoutClockPanelAndButton", "correctMenuCount", "", "menuCount", "MyActionListener", "MyAnimator", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nFloatingMenuBarFlavor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatingMenuBarFlavor.kt\ncom/intellij/platform/ide/menu/FloatingMenuBarFlavor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,348:1\n1#2:349\n*E\n"})
public final class FloatingMenuBarFlavor
implements IdeMenuFlavor {
    @NotNull
    private final IdeJMenuBar menuBar;
    @NotNull
    private final MyAnimator animator;
    @NotNull
    private final Timer activationWatcher;
    private boolean activated;
    @NotNull
    private IdeMenuBarState state;

    public FloatingMenuBarFlavor(@NotNull IdeJMenuBar menuBar) {
        ProjectFrameHelper frameHelper;
        Intrinsics.checkNotNullParameter((Object)menuBar, (String)"menuBar");
        this.menuBar = menuBar;
        this.animator = new MyAnimator(this.menuBar, this);
        Timer timer = TimerUtil.createNamedTimer((String)"IdeMenuBar", (int)100, (ActionListener)new MyActionListener());
        Intrinsics.checkNotNullExpressionValue((Object)timer, (String)"createNamedTimer(...)");
        this.activationWatcher = timer;
        this.state = IdeMenuBarState.EXPANDED;
        ProjectFrameHelper projectFrameHelper = frameHelper = ProjectFrameHelper.Companion.getFrameHelper(this.menuBar.frame);
        this.updateFullScreenControls(projectFrameHelper != null ? projectFrameHelper.isInFullScreen() : false);
        this.menuBar.addMouseListener(new MyMouseListener());
        this.menuBar.addPropertyChangeListener("ide.frame.full.screen", arg_0 -> FloatingMenuBarFlavor._init_$lambda$0(this, arg_0));
        IdeEventQueue.Companion.getInstance().addDispatcher(arg_0 -> FloatingMenuBarFlavor._init_$lambda$1(this, arg_0), this.menuBar.coroutineScope);
    }

    private final ClockPanel getClockPanel() {
        ClockPanel clockPanel;
        block2: {
            Component[] componentArray = this.menuBar.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            Object[] objectArray = componentArray;
            int n = objectArray.length;
            for (int j = 0; j < n; ++j) {
                Component it = (Component)objectArray[j];
                boolean bl = false;
                clockPanel = it instanceof ClockPanel ? (ClockPanel)it : null;
                if (clockPanel == null) {
                    continue;
                }
                break block2;
            }
            clockPanel = null;
        }
        return clockPanel;
    }

    private final FloatingMenuBarExitFullScreenButton getExitFullScreenButton() {
        FloatingMenuBarExitFullScreenButton floatingMenuBarExitFullScreenButton;
        block2: {
            Component[] componentArray = this.menuBar.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            Object[] objectArray = componentArray;
            int n = objectArray.length;
            for (int j = 0; j < n; ++j) {
                Component it = (Component)objectArray[j];
                boolean bl = false;
                floatingMenuBarExitFullScreenButton = it instanceof FloatingMenuBarExitFullScreenButton ? (FloatingMenuBarExitFullScreenButton)it : null;
                if (floatingMenuBarExitFullScreenButton == null) {
                    continue;
                }
                break block2;
            }
            floatingMenuBarExitFullScreenButton = null;
        }
        return floatingMenuBarExitFullScreenButton;
    }

    @Override
    @NotNull
    public IdeMenuBarState getState() {
        return this.state;
    }

    public void setState(@NotNull IdeMenuBarState value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.state = value;
        if (value == IdeMenuBarState.EXPANDING && !this.activationWatcher.isRunning()) {
            this.activationWatcher.start();
        } else if (this.activationWatcher.isRunning() && (value == IdeMenuBarState.EXPANDED || value == IdeMenuBarState.COLLAPSED)) {
            this.activationWatcher.stop();
        }
        this.menuBar.setOpaque(value != IdeMenuBarState.COLLAPSED);
    }

    private final void updateFullScreenControls(boolean fullScreen) {
        if (fullScreen) {
            this.setState(IdeMenuBarState.COLLAPSING);
            this.restartAnimator();
        } else {
            this.setState(IdeMenuBarState.EXPANDED);
            this.animator.suspend();
        }
    }

    private final void addClockAndFullScreenButton() {
        if (this.getClockPanel() == null) {
            this.menuBar.add(new ClockPanel());
        }
        if (this.getExitFullScreenButton() == null) {
            this.menuBar.add(new FloatingMenuBarExitFullScreenButton());
        }
    }

    private final void removeClockAndFullScreenExitButton() {
        block1: {
            JComponent it;
            ClockPanel clockPanel = this.getClockPanel();
            if (clockPanel != null) {
                it = clockPanel;
                boolean bl = false;
                this.menuBar.remove(it);
            }
            FloatingMenuBarExitFullScreenButton floatingMenuBarExitFullScreenButton = this.getExitFullScreenButton();
            if (floatingMenuBarExitFullScreenButton == null) break block1;
            it = floatingMenuBarExitFullScreenButton;
            boolean bl = false;
            this.menuBar.remove(it);
        }
    }

    @Override
    public void jMenuSelectionChanged(boolean isIncluded) {
        if (!isIncluded && this.getState() == IdeMenuBarState.TEMPORARY_EXPANDED) {
            this.activated = false;
            this.setState(IdeMenuBarState.COLLAPSING);
            this.restartAnimator();
            return;
        }
        if (isIncluded && this.getState() == IdeMenuBarState.COLLAPSED) {
            this.activated = true;
            this.setState(IdeMenuBarState.TEMPORARY_EXPANDED);
            this.menuBar.revalidate();
            this.menuBar.repaint();
            SwingUtilities.invokeLater(() -> FloatingMenuBarFlavor.jMenuSelectionChanged$lambda$0(this));
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(@NotNull Dimension size2) {
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        if (this.getState().isInProgress()) {
            double progress = this.animator.progress;
            size2.height = 2 + (int)((this.getState() == IdeMenuBarState.COLLAPSING ? 1.0 - progress : progress) * (double)(size2.height - 2));
        } else if (this.getState() == IdeMenuBarState.COLLAPSED) {
            size2.height = 2;
        }
        return size2;
    }

    private final void considerRestartingAnimator(MouseEvent mouseEvent) {
        boolean mouseInside;
        boolean bl = mouseInside = this.activated || UIUtil.isDescendingFrom((Component)this.findActualComponent(mouseEvent), (Component)this.menuBar);
        if (mouseEvent.getID() == 505 && mouseEvent.getSource() == SwingUtilities.windowForComponent(this.menuBar) && !this.activated) {
            mouseInside = false;
        }
        if (mouseInside && this.getState() == IdeMenuBarState.COLLAPSED) {
            this.setState(IdeMenuBarState.EXPANDING);
            this.restartAnimator();
        } else if (!mouseInside && this.getState() != IdeMenuBarState.COLLAPSING && this.getState() != IdeMenuBarState.COLLAPSED) {
            this.setState(IdeMenuBarState.COLLAPSING);
            this.restartAnimator();
        }
    }

    private final Component findActualComponent(MouseEvent mouseEvent) {
        Component component2 = mouseEvent.getComponent();
        if (component2 == null) {
            return null;
        }
        Component component3 = component2;
        Component deepestComponent = this.getState() != IdeMenuBarState.EXPANDED && !this.getState().isInProgress() && this.menuBar.contains(SwingUtilities.convertPoint(component3, mouseEvent.getPoint(), this.menuBar)) ? (Component)this.menuBar : SwingUtilities.getDeepestComponentAt(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        Component component4 = deepestComponent;
        if (component4 == null) {
            component4 = component3;
        }
        return component4;
    }

    @Override
    public void suspendAnimator() {
        this.animator.suspend();
    }

    private final void restartAnimator() {
        this.animator.reset();
        this.animator.resume();
    }

    @Override
    public void updateAppMenu() {
        IdeJMenuBarKt.doUpdateAppMenu();
    }

    @Override
    public void layoutClockPanelAndButton() {
        if (this.getState() == IdeMenuBarState.EXPANDED) {
            this.removeClockAndFullScreenExitButton();
            return;
        }
        this.addClockAndFullScreenButton();
        FloatingMenuBarExitFullScreenButton floatingMenuBarExitFullScreenButton = this.getExitFullScreenButton();
        Intrinsics.checkNotNull((Object)floatingMenuBarExitFullScreenButton);
        FloatingMenuBarExitFullScreenButton exitFullScreenButton = floatingMenuBarExitFullScreenButton;
        ClockPanel clockPanel = this.getClockPanel();
        Intrinsics.checkNotNull((Object)clockPanel);
        ClockPanel clockPanel2 = clockPanel;
        Dimension preferredSize = exitFullScreenButton.getPreferredSize();
        exitFullScreenButton.setBounds(this.menuBar.getBounds().width - preferredSize.width, 0, preferredSize.width, preferredSize.height);
        Dimension dimension = clockPanel2.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        preferredSize = dimension;
        clockPanel2.setBounds(this.menuBar.getBounds().width - preferredSize.width - exitFullScreenButton.getWidth(), 0, preferredSize.width, preferredSize.height);
    }

    @Override
    public int correctMenuCount(int menuCount) {
        return this.getClockPanel() == null ? menuCount : menuCount - 2;
    }

    private static final void _init_$lambda$0(FloatingMenuBarFlavor this$0, PropertyChangeEvent it) {
        boolean fullScreenProperty = ClientProperty.isTrue((Component)this$0.menuBar, (Object)"ide.frame.full.screen");
        this$0.updateFullScreenControls(fullScreenProperty);
    }

    private static final boolean _init_$lambda$1(FloatingMenuBarFlavor this$0, AWTEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this$0.getState() != IdeMenuBarState.EXPANDED && event instanceof MouseEvent) {
            this$0.considerRestartingAnimator((MouseEvent)event);
        }
        return false;
    }

    private static final void jMenuSelectionChanged$lambda$0(FloatingMenuBarFlavor this$0) {
        JMenu menu = this$0.menuBar.getMenu(this$0.menuBar.getSelectionModel().getSelectedIndex());
        if (menu.isPopupMenuVisible()) {
            menu.setPopupMenuVisible(false);
            menu.setPopupMenuVisible(true);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/ide/menu/FloatingMenuBarFlavor$MyActionListener;", "Ljava/awt/event/ActionListener;", "<init>", "(Lcom/intellij/platform/ide/menu/FloatingMenuBarFlavor;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.platform.ide.impl"})
    private final class MyActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (FloatingMenuBarFlavor.this.getState() == IdeMenuBarState.EXPANDED || FloatingMenuBarFlavor.this.getState() == IdeMenuBarState.EXPANDING) {
                return;
            }
            boolean wasActivated = FloatingMenuBarFlavor.this.menuBar.isActivated$intellij_platform_ide_impl();
            if (FloatingMenuBarFlavor.this.activated && !wasActivated && FloatingMenuBarFlavor.this.getState() == IdeMenuBarState.TEMPORARY_EXPANDED) {
                FloatingMenuBarFlavor.this.activated = false;
                FloatingMenuBarFlavor.this.setState(IdeMenuBarState.COLLAPSING);
                FloatingMenuBarFlavor.this.restartAnimator();
            }
            if (wasActivated) {
                FloatingMenuBarFlavor.this.activated = true;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/ide/menu/FloatingMenuBarFlavor$MyAnimator;", "Lcom/intellij/util/ui/Animator;", "menuBar", "Ljavax/swing/JComponent;", "flavor", "Lcom/intellij/platform/ide/menu/FloatingMenuBarFlavor;", "<init>", "(Ljavax/swing/JComponent;Lcom/intellij/platform/ide/menu/FloatingMenuBarFlavor;)V", "progress", "", "paintNow", "", "frame", "", "totalFrames", "cycle", "paintCycleEnd", "intellij.platform.ide.impl"})
    private static final class MyAnimator
    extends Animator {
        @NotNull
        private final JComponent menuBar;
        @NotNull
        private final FloatingMenuBarFlavor flavor;
        @JvmField
        public double progress;

        public MyAnimator(@NotNull JComponent menuBar, @NotNull FloatingMenuBarFlavor flavor2) {
            Intrinsics.checkNotNullParameter((Object)menuBar, (String)"menuBar");
            Intrinsics.checkNotNullParameter((Object)flavor2, (String)"flavor");
            super("MenuBarAnimator", 16, 300, false, false, null, 48, null);
            this.menuBar = menuBar;
            this.flavor = flavor2;
        }

        public void paintNow(int frame, int totalFrames, int cycle) {
            this.progress = (1.0 - Math.cos(Math.PI * (double)((float)frame / (float)totalFrames))) / (double)2;
            this.menuBar.revalidate();
            this.menuBar.repaint();
        }

        protected void paintCycleEnd() {
            this.progress = 1.0;
            switch (WhenMappings.$EnumSwitchMapping$0[this.flavor.getState().ordinal()]) {
                case 1: {
                    this.flavor.setState(IdeMenuBarState.COLLAPSED);
                    break;
                }
                case 2: {
                    this.flavor.setState(IdeMenuBarState.TEMPORARY_EXPANDED);
                }
            }
            if (!this.menuBar.isShowing()) {
                return;
            }
            this.menuBar.revalidate();
            if (this.flavor.getState() == IdeMenuBarState.COLLAPSED) {
                this.menuBar.getParent().repaint();
            } else {
                this.menuBar.repaint();
            }
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[IdeMenuBarState.values().length];
                try {
                    nArray[IdeMenuBarState.COLLAPSING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IdeMenuBarState.EXPANDING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

