/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.menu;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.headertoolbar.MainMenuWithButton;
import com.intellij.openapi.wm.impl.headertoolbar.MergedMainMenu;
import com.intellij.platform.ide.menu.IdeJMenuBar;
import com.intellij.platform.ide.menu.IdeMenuBarHelper;
import com.intellij.platform.ide.menu.IdeMenuFlavor;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.awt.Component;
import java.awt.Container;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J$\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\tH\u0094@\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/ide/menu/JMenuBasedIdeMenuBarHelper;", "Lcom/intellij/platform/ide/menu/IdeMenuBarHelper;", "flavor", "Lcom/intellij/platform/ide/menu/IdeMenuFlavor;", "menuBar", "Lcom/intellij/platform/ide/menu/IdeJMenuBar$JMenuBarImpl;", "<init>", "(Lcom/intellij/platform/ide/menu/IdeMenuFlavor;Lcom/intellij/platform/ide/menu/IdeJMenuBar$JMenuBarImpl;)V", "isUpdateForbidden", "", "doUpdateVisibleActions", "", "newVisibleActions", "", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "forceRebuild", "(Ljava/util/List;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
public final class JMenuBasedIdeMenuBarHelper
extends IdeMenuBarHelper {
    public JMenuBasedIdeMenuBarHelper(@NotNull IdeMenuFlavor flavor2, @NotNull IdeJMenuBar.JMenuBarImpl menuBar) {
        Intrinsics.checkNotNullParameter((Object)flavor2, (String)"flavor");
        Intrinsics.checkNotNullParameter((Object)menuBar, (String)"menuBar");
        super(flavor2, menuBar, null);
    }

    @Override
    protected boolean isUpdateForbidden() {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        Intrinsics.checkNotNullExpressionValue((Object)menuElementArray, (String)"getSelectedPath(...)");
        return !(((Object[])menuElementArray).length == 0);
    }

    @Override
    @Nullable
    protected Object doUpdateVisibleActions(@NotNull List<? extends ActionGroup> newVisibleActions, boolean forceRebuild, @NotNull Continuation<? super Unit> $completion) {
        ThreadingAssertions.assertEventDispatchThread();
        JComponent menuBarComponent = this.menuBar.getComponent();
        if (!forceRebuild && Intrinsics.areEqual(newVisibleActions, (Object)this.visibleActions) && !this.presentationFactory.isNeedRebuild()) {
            boolean enableMnemonics = !UISettings.Companion.getInstance().getDisableMnemonics();
            Component[] componentArray = menuBarComponent.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            for (Component child : componentArray) {
                if (!(child instanceof ActionMenu)) continue;
                ((ActionMenu)((Object)child)).updateFromPresentation$intellij_platform_ide_impl(enableMnemonics);
            }
            return Unit.INSTANCE;
        }
        boolean changeBarVisibility = newVisibleActions.isEmpty() || this.visibleActions.isEmpty();
        this.visibleActions = newVisibleActions;
        MergedMainMenu mergedMainMenu = menuBarComponent instanceof MergedMainMenu ? (MergedMainMenu)menuBarComponent : null;
        Object object = mergedMainMenu;
        int visibleMenuCount = object != null && (object = ((IdeJMenuBar)object).getRootMenuItems()) != null ? ((Collection)object).size() : 0;
        menuBarComponent.removeAll();
        if (!newVisibleActions.isEmpty()) {
            boolean enableMnemonics = !UISettings.Companion.getInstance().getDisableMnemonics();
            boolean isCustomDecorationActive = IdeFrameDecorator.Companion.isCustomDecorationActive();
            for (ActionGroup container : newVisibleActions) {
                IdeMenuBarHelper.MenuBarImpl menuBarImpl = this.menuBar;
                Intrinsics.checkNotNull((Object)menuBarImpl, (String)"null cannot be cast to non-null type com.intellij.platform.ide.menu.IdeJMenuBar.JMenuBarImpl");
                ActionMenu actionMenu = new ActionMenu(null, "MainMenu", container, this.presentationFactory, enableMnemonics, ((IdeJMenuBar.JMenuBarImpl)menuBarImpl).isDarkMenu(), true);
                if (isCustomDecorationActive || menuBarComponent instanceof MergedMainMenu) {
                    actionMenu.setOpaque(false);
                    if (isCustomDecorationActive) {
                        actionMenu.setFocusable(false);
                    }
                }
                if (mergedMainMenu != null && visibleMenuCount > 0 && visibleMenuCount < this.visibleActions.size() && newVisibleActions.indexOf(container) >= visibleMenuCount) {
                    mergedMainMenu.addInvisibleItem(actionMenu);
                    continue;
                }
                menuBarComponent.add((Component)((Object)actionMenu));
            }
            MergedMainMenu mergedMainMenu2 = mergedMainMenu;
            Container container = mergedMainMenu2 != null ? mergedMainMenu2.getParent() : null;
            MainMenuWithButton mainMenuWithButton = container instanceof MainMenuWithButton ? (MainMenuWithButton)((Object)container) : null;
            if (mainMenuWithButton != null) {
                mainMenuWithButton.recalculateWidth();
            }
        }
        this.presentationFactory.resetNeedRebuild();
        this.flavor.updateAppMenu();
        this.menuBar.updateGlobalMenuRoots();
        menuBarComponent.validate();
        if (changeBarVisibility) {
            menuBarComponent.invalidate();
            this.menuBar.getFrame().validate();
        }
        return Unit.INSTANCE;
    }
}

