/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ijent;

import com.intellij.platform.eel.EelPlatform;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"executableName", "", "Lcom/intellij/platform/eel/EelPlatform;", "getExecutableName", "(Lcom/intellij/platform/eel/EelPlatform;)Ljava/lang/String;", "intellij.platform.ijent"})
public final class EelPlatformExKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final String getExecutableName(@NotNull EelPlatform $this$executableName) {
        Intrinsics.checkNotNullParameter((Object)$this$executableName, (String)"<this>");
        EelPlatform eelPlatform = $this$executableName;
        if (eelPlatform instanceof EelPlatform.Darwin) {
            EelPlatform.Arch arch = ((EelPlatform.Darwin)$this$executableName).getArch();
            if (Intrinsics.areEqual((Object)arch, (Object)EelPlatform.Arch.ARM_64.INSTANCE)) {
                return "ijent-aarch64-apple-darwin-release";
            }
            if (!Intrinsics.areEqual((Object)arch, (Object)EelPlatform.Arch.X86_64.INSTANCE)) throw new IllegalArgumentException("Unsupported darwin arch: " + ((EelPlatform.Darwin)$this$executableName).getArch());
            return "ijent-x86_64-apple-darwin-release";
        }
        if (eelPlatform instanceof EelPlatform.Linux) {
            EelPlatform.Arch arch = ((EelPlatform.Linux)$this$executableName).getArch();
            if (Intrinsics.areEqual((Object)arch, (Object)EelPlatform.Arch.ARM_64.INSTANCE)) {
                return "ijent-aarch64-unknown-linux-musl-release";
            }
            if (!Intrinsics.areEqual((Object)arch, (Object)EelPlatform.Arch.X86_64.INSTANCE)) throw new IllegalArgumentException("Unsupported linux arch: " + ((EelPlatform.Linux)$this$executableName).getArch());
            return "ijent-x86_64-unknown-linux-musl-release";
        }
        if (eelPlatform instanceof EelPlatform.Windows) {
            EelPlatform.Arch arch = ((EelPlatform.Windows)$this$executableName).getArch();
            if (Intrinsics.areEqual((Object)arch, (Object)EelPlatform.Arch.ARM_64.INSTANCE)) {
                return "ijent-aarch64-pc-windows-gnu-release";
            }
            if (!Intrinsics.areEqual((Object)arch, (Object)EelPlatform.Arch.X86_64.INSTANCE)) throw new IllegalArgumentException("Unsupported windows arch: " + ((EelPlatform.Windows)$this$executableName).getArch());
            return "ijent-x86_64-pc-windows-gnu-release.exe";
        }
        if (!(eelPlatform instanceof EelPlatform.FreeBSD)) throw new NoWhenBranchMatchedException();
        throw new IllegalStateException("FreeBSD is not supported");
    }
}

